/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.bizrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;

public class BizRuleExecParam {
    private BizRuleExecCommonParam commonParam = new BizRuleExecCommonParam();
    private List<Pair<Long, String>> bizRuleList = new ArrayList<Pair<Long, String>>();
    private String modelNum;
    private BizRuleExecuteTypeEnum executeType;
    private String paperTemplateNumber = "";
    private Long paperTemplateId;
    private String calcTypeWay;

    public BizRuleExecParam(String modelNum) {
        this.modelNum = modelNum;
    }

    public String getModelNum() {
        return this.modelNum;
    }

    public long getModelId() {
        return MemberReader.findModelIdByNum((String)this.modelNum);
    }

    public List<Pair<Long, String>> getBizRuleList() {
        return this.bizRuleList;
    }

    public void setBizRuleList(List<Pair<Long, String>> bizRuleList) {
        this.bizRuleList = bizRuleList;
    }

    public void addBizRuleList(Pair<Long, String> bizRule) {
        this.bizRuleList.add(bizRule);
    }

    public BizRuleExecCommonParam getCommonParam() {
        return this.commonParam;
    }

    public long getEntityId() {
        return this.getIdFromCommonParam(PresetConstant.ENTITY_DIM);
    }

    public String getEntityNumber() {
        return this.getNumberFromCommonParam(PresetConstant.ENTITY_DIM);
    }

    public long getFyId() {
        return this.getIdFromCommonParam(PresetConstant.FY_DIM);
    }

    public long getProcessId() {
        return this.getIdFromCommonParam(PresetConstant.PROCESS_DIM);
    }

    public String getProcessNumber() {
        return this.getNumberFromCommonParam(PresetConstant.PROCESS_DIM);
    }

    public String getFyNumber() {
        return this.getNumberFromCommonParam(PresetConstant.FY_DIM);
    }

    public long getPeriodId() {
        return this.getIdFromCommonParam(PresetConstant.PERIOD_DIM);
    }

    public String getPeriodNumber() {
        return this.getNumberFromCommonParam(PresetConstant.PERIOD_DIM);
    }

    public long getCurrencyId() {
        return this.getIdFromCommonParam(PresetConstant.CURRENCY_DIM);
    }

    public String getCurrencyNumber() {
        return this.getNumberFromCommonParam(PresetConstant.CURRENCY_DIM);
    }

    public long getScenarioId() {
        return this.getIdFromCommonParam(PresetConstant.SCENE_DIM);
    }

    public String getScenarioNumber() {
        return this.getNumberFromCommonParam(PresetConstant.SCENE_DIM);
    }

    public BizRuleExecuteTypeEnum getExecuteType() {
        return this.executeType;
    }

    public void setExecuteType(BizRuleExecuteTypeEnum executeType) {
        this.executeType = executeType;
    }

    public String getPaperTemplateNumber() {
        return this.paperTemplateNumber;
    }

    public void setPaperTemplateNumber(String paperTemplateNumber) {
        this.paperTemplateNumber = paperTemplateNumber;
    }

    public Long getPaperTemplateId() {
        return this.paperTemplateId;
    }

    public void setPaperTemplateId(Long paperTemplateId) {
        this.paperTemplateId = paperTemplateId;
    }

    public String getCalcTypeWay() {
        return this.calcTypeWay;
    }

    public void setCalcTypeWay(String calcTypeWay) {
        this.calcTypeWay = calcTypeWay;
    }

    public long getIdFromCommonParam(String dimNumber) {
        Pair<Long, String> p = this.getCommonParam().getDimMemberPair(dimNumber);
        return p == null ? 0L : (Long)p.p1;
    }

    public String getNumberFromCommonParam(String dimNumber) {
        Pair<Long, String> p = this.getCommonParam().getDimMemberPair(dimNumber);
        return p == null ? "" : (String)p.p2;
    }

    public BizRuleExecCommonParam addCommonParamPair(String dimNum, Long id, String number) {
        return this.commonParam.addCommonParamPair(dimNum, id, number);
    }

    public BizRuleExecCommonParam addCommonParamPair(String dimNum, Pair<Long, String> member) {
        return this.commonParam.addCommonParamPair(dimNum, member);
    }

    public void addExternalCommParams(String dim, String ... members) {
        this.commonParam.addExternalCommParams(dim, members);
    }

    public static class BizRuleExecCommonParam {
        private Map<String, Pair<Long, String>> params = new HashMap<String, Pair<Long, String>>();
        private Map<String, String[]> externalCommParams = new HashMap<String, String[]>();

        public BizRuleExecCommonParam addCommonParamPair(String dimNum, Long id, String number) {
            Objects.requireNonNull(id, "id request non-null");
            Objects.requireNonNull(number, "number request non-null");
            this.params.put(dimNum, (Pair<Long, String>)Pair.onePair((Object)id, (Object)number));
            return this;
        }

        public BizRuleExecCommonParam addCommonParamPair(String dimNum, Pair<Long, String> member) {
            Objects.requireNonNull(member.p1, "id request non-null");
            Objects.requireNonNull(member.p2, "number request non-null");
            this.params.put(dimNum, member);
            return this;
        }

        public void addAllCommonParamPair(Map<String, Pair<Long, String>> param) {
            this.params.putAll(param);
        }

        public Map<String, Pair<Long, String>> getParams() {
            return this.params;
        }

        public Map<String, String[]> getExternalCommParams() {
            return this.externalCommParams;
        }

        public void addExternalCommParams(String dim, String ... members) {
            this.externalCommParams.put(dim, members);
        }

        public Pair<Long, String> getDimMemberPair(String dimNum) {
            return this.params.get(dimNum);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            this.params.forEach((key, value) -> str.append(String.format("%s:%s,", key, value.p2)));
            this.externalCommParams.forEach((key, value) -> str.append(String.format("%s:%s,", key, Arrays.toString(value))));
            if (str.length() > 0) {
                str.deleteCharAt(str.length() - 1);
            }
            return String.format("Params:%s", str);
        }
    }
}

