/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.bizrule.formula;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.datasource.IOutline;
import org.apache.commons.lang3.tuple.Triple;

public class BizRuleInvFormulaHelper {
    private static final String FI_BCM_COMPUTING = "fi-bcm-computing";

    public static Date[] trans2DateByYP(String cubeNumber, String yearNumber, String periodNumber) {
        String yearStr = yearNumber.substring(2);
        QFBuilder qf = new QFBuilder();
        qf.add("number", "=", (Object)periodNumber);
        qf.add("model.number", "=", (Object)cubeNumber);
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"id", (QFilter[])qf.toArray());
        Triple triple = PeriodUtils.getPeiodStartEndAndYearStartDate((String)yearStr, (long)periodDyn.getLong("id"));
        return new Date[]{(Date)triple.getMiddle(), (Date)triple.getRight(), (Date)triple.getLeft()};
    }

    public static Map<String, String> checkParamAndSetDefault(IOutline outline, String dimStr, String typeStr) {
        if (StringUtils.isEmpty((String)dimStr) || StringUtils.isEmpty((String)typeStr)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"inv\u51fd\u6570\u4f20\u5165\u53c2\u6570\u6709\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleInvFormulaHelper_0", (String)FI_BCM_COMPUTING, (Object[])new Object[0]));
        }
        ScopeInfo filterScope = ScopeInfo.parserScopeExpr(dimStr, outline.getModelNum());
        filterScope = outline.getComputingContext().getRuntimeScope(filterScope);
        Map<String, List> dimFilterMap = filterScope.getFilters().stream().collect(Collectors.toMap(DimensionFilterItem::getName, DimensionFilterItem::getValues));
        HashMap<String, String> dimAndMemberMap = new HashMap<String, String>(16);
        HashMap<String, IDNumberTreeNode> dimAndMemberNodeMap = new HashMap<String, IDNumberTreeNode>(16);
        if (!(dimFilterMap.containsKey("Entity") && dimFilterMap.containsKey("Account") && dimFilterMap.containsKey("ChangeType"))) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u8981\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\uff1a\u7ec4\u7ec7\u3001\u79d1\u76ee\u53ca\u53d8\u52a8\u7c7b\u578b\u3002", (String)"BizRuleInvFormulaHelper_1", (String)FI_BCM_COMPUTING, (Object[])new Object[0]));
        }
        for (Map.Entry<String, List> entry : dimFilterMap.entrySet()) {
            String dimNumber = entry.getKey();
            String dimMemberNumber = !entry.getValue().isEmpty() ? (String)entry.getValue().get(0) : "";
            IDNumberTreeNode member = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)dimNumber, (String)dimMemberNumber);
            if (member == null || member.getId() == 0L) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"inv\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684%s\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u3002", (String)"BizRuleInvFormulaHelper_2", (String)FI_BCM_COMPUTING, (Object[])new Object[0]), dimMemberNumber));
            }
            dimAndMemberMap.put(dimNumber, dimMemberNumber);
            dimAndMemberNodeMap.put(dimNumber, member);
        }
        IDNumberTreeNode accountNode = (IDNumberTreeNode)dimAndMemberNodeMap.get("Account");
        DynamicObject accountDy = BusinessDataServiceHelper.loadSingle((Object)accountNode.getId(), (String)"bcm_accountmembertree", (String)"id,number,accountpart.isaccountoffset");
        if (accountDy != null && !accountDy.getBoolean("accountpart.isaccountoffset")) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u79d1\u76ee\u6210\u5458\u7f16\u7801\u65e0\u6548\u3002", (String)"BizRuleInvFormulaHelper_3", (String)FI_BCM_COMPUTING, (Object[])new Object[0]));
        }
        IDNumberTreeNode entityNode = (IDNumberTreeNode)dimAndMemberNodeMap.get("Entity");
        if (!entityNode.isLeaf()) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6295\u8d44\u5355\u4f4d\u65e0\u6548\u3002", (String)"BizRuleInvFormulaHelper_4", (String)FI_BCM_COMPUTING, (Object[])new Object[0]));
        }
        if (!(typeStr.equalsIgnoreCase("P") || typeStr.equalsIgnoreCase("Y") || typeStr.equalsIgnoreCase("E"))) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u65e0\u6548\u3002", (String)"BizRuleInvFormulaHelper_5", (String)FI_BCM_COMPUTING, (Object[])new Object[0]));
        }
        return dimAndMemberMap;
    }

    public static BigDecimal getInvValue(IOutline outline, Map<String, String> scope, String typeStr) {
        BigDecimal value = BigDecimal.ZERO;
        Date[] dates = BizRuleInvFormulaHelper.trans2DateByYP(outline.getModelNum(), scope.get("Year"), scope.get("Period"));
        QFilter filter = new QFilter("model.number", "=", (Object)outline.getModelNum()).and("account.number", "=", (Object)scope.get("Account")).and("changetype.number", "=", (Object)scope.get("ChangeType")).and("investeecompany.number", "=", (Object)scope.get("Entity"));
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bcm_invchangeentry", (String)"account, account.number, changetype.number, investeecompany.number, changedate, invcompanycurrency.number, changeamount, cvt1currenyid.number, change1amount, cvt2currenyid.number, change2amount, cvt3currenyid.number, change3amount, cvt4currenyid.number, change4amount, cvt5currenyid.number, change5amount", (QFilter[])filter.toArray());
        if (records != null) {
            for (DynamicObject record : records) {
                Date endDate;
                Date changedate = record.getDate("changedate");
                Date startDate = null;
                if (typeStr.equalsIgnoreCase("P")) {
                    startDate = dates[0];
                    endDate = dates[1];
                } else if (typeStr.equalsIgnoreCase("Y")) {
                    startDate = dates[2];
                    endDate = dates[1];
                } else {
                    endDate = typeStr.equalsIgnoreCase("E") ? dates[1] : null;
                }
                if (startDate != null && startDate.compareTo(changedate) > 0 || endDate != null && endDate.compareTo(changedate) < 0) continue;
                String currencyNumber = scope.get("Currency");
                if (currencyNumber.equals(record.getString("invcompanycurrency.number"))) {
                    value = record.getBigDecimal("changeamount");
                    continue;
                }
                for (int i = 1; i <= 5; ++i) {
                    if (record.getString("cvt" + i + "currenyid.number") == null || !currencyNumber.equals(record.getString("cvt" + i + "currenyid.number"))) continue;
                    value = record.getBigDecimal("change" + i + "amount");
                }
            }
        }
        return value;
    }
}

