/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.bizrule.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.msservice.MsServiceHelper;
import kd.fi.bcm.common.msservice.param.ConvertParam;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class BizRuleTranslateFormulaHelper {
    public static final String CVT_CURRENCY = "CVT_CURRENCY";

    public static Map<String, IDNumberTreeNode> checkParamAndSetDefault(IOutline outline, String entCode, String tarCurrency) {
        if (StringUtils.isEmpty((String)entCode) || StringUtils.isEmpty((String)tarCurrency)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"translate\u51fd\u6570\u4f20\u5165\u53c2\u6570\u6709\u8bef, \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BizRuleTranslateFormulaHelper_0", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        ScopeInfo filterScope = new ScopeInfo();
        filterScope = outline.getComputingContext().getRuntimeScope(filterScope);
        Map<String, List> dimFilterMap = filterScope.getFilters().stream().collect(Collectors.toMap(DimensionFilterItem::getName, DimensionFilterItem::getValues));
        HashMap<String, IDNumberTreeNode> dimAndMemberNodeMap = new HashMap<String, IDNumberTreeNode>(16);
        for (Map.Entry<String, List> entry : dimFilterMap.entrySet()) {
            IDNumberTreeNode member;
            String dimMemberNumber;
            String dimNumber = entry.getKey();
            String string = dimMemberNumber = !entry.getValue().isEmpty() ? (String)entry.getValue().get(0) : "";
            if (dimNumber.equals("Entity")) {
                dimMemberNumber = entCode;
            }
            if ((member = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)dimNumber, (String)dimMemberNumber)) == null || member.getId() == 0L) {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"tarnslate\u51fd\u6570\u6307\u5b9a\u7684\u201c%1$s\u201d\u7ef4\u5ea6\u7684\u6210\u5458\u7f16\u7801\u201c%2$s\u201d\u65e0\u6548\u3002", (String)"BizRuleTranslateFormulaHelper_1", (String)"fi-bcm-computing", (Object[])new Object[0]), dimNumber, dimMemberNumber));
            }
            dimAndMemberNodeMap.put(dimNumber, member);
        }
        IDNumberTreeNode cvtCurrencyMember = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)"Currency", (String)tarCurrency);
        if (cvtCurrencyMember == null || cvtCurrencyMember.getId() == 0L) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u6298\u7b97\u5e01\u7f16\u7801%s\u65e0\u6548\u3002", (String)"BizRuleTranslateFormulaHelper_2", (String)"fi-bcm-computing", (Object[])new Object[0]), tarCurrency));
        }
        dimAndMemberNodeMap.put(CVT_CURRENCY, cvtCurrencyMember);
        return dimAndMemberNodeMap;
    }

    public static void translate(IOutline outline, Map<String, IDNumberTreeNode> dimAndMemMap, String entCode, String tarCurrency) {
        IDNumberTreeNode processNode = dimAndMemMap.get("Process");
        String processNumber = processNode.getNumber();
        if ("EIRpt".equals(processNumber) || "ERAdj".equals(processNumber) || "IRpt".equals(processNumber) || "RAdj".equals(processNumber)) {
            return;
        }
        IDNumberTreeNode entityNode = dimAndMemMap.get("Entity");
        String sourceCurrencyNumber = entityNode.getCurrency();
        IDNumberTreeNode sourceCurrencyMember = MemberReader.findMemberByNumber((String)outline.getModelNum(), (String)"Currency", (String)sourceCurrencyNumber);
        IDNumberTreeNode tarCurrencyMember = dimAndMemMap.get(CVT_CURRENCY);
        String modelNum = outline.getModelNum();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Pair modelPair = Pair.onePair((Object)modelId, (Object)modelNum);
        Pair cvtCurrency = Pair.onePair((Object)tarCurrencyMember.getId(), (Object)tarCurrency);
        ConvertParam cvtParam = new ConvertParam(null, cvtCurrency, modelPair);
        cvtParam.setNeedMonitorDataStatus(true);
        cvtParam.addFixScope(PresetConstant.ENTITY_DIM, dimAndMemMap.get(PresetConstant.ENTITY_DIM).getNumber(), dimAndMemMap.get(PresetConstant.ENTITY_DIM).getId());
        cvtParam.addFixScope(PresetConstant.SCENE_DIM, dimAndMemMap.get(PresetConstant.SCENE_DIM).getNumber(), dimAndMemMap.get(PresetConstant.SCENE_DIM).getId());
        cvtParam.addFixScope(PresetConstant.FY_DIM, dimAndMemMap.get(PresetConstant.FY_DIM).getNumber(), dimAndMemMap.get(PresetConstant.FY_DIM).getId());
        cvtParam.addFixScope(PresetConstant.PERIOD_DIM, dimAndMemMap.get(PresetConstant.PERIOD_DIM).getNumber(), dimAndMemMap.get(PresetConstant.PERIOD_DIM).getId());
        cvtParam.addFixScope(PresetConstant.CURRENCY_DIM, sourceCurrencyNumber, sourceCurrencyMember.getId());
        ArrayList errors = new ArrayList(10);
        BatchProcessHelper.handleSync(() -> errors.addAll(MsServiceHelper.invokeConvertService((ConvertParam)cvtParam)));
        if (!errors.isEmpty()) {
            throw new KDBizException((String)errors.get(0));
        }
    }
}

