/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.bizrule.log;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import kd.bos.orm.util.ReflectionUtils;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.proxy.Interceptor;
import kd.fi.bcm.computing.bizrule.log.AuditItem;
import kd.fi.bcm.computing.bizrule.log.AuditStatistics;
import net.sf.cglib.proxy.MethodProxy;

public class AuditLogHelper {
    public static void audit(AuditItem item) {
        AuditStatistics.current().audit(item);
    }

    public static String outputAuditStatistics() {
        String rs = AuditStatistics.current().toString();
        AuditStatistics.current().reSet();
        return rs;
    }

    public static void clearCurrent() {
        if (DebugServiceHelper.isDebugModel()) {
            AuditStatistics.current().reSet();
        }
    }

    public static <T> T proxyWithAuditEvent(final Object targ, Class[] paramClazz, Object[] params) {
        if (!DebugServiceHelper.isDebugModel()) {
            return (T)targ;
        }
        Interceptor proxy = new Interceptor(targ, null){

            public Object intercept(Object arg0, Method method, Object[] args, MethodProxy arg3) throws Throwable {
                Object rt = null;
                ReflectionUtils.makeAccessible((Method)method);
                if (Modifier.isPublic(method.getModifiers())) {
                    String paramFormat = "__getUndefinedElement".equals(method.getName()) || "__getUndefinedProperty".equals(method.getName()) ? Arrays.toString(args) : "";
                    try (AuditItem item = new AuditItem((targ != null ? targ.getClass().getSimpleName() + "." + method.getName() : method.getName()) + paramFormat);){
                        rt = method.invoke(targ, args);
                    }
                } else {
                    rt = method.invoke(targ, args);
                }
                return rt;
            }
        };
        if (paramClazz != null && paramClazz.length > 0) {
            return (T)proxy.createProxy(paramClazz, params);
        }
        return (T)proxy.createProxy();
    }
}

