/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.bizrule.log;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.computing.bizrule.log.AuditItem;

public class AuditStatistics
implements Closeable {
    private static final ThreadLocal<AuditStatistics> auditThreadLocals = ThreadLocals.create(AuditStatistics::new);
    private Map<String, SatisticsData> auditMap = new HashMap<String, SatisticsData>(8);

    public static AuditStatistics current() {
        return auditThreadLocals.get();
    }

    public void audit(AuditItem item) {
        this.auditMap.computeIfAbsent(item.getKey(), k -> new SatisticsData()).analysis(item);
    }

    public void reSet() {
        this.auditMap.clear();
    }

    @Override
    public void close() throws IOException {
        this.reSet();
    }

    public String toString() {
        if (this.auditMap.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("profile analysis \n");
        sb.append("{ \n");
        boolean isOutput = false;
        for (Map.Entry<String, SatisticsData> e : this.auditMap.entrySet()) {
            if (e.getValue().cost <= 0L) continue;
            sb.append("     " + e.getKey() + e.getValue() + ",\n");
            isOutput = true;
        }
        if (isOutput) {
            sb.substring(0, sb.length() - 2);
        }
        sb.append("} \n");
        return isOutput ? sb.toString() : "";
    }

    private static class SatisticsData {
        private int times = 0;
        private long cost = 0L;

        private SatisticsData() {
        }

        void analysis(AuditItem item) {
            ++this.times;
            this.cost += System.currentTimeMillis() - item.getStartTime();
        }

        public String toString() {
            return String.format("[times:%d,cost:%s,t/p:%s]", this.times, this.cost + "ms", this.cost / (long)this.times + "ms");
        }
    }
}

