/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.SimpleScriptInfo;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import org.apache.commons.io.IOUtils;

public class JavaScriptLoader {
    private final ScriptInfo jscontent = new SimpleScriptInfo("biz_rule.js", JavaScriptLoader.getStringFromResources("js/biz_rule.js"));

    private JavaScriptLoader() {
    }

    public ScriptInfo getBizRuleScript() {
        return this.jscontent;
    }

    public static final JavaScriptLoader getInstance() {
        return JavaScriptLoaderHolder.holder;
    }

    public static String getStringFromResources(String path) {
        InputStream in = JavaScriptLoader.class.getClassLoader().getResourceAsStream(path);
        try {
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("load biz-rule.js failed!");
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public List<ScriptInfo> getDefImportScript(String modelNumber) {
        return BizRuleServiceHelper.getDefImportScript((String)modelNumber);
    }

    private static class JavaScriptLoaderHolder {
        private static final JavaScriptLoader holder = new JavaScriptLoader();

        private JavaScriptLoaderHolder() {
        }
    }
}

