/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.datasource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapConnectionStringBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptExecutor;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptBuiltin;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.DataSource;
import kd.fi.bcm.computing.datasource.DimensionInfo;
import kd.fi.bcm.computing.datasource.ExtOutlineNode;
import kd.fi.bcm.computing.datasource.IDataSource;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.OutlineNode;
import kd.fi.bcm.computing.util.TreeStructureServiceHelper;

public class Outline
implements IOutline {
    private final OlapConnectionStringBuilder conBuilder;
    private Map<String, DimensionInfo> dimensionInfos;
    private ComputingContext ctx;
    private ScriptBuiltin builtin;
    private ScriptExecutor executor;
    private static final String[] D_PROPS = new String[]{"dpropertyid2", "dpropertyid3", "dpropertyid4", "dpropertyid5", "dpropertyid6", "dpropertyid7", "dpropertyid8", "dpropertyid9", "dpropertyid10"};

    public Outline(OlapConnection olapConnection, IDataSource datasource) {
        this.conBuilder = new OlapConnectionStringBuilder(olapConnection.getConnectionString());
        this.dimensionInfos = new HashMap<String, DimensionInfo>();
    }

    public Outline(OlapConnection olapConnection) {
        this(olapConnection, new DataSource());
    }

    public static Outline create(OlapConnection olapConnection) {
        return (Outline)AuditLogHelper.proxyWithAuditEvent(new Outline(olapConnection), new Class[]{OlapConnection.class}, new Object[]{olapConnection});
    }

    @Override
    public OutlineNode getAggNode(String dimensionNumber, String memberNumber) {
        Pair<Long, String> entityPair;
        IDNumberTreeNode obj = MemberReader.findMemberByNumber((String)this.conBuilder.getInitialCatalog(), (String)dimensionNumber, (String)memberNumber);
        if (DimTypesEnum.ENTITY.getNumber().equals(dimensionNumber) && (entityPair = this.ctx.getScopeItems().get(DimTypesEnum.ENTITY.getNumber())) != null) {
            IDNumberTreeNode ctxEntity = MemberReader.findEntityMemberById((String)this.ctx.getOutline().getModelNum(), (Long)((Long)entityPair.p1));
            Object value = ctxEntity.getProperty("cslscheme.id");
            if (obj != IDNumberTreeNode.NotFoundTreeNode && !Objects.equals(obj.getProperty("cslscheme.id"), value)) {
                for (IDNumberTreeNode shareNode : obj.getShareNodes()) {
                    if (!Objects.equals(value, shareNode.getProperty("cslscheme.id"))) continue;
                    obj = shareNode;
                    break;
                }
            }
        }
        if (obj.getId() == -1L) {
            throw new BizRuleException((Throwable)new NullPointerException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6210\u5458\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"Outline_7", (String)"fi-bcm-computing", (Object[])new Object[0]), dimensionNumber, memberNumber)));
        }
        return new OutlineNode(obj.getId(), obj.getNumber(), obj.getAggOprt(), obj.getdSeq(), obj.getLevel(), this.getDimensionInfo(obj.getDimNumber()), obj.getStorageType(), obj.isLeaf(), obj.isShare(), obj.getModelId());
    }

    public OutlineNode getAggRootNode(String dimensionNumber) {
        String entityNumByNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dimensionNumber);
        String cacheKey = this.genCacheKey(dimensionNumber, dimensionNumber);
        return (OutlineNode)GlobalCacheServiceHelper.getOrLoadNode((String)cacheKey, () -> this.createOutlineNodeByNumber(dimensionNumber, dimensionNumber, entityNumByNumber, this.conBuilder.getInitialCatalog()));
    }

    @Override
    public OutlineNode tryGetNode(String nodeNumber) {
        if (nodeNumber == null) {
            return null;
        }
        ArrayList nameArray = nodeNumber.contains("@") ? Lists.newArrayList((Object[])nodeNumber.split("@")) : Lists.newArrayList((Object[])nodeNumber.split("\\."));
        if (nameArray.size() <= 1) {
            return this.getAggRootNode(nodeNumber);
        }
        if (nameArray.size() >= 3) {
            throw new BizRuleException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u6210\u5458\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a\u201c%s\u201d\u3002", (String)"Outline_0", (String)"fi-bcm-computing", (Object[])new Object[0]), nodeNumber)));
        }
        return this.getAggNode((String)nameArray.get(0), (String)nameArray.get(1));
    }

    @Override
    public OutlineNode getOrCreateOutlineNode(DynamicObject obj) {
        String cacheKey = this.genCacheKey(obj.getString("dimension.number"), obj.getString("number"));
        return (OutlineNode)GlobalCacheServiceHelper.getOrLoadAboutDim((String)this.conBuilder.getInitialCatalog(), (String)cacheKey, () -> this.trans2OutlineNode(obj));
    }

    public OutlineNode getOrCreateOutlineNode(IDNumberTreeNode obj) {
        String cacheKey = this.genCacheKey(obj.getDimNumber(), obj.getNumber());
        return (OutlineNode)GlobalCacheServiceHelper.getOrLoadAboutDim((String)this.conBuilder.getInitialCatalog(), (String)cacheKey, () -> this.trans2OutlineNode(obj));
    }

    public String genCacheKey(String dimKey, String membKey) {
        return this.conBuilder.getInitialCatalog() + '.' + dimKey + '.' + membKey;
    }

    public DimensionInfo getDimensionInfo(String dimensionNumber) {
        DimensionInfo dimensionInfo = this.dimensionInfos.get(dimensionNumber);
        if (dimensionInfo == null) {
            String entityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dimensionNumber);
            dimensionInfo = new DimensionInfo(dimensionNumber, entityNumber, this);
            this.dimensionInfos.put(dimensionNumber, dimensionInfo);
        }
        return dimensionInfo;
    }

    private OutlineNode createOutlineNodeByNumber(String dimensionNumber, String memberNumber, String entityNumber, String modelNumber) {
        DynamicObject obj = TreeStructureServiceHelper.getSelfByNumber(dimensionNumber, entityNumber, memberNumber, modelNumber, Outline.getSelectFields());
        return this.trans2OutlineNode(obj);
    }

    public OutlineNode trans2OutlineNode(DynamicObject obj) {
        String aggOprt = StringUtils.isEmpty((String)obj.getString("aggoprt")) ? "" : AggOprtEnum.getAggOprtEnumBySign((String)obj.getString("aggoprt")).getName();
        StorageTypeEnum storageType = StorageTypeEnum.stringToStorageType((String)obj.getString("storagetype"));
        return new OutlineNode(obj.getLong("id"), obj.getString("number"), aggOprt, obj.getInt("dseq"), obj.getInt("level"), this.getDimensionInfo(obj.getString("dimension.number")), storageType, obj.getBoolean("isleaf"), StorageTypeEnum.isShare((StorageTypeEnum)storageType), obj.getLong("model.id"));
    }

    public OutlineNode trans2OutlineNode(IDNumberTreeNode cache) {
        return new OutlineNode(cache.getId(), cache.getNumber(), cache.getAggOprt(), cache.getdSeq(), cache.getLevel(), this.getDimensionInfo(cache.getDimNumber()), cache.getStorageType(), cache.isLeaf(), cache.isShare(), cache.getModelId());
    }

    public static String getSelectFields() {
        return "id,number,aggoprt,dseq,level,dimension.number,storagetype,isleaf,model.id";
    }

    @Override
    public OutlineNode searchParent(String dimension, String name) {
        return this.getAggNode(dimension, name).getParent();
    }

    @Override
    public TreeMap<Integer, OutlineNode> searchChildren(String dimension, String name) {
        OutlineNode node = this.getAggNode(dimension, name);
        if (node == null) {
            throw new BizRuleException((Throwable)new NullPointerException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u6210\u5458\u8282\u70b9\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u7ef4\u5ea6\u4e3a: \u201c%1$s\u201d\uff0c\u6210\u5458\u8282\u70b9\u4e3a: \u201c%2$s\u201d\u3002", (String)"Outline_1", (String)"fi-bcm-computing", (Object[])new Object[0]), dimension, name)));
        }
        return node.getChildren();
    }

    @Override
    public List<OutlineNode> searchAncestors(String dimension, String name) {
        ArrayList<OutlineNode> ancestors = new ArrayList<OutlineNode>();
        OutlineNode node = this.getAggNode(dimension, name);
        while (node.getParent() != null) {
            ancestors.add(node.getParent());
            node = node.getParent();
        }
        return ancestors;
    }

    @Override
    public List<OutlineNode> searchDescendants(String dimension, String name) {
        ArrayList<OutlineNode> descendants = new ArrayList<OutlineNode>();
        OutlineNode node = this.tryGetNode(dimension + '.' + name);
        if (!node.hasExtendAllChildren()) {
            node.extendAllChildren();
        }
        this.addChildren2List(node, descendants);
        return descendants;
    }

    private void addChildren2List(OutlineNode node, List<OutlineNode> descendants) {
        List<OutlineNode> directChildren = node.getDirectChildren();
        if (!directChildren.isEmpty()) {
            descendants.addAll(directChildren);
            for (OutlineNode directChild : directChildren) {
                this.addChildren2List(directChild, descendants);
            }
        }
    }

    @Override
    public List<OutlineNode> searchIdesc(String dimension, String name) {
        List<OutlineNode> descendants = this.searchDescendants(dimension, name);
        descendants.add(this.tryGetNode(dimension + '.' + name));
        return descendants;
    }

    @Override
    public List<OutlineNode> searchRemove(Object scope, Object removeScope) {
        List<OutlineNode> scopeList = this.analyticFunction(scope);
        List<OutlineNode> removeScopeList = this.analyticFunction(removeScope);
        scopeList.removeAll(removeScopeList);
        return scopeList;
    }

    private List<OutlineNode> analyticFunction(Object scope) {
        ArrayList<OutlineNode> scopeList = new ArrayList();
        if (scope instanceof List) {
            scopeList = (List)scope;
        } else if (scope instanceof String) {
            scopeList.add(this.tryGetNode((String)scope));
        } else if (scope instanceof ScopeInfo) {
            DimensionFilterItem filter = ((ScopeInfo)scope).getFilters().iterator().next();
            List values = filter.getValues();
            for (String value : values) {
                scopeList.add(this.tryGetNode(filter.getName() + '.' + value));
            }
        }
        return scopeList;
    }

    @Override
    public List<OutlineNode> searchAttribute(String dimension, String attributeCode, String attributeMemCodeame) {
        ArrayList<OutlineNode> descendants = new ArrayList<OutlineNode>();
        String entityname = DimEntityNumEnum.getEntieyNumByNumber((String)dimension);
        String[] attributeMemCodeames = attributeMemCodeame.trim().split(",");
        QFBuilder attributeCodeFilter = this.getQFilterByattributeCode(attributeCode, attributeMemCodeames);
        if ("bcm_userdefinedmembertree".equals(entityname)) {
            attributeCodeFilter.and("dimension.number", "=", (Object)dimension);
        }
        DynamicObjectCollection codes = QueryServiceHelper.query((String)entityname, (String)Outline.getSelectFields(), (QFilter[])attributeCodeFilter.toArray());
        codes.forEach(p -> {
            OutlineNode node = this.trans2OutlineNode((DynamicObject)p);
            if (node != null) {
                descendants.add(node);
            }
        });
        return descendants;
    }

    private QFBuilder getQFilterByattributeCode(String attributeCode, String[] attributeMemCodeames) {
        String[] dpropertys = D_PROPS;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("dpropertyid1.propertyid.number", "=", (Object)attributeCode).and("dpropertyid1.number", "in", (Object)attributeMemCodeames));
        Stream.of(dpropertys).forEach(p -> qfBuilder.or(new QFilter(p + ".propertyid.number", "=", (Object)attributeCode).and(p + ".number", "in", (Object)attributeMemCodeames)));
        qfBuilder.and(new QFilter("model.number", "=", (Object)this.conBuilder.getInitialCatalog()));
        dpropertys = null;
        return qfBuilder;
    }

    @Override
    public List<OutlineNode> searchGeneration(String dimension, int generation) {
        OutlineNode root = this.tryGetNode(dimension);
        ArrayList<OutlineNode> parents = new ArrayList<OutlineNode>();
        parents.add(root);
        if (generation == root.getLevel()) {
            return parents;
        }
        return this.collectMatchLevelNode(parents, generation, root.getLevel());
    }

    public List<OutlineNode> collectMatchLevelNode(List<OutlineNode> parents, int generation, int level) {
        int nextLevel = level + 1;
        ArrayList<OutlineNode> nextParents = new ArrayList<OutlineNode>();
        for (OutlineNode parent : parents) {
            Collection<OutlineNode> children = parent.getChildren().values();
            if (children.isEmpty()) continue;
            nextParents.addAll(children);
        }
        if (nextLevel == generation) {
            return nextParents;
        }
        return this.collectMatchLevelNode(nextParents, generation, nextLevel);
    }

    @Override
    public List<OutlineNode> searchSiblings(String dimension, int sibling) {
        OutlineNode root = this.tryGetNode(dimension);
        ArrayList<OutlineNode> nodesOfOneSibling = new ArrayList<OutlineNode>();
        this.collectMatchSiblingsNode(root, sibling, nodesOfOneSibling);
        return nodesOfOneSibling;
    }

    private void collectMatchSiblingsNode(OutlineNode node, int sibling, List<OutlineNode> nodesOfOneSibling) {
        if (node.getSibling() != sibling) {
            if (node.getSibling() < sibling) {
                return;
            }
        } else {
            nodesOfOneSibling.add(node);
            return;
        }
        node.getChildren().values().forEach(selectNode -> this.collectMatchSiblingsNode((OutlineNode)selectNode, sibling, nodesOfOneSibling));
    }

    @Override
    public String getModelNum() {
        return this.conBuilder.getInitialCatalog();
    }

    @Override
    public Boolean isMember(Object object, ScopeInfo scopeInfo) {
        if (object instanceof String) {
            Pair<String, String> dimensionMemberPair = this.parseDimensionMember((String)object);
            if (dimensionMemberPair == null) {
                return Boolean.FALSE;
            }
            for (DimensionFilterItem dimensionFilterItem : scopeInfo.getFilters()) {
                if (!dimensionFilterItem.getName().equals(dimensionMemberPair.p1)) continue;
                return ((String)dimensionMemberPair.p2).equals(dimensionFilterItem.getValues().get(0));
            }
            return Boolean.FALSE;
        }
        if (object instanceof ScopeInfo) {
            Collection<DimensionFilterItem> filters = ((ScopeInfo)object).getFilters();
            if (filters.size() == 1) {
                for (DimensionFilterItem dimensionFilterItem : filters) {
                    for (DimensionFilterItem dimensionFilterItem2 : scopeInfo.getFilters()) {
                        if (!dimensionFilterItem2.getName().equals(dimensionFilterItem.getName())) continue;
                        return dimensionFilterItem.getValues().contains(dimensionFilterItem2.getValues().get(0));
                    }
                }
            }
            return Boolean.FALSE;
        }
        if (object instanceof List) {
            if (((List)object).get(0) instanceof OutlineNode) {
                HashMap<String, List> map = new HashMap<String, List>();
                for (Object e : (List)object) {
                    String dimensionNumber = ((OutlineNode)e).getDimension();
                    List members = map.computeIfAbsent(dimensionNumber, k -> new ArrayList());
                    members.add(((OutlineNode)e).getNumber());
                }
                for (Map.Entry entry : map.entrySet()) {
                    for (DimensionFilterItem dimensionFilterItem : scopeInfo.getFilters()) {
                        if (!dimensionFilterItem.getName().equals(entry.getKey())) continue;
                        return ((List)entry.getValue()).contains(dimensionFilterItem.getValues().get(0));
                    }
                }
            }
            return Boolean.FALSE;
        }
        throw new BizRuleException((Throwable)new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u7c7b\u578b\uff1a\u201c%s\u201d\u3002", (String)"Outline_5", (String)"fi-bcm-computing", (Object[])new Object[0]), object.getClass())));
    }

    @Override
    public String searchProperties(String dimension, String level, String properity, ScopeInfo scopeInfo) {
        DynamicObject dynamicObject;
        QFBuilder qfBuilder;
        String number = null;
        for (DimensionFilterItem dimensionFilterItem : scopeInfo.getFilters()) {
            if (!dimensionFilterItem.getName().equals(dimension)) continue;
            number = (String)dimensionFilterItem.getValues().get(0);
            break;
        }
        if (number == null) {
            return null;
        }
        String entityname = DimEntityNumEnum.getEntieyNumByNumber((String)dimension);
        if ("PE".equals(level)) {
            qfBuilder = new QFBuilder();
            qfBuilder.add("model.number", "=", (Object)this.conBuilder.getInitialCatalog());
            qfBuilder.add("number", "=", (Object)number);
            if ("bcm_userdefinedmembertree".equals(entityname)) {
                qfBuilder.and("dimension.number", "=", (Object)dimension);
            }
            if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityname, (String)"parent.number", (QFilter[])qfBuilder.toArray())) != null) {
                number = dynamicObject.getString("parent.number");
            }
        } else if (!"CE".equals(level)) {
            throw new BizRuleException((Throwable)new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6709\u8bef\uff1a\u201c%s\u201d\u3002", (String)"Outline_6", (String)"fi-bcm-computing", (Object[])new Object[0]), level)));
        }
        qfBuilder = new QFBuilder();
        qfBuilder.add("model.number", "=", (Object)this.conBuilder.getInitialCatalog());
        qfBuilder.add("number", "=", (Object)number);
        if ("bcm_userdefinedmembertree".equals(entityname)) {
            qfBuilder.and("dimension.number", "=", (Object)dimension);
        }
        if (DataEntityUtils.checkExistInherentAttribute((String)entityname, (String)properity)) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityname, (String)properity, (QFilter[])qfBuilder.toArray());
            if (dynamicObject != null) {
                Object properityObj = dynamicObject.get(properity);
                if (properityObj instanceof String) {
                    return (String)properityObj;
                }
                if (properityObj instanceof DynamicObject) {
                    return ((DynamicObject)properityObj).getString("number");
                }
                return null;
            }
        } else {
            return this.queryUserDefineProperty(entityname, properity, qfBuilder);
        }
        return null;
    }

    private String queryUserDefineProperty(String entityname, String properity, QFBuilder qfBuilder) {
        DynamicObject dimensionMember = QueryServiceHelper.queryOne((String)entityname, (String)"dpropertyid1.propertyid.number,dpropertyid1.number,dpropertyid2.propertyid.number,dpropertyid2.number,dpropertyid3.propertyid.number,dpropertyid3.number,dpropertyid4.propertyid.number,dpropertyid4.number,dpropertyid5.propertyid.number,dpropertyid5.number,dpropertyid6.propertyid.number,dpropertyid6.number,dpropertyid7.propertyid.number,dpropertyid7.number,dpropertyid8.propertyid.number,dpropertyid8.number,dpropertyid9.propertyid.number,dpropertyid9.number,dpropertyid10.propertyid.number,dpropertyid10.number", (QFilter[])qfBuilder.toArray());
        for (int i = 1; i <= 10; ++i) {
            if (!properity.equals(dimensionMember.getString("dpropertyid" + i + ".propertyid.number"))) continue;
            return dimensionMember.getString("dpropertyid" + i + ".number");
        }
        return null;
    }

    @Override
    public Boolean isParent(String member, ScopeInfo scopeInfo) {
        return this.isParent(member, scopeInfo, Boolean.FALSE);
    }

    @Override
    public Boolean isIparent(String member, ScopeInfo scopeInfo) {
        return this.isParent(member, scopeInfo, Boolean.TRUE);
    }

    private Boolean isParent(String member, ScopeInfo scopeInfo, Boolean equalSelf) {
        Pair<String, String> dimensionMemberPair = this.parseDimensionMember(member);
        if (dimensionMemberPair == null) {
            return Boolean.FALSE;
        }
        Pair<String, String> filterPair = this.getScopeInfoFilter(scopeInfo, (String)dimensionMemberPair.p1);
        if (filterPair == null) {
            return Boolean.FALSE;
        }
        if (equalSelf.booleanValue() && Objects.equals(filterPair.p2, dimensionMemberPair.p2)) {
            return Boolean.TRUE;
        }
        String parentNumber = this.queryMemberParentNumber((String)dimensionMemberPair.p1, (String)dimensionMemberPair.p2);
        return Objects.equals(filterPair.p2, parentNumber);
    }

    private String queryMemberParentNumber(String dimension, String number) {
        String entityname = DimEntityNumEnum.getEntieyNumByNumber((String)dimension);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.number", "=", (Object)this.conBuilder.getInitialCatalog());
        qfBuilder.add("number", "=", (Object)number);
        if ("bcm_userdefinedmembertree".equals(entityname)) {
            qfBuilder.and("dimension.number", "=", (Object)dimension);
        }
        String parentNumber = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityname, (String)"parent.number", (QFilter[])qfBuilder.toArray());
        if (dynamicObject != null) {
            parentNumber = dynamicObject.getString("parent.number");
        }
        return parentNumber;
    }

    @Override
    public Boolean isAncest(String member, ScopeInfo scopeInfo) {
        return this.isAncest(member, scopeInfo, Boolean.FALSE);
    }

    @Override
    public Boolean isIancest(String member, ScopeInfo scopeInfo) {
        return this.isAncest(member, scopeInfo, Boolean.TRUE);
    }

    private Boolean isAncest(String member, ScopeInfo scopeInfo, Boolean equalSelf) {
        Pair<String, String> dimensionMemberPair = this.parseDimensionMember(member);
        if (dimensionMemberPair == null) {
            return Boolean.FALSE;
        }
        Pair<String, String> filterPair = this.getScopeInfoFilter(scopeInfo, (String)dimensionMemberPair.p1);
        if (filterPair == null) {
            return Boolean.FALSE;
        }
        if (equalSelf.booleanValue() && Objects.equals(filterPair.p2, dimensionMemberPair.p2)) {
            return Boolean.TRUE;
        }
        String parentNumber = this.queryMemberParentNumber((String)dimensionMemberPair.p1, (String)dimensionMemberPair.p2);
        while (!Objects.equals(filterPair.p2, parentNumber)) {
            if (parentNumber == null) {
                return Boolean.FALSE;
            }
            parentNumber = this.queryMemberParentNumber((String)dimensionMemberPair.p1, parentNumber);
        }
        return Boolean.TRUE;
    }

    private Pair<String, String> parseDimensionMember(String s) {
        String[] arr = s.split("@");
        if (arr.length != 2) {
            arr = s.split("\\.");
        }
        if (arr.length == 2) {
            return Pair.onePair((Object)arr[0], (Object)arr[1]);
        }
        return null;
    }

    private Pair<String, String> getScopeInfoFilter(ScopeInfo scopeInfo, String filterName) {
        for (DimensionFilterItem filter : scopeInfo.getFilters()) {
            if (!filter.getName().equals(filterName)) continue;
            return Pair.onePair((Object)filter.getName(), filter.getValues().get(0));
        }
        return null;
    }

    @Override
    public Boolean isChild(String member, ScopeInfo scopeInfo) {
        return this.isChild(member, scopeInfo, Boolean.FALSE);
    }

    @Override
    public Boolean isIchild(String member, ScopeInfo scopeInfo) {
        return this.isChild(member, scopeInfo, Boolean.TRUE);
    }

    private Boolean isChild(String member, ScopeInfo scopeInfo, Boolean equalSelf) {
        Pair<String, String> dimensionMemberPair = this.parseDimensionMember(member);
        if (dimensionMemberPair == null) {
            return Boolean.FALSE;
        }
        Pair<String, String> filterPair = this.getScopeInfoFilter(scopeInfo, (String)dimensionMemberPair.p1);
        if (filterPair == null) {
            return Boolean.FALSE;
        }
        if (equalSelf.booleanValue() && Objects.equals(filterPair.p2, dimensionMemberPair.p2)) {
            return Boolean.TRUE;
        }
        String parentNumber = this.queryMemberParentNumber((String)filterPair.p1, (String)filterPair.p2);
        return Objects.equals(dimensionMemberPair.p2, parentNumber);
    }

    @Override
    public Boolean isDescendants(String member, ScopeInfo scopeInfo) {
        return this.isDescendants(member, scopeInfo, Boolean.FALSE);
    }

    @Override
    public Boolean isIdescendant(String member, ScopeInfo scopeInfo) {
        return this.isDescendants(member, scopeInfo, Boolean.TRUE);
    }

    private Boolean isDescendants(String member, ScopeInfo scopeInfo, Boolean equalSelf) {
        Pair<String, String> dimensionMemberPair = this.parseDimensionMember(member);
        if (dimensionMemberPair == null) {
            return Boolean.FALSE;
        }
        Pair<String, String> filterPair = this.getScopeInfoFilter(scopeInfo, (String)dimensionMemberPair.p1);
        if (filterPair == null) {
            return Boolean.FALSE;
        }
        if (equalSelf.booleanValue() && Objects.equals(filterPair.p2, dimensionMemberPair.p2)) {
            return Boolean.TRUE;
        }
        String parentNumber = this.queryMemberParentNumber((String)filterPair.p1, (String)filterPair.p2);
        while (!Objects.equals(dimensionMemberPair.p2, parentNumber)) {
            if (parentNumber == null) {
                return Boolean.FALSE;
            }
            parentNumber = this.queryMemberParentNumber((String)filterPair.p1, parentNumber);
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean isSibling(String member, ScopeInfo scopeInfo) {
        return this.isSibling(member, scopeInfo, Boolean.FALSE);
    }

    @Override
    public Boolean isIsibling(String member, ScopeInfo scopeInfo) {
        return this.isSibling(member, scopeInfo, Boolean.TRUE);
    }

    private Boolean isSibling(String member, ScopeInfo scopeInfo, Boolean equalSelf) {
        Pair<String, String> dimensionMemberPair = this.parseDimensionMember(member);
        if (dimensionMemberPair == null) {
            return Boolean.FALSE;
        }
        Pair<String, String> filterPair = this.getScopeInfoFilter(scopeInfo, (String)dimensionMemberPair.p1);
        if (filterPair == null) {
            return Boolean.FALSE;
        }
        if (!equalSelf.booleanValue() && Objects.equals(dimensionMemberPair.p2, filterPair.p2)) {
            return Boolean.FALSE;
        }
        String parentNumber = this.queryMemberParentNumber((String)dimensionMemberPair.p1, (String)dimensionMemberPair.p2);
        String parentNumber2 = this.queryMemberParentNumber((String)filterPair.p1, (String)filterPair.p2);
        return Objects.equals(parentNumber, parentNumber2);
    }

    @Override
    public Boolean isProperties(String dimension, String properity, String value, ScopeInfo scopeInfo) {
        String number = null;
        for (DimensionFilterItem dimensionFilterItem : scopeInfo.getFilters()) {
            if (!dimensionFilterItem.getName().equals(dimension)) continue;
            number = (String)dimensionFilterItem.getValues().get(0);
            break;
        }
        if (number == null) {
            return Boolean.FALSE;
        }
        String entityname = DimEntityNumEnum.getEntieyNumByNumber((String)dimension);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model.number", "=", (Object)this.conBuilder.getInitialCatalog());
        qfBuilder.add("number", "=", (Object)number);
        if ("bcm_userdefinedmembertree".equals(entityname)) {
            qfBuilder.and("dimension.number", "=", (Object)dimension);
        }
        if (DataEntityUtils.checkExistInherentAttribute((String)entityname, (String)properity)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityname, (String)properity, (QFilter[])qfBuilder.toArray());
            if (dynamicObject != null) {
                Object properityObj = dynamicObject.get(properity);
                if (properityObj instanceof String) {
                    return Objects.equals(properityObj, value);
                }
                if (properityObj instanceof DynamicObject) {
                    return Objects.equals(((DynamicObject)properityObj).getString("number"), value);
                }
                return Boolean.FALSE;
            }
        } else {
            String propertyValue = this.queryUserDefineProperty(entityname, properity, qfBuilder);
            return Objects.equals(propertyValue, value);
        }
        return Boolean.FALSE;
    }

    @Override
    public ComputingContext getComputingContext() {
        return this.ctx;
    }

    @Override
    public void setComputingContext(ComputingContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ScriptBuiltin getBuiltin() {
        return this.builtin;
    }

    @Override
    public void setBuiltin(ScriptBuiltin builtin) {
        this.builtin = builtin;
    }

    @Override
    public ScriptExecutor getScriptExecutor() {
        return this.executor;
    }

    @Override
    public void setScriptExecutor(ScriptExecutor executor) {
        this.executor = executor;
    }

    @Override
    public ExtOutlineNode tryGetExtendNode(String name) {
        String cacheKey = this.genCacheKey(name, name);
        return (ExtOutlineNode)GlobalCacheServiceHelper.getOrLoadNode((String)cacheKey, () -> this.createExtOutlineNodeByNumber(name, "bcm_structofextend", this.conBuilder.getInitialCatalog()));
    }

    @Override
    public ExtOutlineNode getExtAggNode(String propertyName, String modelNumber) {
        QFilter filter = new QFilter("model", "=", (Object)MemberReader.findModelIdByNum((String)modelNumber));
        filter.and("number", "=", (Object)propertyName);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_structofextend", (String)Outline.getSelectFields(), (QFilter[])filter.toArray());
        if (dyo == null) {
            throw new BizRuleException((Throwable)new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5b57\u6bb5\u3002", (String)"Outline_8", (String)"fi-bcm-computing", (Object[])new Object[0]), propertyName)));
        }
        StorageTypeEnum storageType = StorageTypeEnum.stringToStorageType((String)dyo.getString("storagetype"));
        return new ExtOutlineNode(dyo.getLong("id"), dyo.getString("number"), dyo.getInt("dseq"), dyo.getInt("level"), this.getDimensionInfo(dyo.getString("dimension.number")), storageType, dyo.getBoolean("isleaf"), dyo.getLong("model.id"));
    }

    private ExtOutlineNode createExtOutlineNodeByNumber(String memberNumber, String entityNumber, String modelNumber) {
        DynamicObject obj = TreeStructureServiceHelper.getSelfByNumber(null, entityNumber, memberNumber, modelNumber, Outline.getSelectFields());
        StorageTypeEnum storageType = StorageTypeEnum.stringToStorageType((String)obj.getString("storagetype"));
        return new ExtOutlineNode(obj.getLong("id"), obj.getString("number"), obj.getInt("dseq"), obj.getInt("level"), this.getDimensionInfo(obj.getString("dimension.number")), storageType, obj.getBoolean("isleaf"), obj.getLong("model.id"));
    }
}

