/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.datasource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.AggExpressionItem;
import kd.bos.olap.dataSources.AggPair;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.IExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.datasource.OutlineNode;

public class ScriptAgg {
    private final OlapConnection olapConnection;
    private final IOutline outline;
    private final WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public ScriptAgg(OlapConnection olapConnection, IOutline outline) {
        this.olapConnection = olapConnection;
        this.outline = outline;
    }

    public ScriptAgg(OlapConnection olapConnection) {
        this.olapConnection = olapConnection;
        this.outline = new Outline(olapConnection);
    }

    public void agg(ScopeInfo scopeInfo, String ... memberNames) {
        Arrays.stream(memberNames).filter(Objects::nonNull).map(it -> {
            long start = System.currentTimeMillis();
            List<ComputingCommandInfo> commands = this.parseAgg(this.outline, scopeInfo, (String)it);
            return commands;
        }).forEach(this::postCommands);
    }

    private void postCommands(List<ComputingCommandInfo> commands) {
        for (int i = 0; i < commands.size(); ++i) {
            long start = System.currentTimeMillis();
            OlapCommand cmd = new OlapCommand(this.olapConnection, (CommandInfo)commands.get(i));
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"compute");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"compute");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"compute", commands.get(i)});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", commands.get(i).toString());
                }
                cmd.executeCompute();
                continue;
            }
        }
    }

    private List<ComputingCommandInfo> parseAgg(IOutline outline, ScopeInfo scopeInfo, String dimension) {
        String dimensionNumber = dimension.contains("@") ? (String)Lists.newArrayList((Object[])dimension.split("@")).get(0) : (String)Lists.newArrayList((Object[])dimension.split("\\.")).get(0);
        ArrayList<ComputingCommandInfo> commands = new ArrayList<ComputingCommandInfo>();
        OutlineNode node = outline.tryGetNode(dimension);
        if (node == null) {
            throw new ScriptAnalyzeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a %s \u7684\u7ef4\u5ea6\u6216\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"ScriptAgg_0", (String)"fi-bcm-computing", (Object[])new Object[0]), dimension));
        }
        this.handleCommand(node, scopeInfo, commands, dimensionNumber);
        return commands;
    }

    private void handleCommand(OutlineNode node, ScopeInfo scopeInfo, List<ComputingCommandInfo> commands, String dimensionNumber) {
        node.extendAllChildren();
        HashMap<Integer, Set<OutlineNode>> collect = new HashMap<Integer, Set<OutlineNode>>();
        node.collectNodesByLevel(collect);
        int maxLevel = 0;
        for (Object level : collect.keySet()) {
            maxLevel = Math.max((Integer)level, maxLevel);
        }
        Object[] sortedResult = new Object[maxLevel + 1];
        for (Map.Entry entry : collect.entrySet()) {
            sortedResult[((Integer)entry.getKey()).intValue() - 1] = entry.getValue();
        }
        HashSet<String> leftExpressSet = new HashSet<String>();
        for (Object object : sortedResult) {
            Set outlineNodeList = (Set)object;
            if (outlineNodeList == null) continue;
            ComputingCommandInfo command = new ComputingCommandInfo();
            for (OutlineNode outlineNode : outlineNodeList) {
                if (outlineNode.isDynamicType() || leftExpressSet.contains(outlineNode.getNumber())) continue;
                leftExpressSet.add(outlineNode.getNumber());
                AggExpressionItem expression = new AggExpressionItem();
                expression.setExpressLeft(outlineNode.getNumber());
                for (OutlineNode child : outlineNode.getDirectChildren()) {
                    if (child.isSkipAggOprt()) continue;
                    expression.getExpressRight().add(new AggPair(child.getNumber(), child.getAggOprt()));
                }
                if (expression.getExpressRight().isEmpty()) continue;
                command.addExpression((IExpressionItem)expression);
            }
            if (command.getExpressionItems().isEmpty()) continue;
            command.setMainDimName(dimensionNumber);
            command.setMainMeaName("FMONEY");
            if (scopeInfo != null) {
                for (DimensionFilterItem filter : scopeInfo.getFilters()) {
                    if (filter.getName().equals(command.getMainDimName())) continue;
                    command.getFilter().add(filter);
                }
            }
            commands.add(command);
        }
    }
}

