/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.member;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.computing.ScriptBuiltin;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.XDMScopeInfo;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.member.ScriptMemberExtDimensionNode;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ScriptAllMemberExtDimensionNode
extends ScriptMember {
    private final Map<String, ScriptMemberExtDimensionNode> extDimensionNodeMap;
    private final IOutline outline;
    private String datamodelNum;
    private Long datamodelId;
    private long extGroupId;
    private Object saveCommand;
    private List<Object> invSaveCommands = new ArrayList<Object>(10);
    private ExtendDimGroupType groupType;

    public String getDatamodelNum() {
        return this.datamodelNum;
    }

    public void setDatamodelNum(String datamodelNum) {
        this.datamodelNum = datamodelNum;
    }

    public Long getDatamodelId() {
        return this.datamodelId;
    }

    public void setDatamodelId(Long datamodelId) {
        this.datamodelId = datamodelId;
    }

    public ExtendDimGroupType getGroupType() {
        return this.groupType;
    }

    public ScriptAllMemberExtDimensionNode(List<ScriptMember> allNodes, String datamodelNum, Long datamodelId, IOutline outline, long extGroupId, String groupType) {
        super(datamodelNum);
        LinkedHashMap<String, ScriptMemberExtDimensionNode> map = new LinkedHashMap<String, ScriptMemberExtDimensionNode>(allNodes.size());
        for (ScriptMember node : allNodes) {
            map.put(node.getNumber(), new ScriptMemberExtDimensionNode(node.getNumber(), node.getDimension(), node.getId(), datamodelNum));
        }
        this.extDimensionNodeMap = MapUtils.unmodifiableMap(map);
        this.datamodelNum = datamodelNum;
        this.datamodelId = datamodelId;
        this.extGroupId = extGroupId;
        this.outline = outline;
        this.groupType = ExtendDimGroupType.getEnumByIndex((String)groupType);
    }

    @Override
    public Object __getUndefinedProperty(String propertyName) {
        if (StringUtils.isNotEmpty((CharSequence)propertyName) && this.extDimensionNodeMap.containsKey(propertyName)) {
            return this.extDimensionNodeMap.get(propertyName);
        }
        throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u62d3\u5c55\u6570\u636e\u6a21\u578b\u201c%2$s\u201d\u3002", (String)"ScriptMemberExtDimensionNode_1", (String)"fi-bcm-computing", (Object[])new Object[0]), propertyName, this.datamodelNum));
    }

    @KSMethod
    public String[] getColumns() {
        String[] strs;
        int count = 0;
        if (this.groupType != ExtendDimGroupType.EQUITY) {
            QFilter qf = new QFilter("extmodelid", "=", (Object)this.datamodelId);
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)ThreadCache.get((Object)this.datamodelId, () -> QueryServiceHelper.query((String)"bcm_extmodeldim", (String)"dimension.number", (QFilter[])new QFilter("extmodelid", "=", (Object)this.datamodelId).toArray(), (String)"sequence"));
            strs = new String[this.extDimensionNodeMap.size() + dynamicObjects.size()];
            for (DynamicObject dyn : dynamicObjects) {
                strs[count] = dyn.getString("dimension.number");
                ++count;
            }
        } else {
            strs = new String[this.extDimensionNodeMap.size()];
        }
        for (Map.Entry<String, ScriptMemberExtDimensionNode> entry : this.extDimensionNodeMap.entrySet()) {
            strs[count] = entry.getKey();
            ++count;
        }
        return strs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KSMethod
    public Object getColValue(Object[] params) {
        this.paramsNotNull(params);
        if (this.groupType == ExtendDimGroupType.EQUITY) {
            ScriptMemberExtDimensionNode node;
            this.checkInvestModelMethod("getColValue");
            if (params.length > 7) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"getColValue", 7});
            }
            if (params.length < 4) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684getColValue\u65b9\u6cd5\u5fc5\u987b\u6307\u5b9a\u5b8c\u6574\u7684\u53c2\u6570\uff0c\u5305\u62ec\u76ee\u6807\u5b57\u6bb5\u3001\u6295\u8d44\u5355\u4f4d\u3001\u88ab\u6295\u8d44\u5355\u4f4d\u548c\u80a1\u6bd4\u7c7b\u578b", (String)"ScriptMemberExtDimensionNode_23", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            if (!(params[0] instanceof String && params[1] instanceof String && params[2] instanceof String && params[3] instanceof String)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            boolean isDynamic = false;
            String ctxDimStr = "";
            String mergeOrg = "";
            if (params.length == 5) {
                if (params[4] instanceof String) {
                    ctxDimStr = (String)params[4];
                } else {
                    if (!(params[4] instanceof Boolean)) throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
                    isDynamic = (Boolean)params[4];
                }
            } else if (params.length == 6) {
                if (!(params[4] instanceof String) || !(params[5] instanceof Boolean)) {
                    throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
                }
                ctxDimStr = (String)params[4];
                isDynamic = (Boolean)params[5];
            } else if (params.length == 7) {
                if (!(params[6] instanceof String)) {
                    throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
                }
                mergeOrg = (String)params[6];
            }
            HashMap<String, String> dimMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)ctxDimStr)) {
                String[] dims;
                for (String dimStr : dims = ctxDimStr.split(",")) {
                    String[] split = dimStr.split("[@.]", 2);
                    String dim = split[0];
                    List<String> scopeDims = Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.SCENARIO.getNumber());
                    Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)this.outline.getModelNum());
                    if (!scopeDims.contains(dim) && !scopeDims.contains(shortNums.get(dim))) {
                        throw new BizRuleException(ResManager.loadKDString((String)"getColValue\u51fd\u6570\u7ef4\u5ea6\u7ec4\u5408\u53c2\u6570\u53ea\u80fd\u6307\u5b9a\u60c5\u666f\u3001\u8d22\u5e74\u3001\u671f\u95f4\u548c\u7ec4\u7ec7\u3002", (String)"ScriptAllMemberExtDimensionNode_1", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    String key = shortNums.get(dim) == null ? dim : (String)shortNums.get(dim);
                    dimMap.put(key, split[1]);
                }
            }
            if ((node = this.extDimensionNodeMap.get(params[0].toString())) != null) return node.getColValue(this.datamodelNum, params[1].toString().trim(), params[2].toString().trim(), params[3].toString().trim(), isDynamic, dimMap, mergeOrg);
            throw new BizRuleException(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684getColValue\u65b9\u6cd5\u4e2d\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u62d3\u5c55\u5b57\u6bb5\u7f16\u7801\u3002", (String)"ScriptMemberExtDimensionNode_25", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        ScriptMemberExtDimensionNode node = this.checkNumAndScope(params, "getColValue");
        XDMScopeInfo xdmScopeInfo = params.length == 2 ? (XDMScopeInfo)params[1] : new XDMScopeInfo();
        return node.getColValue(this.datamodelNum, xdmScopeInfo);
    }

    @KSMethod
    public BigDecimal getColSum(Object[] params) {
        this.paramsNotNull(params);
        this.checkNormalModelMethod("getColSum");
        ScriptMemberExtDimensionNode node = this.checkNumAndScope(params, "getColSum");
        XDMScopeInfo xdmScopeInfo = params.length == 2 ? (XDMScopeInfo)params[1] : new XDMScopeInfo();
        return node.getColSum(this.datamodelNum, xdmScopeInfo);
    }

    @KSMethod
    public ScriptObject getColSumSet(Object[] params) {
        this.paramsNotNull(params);
        this.checkNormalModelMethod("getColSumSet");
        ScriptMemberExtDimensionNode node = this.checkNumAndScope(params, "getColSumSet");
        XDMScopeInfo xdmScopeInfo = params.length == 2 ? (XDMScopeInfo)params[1] : new XDMScopeInfo();
        return node.getColSumSet(this.datamodelNum, xdmScopeInfo);
    }

    @KSMethod
    public XDMScopeInfo XDMScope(Object[] xdmScope) {
        this.checkNormalModelMethod("XDMScope");
        return XDMScopeInfo.create(this.datamodelId, this.datamodelNum, this.extDimensionNodeMap.keySet(), xdmScope);
    }

    @KSMethod
    public XDMScopeInfo XDMScope() {
        return this.XDMScope(null);
    }

    @KSMethod
    public void setColValue(Object[] params) {
        this.paramsNotNull(params);
        this.checkExecuteType("setColValue");
        if (this.groupType == ExtendDimGroupType.EQUITY) {
            if (params.length > 7) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"setColValue", 7});
            }
            if (params.length < 5) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"setColValue", 5});
            }
            if (!(params[1] instanceof String && params[2] instanceof String && params[3] instanceof String && params[4] instanceof String && (params.length != 6 || params[5] != null && ("true".equalsIgnoreCase(params[5].toString()) || "false".equalsIgnoreCase(params[5].toString()))) && (params.length != 7 || params[6] instanceof String))) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            boolean isCustomed = params.length == 6 && Boolean.parseBoolean(params[5].toString());
            String mergeOrg = params.length == 7 ? (String)params[6] : "";
            Object[] methodParams = new Object[]{this.outline, this.extDimensionNodeMap, this.datamodelNum, params[0], params[1].toString(), params[2].toString(), params[3].toString(), params[4].toString(), isCustomed, mergeOrg};
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"setColValue", (Object[])methodParams);
        } else {
            if (params.length > 3) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"setColValue", 3});
            }
            if (params.length < 2) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"setColValue", 2});
            }
            Object number = params[1];
            if (!(number instanceof String) || params.length == 3 && !(params[2] instanceof XDMScopeInfo)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            XDMScopeInfo xdmScopeInfo = params.length == 3 ? (XDMScopeInfo)params[2] : new XDMScopeInfo();
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"setColValue", (Object[])new Object[]{this.outline, this.extDimensionNodeMap, this.datamodelNum, params[0], params[1].toString(), xdmScopeInfo});
        }
    }

    @KSMethod
    public void insertRow(Object[] params) {
        this.paramsNotNull(params);
        this.checkExecuteType("insertRow");
        if (this.groupType == ExtendDimGroupType.EQUITY) {
            Object[] objectArray;
            if (params.length > 7) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"insertRow", 7});
            }
            if (params.length < 5) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"insertRow", 5});
            }
            if (!(params[0] instanceof String) || !(params[1] instanceof String) || !(params[2] instanceof String) || !(params[3] instanceof String) || !(params[4] instanceof Object[]) && params[3].toString().contains(",") || params.length == 6 && (params[5] == null || !"true".equalsIgnoreCase(params[5].toString()) && !"false".equalsIgnoreCase(params[5].toString())) || params.length == 7 && !(params[6] instanceof String)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            boolean isCustomed = params.length == 6 && Boolean.parseBoolean(params[5].toString());
            String mergeOrg = params.length == 7 ? (String)params[6] : "";
            Object[] objectArray2 = new Object[10];
            objectArray2[0] = this.outline;
            objectArray2[1] = this.datamodelNum;
            objectArray2[2] = this.invSaveCommands;
            objectArray2[3] = params[0];
            objectArray2[4] = params[1];
            objectArray2[5] = params[2];
            objectArray2[6] = params[3];
            if (params[4].getClass().isArray()) {
                objectArray = params[4];
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = params[4];
            }
            objectArray2[7] = objectArray;
            objectArray2[8] = isCustomed;
            objectArray2[9] = mergeOrg;
            Object[] methodParams = objectArray2;
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"insertRow", (Object[])methodParams);
        } else {
            String colNumbers;
            boolean isAllArray = true;
            boolean isAllNotArray = true;
            for (Object param : params) {
                if (!(param instanceof Object[])) {
                    isAllArray = false;
                    continue;
                }
                isAllNotArray = false;
            }
            if (params.length == 2 && params[0] instanceof String && params[0].toString().contains(",") && params[1] instanceof Object[]) {
                colNumbers = params[0].toString();
                if (((Object[])params[1])[0] instanceof Object[]) {
                    Object[] next;
                    for (Object param : next = (Object[])params[1]) {
                        this.saveCommand = InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"insertRow", (Object[])new Object[]{this.outline, this.datamodelNum, this.saveCommand, colNumbers, param});
                    }
                } else {
                    this.saveCommand = InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"insertRow", (Object[])new Object[]{this.outline, this.datamodelNum, this.saveCommand, colNumbers, params[1]});
                }
            } else if (isAllArray || isAllNotArray) {
                colNumbers = new StringJoiner(",").add("AuditTrail").add((CharSequence)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"getExtModelAllFieldNumStr", (Object[])new Object[]{this.datamodelId})).toString();
                if (isAllArray) {
                    for (Object param : params) {
                        Object[] temp = (Object[])param;
                        this.saveCommand = InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"insertRow", (Object[])new Object[]{this.outline, this.datamodelNum, this.saveCommand, colNumbers, temp});
                    }
                } else {
                    this.saveCommand = InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"insertRow", (Object[])new Object[]{this.outline, this.datamodelNum, this.saveCommand, colNumbers, params});
                }
            } else {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
        }
    }

    @KSMethod
    public void save() {
        if (this.saveCommand != null) {
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"save", (Object[])new Object[]{this.outline, this.saveCommand});
            this.saveCommand = null;
        }
        if (!CollectionUtils.isEmpty(this.invSaveCommands) || this.outline.getBuiltin().getArgs().get("paperTemplateNumber") != null) {
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"save", (Object[])new Object[]{this.outline, this.invSaveCommands});
        }
    }

    @KSMethod
    public void batchInsertRows(int count, String colNumbers, Object[] values) {
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"batchInsertRows", (Object[])new Object[]{this.outline, this.datamodelNum, this.datamodelId, this.extGroupId, colNumbers, values, count});
    }

    @KSMethod
    public void delRows(Object[] params) {
        this.checkExecuteType("delRows");
        if (this.groupType == ExtendDimGroupType.EQUITY) {
            this.paramsNotNull(params);
            if (params.length > 5) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"delRows", 5});
            }
            if (params.length < 3) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"delRows", 3});
            }
            if (!(params[0] instanceof String) || !(params[1] instanceof String) || !(params[2] instanceof String) || params.length >= 4 && (params[3] == null || !"true".equalsIgnoreCase(params[3].toString()) && !"false".equalsIgnoreCase(params[3].toString())) || params.length == 5 && !(params[4] instanceof String)) {
                throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
            }
            boolean isCustomed = params.length == 4 && Boolean.parseBoolean(params[3].toString());
            String mergeOrg = params.length == 5 ? (String)params[4] : "";
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"delRows", (Object[])new Object[]{this.outline, this.datamodelNum, params[0], params[1], params[2], isCustomed, mergeOrg});
        } else {
            XDMScopeInfo xdmScopeInfo = new XDMScopeInfo();
            if (params != null) {
                if (params.length > 1) {
                    throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"delRows", 1});
                }
                if (!(params[0] instanceof XDMScopeInfo)) {
                    throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
                }
                xdmScopeInfo = (XDMScopeInfo)params[0];
            }
            InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"delRows", (Object[])new Object[]{this.outline, this.datamodelNum, xdmScopeInfo});
        }
    }

    @KSMethod
    public void delRows() {
        this.delRows(new Object[]{new XDMScopeInfo()});
    }

    @KSMethod
    public void copy(String tarATCode, String ctxDimStr) {
        if (this.groupType == ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u6a21\u578b\u7684copy\u51fd\u6570\u6682\u4e0d\u652f\u6301\u6743\u76ca\u7c7b\u62d3\u5c55\u6570\u636e\u6a21\u578b\u3002", (String)"ScriptMemberExtDimensionNode_27", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.extendscript.util.ScriptBuiltinExtHelper", (String)"copy", (Object[])new Object[]{this.outline, this.datamodelNum, tarATCode, ctxDimStr, this.saveCommand});
    }

    @Override
    public String toString() {
        Object[] columns = this.getColumns();
        return Arrays.toString(columns);
    }

    private void checkInvestModelMethod(String methodName) {
        if (this.groupType != ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8be5\u65b9\u6cd5\u4ec5\u9002\u7528\u4e8e\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u6a21\u578b\u3002", (String)"ScriptMemberExtDimensionNode_22", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        ScriptBuiltin builtin = this.outline.getBuiltin();
        Object executeTypeValue = builtin.getArgs().get("executeType");
        if (executeTypeValue != BizRuleExecuteTypeEnum.EQUITY_ONLY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684%s\u65b9\u6cd5\u53ea\u80fd\u5b9a\u4e49\u5728\u6267\u884c\u7c7b\u578b\u662f'\u4ec5\u6743\u76ca\u5e95\u7a3f'\u7684\u4e1a\u52a1\u89c4\u5219\u4e2d", (String)"ScriptMemberExtDimensionNode_24", (String)"fi-bcm-computing", (Object[])new Object[0]), methodName));
        }
    }

    private void checkNormalModelMethod(String methodName) {
        if (this.groupType == ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"%s\u65b9\u6cd5\u4ec5\u9002\u7528\u4e8e\u975e\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u6a21\u578b", (String)"ScriptMemberExtDimensionNode_26", (String)"fi-bcm-computing", (Object[])new Object[0]), methodName));
        }
    }

    private void paramsNotNull(Object[] params) {
        if (params == null) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
        }
    }

    private ScriptMemberExtDimensionNode checkNumAndScope(Object[] params, String methodName) {
        if (params.length > 2) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{methodName, 2});
        }
        Object number = params[0];
        if (!(number instanceof String) || params.length == 2 && !(params[1] instanceof XDMScopeInfo)) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.scriptParamError"), new Object[0]);
        }
        ScriptMemberExtDimensionNode node = this.extDimensionNodeMap.get(number);
        if (node == null) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5b57\u6bb5\u6210\u5458\u3002", (String)"ScriptMemberExtDimensionNode_4", (String)"fi-bcm-computing", (Object[])new Object[0]), number));
        }
        return node;
    }

    private void checkExecuteType(String methodName) {
        Object executeTypeValue = this.outline.getBuiltin().getArgs().get("executeType");
        if (this.groupType != ExtendDimGroupType.EQUITY && executeTypeValue == BizRuleExecuteTypeEnum.EQUITY_ONLY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u975e\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684%s\u65b9\u6cd5\u4e0d\u80fd\u5b9a\u4e49\u5728\u6267\u884c\u7c7b\u578b\u662f'\u4ec5\u6743\u76ca\u5e95\u7a3f'\u7684\u4e1a\u52a1\u89c4\u5219\u4e2d", (String)"ScriptMemberExtDimensionNode_29", (String)"fi-bcm-computing", (Object[])new Object[0]), methodName));
        }
        if (this.groupType == ExtendDimGroupType.EQUITY && executeTypeValue != BizRuleExecuteTypeEnum.EQUITY_ONLY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684%s\u65b9\u6cd5\u53ea\u80fd\u5b9a\u4e49\u5728\u6267\u884c\u7c7b\u578b\u662f'\u4ec5\u6743\u76ca\u5e95\u7a3f'\u7684\u4e1a\u52a1\u89c4\u5219\u4e2d", (String)"ScriptMemberExtDimensionNode_24", (String)"fi-bcm-computing", (Object[])new Object[0]), methodName));
        }
    }
}

