/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.member;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.olap.common.MembersKey;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSObject;

@KSObject
public class ScriptCell
implements ScriptObject {
    private MembersKey membersKey;
    private Object value;
    private HashMap<String, Integer> dimensionIndexMap;

    public ScriptCell(HashMap<String, Integer> dimensionIndexMap, MembersKey membersKey, Object value) {
        this.membersKey = membersKey;
        this.value = value;
        this.dimensionIndexMap = dimensionIndexMap;
    }

    public Object __getUndefinedProperty(String propertyName) {
        if ("value".equals(propertyName)) {
            return this.value;
        }
        Integer dimensionIndex = this.dimensionIndexMap.get(propertyName);
        if (dimensionIndex != null) {
            return this.membersKey.getKey(dimensionIndex.intValue());
        }
        throw new UnsupportedOperationException(String.format("cell not supported property [%s] operate", propertyName));
    }

    public MembersKey getMembersKey() {
        return this.membersKey;
    }

    public String toString() {
        ArrayList memb = new ArrayList(this.membersKey.getCount());
        this.dimensionIndexMap.entrySet().forEach(e -> memb.add((String)e.getKey() + ":" + this.membersKey.getKey(((Integer)e.getValue()).intValue())));
        return "[" + Joiner.on((String)",").join(memb) + "]=" + this.value;
    }

    public String formatOutput() {
        ArrayList<String> memb = new ArrayList<String>(this.membersKey.getCount());
        for (int i = 0; i < this.membersKey.getCount(); ++i) {
            memb.add(this.membersKey.getKey(i));
        }
        memb.add(String.valueOf(this.value));
        return "[" + Joiner.on((String)" ,").join(memb) + "]";
    }
}

