/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.member;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.script.ScriptFunction;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.OlapMeasureHandleUtil;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.member.ScriptCell;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.WrappedException;

@KSObject
public class ScriptCellSet
implements ScriptObject,
Iterable<ScriptCell> {
    private CellSet cellSet;
    private List<DimensionFilterItem> fixDimensions;
    private List<String> dimensions;
    private Set<String> dimensionSet;
    private OlapConnection olapConnection;
    private String defaultMember;
    private HashMap<String, Set<String>> memberMap;
    private HashMap<String, Integer> dimenisonIndexMap;
    private Map<String, String> dimShort2NumMap;
    private Boolean isAsc;
    private boolean zeroToNull = true;
    private ComputingContext computingContext;

    public CellSet getCellSet() {
        return this.cellSet;
    }

    public List<DimensionFilterItem> getFixDimensions() {
        return this.fixDimensions;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public OlapConnection getOlapConnection() {
        return this.olapConnection;
    }

    public String getDefaultMember() {
        return this.defaultMember;
    }

    public HashMap<String, Set<String>> getMemberMap() {
        return this.memberMap;
    }

    public HashMap<String, Integer> getDimenisonIndexMap() {
        return this.dimenisonIndexMap;
    }

    public ScriptCellSet(OlapConnection olapConnection, CellSet cellSet, List<DimensionFilterItem> fixDimensions, List<String> dimensions, HashMap<String, Set<String>> memberMap, Map<String, String> dimShort2NumMap, ComputingContext computingContext) {
        this.olapConnection = olapConnection;
        this.cellSet = cellSet;
        this.fixDimensions = fixDimensions;
        this.dimensions = dimensions;
        this.dimensionSet = new HashSet<String>(dimensions);
        this.dimenisonIndexMap = this.initDimensionIndexMap();
        this.memberMap = memberMap;
        this.dimShort2NumMap = dimShort2NumMap;
        this.computingContext = computingContext;
    }

    public ScriptCellSet(OlapConnection olapConnection, CellSet cellSet, List<DimensionFilterItem> fixDimensions, List<String> dimensions, HashMap<String, Set<String>> memberMap, Map<String, String> dimShort2NumMap, ComputingContext computingContext, Boolean isAsc) {
        this(olapConnection, cellSet, fixDimensions, dimensions, memberMap, dimShort2NumMap, computingContext);
        this.isAsc = isAsc;
    }

    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty() && propertyName.equals("length")) {
            return this.cellSet.getCount();
        }
        throw new WrappedException((Throwable)new UnsupportedOperationException(String.format("%s not supported property [%s] operate", "CellSet", propertyName)));
    }

    public final HashMap<String, Integer> initDimensionIndexMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        String[] dims = this.dimensions.toArray(new String[0]);
        for (int i = 0; i < dims.length; ++i) {
            map.put(dims[i], i);
        }
        return map;
    }

    private Map<String, String> initDimensionNumMap() {
        return new HashMap<String, String>();
    }

    public Object get(Object ... objects) {
        String[] rowKeys = this.getRowKeys(objects, 0);
        return this.cellSet.get(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField());
    }

    public void set(Object value, ScriptCell scriptCell) {
        int count = scriptCell.getMembersKey().getCount();
        String[] rowKeys = new String[count];
        for (int i = 0; i < count; ++i) {
            rowKeys[i] = (String)scriptCell.getMembersKey().get(i);
        }
        this.setOlapMeasure(rowKeys, value);
    }

    public void set(Object ... objects) {
        String[] rowKeys = this.getRowKeys(objects, 1);
        this.setOlapMeasure(rowKeys, objects[0]);
    }

    private void setOlapMeasure(String[] rowKeys, Object object) {
        Object value = object;
        this.validDimMemberWithCtx(rowKeys);
        if (this.zeroToNull && this.isZero(value)) {
            this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
        } else {
            if (value instanceof Number) {
                value = this.computingContext.executeRound(OlapMeasureHandleUtil.handleMeasure((Object)value));
            }
            this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
        }
    }

    public void add(Object ... objects) {
        String[] rowKeys = this.getRowKeys(objects, 1);
        Object value = objects[0];
        this.validDimMemberWithCtx(rowKeys);
        if (!(this.zeroToNull && this.isZero(value) || value == null)) {
            Object oldValue = this.cellSet.get(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (oldValue == null) {
                if (value instanceof Number) {
                    value = this.computingContext.executeRound(value);
                }
                this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), value);
            } else if (oldValue instanceof Number && value instanceof Number) {
                BigDecimal left = new BigDecimal(oldValue.toString());
                BigDecimal right = new BigDecimal(value.toString());
                this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), this.computingContext.executeRound(left.add(right)));
            } else if (oldValue instanceof String || value instanceof String) {
                this.cellSet.set(rowKeys, FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)(oldValue.toString() + value.toString()));
            }
        }
    }

    private void validDimMemberWithCtx(String[] rowKeys) {
        if (this.computingContext.isIgnoreVerify()) {
            return;
        }
        for (Map.Entry<String, Integer> entrySet : this.dimenisonIndexMap.entrySet()) {
            if (!this.computingContext.getScopeItems().containsKey(entrySet.getKey()) || rowKeys[entrySet.getValue()].equals(this.computingContext.getScopeItems().get((Object)entrySet.getKey()).p2)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u7ef4\u5ea6\u6210\u5458[%s]\u4e0e\u5f53\u524d\u4e0a\u4e0b\u6587\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ScriptCellSet_0", (String)"fi-bcm-computing", (Object[])new Object[0]), rowKeys[entrySet.getValue()]));
        }
    }

    private boolean isZero(Object value) {
        if (value instanceof Integer) {
            return value == Integer.valueOf(0);
        }
        if (value instanceof Double) {
            return ((Double)value).compareTo(0.0) == 0;
        }
        if (value instanceof Long) {
            return value == Long.valueOf(0L);
        }
        if (value instanceof Float) {
            return ((Float)value).compareTo(Float.valueOf(0.0f)) == 0;
        }
        if (value instanceof Short) {
            return ((Short)value).compareTo((short)0) == 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.ZERO) == 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    public void setDefaultMember(Object defaultMember) {
        if (defaultMember instanceof String) {
            this.defaultMember = defaultMember.toString();
        } else if (defaultMember instanceof ScriptMember) {
            ScriptMember scriptMember = (ScriptMember)defaultMember;
            String dimNumber = scriptMember.getDimension().getNumber();
            String memberNumber = scriptMember.getNumber();
            this.defaultMember = dimNumber + "@" + memberNumber;
        } else {
            throw new IllegalArgumentException(String.format("cellSet setDefaultMember method param [%s] class type must be String or ScriptMember", defaultMember));
        }
    }

    @KSMethod
    public void setZeroToNull(boolean value) {
        this.zeroToNull = value;
    }

    public void save() {
        SaveCommandInfo saveCommandInfo = new SaveCommandInfo();
        saveCommandInfo.setDimensions(this.dimensions.toArray(new String[0]));
        saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Object ruleInternal = this.computingContext.getOutline().getBuiltin().getArgs().get("ruleInternal");
        OlapCommandUtil.addSourceMeasure((String)this.computingContext.getOutline().getModelNum(), (CommandInfo)saveCommandInfo, (Integer)(ruleInternal instanceof Integer ? (Integer)ruleInternal : null));
        this.fixDimensions.forEach((? super T f) -> {
            String member = f.getName().equals(PresetConstant.PROCESS_DIM) ? this.handleProcess((String)f.getValues().get(0)) : (String)f.getValues().get(0);
            saveCommandInfo.addfixedDimension(new String[]{f.getName(), member});
        });
        OlapCommand olapCommand = new OlapCommand(this.olapConnection, (CommandInfo)saveCommandInfo);
        OlapComTraceUtil.setTraceId((CommandInfo)saveCommandInfo);
        try (OlapDataWriter writer = olapCommand.CreateWriter();){
            this.cellSet.Save(writer);
        }
    }

    private String handleProcess(String memberNum) {
        if ("EIRpt".equals(memberNum)) {
            return "IRpt";
        }
        if ("ERAdj".equals(memberNum)) {
            return "RAdj";
        }
        return memberNum;
    }

    private String[] getRowKeys(Object[] objects, int startIndex) {
        String[] dimMemberSplit;
        int dimIndex;
        int i;
        int rowKeyLength = this.dimensions.size();
        int realLength = objects.length - startIndex;
        Object firstParam = objects[startIndex];
        if (realLength == 1 && firstParam instanceof String && firstParam.toString().contains(",")) {
            objects = this.getRealObjects(objects, startIndex);
            realLength = objects.length - startIndex;
        }
        if (realLength > rowKeyLength) {
            throw new IllegalArgumentException(String.format("cellSet get or set method params length is too long : %s", Arrays.toString(objects)));
        }
        String[] rowKeys = new String[rowKeyLength];
        for (i = startIndex; i < objects.length; ++i) {
            String memberNumber;
            String dimNumber;
            Object object = objects[i];
            if (object instanceof String) {
                String[] dimMemberSplit2 = this.getDimMemberSplit(object.toString(), startIndex == 0);
                dimNumber = dimMemberSplit2[0];
                memberNumber = dimMemberSplit2[1];
                Integer dimIndex2 = this.dimenisonIndexMap.get(dimNumber);
                rowKeys[dimIndex2.intValue()] = memberNumber;
                continue;
            }
            if (object instanceof ScriptMember) {
                ScriptMember scriptMember = (ScriptMember)object;
                dimNumber = scriptMember.getDimension().getNumber();
                memberNumber = scriptMember.getNumber();
                if (startIndex == 0) {
                    this.checkLoadMember(dimNumber, memberNumber);
                }
                int dimIndex3 = this.dimenisonIndexMap.get(dimNumber);
                rowKeys[dimIndex3] = memberNumber;
                continue;
            }
            throw new IllegalArgumentException(String.format("cellSet get or set method param [%s] class type must be String or ScriptMember", object));
        }
        if (this.defaultMember != null && rowKeys[dimIndex = this.dimenisonIndexMap.get((dimMemberSplit = this.getDimMemberSplit(this.defaultMember, startIndex == 0))[0]).intValue()] == null) {
            rowKeys[dimIndex] = dimMemberSplit[1];
        }
        for (i = 0; i < rowKeys.length; ++i) {
            String rowKey = rowKeys[i];
            if (rowKey != null) continue;
            throw new IllegalArgumentException(String.format("cellSet get or set method param Dimension[%s] must be set member.", this.dimensions.get(i)));
        }
        return rowKeys;
    }

    private Object[] getRealObjects(Object[] objects, int startIndex) {
        String param = objects[startIndex].toString().replaceAll(" ", "");
        String[] dimInfo = param.split(",");
        Object[] result = new Object[dimInfo.length + startIndex];
        System.arraycopy(objects, 0, result, 0, startIndex);
        System.arraycopy(dimInfo, 0, result, startIndex, dimInfo.length);
        return result;
    }

    private String[] getDimMemberSplit(String dimMember, boolean isGet) {
        String[] dimMemberSplit = new String[2];
        int ind = dimMember.indexOf(64);
        if (ind == -1) {
            ind = dimMember.indexOf(46);
        }
        dimMemberSplit[0] = dimMember.substring(0, ind);
        dimMemberSplit[1] = dimMember.substring(ind + 1);
        if (ind == -1) {
            throw new IllegalArgumentException(String.format("cellSet get or set method param [%s] error,format: dimName@member .", dimMember));
        }
        dimMemberSplit[0] = this.dimShort2NumMap.containsKey(dimMemberSplit[0]) ? this.dimShort2NumMap.get(dimMemberSplit[0]) : dimMemberSplit[0];
        String dimName = dimMemberSplit[0];
        if (dimName != null && !this.dimensionSet.contains(dimName)) {
            throw new IllegalArgumentException(String.format("cellSet param error,Dimension[%s] is fixDimension.", dimName));
        }
        if (isGet) {
            this.checkLoadMember(dimName, dimMemberSplit[1]);
        }
        return dimMemberSplit;
    }

    private void checkLoadMember(String dimName, String memberName) {
        Set<String> members = this.memberMap.get(dimName);
        if (members != null && !members.contains(memberName)) {
            throw new IllegalArgumentException(String.format("cellSet getCellSet method not load Dimension[%s] Member[%s] data.", dimName, memberName));
        }
    }

    @KSMethod
    public void forEach(ScriptFunction func) {
        ScriptCell cell;
        Iterator<ScriptCell> iter = this.iterator();
        ArrayList<ScriptCell> cells = new ArrayList<ScriptCell>(10);
        while (iter.hasNext()) {
            cells.add(iter.next());
        }
        int i = 0;
        Object returnV = null;
        Iterator iterator = cells.iterator();
        while (!(!iterator.hasNext() || (returnV = func.call(new Object[]{cell = (ScriptCell)iterator.next(), i++})) instanceof Boolean && ((Boolean)returnV).booleanValue())) {
        }
    }

    public String toString() {
        if (this.isAsc == null) {
            return this.cellSet.toString();
        }
        StringJoiner sj = new StringJoiner(System.lineSeparator());
        for (ScriptCell next : this) {
            sj.add(next.formatOutput());
        }
        return sj.toString();
    }

    @Override
    @NotNull
    public Iterator<ScriptCell> iterator() {
        return new ScriptCellIterator();
    }

    private class ScriptCellIterator
    implements Iterator<ScriptCell> {
        private Iterator<Pair<MembersKey, Object>> iter = this.sort();

        private ScriptCellIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public ScriptCell next() {
            Pair<MembersKey, Object> item = this.iter.next();
            return new ScriptCell(ScriptCellSet.this.dimenisonIndexMap, (MembersKey)item.component1(), item.component2());
        }

        public final Iterator<Pair<MembersKey, Object>> sort() {
            this.iter = ScriptCellSet.this.cellSet.getMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField());
            if (ScriptCellSet.this.isAsc == null) {
                return this.iter;
            }
            ArrayList<Object> pairs = new ArrayList<Object>();
            while (this.iter.hasNext()) {
                Pair<MembersKey, Object> pair = this.iter.next();
                pairs.add(pair);
            }
            Comparator<Pair> comparatorAsc = Comparator.comparing(s -> {
                try {
                    return new BigDecimal(String.valueOf(s.component2()));
                }
                catch (Exception e) {
                    return null;
                }
            }, Comparator.nullsLast(BigDecimal::compareTo));
            Comparator<Pair> comparatorDesc = Comparator.comparing(s -> {
                try {
                    return new BigDecimal(String.valueOf(s.component2()));
                }
                catch (Exception e) {
                    return null;
                }
            }, Comparator.nullsFirst(BigDecimal::compareTo).reversed());
            if (ScriptCellSet.this.isAsc.booleanValue()) {
                pairs.sort(comparatorAsc);
            } else {
                pairs.sort(comparatorDesc);
            }
            return pairs.iterator();
        }
    }
}

