/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.member;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.HashMultimap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptObject;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.json.JSONObject;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.bizabout.cach.ScriptCache;
import kd.fi.bcm.computing.datasource.IOutline;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

@KSObject
public class ScriptMemberEntityNode
extends ScriptMember {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public ScriptMemberEntityNode(String name, ScriptDimension dimension, long id) {
        super(name, dimension, id);
    }

    @Override
    public Object __getUndefinedProperty(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty()) {
            if ("PC".equalsIgnoreCase(propertyName)) {
                return this.getIDNumberTreeNode().getParent().getCurrency();
            }
            if ("EC".equalsIgnoreCase(propertyName)) {
                return this.getIDNumberTreeNode().getCurrency();
            }
            if ("IsIC".equalsIgnoreCase(propertyName)) {
                Boolean isIC = (Boolean)this.getIDNumberTreeNode().loadAndConsumerProp("isinnerorg", dyna -> dyna.getBoolean("isinnerorg"));
                if (isIC.booleanValue() && this.getOutline().getComputingContext().getScopeItems() != null) {
                    Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, this.getNumber()};
                    return InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isValidIC", (Object[])params);
                }
                return isIC;
            }
            if ("isDependent".equalsIgnoreCase(propertyName)) {
                return this.getIDNumberTreeNode().loadAndConsumerProp("isindependentorg", dyna -> dyna.getBoolean("isindependentorg"));
            }
            if ("controlOrg".equalsIgnoreCase(propertyName)) {
                Long id = (Long)this.getIDNumberTreeNode().loadAndConsumerProp("ctrlorg.id", dyna -> dyna.getLong("ctrlorg.id"));
                if (id != 0L) {
                    IDNumberTreeNode node = this.getIDNumberTreeNode(this.getOutline().getModelNum(), DimEntityNumEnum.getEntieyNumByNumber((String)this.getDimension().getNumber()), id);
                    return ScriptMember.create(node.getNumber(), this.getDimension(), id);
                }
                return null;
            }
            if ("cslNum".equalsIgnoreCase(propertyName)) {
                return this.getIDNumberTreeNode().getProperty("cslscheme");
            }
            return super.__getUndefinedProperty(propertyName);
        }
        return super.__getUndefinedProperty(propertyName);
    }

    @KSMethod
    public String getVirtualEntity() {
        IDNumberTreeNode parent = this.getIDNumberTreeNode().getParent();
        if (parent != null) {
            return parent.getNumber() + "_" + this.number;
        }
        return null;
    }

    @KSMethod
    public ScriptMember[] validBase() {
        return (ScriptMember[])ScriptCache.getCacheOf("validBase_" + this.getDimension().getNumber() + this.getId(), () -> {
            ScriptMember[] allMembers = this.base();
            ScriptMember[] members = ScriptMemberEntityNode.getEffectiveMembers(allMembers, this.getDimension());
            return ScriptMemberEntityNode.excludeNotMergeEntity(false, members, this.getNumber(), this.getDimension());
        });
    }

    @KSMethod
    public ScriptMember[] validChildren() {
        return (ScriptMember[])ScriptCache.getCacheOf("validChildren_" + this.getDimension().getNumber() + this.getId(), () -> {
            ScriptMember[] allMembers = this.children();
            ScriptMember[] members = ScriptMemberEntityNode.getEffectiveMembers(allMembers, this.getDimension());
            return ScriptMemberEntityNode.excludeNotMergeEntity(false, members, this.getNumber(), this.getDimension());
        });
    }

    public static ScriptMember[] getEffectiveMembers(ScriptMember[] allMembers, ScriptDimension dimension) {
        ArrayList<ScriptMember> newlist = new ArrayList<ScriptMember>();
        List<String> orgNumberList = Arrays.stream(allMembers).map(member -> member.getNumber()).collect(Collectors.toList());
        List<DynamicObject> effectiveOrg = ScriptMemberEntityNode.getEffectiveOrg(orgNumberList, dimension);
        if (CollectionUtils.isNotEmpty(effectiveOrg)) {
            Map<Long, String> map = effectiveOrg.stream().collect(Collectors.toMap(org -> org.getLong("id"), org -> org.getString("number")));
            for (ScriptMember scriptNode : allMembers) {
                if (!map.containsKey(scriptNode.getId())) continue;
                newlist.add(scriptNode);
            }
        }
        ScriptMember[] members = newlist.toArray(new ScriptMember[0]);
        return members;
    }

    private static List<DynamicObject> getEffectiveOrg(List<String> orgNumberList, ScriptDimension dimension) {
        long modelId = MemberReader.findModelIdByNum((String)dimension.getOutline().getModelNum());
        long yearId = (Long)dimension.getOutline().getComputingContext().getDimMemberPairOnCommParam((String)PresetConstant.FY_DIM).p1;
        long periodId = (Long)dimension.getOutline().getComputingContext().getDimMemberPairOnCommParam((String)PresetConstant.PERIOD_DIM).p1;
        long sceneId = (Long)dimension.getOutline().getComputingContext().getDimMemberPairOnCommParam((String)PresetConstant.SCENE_DIM).p1;
        QFBuilder qf = new QFBuilder("number", "in", orgNumberList);
        qf.add("model", "=", (Object)modelId);
        qf.add("isexchangerate", "=", (Object)false);
        String selectStr = "id, name, number,longnumber, bizchangerds.changetype, bizchangerds.bizeffdate";
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)selectStr, (QFilter[])qf.toArray(), (String)"dseq");
        ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>(Arrays.asList(orgs));
        Object[] params = new Object[]{orgList, modelId, yearId, periodId, sceneId};
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.dimension.util.EntityVersioningUtil", (String)"filterVersionOrgTree", (Object[])params);
        return orgList;
    }

    @KSMethod
    public ScriptMember[] validDescendant() {
        return (ScriptMember[])ScriptCache.getCacheOf("validDescendant_" + this.getDimension().getNumber() + this.getId(), () -> {
            ScriptMember[] allMembers = this.descendant();
            ScriptMember[] members = ScriptMemberEntityNode.getEffectiveMembers(allMembers, this.getDimension());
            return ScriptMemberEntityNode.excludeNotMergeEntity(false, members, this.getNumber(), this.getDimension());
        });
    }

    public static ScriptMember[] excludeNotMergeEntity(boolean isExistPredicate, ScriptMember[] members, String parentNum, ScriptDimension dimension) {
        if (members == null || members.length <= 0) {
            return members;
        }
        long modelId = MemberReader.findModelIdByNum((String)dimension.getOutline().getModelNum());
        long scenarioId = (Long)dimension.getOutline().getComputingContext().getDimMemberPairOnCommParam((String)PresetConstant.SCENE_DIM).p1;
        long yearId = (Long)dimension.getOutline().getComputingContext().getDimMemberPairOnCommParam((String)PresetConstant.FY_DIM).p1;
        long periodId = (Long)dimension.getOutline().getComputingContext().getDimMemberPairOnCommParam((String)PresetConstant.PERIOD_DIM).p1;
        Object[] params = new Object[]{modelId, scenarioId, yearId, periodId};
        HashMultimap allNotMergePairs = (HashMultimap)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.mergecontrol.MergeControlHelper", (String)"getCancelMergeDataByModel", (Object[])params);
        if (allNotMergePairs == null || allNotMergePairs.isEmpty()) {
            return members;
        }
        ArrayList membList = new ArrayList(members.length);
        HashMultimap mergeSet = HashMultimap.create();
        for (ScriptMember m2 : members) {
            mergeSet.put((Object)m2.getNumber(), (Object)m2);
        }
        HashMultimap compareNotMergeSet = HashMultimap.create();
        for (String membNum : mergeSet.keys()) {
            if (!allNotMergePairs.containsKey((Object)membNum)) continue;
            compareNotMergeSet.putAll((Object)membNum, (Iterable)allNotMergePairs.get((Object)membNum));
        }
        for (Map.Entry entry : mergeSet.asMap().entrySet()) {
            if (!compareNotMergeSet.containsKey(entry.getKey())) {
                membList.addAll((Collection)entry.getValue());
                continue;
            }
            Set pairSet = compareNotMergeSet.get(entry.getKey());
            boolean isInvalidate = ((Collection)entry.getValue()).stream().allMatch(m -> {
                ScriptMember parent = m.parent();
                if (parent != null) {
                    return pairSet.stream().anyMatch(p -> ((String)p.p2).equals(parent.getNumber()));
                }
                return pairSet.stream().anyMatch(p -> ((String)p.p2).equals(parentNum) || dimension.isDescendant((String)p.p2, parentNum));
            });
            if (isExistPredicate) {
                IDNumberTreeNode currentMember = MemberReader.findEntityMemberByNum((String)dimension.getOutline().getModelNum(), (String)((String)entry.getKey()));
                if (currentMember.getShareNodes() != null) {
                    int i = 0;
                    for (IDNumberTreeNode m3 : currentMember.getShareNodes()) {
                        if (!dimension.isDescendant(m3.getParent().getNumber(), parentNum) && !m3.getParent().getNumber().equals(parentNum)) continue;
                        ++i;
                    }
                    if (dimension.isDescendant(currentMember.getParent().getNumber(), parentNum) || currentMember.getParent().getNumber().equals(parentNum)) {
                        ++i;
                    }
                    isInvalidate = isInvalidate && i == pairSet.size();
                }
            } else {
                boolean bl = isInvalidate = isInvalidate && ((Collection)entry.getValue()).size() == pairSet.size();
            }
            if (isInvalidate) continue;
            membList.addAll((Collection)entry.getValue());
        }
        Iterator it = membList.iterator();
        while (it.hasNext()) {
            ScriptMember p = (ScriptMember)it.next();
            ArrayList<IDNumberTreeNode> list = new ArrayList<IDNumberTreeNode>(4);
            IDNumberTreeNode currentMember = MemberReader.findEntityMemberByNum((String)dimension.getOutline().getModelNum(), (String)p.getNumber());
            list.add(currentMember);
            if (currentMember.getShareNodes() != null) {
                list.addAll(currentMember.getShareNodes());
            }
            list.removeIf(m -> !m.getLongNumber().contains("!" + parentNum + "!"));
            boolean isInvalidate = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IDNumberTreeNode m4;
                boolean tempBoolean = false;
                for (IDNumberTreeNode temp = m4 = (IDNumberTreeNode)iterator.next(); temp != null && temp.getParent() != null && ScriptMemberEntityNode.isValidateMember(parentNum, dimension, temp.getNumber()); temp = temp.getParent()) {
                    if (!allNotMergePairs.containsKey((Object)temp.getNumber())) continue;
                    for (Pair np : allNotMergePairs.get((Object)temp.getNumber())) {
                        if (!ScriptMemberEntityNode.isValidateMember(parentNum, dimension, (String)np.p2) || temp.getParent() == null || !temp.getParent().getNumber().equals(np.p2)) continue;
                        tempBoolean = true;
                        break;
                    }
                    if (tempBoolean) break;
                }
                isInvalidate = isInvalidate && tempBoolean;
            }
            if (!isInvalidate) continue;
            it.remove();
        }
        HashMap map = new HashMap(membList.size());
        membList.forEach(e -> map.put(e.getNumber(), e));
        return map.values().toArray(new ScriptMember[0]);
    }

    @KSMethod
    public ScriptMember[] parents() {
        return this.parents(null);
    }

    @KSMethod
    public ScriptMember[] parents(String cslscheme) {
        IOutline outline = this.getOutline();
        String modelNum = outline.getModelNum();
        List<IDNumberTreeNode> allNodes = this.getAllNodes(this.getDimension().getNumber(), modelNum, this.getNumber(), cslscheme);
        ScriptMember[] scriptMembers = new ScriptMember[allNodes.size()];
        for (int i = 0; i < allNodes.size(); ++i) {
            IDNumberTreeNode parent = allNodes.get(i).getParent();
            scriptMembers[i] = ScriptMember.create(parent.getNumber(), this.getDimension(), parent.getId());
        }
        return scriptMembers;
    }

    @KSMethod
    public ScriptMember commonParent(String memNum) {
        IDNumberTreeNode otherNode = MemberReader.findEntityMemberByNum((String)this.getOutline().getModelNum(), (String)memNum);
        if (otherNode != IDNumberTreeNode.NotFoundTreeNode) {
            ScriptMember otherMember = this.getDimension().member(memNum, (String)this.getIDNumberTreeNode().getProperty("cslscheme"));
            return this.commonParent(otherMember);
        }
        return null;
    }

    @KSMethod
    public ScriptMember commonParent(ScriptMember scriptMember) {
        String otherLongNum = MemberReader.findEntityMemberById((String)this.getOutline().getModelNum(), (Long)scriptMember.getId()).getLongNumber();
        String thisLongNum = MemberReader.findEntityMemberById((String)this.getOutline().getModelNum(), (Long)this.getId()).getLongNumber();
        if (otherLongNum.contains("!") && thisLongNum.contains("!")) {
            String[] otherSplits = otherLongNum.split("!");
            String[] thisSplits = thisLongNum.split("!");
            int end = Math.max(thisSplits.length, otherSplits.length);
            int index = -1;
            for (int i = 0; i < end && otherSplits[i].equals(thisSplits[i]); ++i) {
                ++index;
            }
            StringJoiner sj = new StringJoiner("!");
            for (int i = 0; i <= index; ++i) {
                sj.add(otherSplits[i]);
            }
            IDNumberTreeNode node = MemberReader.findMemberByLongNumber((String)this.getOutline().getModelNum(), (String)this.getDimension().getNumber(), (String)sj.toString());
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return null;
            }
            return ScriptMember.create(node.getNumber(), this.getDimension(), node.getId());
        }
        return null;
    }

    @KSMethod
    public CTLog[] ctLog() {
        long id = this.getId();
        List<CTLog> ctLogs = this.getCtLogs(id);
        return ctLogs.toArray(new CTLog[0]);
    }

    private List<CTLog> getCtLogs(long id) {
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_entitymembertree");
        DynamicObjectCollection changes = entity.getDynamicObjectCollection("bizchangerds");
        ArrayList<CTLog> ctLogs = new ArrayList<CTLog>();
        for (DynamicObject change : changes) {
            OrgBizChangeTypeEnum changeType = OrgBizChangeTypeEnum.getEnumByValue((String)change.getString("changetype"));
            String startDate = change.getDate("bizeffdate") == null ? "" : this.dateFormat.format(change.getDate("bizeffdate"));
            String endDate = change.getDate("bizexpdate") == null ? "" : this.dateFormat.format(change.getDate("bizexpdate"));
            ctLogs.add(new CTLog(changeType.getCode(), startDate, endDate));
        }
        return ctLogs;
    }

    @KSMethod
    public CTLog[] ctLog(String validDate) {
        try {
            DateUtils.parseDateStrictly((String)validDate, (String[])new String[]{"yyyy-MM-dd"});
        }
        catch (ParseException e) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ec4\u7ec7\u6210\u5458\u7684\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55\u7684\u51fd\u6570ctLog\u53c2\u6570\u65e0\u6548\uff0c\u987b\u4f20\u5165\u683c\u5f0f\u4e3a\u201c2023-06-31\u201d\u7684\u65e5\u671f\u5b57\u7b26\u4e32\u3002", (String)"ScriptMemberEntityNode_1", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        List<CTLog> ctLogs = this.getCtLogs(this.getId());
        ctLogs.removeIf(ctLog -> ((CTLog)ctLog).StartDate.compareTo(validDate) > 0);
        return ctLogs.toArray(new CTLog[0]);
    }

    private static boolean isValidateMember(String parentNum, ScriptDimension dimension, String currMembParent) {
        return currMembParent.equals(parentNum) || dimension.isDescendant(currMembParent, parentNum);
    }

    private List<IDNumberTreeNode> getAllNodes(String dimensionNumber, String modelNum, String entityMember, String cslscheme) {
        String entityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dimensionNumber);
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        if (StringUtils.isNotEmpty((String)cslscheme)) {
            QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
            qf.add("number", "=", (Object)cslscheme);
            DynamicObject cslschemeDyo = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])qf.toArray());
            if (cslschemeDyo == null) {
                throw new NullPointerException(ResManager.loadKDString((String)"parents\u65b9\u6cd5\u6307\u5b9a\u7684\u7ec4\u7ec7\u89c6\u56fe\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ScriptMemberEntityNode_0", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
        }
        Map number2ShareNode = (Map)MemberReader.getAllNodeByNumber2ShareNodeFromCache((String)entityNumber, (String)modelNum).get(dimensionNumber);
        Map number2Node = (Map)MemberReader.getAllNodeByNumberFromCache((String)entityNumber, (String)modelNum).get(dimensionNumber);
        ArrayList<IDNumberTreeNode> allNodes = new ArrayList<IDNumberTreeNode>();
        if (number2ShareNode.containsKey(entityMember)) {
            allNodes.addAll((Collection)number2ShareNode.get(entityMember));
        }
        if (number2Node.containsKey(entityMember)) {
            allNodes.add((IDNumberTreeNode)number2Node.get(entityMember));
        }
        if (StringUtils.isNotEmpty((String)cslscheme)) {
            return allNodes.stream().filter(node -> cslscheme.equals(node.getProperty("cslscheme.number"))).collect(Collectors.toList());
        }
        return allNodes;
    }

    @KSObject
    static class CTLog
    implements ScriptObject {
        private String CTCode;
        private String StartDate;
        private String EndDate;

        public CTLog(String CTCode, String startDate, String endDate) {
            this.CTCode = CTCode;
            this.StartDate = startDate;
            this.EndDate = endDate;
        }

        @JSONField(name="CTCode")
        public String getCTCode() {
            return this.CTCode;
        }

        @JSONField(name="StartDate")
        public String getStartDate() {
            return this.StartDate;
        }

        @JSONField(name="EndDate")
        public String getEndDate() {
            return this.EndDate;
        }

        @KSMethod
        public Object __getUndefinedProperty(String propertyName) {
            if ("CTCode".equalsIgnoreCase(propertyName)) {
                return this.CTCode;
            }
            if ("StartDate".equalsIgnoreCase(propertyName)) {
                return this.StartDate;
            }
            if ("EndDate".equalsIgnoreCase(propertyName)) {
                return this.EndDate;
            }
            return super.__getUndefinedProperty(propertyName);
        }

        @KSMethod
        public Object __getUndefinedElement(Object element) {
            return this.__getUndefinedProperty(element.toString());
        }

        @KSMethod
        public String toString() {
            return JSONObject.toJSONString((Object)this);
        }
    }
}

