/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.member;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.computing.ScriptDimension;
import kd.fi.bcm.computing.ScriptMember;
import kd.fi.bcm.computing.bizabout.cach.ScriptCache;
import kd.fi.bcm.computing.util.BizRuleUtil;
import org.apache.commons.lang3.ArrayUtils;

@KSObject
public class ScriptMemberICNode
extends ScriptMember {
    public static final Set<String> SPECIAL_IC = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"InternalCompany", "ICTotal", "ICEntity", "ICOEntity", "ICNone"}));

    public ScriptMemberICNode(String name, ScriptDimension dimension, long id) {
        super(name, dimension, id);
    }

    @Override
    @KSMethod
    public ScriptMember[] base() {
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return super.base();
        }
        return (ScriptMember[])ScriptCache.getCacheOf("base_" + this.getDimension().getNumber() + this.getId(), () -> {
            Object[] params = new Object[]{this, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, 90};
            return (ScriptMember[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validICByScope", (Object[])params);
        });
    }

    @KSMethod
    public ScriptMember[] base(String dimStr) {
        Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return this.base();
        }
        String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
        String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
        String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
        return (ScriptMember[])ScriptCache.getCacheOf("base_" + dimStr + this.getId(), () -> {
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this, scenario, year, period, 90};
            return (ScriptMember[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validICByScope", (Object[])params);
        });
    }

    @Override
    @KSMethod
    public ScriptMember[] children() {
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return super.children();
        }
        return (ScriptMember[])ScriptCache.getCacheOf("children_" + this.getDimension().getNumber() + this.getId(), () -> {
            Object[] params = new Object[]{this, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, 20};
            return (ScriptMember[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validICByScope", (Object[])params);
        });
    }

    @KSMethod
    public ScriptMember[] children(String dimStr) {
        Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return this.children();
        }
        String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
        String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
        String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
        return (ScriptMember[])ScriptCache.getCacheOf("children_" + dimStr + this.getId(), () -> {
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this, scenario, year, period, 20};
            return (ScriptMember[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validICByScope", (Object[])params);
        });
    }

    @Override
    @KSMethod
    public boolean isChild(String memberNumber) {
        return this.getDimension().isChild(this.getNumber(), memberNumber);
    }

    @KSMethod
    public boolean isChild(String memberNumber, String dimStr) {
        return this.getDimension().isChild(this.getNumber(), memberNumber, dimStr);
    }

    @Override
    public boolean isChild(ScriptMember scriptMember) {
        return this.isChild(scriptMember.getNumber());
    }

    @KSMethod
    public boolean isBase(String memberNumber, String dimStr) {
        return this.getDimension().isBase(this.getNumber(), memberNumber, dimStr);
    }

    @Override
    @KSMethod
    public ScriptMember[] descendant() {
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return super.descendant();
        }
        return (ScriptMember[])ScriptCache.getCacheOf("descendant_" + this.getDimension().getNumber() + this.getId(), () -> {
            Object[] params = new Object[]{this, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1, 40};
            return (ScriptMember[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validICByScope", (Object[])params);
        });
    }

    @KSMethod
    public ScriptMember[] descendant(String dimStr) {
        Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return this.descendant();
        }
        String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
        String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
        String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
        return (ScriptMember[])ScriptCache.getCacheOf("descendant_" + dimStr + this.getId(), () -> {
            long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
            long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
            long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
            Object[] params = new Object[]{this, scenario, year, period, 40};
            return (ScriptMember[])InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validICByScope", (Object[])params);
        });
    }

    @Override
    @KSMethod
    public boolean isDescendant(String memberNumber) {
        return this.getDimension().isDescendant(this.getNumber(), memberNumber);
    }

    @KSMethod
    public boolean isDescendant(String memberNumber, String dimStr) {
        return this.getDimension().isDescendant(this.getNumber(), memberNumber, dimStr);
    }

    @Override
    @KSMethod
    public boolean isDescendant(ScriptMember scriptMember) {
        return this.isDescendant(scriptMember.getNumber());
    }

    @Override
    @KSMethod
    public ScriptMember[] hierarchy() {
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return super.hierarchy();
        }
        Object[] self = new ScriptMember[]{this};
        return (ScriptMember[])ArrayUtils.addAll((Object[])self, (Object[])this.descendant());
    }

    @KSMethod
    public ScriptMember[] hierarchy(String dimStr) {
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return this.hierarchy();
        }
        Object[] self = new ScriptMember[]{this};
        return (ScriptMember[])ArrayUtils.addAll((Object[])self, (Object[])this.descendant(dimStr));
    }

    @Override
    @KSMethod
    public boolean isHierarchy(String memberNumber) {
        return this.getDimension().isHierarchy(this.getNumber(), memberNumber);
    }

    @KSMethod
    public boolean isHierarchy(String memberNumber, String dimStr) {
        return this.getDimension().isHierarchy(this.getNumber(), memberNumber, dimStr);
    }

    @Override
    public boolean isHierarchy(ScriptMember scriptMember) {
        return this.isHierarchy(scriptMember.getNumber());
    }

    @Override
    @KSMethod
    public ScriptMember parent() {
        if (SPECIAL_IC.contains(this.getNumber()) || !this.isOpenVersion()) {
            return super.parent();
        }
        Object[] params = new Object[]{this, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1};
        return (ScriptMember)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validParent", (Object[])params);
    }

    @KSMethod
    public ScriptMember parent(String dimStr) {
        Map<String, String> map = BizRuleUtil.parseICDimStr(this.getOutline().getModelNum(), dimStr);
        boolean openVersion = this.isOpenVersion();
        if (!openVersion) {
            return this.parent();
        }
        String scenarioNum = map.getOrDefault(PresetConstant.SCENE_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
        String yearNum = map.getOrDefault(PresetConstant.FY_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
        String periodNum = map.getOrDefault(PresetConstant.PERIOD_DIM, (String)this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
        long scenario = MemberReader.findScenaMemberByNum((String)this.getOutline().getModelNum(), (String)scenarioNum).getId();
        long year = MemberReader.findFyMemberByNum((String)this.getOutline().getModelNum(), (String)yearNum).getId();
        long period = MemberReader.findPeriodMemberByNum((String)this.getOutline().getModelNum(), (String)periodNum).getId();
        Object[] params = new Object[]{this, scenario, year, period};
        return (ScriptMember)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"validParent", (Object[])params);
    }

    private boolean isOpenVersion() {
        boolean openVersion = false;
        if (this.getOutline().getComputingContext().getScopeItems() != null && this.getOutline().getComputingContext().getScopeItems().get(PresetConstant.SCENE_DIM) != null && this.getOutline().getComputingContext().getScopeItems().get(PresetConstant.FY_DIM) != null && this.getOutline().getComputingContext().getScopeItems().get(PresetConstant.PERIOD_DIM) != null) {
            Object[] params = new Object[]{this.getOutline().getModelNum(), this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1, this.getOutline().getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1};
            openVersion = (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.BizRuleUtil", (String)"isOpenVersion", (Object[])params);
        }
        return openVersion;
    }
}

