/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.util;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import org.apache.commons.lang3.StringUtils;

public class BizRuleUtil {
    public static final Set<String> DIMS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{DimTypesEnum.SCENARIO.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber()}));

    public static Map<String, String> parseICDimStr(String cube, String dimCode) {
        HashMap<String, String> dimMap = new HashMap<String, String>(4);
        if (StringUtils.isNotEmpty((CharSequence)dimCode)) {
            String[] dims;
            Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)cube);
            for (String temp : dims = dimCode.split(",")) {
                String key;
                String[] split = temp.split("[@.]", 2);
                if (split.length < 2) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e32%s\u683c\u5f0f\u9519\u8bef\uff0c\u683c\u5f0f\u4e3a\u7ef4\u5ea6@\u6210\u5458", (String)"BizRuleUtil_3", (String)"fi-bcm-computing", (Object[])new Object[0]), temp));
                }
                String dim2 = split[0].trim();
                String mem = split[1].trim();
                if (shortNums.containsKey(dim2)) {
                    key = (String)shortNums.get(dim2);
                } else if (shortNums.containsValue(dim2)) {
                    key = dim2;
                } else {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"BizRuleUtil_0", (String)"fi-bcm-computing", (Object[])new Object[0]), dim2));
                }
                IDNumberTreeNode node = MemberReader.findMemberByNumber((String)cube, (String)key, (String)mem);
                if (node == IDNumberTreeNode.NotFoundTreeNode) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801%s\u4e0d\u5b58\u5728", (String)"BizRuleUtil_1", (String)"fi-bcm-computing", (Object[])new Object[0]), mem));
                }
                dimMap.put(key, mem);
            }
        }
        if (dimMap.keySet().stream().anyMatch(dim -> !DIMS.contains(dim))) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u7248\u672c\u5316\u53ea\u652f\u6301\u6307\u5b9a\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\u7ef4\u5ea6", (String)"BizRuleUtil_2", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        return dimMap;
    }
}

