/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.fel.common.StringUtils;

public class EntityVersioningUtil {
    public static DynamicObject getOrgBizInfo(long orgId, Object modelId, Object yearId, Object periodId) {
        DynamicObject modelDo = EntityVersioningUtil.getModelFilter(modelId);
        String yearNum = EntityVersioningUtil.getYearFilter(yearId).getString("number");
        DynamicObject periodDo = EntityVersioningUtil.getPeriodFilter(periodId);
        Date firstDate = EntityVersioningUtil.getFilterDay(true, modelDo, yearNum, periodDo);
        Date lastDate = EntityVersioningUtil.getFilterDay(false, modelDo, yearNum, periodDo);
        if (firstDate == null || lastDate == null) {
            return null;
        }
        DynamicObjectCollection allData = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, name,isleaf,bizchangerds.changetype, bizchangerds.bizeffdate, bizchangerds.bizexpdate, namechangerds.namerds,namechangerds.nameeffdate,namechangerds.nameexpdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)}, (String)"bizchangerds.seq, namechangerds.seq");
        for (DynamicObject tmp : allData) {
            String name = tmp.getString("namechangerds.namerds");
            Date bizeffdate = tmp.getDate("bizchangerds.bizeffdate");
            if (bizeffdate == null || name == null) {
                return null;
            }
            Date bizexpdate = tmp.getDate("bizchangerds.bizexpdate");
            Date nameeffdate = tmp.getDate("namechangerds.nameeffdate");
            Date nameexpdate = tmp.getDate("namechangerds.nameexpdate");
            if (bizeffdate.compareTo(lastDate) > 0 || bizexpdate != null && bizexpdate.compareTo(lastDate) < 0 || nameeffdate.compareTo(lastDate) > 0 || nameexpdate != null && nameexpdate.compareTo(lastDate) < 0) continue;
            return tmp;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
    }

    public static DynamicObject getModelFilter(Object modelId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(modelId.toString()), (String)"bcm_model", (String)"id, beginyearofmonth");
    }

    public static DynamicObject getYearFilter(Object yearId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)EntityVersioningUtil.convertObjToLong(yearId))});
    }

    public static DynamicObject getPeriodFilter(Object periodId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"id, effmonth, effday, expmonth, expday", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)EntityVersioningUtil.convertObjToLong(periodId))});
    }

    public static Date getFilterDay(boolean isFirst, DynamicObject modelDo, String yearNum, DynamicObject periodDo) {
        int year = 0;
        try {
            year = Integer.parseInt(yearNum.substring(2));
            String beginyearofmonth = modelDo.getString("beginyearofmonth");
            if (FyEnum.PRE.index.equals(beginyearofmonth)) {
                --year;
            }
            int month = 0;
            int day = 0;
            if (isFirst) {
                month = periodDo.getInt("effmonth");
                day = periodDo.getInt("effday");
            } else {
                month = periodDo.getInt("expmonth");
                day = periodDo.getInt("expday");
            }
            String dateStr = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month)).concat("-").concat(day < 10 ? "0" + day : String.valueOf(day));
            try {
                return EntityVersioningUtil.parseDate(dateStr);
            }
            catch (ParseException e) {
                if (day == 29) {
                    dateStr = String.valueOf(year).concat("-").concat(month < 10 ? "0" + month : String.valueOf(month)).concat("-").concat(day < 10 ? "0" + day : String.valueOf(--day));
                }
                return EntityVersioningUtil.parseDate(dateStr);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Long convertObjToLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        return (Long)obj;
    }

    private static Date parseDate(String s) throws ParseException {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            int length = s.length();
            if (19 == length) {
                if (s.indexOf("-") > 0) {
                    return EntityVersioningUtil.parseDate(s, "yyyy-MM-dd HH:mm:ss");
                }
                return EntityVersioningUtil.parseDate(s, "MM/dd/yyyy HH:mm:ss");
            }
            if (8 == length) {
                return EntityVersioningUtil.parseDate(s, "HH:mm:ss");
            }
            if (10 == length) {
                if (s.indexOf("-") > 0) {
                    return EntityVersioningUtil.parseDate(s, "yyyy-MM-dd");
                }
                return EntityVersioningUtil.parseDate(s, "MM/dd/yyyy");
            }
            return EntityVersioningUtil.parseDate(s, "yyyy-MM-dd HH:mm:ss");
        }
        return EntityVersioningUtil.parseDate(s, "yyyy-MM-dd HH:mm:ss");
    }

    private static Date parseDate(String s, String fmt) throws ParseException {
        return EntityVersioningUtil.parseDate(s, fmt, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return EntityVersioningUtil.parseDate(s, fmt, timezone, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }
}

