/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.common.OlapConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.DebugServiceHelper;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.trace.TraceLogCache;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.ComputingEngine;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.bizrule.log.AuditLogHelper;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.util.ScriptDebugLogInfoUtil;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptStackElement;

public class RuleExecuteServiceHelper {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, RuleExecuteServiceHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, String> excuteScript4ReportParams(String cube, List<BizRuleExecParam> paramList, ApplicationTypeEnum app, boolean isDebug) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        OlapConnection olapConnection = RuleExecuteServiceHelper.getOlapConnection(cube);
        olapConnection.Open();
        Outline outline = Outline.create(olapConnection);
        ComputingEngine computingEngine = new ComputingEngine(olapConnection, outline);
        Map idNumMap = (Map)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)("getAllBizRule_" + cube), () -> QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id,internal", (QFilter[])new QFBuilder("model", "=", (Object)MemberReader.findModelIdByNum((String)cube)).toArray()).stream().collect(Collectors.toMap(k -> k.getLong("id"), k -> {
            String id = "" + OlapSourceEnum.R1.getType() + k.getLong("internal");
            return Long.parseLong(id) > Integer.MAX_VALUE ? 0 : Integer.parseInt(id);
        })));
        try {
            long starttime = 0L;
            for (BizRuleExecParam execParam : paramList) {
                List<Pair<Long, String>> bizRuleList = execParam.getBizRuleList();
                for (Pair<Long, String> bizRule : bizRuleList) {
                    if (result.containsKey(bizRule.p1) || !StringUtils.isNotEmpty((String)((String)bizRule.p2))) continue;
                    ComputingContext ctx = ComputingContext.create(olapConnection, outline, execParam.getCommonParam());
                    HashMap<String, Object> args = new HashMap<String, Object>(4);
                    args.put("ctx", ctx);
                    args.put("outline", outline);
                    args.put("ruleid", ((Long)bizRule.p1).toString());
                    args.put("ruleInternal", idNumMap.get(bizRule.p1));
                    args.put("executeType", execParam.getExecuteType());
                    args.put("paperTemplateNumber", execParam.getPaperTemplateNumber());
                    args.put("paperTemplateId", execParam.getPaperTemplateId());
                    args.put("calcTypeWay", execParam.getCalcTypeWay());
                    starttime = System.currentTimeMillis();
                    String str = (String)bizRule.p2;
                    ThreadCache.put((Object)(bizRule.p1 + "startTime"), (Object)starttime);
                    try {
                        TraceLogCache.put((Object)"ruleid", (Object)((Long)bizRule.p1).toString());
                        computingEngine.execute(str, args);
                        TraceLogCache.remove((Object)"ruleid");
                    }
                    catch (Exception e) {
                        log.error("olap operator: excute script(" + str + "), result: failure, spendtime ", (Throwable)e);
                        result.put((Long)bizRule.p1, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u7f16\u7801[%1$s],%2$s", (String)"RuleExecuteServiceHelper_0", (String)"fi-bcm-computing", (Object[])new Object[0]), RuleExecuteServiceHelper.getBizNumber((Long)bizRule.p1), RuleExecuteServiceHelper.getErrMsg(e, execParam, isDebug)));
                        if (!ThreadCache.exists((Object)"all_in_one_thread")) continue;
                        ScriptDebugLogInfoUtil.log("" + bizRule.p1, RuleExecuteServiceHelper.getErrMsg(e));
                    }
                    finally {
                        long endTime = System.currentTimeMillis();
                        long spendTime = endTime - starttime;
                        ThreadCache.put((Object)(bizRule.p1 + "endTime"), (Object)endTime);
                        if (spendTime >= 1000L || DebugServiceHelper.isDebugModel()) {
                            ScriptDebugLogInfoUtil.log("" + bizRule.p1, "cost:" + spendTime + "ms");
                            if (DebugServiceHelper.isDebugModel()) {
                                ScriptDebugLogInfoUtil.log("" + bizRule.p1, AuditLogHelper.outputAuditStatistics());
                            }
                        }
                        AuditLogHelper.clearCurrent();
                    }
                }
            }
        }
        finally {
            olapConnection.Close();
        }
        return result;
    }

    private static String getErrMsg(Throwable e) {
        Throwable bottomEx = RuleExecuteServiceHelper.getBottomEx(e);
        return StringUtils.isEmpty((String)bottomEx.getMessage()) ? Objects.toString(bottomEx) : bottomEx.getMessage();
    }

    private static String getErrMsg(Throwable e, BizRuleExecParam execParam, boolean isDebug) {
        Throwable ex;
        StringBuilder sb = new StringBuilder();
        String param = execParam.getCommonParam().toString();
        sb.append(param).append(System.lineSeparator());
        if (ex == null) {
            return sb.toString();
        }
        Throwable bottomEx = RuleExecuteServiceHelper.getBottomEx(e);
        for (ex = e; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof RhinoException)) continue;
            RhinoException exception = (RhinoException)ex;
            ScriptStackElement scriptStackElement = null;
            String bottomMessage = RuleExecuteServiceHelper.getBottomMessage(bottomEx);
            if (StringUtils.isNotEmpty((String)bottomMessage) && bottomMessage.contains("#DragonEngineException1000")) {
                bottomMessage = bottomMessage + ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801\u4e2d\u5b58\u5728\u8fd0\u7b97\u7b26\u53f7\u7684\uff0c\u8bf7\u4f7f\u7528\u5e26v\u51fd\u6570\u7684\u5199\u6cd5\u3002", (String)"ScriptBuiltin_42", (String)"fi-bcm-computing", (Object[])new Object[0]);
            }
            if (exception.getScriptStack() != null && exception.getScriptStack().length > 0) {
                if (StringUtils.isNotEmpty((String)exception.getScriptStack()[0].functionName)) {
                    sb.append(String.format(ResManager.loadKDString((String)"%s\u51fd\u6570\u6267\u884c\u5931\u8d25\u3002", (String)"RuleExecuteServiceHelper_1", (String)"fi-bcm-computing", (Object[])new Object[0]), exception.getScriptStack()[0].functionName)).append(",");
                }
                scriptStackElement = exception.getScriptStack()[exception.getScriptStack().length - 1];
                sb.append(String.format("at %s:%s", scriptStackElement.fileName, scriptStackElement.lineNumber)).append(System.lineSeparator()).append(bottomMessage);
            } else {
                sb.append(String.format("at %s:%s", ((RhinoException)ex).sourceName(), ((RhinoException)ex).lineNumber())).append(System.lineSeparator()).append(bottomMessage);
            }
            if (!isDebug) {
                sb.append(System.lineSeparator()).append(ThrowableHelper.toString((Throwable)e));
            }
            return sb.toString();
        }
        if (isDebug) {
            return sb.append(RuleExecuteServiceHelper.getBottomMessage(bottomEx)).toString();
        }
        return sb.append(e.getMessage()).append(System.lineSeparator()).append(ThrowableHelper.toString((Throwable)e)).toString();
    }

    private static String getBottomMessage(Throwable bottomEx) {
        return StringUtils.isEmpty((String)bottomEx.getMessage()) ? ThrowableHelper.toString((Throwable)bottomEx) : bottomEx.getMessage();
    }

    private static Throwable getBottomEx(Throwable e) {
        for (Throwable bottomEx = e.getCause(); bottomEx != null; bottomEx = bottomEx.getCause()) {
            if (bottomEx.getCause() != null) continue;
            return bottomEx;
        }
        return e;
    }

    private static String getBizNumber(long bizRuleId) {
        return (String)ThreadCache.get((Object)("getBizNumber:" + bizRuleId), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)bizRuleId, (String)"bcm_bizruleentity", (String)"number").getString("number"));
    }

    public static OlapConnection getOlapConnection(String cube) {
        return RuleExecuteServiceHelper.getOlapConnection(cube, false);
    }

    public static OlapConnection getOlapConnection(String cube, boolean isNestedOpenClose) {
        OlapConnection conn = new OlapConnection(OlapConstant.getConnectSerial((String)cube, (boolean)isNestedOpenClose));
        String password = OlapConstant.getConnectMsg((String)cube).getPassword();
        password = EncryptUtils.aesDecrypt((String)password);
        String username = OlapConstant.getConnectMsg((String)cube).getUsername();
        conn.setUserName(EncryptUtils.aesDecrypt((String)username));
        conn.setPassword(password);
        return conn;
    }
}

