/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.BatchCommandInfo;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.Level;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.bcm.common.FiBcmErrorCode;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DimPropList;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.rule.BizRuleExecuteTypeEnum;
import kd.fi.bcm.common.exception.BizRuleException;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import kd.fi.bcm.common.util.InvokeUtils;
import kd.fi.bcm.common.util.OlapMeasureHandleUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.LambdaParser;
import kd.fi.bcm.computing.ScopeInfo;
import kd.fi.bcm.computing.ScriptBuiltin;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.member.ScriptCellSet;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.computing.util.EntityVersioningUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ScriptBuiltinHelper {
    public static final int cellSet_max_count = 100000;
    public static final List<String> SPECIAL_PROCESS = Arrays.asList("ADJ", "ARPT", "CADJ", "PRPT", "EJE", "CC", "CCADJ", "CCTotal");
    public static final Set<String> PARENT_JOURNAL_BPS = Sets.newHashSet((Object[])new String[]{"ADJ", "CADJ", "EJE", "CCADJ"});
    public static final Set<String> MERGE_JOURNAL_BPS = Sets.newHashSet((Object[])new String[]{"ERAdj", "RAdj", "DADJ", "DEJE"});
    public static Map<String, String> NUM_SHORT_MAP = new HashMap<String, String>(4);
    public static Map<String, String> SHORT_NUM_MAP = new HashMap<String, String>(4);
    public static Set<String> ruleDims = Sets.newHashSet((Object[])new String[]{PresetConstant.ENTITY_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.SCENE_DIM, PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM});
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ScriptBuiltin.class);

    public static void createBatchCommands(String mainDimension, ScopeInfo scopeInfo, ComputingContext computingContext, BatchCommandInfo commands, String[] expressions) {
        ComputingCommandInfo command = null;
        FelLambdaExpressionItem item = null;
        for (String expression : expressions) {
            command = new ComputingCommandInfo();
            command.setFilter((List)scopeInfo.getFilters());
            command.setMainDimName(mainDimension);
            command.setMainMeaName("FMONEY");
            item = new FelLambdaExpressionItem();
            Pair<String, String> pair = LambdaParser.parseExpression(expression);
            item.setExpressLeft((String)pair.getLeft());
            item.setExpression(computingContext.joinRound((String)pair.getRight()));
            command.getExpressionItems().add(item);
            Level level = new Level();
            level.addCommand((CommandInfo)command);
            commands.addLevel(level);
        }
    }

    public static ComputingCommandInfo createCommands(String mainDimension, ScopeInfo scopeInfo, ComputingContext computingContext, String[] expressions) {
        ComputingCommandInfo command = new ComputingCommandInfo();
        command.setFilter((List)scopeInfo.getFilters());
        command.setMainDimName(mainDimension);
        command.setMainMeaName("FMONEY");
        for (String expression : expressions) {
            FelLambdaExpressionItem item = new FelLambdaExpressionItem();
            Pair<String, String> pair = LambdaParser.parseExpression(expression);
            item.setExpressLeft((String)pair.getLeft());
            item.setExpression(computingContext.joinRound((String)pair.getRight()));
            command.getExpressionItems().add(item);
        }
        return command;
    }

    public static JSONArray getOwnership(IOutline outline, Object[] customParams) {
        if (customParams.length > 4) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"getOwnership", 4});
        }
        return (JSONArray)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"getOwnership", (Object[])new Object[]{outline, customParams});
    }

    public static void setOwnership(IOutline outline, Object[] params) {
        if (params.length > 4) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"setOwnership", 4});
        }
        if (params.length < 3) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"setOwnership", 3});
        }
        Map<String, Object> args = outline.getBuiltin().getArgs();
        ScriptBuiltinHelper.checkExecuteType(args, "setOwnership");
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"setOwnership", (Object[])new Object[]{outline, params});
    }

    public static void delOwnership(IOutline outline, Object[] params) {
        if (params.length > 3) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"delOwnership", 3});
        }
        if (params.length < 1) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"delOwnership", 1});
        }
        Map<String, Object> args = outline.getBuiltin().getArgs();
        ScriptBuiltinHelper.checkExecuteType(args, "delOwnership");
        InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"delOwnership", (Object[])new Object[]{outline, params});
    }

    public static ScopeInfo getScopeInfo(ScopeInfo scope, ScopeInfo pageIncomeScope, String expression) {
        ScopeInfo newScope = new ScopeInfo();
        newScope.getFilters().addAll(scope.getFilters());
        if (pageIncomeScope != null) {
            Collection<DimensionFilterItem> filters = pageIncomeScope.getFilters();
            for (DimensionFilterItem filterItem : filters) {
                boolean match;
                String dimNumber = filterItem.getName();
                if (expression.contains(dimNumber + ".") || expression.contains(dimNumber + "@") || (match = scope.getFilters().stream().map(DimensionFilterItem::getName).anyMatch(name -> name.equals(dimNumber)))) continue;
                DimensionFilterItem item = new DimensionFilterItem();
                item.setName(dimNumber);
                item.getValues().addAll(filterItem.getValues());
                newScope.getFilters().add(item);
            }
        }
        return newScope;
    }

    public static void checkIncludeAllDim(ScopeInfo scope, String modelNum) {
        Collection dimNumbers = MemberReader.getDimensionShortNumber2NumberMap((String)modelNum).values();
        Collection<DimensionFilterItem> targetFilters = scope.getFilters();
        if (dimNumbers.size() != targetFilters.size()) {
            List targetNames = targetFilters.stream().map(DimensionFilterItem::getName).collect(Collectors.toList());
            dimNumbers.forEach(dimNumber -> {
                if (!targetNames.contains(dimNumber)) {
                    throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6307\u5b9a\u4e0d\u5168\uff0c\u8bf7\u8bbe\u7f6e\u7ef4\u5ea6\u201c%1$s\u201d\u6210\u5458\u503c\uff0c%2$s\u3002", (String)"ScriptBuiltin_9", (String)"fi-bcm-computing", (Object[])new Object[0]), dimNumber, scope));
                }
            });
        }
    }

    public static ScopeInfo getTargetScope(ScopeInfo scopeInfo, IOutline outline) {
        ScopeInfo fixScope = outline.getComputingContext().getRuntimeScope(null);
        Collection<DimensionFilterItem> fixFilters = fixScope.getFilters();
        List fixNames = fixFilters.stream().map(DimensionFilterItem::getName).collect(Collectors.toList());
        Collection<DimensionFilterItem> filters = scopeInfo.getFilters();
        filters.forEach(f -> {
            String key = f.getName();
            if (fixNames.contains(key)) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"FixScope\u5df2\u6307\u5b9a\u7ef4\u5ea6\uff08%s\uff09\uff0c\u8bf7\u68c0\u67e5scope:", (String)"ScriptBuiltin_8", (String)"fi-bcm-computing", (Object[])new Object[0]), key) + scopeInfo);
            }
        });
        ScopeInfo targetScope = ScopeInfo.mergeReduce(scopeInfo, fixScope);
        ScriptBuiltinHelper.checkIncludeAllDim(targetScope, outline.getModelNum());
        return targetScope;
    }

    public static void handleProcess(ScopeInfo scope) {
        if (scope != null) {
            scope.getFilters().forEach(f -> {
                if (f.getName().equals(PresetConstant.PROCESS_DIM)) {
                    f.getValues().replaceAll(e -> {
                        if ("EIRpt".equals(e)) {
                            return "IRpt";
                        }
                        if ("ERAdj".equals(e)) {
                            return "RAdj";
                        }
                        return e;
                    });
                }
            });
        }
    }

    public static SaveCommandInfo createCommand(ScopeInfo scopeInfo, ComputingContext computingContext, Collection<DimensionFilterItem> targetFilters, List<String> dims, List<String> dimMembers) {
        computingContext.checkHasModifiedGlobalScopeInfo(scopeInfo);
        ScriptBuiltinHelper.handleProcess(scopeInfo);
        targetFilters.forEach(f -> {
            String key = f.getName();
            List values = f.getValues();
            if (values.size() != 1) {
                throw new BizRuleException(String.format(ResManager.loadKDString((String)"save\u51fd\u6570\u6307\u5b9a\u7684\u7ef4\u5ea6\u201c%s\u201d\u6210\u5458\u503c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u7ec4\u5408\u5b9a\u4e49\u3002", (String)"ScriptBuiltin_10", (String)"fi-bcm-computing", (Object[])new Object[0]), key) + scopeInfo);
            }
            dims.add(key);
            dimMembers.add((String)values.get(0));
        });
        SaveCommandInfo saveCommandInfo = new SaveCommandInfo();
        saveCommandInfo.setDimensions(dims.toArray(new String[0]));
        saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        return saveCommandInfo;
    }

    public static ScriptCellSet getCellSet(ScopeInfo scopeInfo, boolean isSelectAll, String isAsc, IOutline outline, OlapConnection olapConnection) {
        Map dimShort2NumMap = MemberReader.getDimensionShortNumber2NumberMap((String)outline.getModelNum());
        ArrayList<String> selectDims = new ArrayList<String>(dimShort2NumMap.values());
        Collection<DimensionFilterItem> targetFilters = scopeInfo.getFilters();
        ArrayList<DimensionFilterItem> fixDims = new ArrayList<DimensionFilterItem>();
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
        SelectCommandInfo selectCommandInfo = new SelectCommandInfo();
        for (DimensionFilterItem f : targetFilters) {
            String key = f.getName();
            List values = f.getValues();
            int size = values.size();
            if (size > 1) {
                selectCommandInfo.addFilter(key, values.toArray(new String[0]));
                memberMap.put(key, new HashSet(values));
                continue;
            }
            if (size != 1) continue;
            fixDims.add(new DimensionFilterItem(key, values));
            selectDims.remove(key);
            selectCommandInfo.addFilter(key, values.toArray(new String[0]));
        }
        if (selectDims.isEmpty() || isSelectAll) {
            selectDims = new ArrayList(MemberReader.getDimensionShortNumber2NumberMap((String)outline.getModelNum()).values());
            fixDims.clear();
            memberMap.clear();
        }
        selectCommandInfo.addDims(selectDims.toArray(new String[0]));
        selectCommandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        OlapCommand olapCommand = new OlapCommand(olapConnection, (CommandInfo)selectCommandInfo);
        CellSet cellSet = olapCommand.executeCellSet((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
        if (cellSet.getCount() > 100000) {
            throw new BizRuleException(String.format("getCellSet load data count must less than %d ,but count is %d", 100000, cellSet.getCount()));
        }
        if (isAsc == null) {
            return new ScriptCellSet(olapConnection, cellSet, fixDims, selectDims, memberMap, dimShort2NumMap, outline.getComputingContext());
        }
        if ("ASC".equals(isAsc)) {
            return new ScriptCellSet(olapConnection, cellSet, fixDims, selectDims, memberMap, dimShort2NumMap, outline.getComputingContext(), true);
        }
        if ("DESC".equals(isAsc)) {
            return new ScriptCellSet(olapConnection, cellSet, fixDims, selectDims, memberMap, dimShort2NumMap, outline.getComputingContext(), false);
        }
        throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u6392\u5e8f\u53c2\u6570\u201c%s\u201d,\u6392\u5e8f\u53c2\u6570\u4ec5\u652f\u6301\u201cASC\u201d\u6216\u201cDESC\u201d\u3002", (String)"ScriptBuiltin_34", (String)"fi-bcm-computing", (Object[])new Object[0]), isAsc));
    }

    public static Map<String, Pair<String, Long>> dealDimStr(String dimStr) {
        String[] splits;
        HashMap<String, Pair<String, Long>> memberMap = new HashMap<String, Pair<String, Long>>(4);
        if (StringUtils.isEmpty((String)dimStr)) {
            return memberMap;
        }
        for (String split : splits = dimStr.split(",")) {
            if (split.contains("@")) {
                String[] temps = split.split("@");
                String dim = temps[0];
                String mem = temps[1];
                if (NUM_SHORT_MAP.containsKey(dim)) {
                    memberMap.put(dim, (Pair<String, Long>)Pair.of((Object)mem, (Object)0L));
                    continue;
                }
                String key = SHORT_NUM_MAP.get(dim);
                if (key != null) {
                    memberMap.put(key, (Pair<String, Long>)Pair.of((Object)mem, (Object)0L));
                    continue;
                }
                throw new BizRuleException("only support scenario,year,period,entity!!!");
            }
            throw new BizRuleException("dimension or member missed!!!");
        }
        return memberMap;
    }

    public static void supplyQueryParams(Map<String, Pair<String, Long>> queryParams, Map<String, Object> args) {
        Map<String, kd.fi.bcm.common.Pair<Long, String>> scopeItems = ((ComputingContext)args.get("ctx")).getScopeItems();
        NUM_SHORT_MAP.forEach((key, value) -> {
            if (queryParams.get(key) == null) {
                queryParams.put((String)key, (Pair<String, Long>)Pair.of((Object)((kd.fi.bcm.common.Pair)scopeItems.get((Object)key)).p2, (Object)((kd.fi.bcm.common.Pair)scopeItems.get((Object)key)).p1));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> getMergeStructInfo(Map<String, Pair<String, Long>> queryParams, IOutline outline) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String parentNum = "";
        String currentNum = "";
        if ((Long)queryParams.get(PresetConstant.ENTITY_DIM).getRight() == 0L) {
            String entityStr = (String)queryParams.get(PresetConstant.ENTITY_DIM).getLeft();
            if (!entityStr.contains("_")) throw new BizRuleException("need appoint a parent entity!!!");
            String[] splits = entityStr.split("_");
            if (splits.length > 2) {
                throw new BizRuleException("entity only support parent_child!!!");
            }
            String parent = splits[0];
            currentNum = splits[1];
            QFBuilder range = new QFBuilder("model.number", "=", (Object)outline.getModelNum());
            range.add("number", "=", (Object)currentNum).add("parent.number", "=", (Object)parent);
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"parent.number", (QFilter[])range.toArray());
            if (dyn == null) {
                map.put("isParent", Boolean.FALSE);
                return map;
            }
            parentNum = dyn.getString("parent.number");
        } else {
            IDNumberTreeNode node = MemberReader.findMemberById((String)outline.getModelNum(), (String)"bcm_entitymembertree", (Long)((Long)queryParams.get(PresetConstant.ENTITY_DIM).getRight()));
            if (node.getParent() != null) {
                parentNum = node.getParent().getNumber();
            }
            currentNum = node.getNumber();
        }
        String key = outline.getModelNum() + "|" + currentNum + "|" + parentNum + "|" + (String)queryParams.get(PresetConstant.SCENE_DIM).getLeft() + "|" + (String)queryParams.get(PresetConstant.FY_DIM).getLeft() + "|" + (String)queryParams.get(PresetConstant.PERIOD_DIM).getLeft();
        map.put("isParent", Boolean.TRUE);
        String currentNum2 = currentNum;
        String parentNum2 = parentNum;
        Map infoMap = (Map)ThreadCache.get((Object)key, () -> {
            String fields = "mergemethod.number,ismerge,userdefined1,userdefined2,userdefined3";
            QFBuilder range = new QFBuilder("model.number", "=", (Object)outline.getModelNum());
            range.add("orgnumber", "=", (Object)currentNum2);
            range.add("orgpnumber", "=", (Object)parentNum2);
            range.and("scenario.number", "=", ((Pair)queryParams.get(PresetConstant.SCENE_DIM)).getLeft());
            range.and("year.number", "=", ((Pair)queryParams.get(PresetConstant.FY_DIM)).getLeft());
            range.and("period.number", "=", ((Pair)queryParams.get(PresetConstant.PERIOD_DIM)).getLeft());
            DynamicObject info2 = BusinessDataServiceHelper.loadSingle((String)"bcm_mergestructinfo", (String)fields, (QFilter[])range.toArray());
            Long orgId = MemberReader.findEntityMemberByNum((String)outline.getModelNum(), (String)currentNum2).getId();
            Long modelId = MemberReader.findModelIdByNum((String)outline.getModelNum());
            Long yearId = MemberReader.findFyMemberByNum((String)outline.getModelNum(), (String)((String)((Pair)queryParams.get(PresetConstant.FY_DIM)).getLeft())).getId();
            Long periodId = MemberReader.findPeriodMemberByNum((String)outline.getModelNum(), (String)((String)((Pair)queryParams.get(PresetConstant.PERIOD_DIM)).getLeft())).getId();
            Long sceneId = MemberReader.findScenaMemberByNum((String)outline.getModelNum(), (String)((String)((Pair)queryParams.get(PresetConstant.SCENE_DIM)).getLeft())).getId();
            HashMap<String, Object> tempMap = new HashMap<String, Object>(3);
            tempMap.put("info", info2);
            DynamicObject orgBizInfo = EntityVersioningUtil.getOrgBizInfo(orgId, modelId, yearId, periodId);
            if (orgBizInfo != null) {
                String changetype = orgBizInfo.getString("bizchangerds.changetype");
                OrgBizChangeTypeEnum orgBizChangeTypeEnum = OrgBizChangeTypeEnum.getEnumByValue4Rule((String)changetype);
                if (orgBizChangeTypeEnum != null && StringUtils.isNotEmpty((String)orgBizChangeTypeEnum.getOldCode())) {
                    tempMap.put("ct", orgBizChangeTypeEnum.getOldCode());
                } else {
                    tempMap.put("ct", changetype);
                }
            }
            QFBuilder qf = new QFBuilder("org", "=", (Object)orgId);
            qf.add("model", "=", (Object)modelId);
            qf.and("scenario", "=", (Object)sceneId);
            qf.and("year", "=", (Object)yearId);
            qf.and("period", "=", (Object)periodId);
            DynamicObject mergeobj = BusinessDataServiceHelper.loadSingle((String)"bcm_mergesetentity", (String)"mergedatasource", (QFilter[])qf.toArray());
            if (mergeobj != null) {
                tempMap.put("ds", mergeobj.getString("mergedatasource"));
            } else if (orgBizInfo != null && !orgBizInfo.getBoolean("isleaf")) {
                tempMap.put("ds", MergeDataSourceEnum.SIRpt.getIndex());
            } else {
                tempMap.put("ds", "-1");
            }
            return tempMap;
        });
        map.putAll(infoMap);
        return map;
    }

    public static String getConAttr(Object[] args, Map<String, Object> contextArgs, IOutline outline) {
        String result = "";
        DynamicObject structInfo = null;
        if (args == null || args.length == 0 || args.length > 2) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u53c2\u6570\u4f20\u5165\u6709\u8bef", (String)"ScriptBuiltin_13", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String[] params = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            params[i] = args[i].toString();
        }
        String attrCode = params[0].toLowerCase(Locale.ENGLISH);
        String dimStr = "";
        if (params.length == 2) {
            dimStr = params[1];
        }
        Map<String, Pair<String, Long>> queryParams = ScriptBuiltinHelper.dealDimStr(dimStr);
        ScriptBuiltinHelper.supplyQueryParams(queryParams, contextArgs);
        Map<String, Object> structInfoMap = ScriptBuiltinHelper.getMergeStructInfo(queryParams, outline);
        if ("ds".equals(attrCode)) {
            return (String)structInfoMap.get("ds");
        }
        if ("ct".equals(attrCode)) {
            return (String)structInfoMap.get("ct");
        }
        if (!((Boolean)structInfoMap.get("isParent")).booleanValue()) {
            return "null";
        }
        if (structInfoMap.get("info") == null) {
            return "as".equals(attrCode) ? "Y" : result;
        }
        structInfo = (DynamicObject)structInfoMap.get("info");
        switch (attrCode) {
            case "cm": {
                if (structInfo.getString("mergemethod.number") != null) {
                    result = structInfo.getString("mergemethod.number");
                    break;
                }
                result = "None";
                break;
            }
            case "as": {
                if (structInfo.getBoolean("ismerge")) {
                    result = "Y";
                    break;
                }
                result = "N";
                break;
            }
            case "ud1": {
                String userdefined1 = structInfo.getString("userdefined1");
                if (!StringUtils.isNotEmpty((String)userdefined1)) break;
                result = userdefined1;
                break;
            }
            case "ud2": {
                String userdefined2 = structInfo.getString("userdefined2");
                if (!StringUtils.isNotEmpty((String)userdefined2)) break;
                result = userdefined2;
                break;
            }
            case "ud3": {
                String userdefined3 = structInfo.getString("userdefined3");
                if (!StringUtils.isNotEmpty((String)userdefined3)) break;
                result = userdefined3;
                break;
            }
        }
        return result;
    }

    public static void doSave(ScopeInfo scopeInfo, Object value, IOutline outline, OlapConnection olapConnection) {
        ComputingContext computingContext = outline.getComputingContext();
        value = computingContext.executeRound(OlapMeasureHandleUtil.handleMeasure((Object)value));
        Collection<DimensionFilterItem> targetFilters = scopeInfo.getFilters();
        ArrayList<String> dims = new ArrayList<String>();
        ArrayList<String> dimMembers = new ArrayList<String>();
        SaveCommandInfo saveCommandInfo = ScriptBuiltinHelper.createCommand(scopeInfo, computingContext, targetFilters, dims, dimMembers);
        OlapCommand cmd = new OlapCommand(olapConnection, (CommandInfo)saveCommandInfo);
        OlapComTraceUtil.setTraceId((CommandInfo)saveCommandInfo);
        try (OlapDataWriter writer = cmd.CreateWriter();){
            Object[] values = new Object[targetFilters.size() + 1];
            values[0] = value;
            for (int i = 1; i < targetFilters.size() + 1; ++i) {
                values[i] = dimMembers.get(i - 1);
            }
            writer.setValues(values);
            writer.flush();
        }
    }

    public static void clear(ScopeInfo scope, IOutline outline) {
        String modelNum = outline.getModelNum();
        String entity = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2;
        String scenario = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2;
        String year = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p2;
        String period = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2;
        String process = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p2;
        String currency = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.CURRENCY_DIM).p2;
        if (entity != null && year != null && period != null && scenario != null && currency != null && process != null) {
            if (scope != null) {
                scope.getFilters().iterator().forEachRemaining(e -> {
                    if (ruleDims.contains(e.getName())) {
                        throw new BizRuleException(ResManager.loadKDString((String)"scope\u8303\u56f4\u4e0e\u4e0a\u4e0b\u6587\u51b2\u7a81\u3002", (String)"ScriptBuiltin_14", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    Long memberId = MemberReader.findMemberByNumber((String)modelNum, (String)e.getName(), (String)((String)e.getValues().get(0))).getId();
                    if (memberId == -1L) {
                        throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u7684\u6210\u5458\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539scope\u3002", (String)"ScriptBuiltin_15", (String)"fi-bcm-computing", (Object[])new Object[0]), e.getName(), e.getValues().get(0)));
                    }
                });
            }
            ArrayList errors = new ArrayList(10);
            BatchProcessHelper.handleSync(() -> errors.addAll((Collection)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.olap.verify.OlapDataCleanServiceHelper", (String)"cleanOlapData", (Object[])new Object[]{modelNum, entity, scenario, year, period, currency, process, scope, outline.getBuiltin().getArgs().get("ruleInternal")})));
            if (!errors.isEmpty()) {
                throw new BizRuleException((String)errors.get(0));
            }
        }
    }

    public static String getLastYearEnd(IOutline outline) {
        String modelNum = outline.getModelNum();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long sceneId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1;
        Long yearId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1;
        Long periodId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1;
        Object[] params = new Object[]{modelId, sceneId, yearId, periodId};
        Pair res = (Pair)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.carry.CarryServiceHelper", (String)"getCarryLast", (Object[])params);
        if ((Long)res.getLeft() == 0L) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u671f\u95f4\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\u671f\u95f4\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u671f\u95f4\u540e\u91cd\u8bd5\u3002", (String)"ScriptBuiltin_20", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String lastPeriodNum = MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)res.getLeft())).getNumber();
        return "FY@" + (String)res.getRight() + ",P@" + lastPeriodNum;
    }

    public static String getEntityLastPeriod(IOutline outline, String entity) {
        String modelNum = outline.getModelNum();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long sceneId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1;
        Long yearId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1;
        Long periodId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1;
        Object[] params = new Object[]{modelId, sceneId, yearId, periodId, MemberReader.findEntityMemberByNum((String)modelNum, (String)entity).getId()};
        Pair res = (Pair)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.carry.CarryServiceHelper", (String)"getEntityCarryLast", (Object[])params);
        if ((Long)res.getLeft() == 0L) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"ScriptBuiltin_18", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String lastPeriodNum = MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)res.getLeft())).getNumber();
        return "FY@" + (String)res.getRight() + ",P@" + lastPeriodNum;
    }

    public static String getAccountLastPeriod(IOutline outline, String account) {
        String modelNum = outline.getModelNum();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long sceneId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1;
        Long yearId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1;
        Long periodId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1;
        Object[] params = new Object[]{modelId, sceneId, yearId, periodId, MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.ACCOUNT_DIM, (String)account).getId()};
        Pair res = (Pair)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.carry.CarryServiceHelper", (String)"getAccountCarryLast", (Object[])params);
        if ((Long)res.getLeft() == 0L) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"ScriptBuiltin_18", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String lastPeriodNum = MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)res.getLeft())).getNumber();
        return "FY@" + (String)res.getRight() + ",P@" + lastPeriodNum;
    }

    public static String getSpecialLastPeriod(IOutline outline, String entity, String account) {
        String modelNum = outline.getModelNum();
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long sceneId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1;
        Long yearId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1;
        Long periodId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1;
        Object[] params = new Object[]{modelId, sceneId, yearId, periodId, MemberReader.findEntityMemberByNum((String)modelNum, (String)entity).getId(), MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.ACCOUNT_DIM, (String)account).getId()};
        Pair res = (Pair)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.carry.CarryServiceHelper", (String)"getSpecialCarryLast", (Object[])params);
        if ((Long)res.getLeft() == 0L) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u540e\u91cd\u8bd5\u3002", (String)"ScriptBuiltin_18", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String lastPeriodNum = MemberReader.findPeriodMemberById((String)modelNum, (Long)((Long)res.getLeft())).getNumber();
        return "FY@" + (String)res.getRight() + ",P@" + lastPeriodNum;
    }

    public static void executeOlapCommand(CommandInfo command, OlapConnection olapConnection) {
        try (TraceSpan ts = Tracer.create((String)"olap-compute", (String)"olap-compute");){
            OlapCommand cmd = new OlapCommand(olapConnection, command);
            OlapComTraceUtil.setTraceId((CommandInfo)command);
            cmd.executeNonQuery();
        }
    }

    public static void copy(Object rightExpression, ScopeInfo scope, IOutline outline, OlapConnection olapConnection) {
        StringBuilder right;
        FelLambdaExpressionItem item;
        ComputingCommandInfo command;
        if (rightExpression == null || rightExpression instanceof ScopeInfo) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6765\u6e90\u7ef4\u5ea6\u7ec4\u5408\u3002", (String)"ScriptBuiltin_23", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        if (rightExpression instanceof String) {
            List ctxFilters;
            if (StringUtils.isEmpty((String)rightExpression.toString())) {
                throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u5f53\u524d\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"ScriptBuiltin_21", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            HashSet<String> numbers = new HashSet<String>();
            numbers.addAll(Arrays.asList(DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.YEAR.getNumber(), DimTypesEnum.PERIOD.getNumber(), DimTypesEnum.CURRENCY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.SCENARIO.getNumber()));
            numbers.addAll(Arrays.asList(DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber(), DimTypesEnum.CURRENCY.getShortNumber(), DimTypesEnum.PROCESS.getShortNumber(), DimTypesEnum.SCENARIO.getShortNumber()));
            Map shortNums = MemberReader.getDimensionShortNumber2NumberMap((String)outline.getModelNum());
            String value = ((String)rightExpression).trim();
            HashMap<String, String> dimValueMap = new HashMap<String, String>(16);
            String[] splits = value.split(",");
            String sourceEntity = "";
            for (String split : splits) {
                String comma = split.indexOf("@") > -1 ? "@" : (split.indexOf(".") > -1 ? "." : "");
                if (StringUtils.isEmpty((String)comma)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6216\u6210\u5458\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ScriptBuiltin_22", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                String[] dimAndMem = split.split(comma);
                String dim = dimAndMem[0];
                String mem = dimAndMem[1];
                if (!numbers.contains(dim)) {
                    throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"ScriptBuiltin_24", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dim) || SysDimensionEnum.Entity.getShortnumber().equals(dim)) {
                    sourceEntity = mem;
                }
                if (shortNums.get(dim) != null) {
                    dim = (String)shortNums.get(dim);
                }
                dimValueMap.put(dim, mem);
            }
            StringBuilder sourceStr = new StringBuilder();
            StringBuilder targetStr = new StringBuilder();
            outline.getComputingContext().getScopeItems();
            outline.getComputingContext().getScopeItems().forEach((key, val) -> {
                String sourceVal = dimValueMap.get(key) == null ? (String)val.p2 : (String)dimValueMap.get(key);
                sourceStr.append((String)key).append(sourceVal).append("|");
                targetStr.append((String)key).append((String)val.p2).append("|");
            });
            if (sourceStr.toString().equals(targetStr.toString())) {
                throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u4e0e\u5f53\u524d\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"ScriptBuiltin_21", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            if (SPECIAL_PROCESS.contains(outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p2) && StringUtils.isNotEmpty((String)sourceEntity) && !sourceEntity.contains("_")) {
                throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u7684\u6765\u6e90\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u7ec4\u5408\u7684\u7ec4\u7ec7\u548c\u8fc7\u7a0b\u4e0d\u5339\u914d\u3002", (String)"ScriptBuiltin_55", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            command = new ComputingCommandInfo();
            if (scope != null) {
                ctxFilters = (List)scope.getFilters();
                for (DimensionFilterItem ctxFilter : ctxFilters) {
                    if (!numbers.contains(ctxFilter.getName())) continue;
                    throw new BizRuleException(ResManager.loadKDString((String)"copy\u51fd\u6570\u4e2d\u7684scope\u53c2\u6570\u7684\u8303\u56f4\u4e0d\u80fd\u542b\u6709\u4e0a\u4e0b\u6587\u7ef4\u5ea6\u3002", (String)"ScriptBuiltin_60", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
            }
            scope = outline.getComputingContext().getRuntimeScope(scope);
            ctxFilters = (List)scope.getFilters();
            ctxFilters.removeIf(filter -> filter.getName().equals(PresetConstant.ENTITY_DIM));
            command.setFilter(ctxFilters);
            command.setMainDimName("");
            command.setMainMeaName("FMONEY");
            item = new FelLambdaExpressionItem();
            item.setExpressLeft("E@" + (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2);
            right = new StringBuilder();
            right.append("v('");
            right.append(rightExpression);
            if (StringUtils.isEmpty((String)sourceEntity)) {
                right.append(",E@");
                right.append((String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2);
            }
        } else {
            throw new BizRuleException("params error");
        }
        right.append("')");
        item.setExpression(right.toString());
        command.getExpressionItems().add(item);
        ScriptBuiltinHelper.executeOlapCommand((CommandInfo)command, olapConnection);
    }

    public static JSONObject shareJournal(String virEntCode, IOutline outline) {
        String modelNum = outline.getModelNum();
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        long tarEntityId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p1;
        String tarEntityNum = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.ENTITY_DIM).p2;
        long sceneId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.SCENE_DIM).p1;
        long yearId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.FY_DIM).p1;
        long periodId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p1;
        long processId = (Long)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p1;
        String processNum = (String)outline.getComputingContext().getScopeItems().get((Object)PresetConstant.PROCESS_DIM).p2;
        if (StringUtils.isNotEmpty((String)virEntCode)) {
            IDNumberTreeNode entityMemberByNum;
            if (virEntCode.contains("_")) {
                virEntCode = virEntCode.substring(virEntCode.lastIndexOf("_") + 1);
            }
            if ((entityMemberByNum = MemberReader.findEntityMemberByNum((String)modelNum, (String)virEntCode)).getId() == -1L) {
                throw new BizRuleException(ResManager.loadKDString((String)"\u6307\u5b9a\u5206\u5f55\u6765\u6e90\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548\u3002", (String)"ScriptBuiltin_27", (String)"fi-bcm-computing", (Object[])new Object[0]));
            }
            try {
                if (entityMemberByNum.isLeaf()) {
                    throw new BizRuleException(ResManager.loadKDString((String)"\u6307\u5b9a\u5206\u5f55\u6765\u6e90\u7ec4\u7ec7\u5fc5\u987b\u662f\u5408\u5e76\u8282\u70b9\u3002", (String)"ScriptBuiltin_26", (String)"fi-bcm-computing", (Object[])new Object[0]));
                }
                IDNumberTreeNode targetEntitynumber = MemberReader.findEntityMemberById((String)modelNum, (Long)tarEntityId);
                if (MERGE_JOURNAL_BPS.contains(processNum)) {
                    if (targetEntitynumber.isLeaf()) {
                        throw new BizRuleException(ResManager.loadKDString((String)"\u6307\u5b9a\u5206\u5f55\u76ee\u6807\u7ec4\u7ec7\u5fc5\u987b\u662f\u5408\u5e76\u8282\u70b9\u3002", (String)"ScriptBuiltin_28", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    if (tarEntityNum.equals(virEntCode)) {
                        throw new BizRuleException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u8fc7\u7a0b\u7684\u7ec4\u5408\u4e0d\u6ee1\u8db3\u5171\u4eab\u5206\u5f55\u51fd\u6570shareJournal\u7684\u6267\u884c\u6761\u4ef6\u3002", (String)"ScriptBuiltin_33", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                }
                if (targetEntitynumber.isLeaf()) {
                    if (!PARENT_JOURNAL_BPS.contains(processNum)) {
                        throw new BizRuleException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u548c\u8fc7\u7a0b\u7684\u7ec4\u5408\u4e0d\u6ee1\u8db3\u5171\u4eab\u5206\u5f55\u51fd\u6570shareJournal\u7684\u6267\u884c\u6761\u4ef6\u3002", (String)"ScriptBuiltin_33", (String)"fi-bcm-computing", (Object[])new Object[0]));
                    }
                    if (!IDNumberTreeNode.NotFoundTreeNode.equals(targetEntitynumber.getParent())) {
                        tarEntityId = targetEntitynumber.getParent().getId();
                    }
                } else if (PARENT_JOURNAL_BPS.contains(processNum) && !IDNumberTreeNode.NotFoundTreeNode.equals(targetEntitynumber.getParent())) {
                    tarEntityId = targetEntitynumber.getParent().getId();
                }
                Object[] params = new Object[]{modelId, entityMemberByNum.getId(), tarEntityId, sceneId, yearId, periodId, processId};
                OperationResult operationResult = (OperationResult)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.adjust.CslSchemeAdjustShareHelper", (String)"shareEntry", (Object[])params);
                JSONObject resultJson = JSONObject.parseObject((String)operationResult.getMessage(), (Feature[])new Feature[]{Feature.OrderedField});
                if (!operationResult.getAllErrorInfo().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (OperateErrorInfo errorInfo : operationResult.getAllErrorInfo()) {
                        sb.append(errorInfo.getMessage()).append(";");
                    }
                    logger.info(String.format(ResManager.loadKDString((String)"\u6e90\u7ec4\u7ec7%1$s\u5171\u4eab\u5230\u76ee\u6807\u7ec4\u7ec7%2$s\u5931\u8d25\u4fe1\u606f\uff1a", (String)"ScriptBuiltin_29", (String)"fi-bcm-computing", (Object[])new Object[0]), virEntCode, targetEntitynumber.getNumber()) + sb);
                }
                return resultJson;
            }
            catch (Exception e) {
                throw new BizRuleException((Throwable)e);
            }
        }
        throw new BizRuleException(ResManager.loadKDString((String)"\u7f3a\u5931\u5206\u5f55\u6765\u6e90\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"ScriptBuiltin_25", (String)"fi-bcm-computing", (Object[])new Object[0]));
    }

    public static String getLastPeriod(IOutline outline) {
        String modelNum = outline.getModelNum();
        ComputingContext context = outline.getComputingContext();
        if ("M_M01".equals(context.getRuntimePeriod())) {
            return ScriptBuiltinHelper.getLastYearEnd(outline);
        }
        String[] lastPeriodIncludeYear = PeriodUtils.getLastPeriodIncludeYear((String)modelNum, (String)context.getRuntimeFy(), (String)context.getRuntimePeriod(), (boolean)true);
        if (lastPeriodIncludeYear[0] == null) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u6240\u9009\u8d22\u5e74\u671f\u95f4\u4e3a\u5f53\u524d\u4f53\u7cfb\u7684\u7b2c\u4e00\u4e2a\u8d22\u5e74\u671f\u95f4\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8d22\u5e74\u671f\u95f4\u540e\u91cd\u8bd5\u3002", (String)"ScriptBuiltin_20", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        return "FY@" + lastPeriodIncludeYear[0] + ",P@" + lastPeriodIncludeYear[1];
    }

    public static Object[] transParamsWithScope(Object params, IOutline outline) {
        if (params == null) {
            return new Object[]{outline.getComputingContext().getRuntimeScope(null)};
        }
        if (params instanceof ScopeInfo) {
            return new Object[]{outline.getComputingContext().getRuntimeScope((ScopeInfo)params)};
        }
        if (params.getClass().isArray()) {
            Object[] args = (Object[])params;
            ArrayList<Object> trans = new ArrayList<Object>(args.length);
            for (Object o : args) {
                if (o instanceof ScopeInfo) {
                    trans.add(outline.getComputingContext().getRuntimeScope((ScopeInfo)o));
                    continue;
                }
                if (o != null && o.getClass().isArray()) {
                    Collections.addAll(trans, (Object[])o);
                    continue;
                }
                if (o instanceof Collection) {
                    trans.addAll((Collection)o);
                    continue;
                }
                trans.add(o);
            }
            if (!trans.isEmpty() && !(trans.get(0) instanceof ScopeInfo)) {
                trans.add(0, outline.getComputingContext().getRuntimeScope(null));
            }
            return trans.toArray();
        }
        return new Object[]{outline.getComputingContext().getRuntimeScope(null), params};
    }

    public static void batchExecuteComputingCommand(BatchCommandInfo batchCommands, OlapConnection olapConnection) {
        if (!batchCommands.getLevels().isEmpty()) {
            ScriptBuiltinHelper.executeOlapCommand((CommandInfo)batchCommands, olapConnection);
        }
        batchCommands.getLevels().clear();
    }

    public static JSONArray getInvestInfo(String solution, IOutline outline, String[] customParams) {
        if (customParams.length > 2) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"getInvestInfo", 3});
        }
        return (JSONArray)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"getInvestInfo", (Object[])new Object[]{solution, outline, customParams});
    }

    public static void checkNormalModelMethod(IOutline outline, ExtendDimGroupType groupType, String methodName) {
        BizRuleExecuteTypeEnum executeType;
        if (groupType == ExtendDimGroupType.EQUITY) {
            throw new BizRuleException(ResManager.loadKDString((String)"\u8be5\u65b9\u6cd5\u4ec5\u9002\u7528\u4e8e\u975e\u6743\u76ca\u5e95\u7a3f\u6570\u636e\u6a21\u578b", (String)"ScriptBuiltinHelper_0", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        Object executeTypeValue = outline.getBuiltin().getArgs().get("executeType");
        if (executeTypeValue instanceof BizRuleExecuteTypeEnum && (executeType = (BizRuleExecuteTypeEnum)executeTypeValue) == BizRuleExecuteTypeEnum.EQUITY_ONLY) {
            throw new BizRuleException(String.format(ResManager.loadKDString((String)"\u975e\u6743\u76ca\u5e95\u7a3f\u6a21\u578b\u7684%s\u65b9\u6cd5\u4e0d\u80fd\u5b9a\u4e49\u5728\u6267\u884c\u7c7b\u578b\u662f'\u4ec5\u6743\u76ca\u5e95\u7a3f'\u7684\u4e1a\u52a1\u89c4\u5219\u4e2d", (String)"ScriptBuiltinHelper_5", (String)"fi-bcm-computing", (Object[])new Object[0]), methodName));
        }
    }

    public static JSONArray getOwnershipMap(IOutline outline, String parent, String startEntity, String endEntity) {
        Map<String, Object> args = outline.getBuiltin().getArgs();
        ScriptBuiltinHelper.checkExecuteType(args, "getOwnershipMap");
        if (StringUtils.isEmpty((String)parent) || StringUtils.isEmpty((String)startEntity) || StringUtils.isEmpty((String)endEntity)) {
            throw new BizRuleException(ResManager.loadKDString((String)"getOwnershipMap\u51fd\u6570\u5fc5\u987b\u6307\u5b9a3\u4e2a\u53c2\u6570\uff1a\u5408\u5e76\u8282\u70b9\u7f16\u7801\u3001\u8d77\u70b9\u6295\u8d44\u516c\u53f8\u7f16\u7801\u548c\u7ec8\u70b9\u88ab\u6295\u8d44\u516c\u53f8\u7f16\u7801\u3002", (String)"ScriptBuiltinHelper_1", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        String modelNum = outline.getModelNum();
        IDNumberTreeNode parentNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)parent);
        if (parentNode == IDNumberTreeNode.NotFoundTreeNode || parentNode.isLeaf()) {
            throw new BizRuleException(ResManager.loadKDString((String)"getOwnershipMap\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u5408\u5e76\u8282\u70b9\u7f16\u7801\u3002", (String)"ScriptBuiltinHelper_2", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        IDNumberTreeNode startEntityNode = MemberReader.findMemberByNumber((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)startEntity);
        if (startEntityNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new BizRuleException(ResManager.loadKDString((String)"getOwnershipMap\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u8d77\u70b9\u6295\u8d44\u516c\u53f8\u7f16\u7801\u3002", (String)"ScriptBuiltinHelper_3", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        IDNumberTreeNode endEntityNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)endEntity);
        if (endEntityNode == IDNumberTreeNode.NotFoundTreeNode) {
            throw new BizRuleException(ResManager.loadKDString((String)"getOwnershipMap\u51fd\u6570\u6307\u5b9a\u4e86\u65e0\u6548\u7684\u7ec8\u70b9\u88ab\u6295\u8d44\u516c\u53f8\u7f16\u7801\u3002", (String)"ScriptBuiltinHelper_4", (String)"fi-bcm-computing", (Object[])new Object[0]));
        }
        StringJoiner key = new StringJoiner("_");
        ComputingContext computingContext = outline.getComputingContext();
        key.add("invCalcStaticWalkPaths");
        key.add(outline.getModelNum());
        key.add((CharSequence)computingContext.getScopeItems().get((Object)PresetConstant.SCENE_DIM).p2);
        key.add((CharSequence)computingContext.getScopeItems().get((Object)PresetConstant.FY_DIM).p2);
        key.add((CharSequence)computingContext.getScopeItems().get((Object)PresetConstant.PERIOD_DIM).p2);
        return (JSONArray)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"getOwnershipMap", (Object[])new Object[]{outline, key.toString(), parent, startEntity, endEntity});
    }

    private static void checkExecuteType(Map<String, Object> args, String methodName) {
        if (args.get("executeType") != BizRuleExecuteTypeEnum.INVEST_ONLY) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.executeTypeError"), new Object[]{methodName});
        }
    }

    public static boolean isRptStatMatched(IOutline outline, Object[] customParams) {
        if (customParams.length > 3) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"isRptStatMatched", 3});
        }
        if (customParams.length < 2) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramLessLimit"), new Object[]{"isRptStatMatched", 2});
        }
        return (Boolean)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"isRptStatMatched", (Object[])new Object[]{outline, customParams});
    }

    public static String getRptStats(IOutline outline, Object[] customParams) {
        if (customParams.length > 2) {
            throw new BizRuleException(FiBcmErrorCode.create((String)"fi.bcm.paramOverLimit"), new Object[]{"getRptStats", 2});
        }
        return (String)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"getRptStats", (Object[])new Object[]{outline, customParams});
    }

    public static List<IDNumberTreeNode> getRefPropertyMembers(String modelNum, String dimNum, String key, String[] values) {
        ArrayList<IDNumberTreeNode> memNodes = new ArrayList<IDNumberTreeNode>(10);
        Long modelId = MemberReader.findModelIdByNum((String)modelNum);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum);
        Set propList = DimPropList.getDimPropList((long)dimensionId).getPropList();
        if (!propList.contains(key)) {
            throw new BizRuleException("not exists property " + key);
        }
        String entityNumber = MemberReader.getEntityNumberByDim((String)modelNum, (String)dimNum);
        for (String value : values) {
            Map allNodeFromCache = MemberReader.getAllNodeFromCache((String)"bcm_definedpropertyvalue", (Object)modelId);
            IDNumberTreeNode exist = null;
            for (IDNumberTreeNode node : allNodeFromCache.values()) {
                if (!Objects.equals(node.getDimId(), dimensionId) || !node.getNumber().equals(value)) continue;
                exist = node;
            }
            if (exist == null) {
                throw new BizRuleException("not exists property value " + value);
            }
            Object[] params = new Object[]{modelId, entityNumber, exist.getId(), exist.getNumber(), 10};
            Set ids = (Set)InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"getPropertyMember", (Object[])params);
            for (Long id : ids) {
                IDNumberTreeNode node = MemberReader.findMemberById((long)modelId, (String)entityNumber, (Long)id);
                if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
                memNodes.add(node);
            }
        }
        return memNodes;
    }

    public static Object getConFlowStatus(IOutline outline, Object[] params) {
        return InvokeUtils.invokeStaticMethod((String)"kd.fi.bcm.business.bizrule.ScriptBuiltinInvokeHelper", (String)"getConFlowStatus", (Object[])new Object[]{outline, params});
    }

    static {
        NUM_SHORT_MAP.put(PresetConstant.ENTITY_DIM, DimTypesEnum.ENTITY.getShortNumber());
        NUM_SHORT_MAP.put(PresetConstant.FY_DIM, DimTypesEnum.YEAR.getShortNumber());
        NUM_SHORT_MAP.put(PresetConstant.PERIOD_DIM, DimTypesEnum.PERIOD.getShortNumber());
        NUM_SHORT_MAP.put(PresetConstant.SCENE_DIM, DimTypesEnum.SCENARIO.getShortNumber());
        SHORT_NUM_MAP.put(DimTypesEnum.ENTITY.getShortNumber(), PresetConstant.ENTITY_DIM);
        SHORT_NUM_MAP.put(DimTypesEnum.YEAR.getShortNumber(), PresetConstant.FY_DIM);
        SHORT_NUM_MAP.put(DimTypesEnum.PERIOD.getShortNumber(), PresetConstant.PERIOD_DIM);
        SHORT_NUM_MAP.put(DimTypesEnum.SCENARIO.getShortNumber(), PresetConstant.SCENE_DIM);
    }
}

