/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.cache.ThreadCache;
import kd.fi.bcm.common.bizrule.BizRuleServiceHelper;
import kd.fi.bcm.common.enums.BizRuleDebugLogInfoEnum;
import kd.fi.bcm.common.json.JSONObject;
import kd.fi.bcm.common.log.BizRuleDebugLogInfo;
import org.mozilla.javascript.NativeObject;

public class ScriptDebugLogInfoUtil {
    public static final String COST_PREFIX = "cost:";

    private static BizRuleDebugLogInfo newLogInfo(BizRuleDebugLogInfoEnum level, String info) {
        return new BizRuleDebugLogInfo(level, info);
    }

    public static void debug(String ruleid, Object info) {
        ScriptDebugLogInfoUtil.addInfo(ruleid, BizRuleDebugLogInfoEnum.DEBUG, info);
    }

    public static void log(String ruleid, Object info) {
        ScriptDebugLogInfoUtil.addInfo(ruleid, BizRuleDebugLogInfoEnum.LOG, info);
    }

    private static void addInfo(String ruleid, BizRuleDebugLogInfoEnum level, Object info) {
        List<BizRuleDebugLogInfo> infolist = ScriptDebugLogInfoUtil.getLogInfoByBizRuleId(ruleid);
        infolist.add(ScriptDebugLogInfoUtil.newLogInfo(level, info == null ? "null" : ScriptDebugLogInfoUtil.transObject(info)));
    }

    private static String transObject(Object info) {
        if (info instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)info;
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry entry : nativeObject.entrySet()) {
                jsonObject.put(ScriptDebugLogInfoUtil.transObject(entry.getKey()), (Object)ScriptDebugLogInfoUtil.transObject(entry.getValue()));
            }
            return jsonObject.toJSONString();
        }
        if (info instanceof HashMap) {
            JSONObject jsonObject = new JSONObject();
            HashMap map = (HashMap)info;
            for (Map.Entry entry : map.entrySet()) {
                jsonObject.put(ScriptDebugLogInfoUtil.transObject(entry.getKey()), (Object)ScriptDebugLogInfoUtil.transObject(entry.getValue()));
            }
            return jsonObject.toJSONString();
        }
        if (info instanceof Object[]) {
            StringBuilder stringBuilder = new StringBuilder("[");
            StringJoiner sj = new StringJoiner(", ");
            for (Object o : (Object[])info) {
                sj.add(ScriptDebugLogInfoUtil.transObject(o));
            }
            stringBuilder.append(sj).append("]");
            return stringBuilder.toString();
        }
        return info == null ? "null" : info.toString();
    }

    public static List<BizRuleDebugLogInfo> getLogInfoByBizRuleId(String ruleId) {
        return (List)ThreadCache.get((Object)ruleId, () -> new ArrayList());
    }

    public static String formatBizLogInfo(String bizLogTitle, Collection<Long> ruleIds) {
        StringBuilder log = new StringBuilder();
        for (Long ruleId : ruleIds) {
            List<BizRuleDebugLogInfo> logs = ScriptDebugLogInfoUtil.getLogInfoByBizRuleId(ruleId.toString());
            StringBuilder cost = new StringBuilder();
            logs.removeIf(p -> {
                if (BizRuleDebugLogInfoEnum.DEBUG == p.getLevel()) {
                    return true;
                }
                if (p.getInfo() != null && p.getInfo().startsWith(COST_PREFIX)) {
                    cost.append(p.getInfo());
                    return true;
                }
                return false;
            });
            if (!logs.isEmpty() || cost.length() > 0) {
                log.append("--------------------------------");
                if (cost.length() > 0) {
                    log.append((CharSequence)cost).append("----");
                }
                log.append(BizRuleServiceHelper.getBizRuleBaseInfo((long)ruleId)).append('|').append(bizLogTitle).append("------------------------\n");
                logs.forEach(l -> log.append(l.getInfo()).append('\n'));
            }
            logs.clear();
        }
        return log.toString();
    }

    public static void collectLog2Cache(String key, String log) {
        ScriptDebugLogInfoUtil.getLogHolder(key).append(log);
    }

    public static String getCollectLogs(String key) {
        return ScriptDebugLogInfoUtil.getLogHolder(key).toString();
    }

    private static StringBuilder getLogHolder(String key) {
        return (StringBuilder)ThreadCache.get((Object)key, StringBuilder::new);
    }

    public static void removeCollectLogs(String key) {
        ThreadCache.remove((Object)key);
    }
}

