/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.computing.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.exception.ScriptAnalyzeException;
import kd.fi.bcm.common.util.DataEntityUtils;
import kd.fi.bcm.common.util.QFBuilder;
import org.mozilla.javascript.WrappedException;

public class TreeStructureServiceHelper {
    public static Map<Object, DynamicObject> getDirectChild(String entityNumber, Object pId, String select) {
        QFBuilder qf = new QFBuilder();
        qf.add("parent", "=", pId);
        if (entityNumber.equals(DimEntityNumEnum.ENTITY.getEntityNum())) {
            qf.add(new QFilter("isexchangerate", "!=", (Object)Boolean.TRUE));
        }
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)select, (QFilter[])qf.toArray());
        return map;
    }

    public static List<IDNumberTreeNode> getDirectChild(String entityNumber, Object pId, String select, String modelNum) {
        Map allNodeCache = MemberReader.getAllNodeFromCache((String)entityNumber, (String)modelNum);
        IDNumberTreeNode selfNode = (IDNumberTreeNode)allNodeCache.get(Long.valueOf(pId.toString()));
        List children = selfNode.getChildren();
        return children == null ? new ArrayList(0) : children;
    }

    public static DynamicObject getSelfByNumber(String dimensionNumber, String entityNum, String memberNumber, String modelNumber, String select) {
        Map map;
        QFilter filter = new QFilter("number", "=", (Object)memberNumber);
        filter.and(new QFilter("model.number", "=", (Object)modelNumber));
        if (dimensionNumber != null) {
            filter.and(new QFilter("dimension.number", "=", (Object)dimensionNumber));
        }
        if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        }
        if ((map = BusinessDataServiceHelper.loadFromCache((String)entityNum, (String)select, (QFilter[])filter.toArray())).isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u627e\u4e0d\u5230\u6210\u5458:%2$s\u30021\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u6216\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b58\u5728\uff1b2\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u5b9a\u4e49\u4e86\u8be5\u53d8\u91cf\u3002", (String)"TreeStructureServiceHelper_1", (String)"fi-bcm-computing", (Object[])new Object[0]), entityNum, memberNumber);
            throw new WrappedException((Throwable)new ScriptAnalyzeException(message));
        }
        return (DynamicObject)map.values().iterator().next();
    }

    public static String getLongNumber(String entityNum, String dimension, String number, Object modelId) {
        DynamicObject baseMember = TreeStructureServiceHelper.getBaseMember(entityNum, "longnumber", new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", modelId)).and(new QFilter("dimension.number", "=", (Object)dimension)));
        if (baseMember == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%1$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6210\u5458\u3002", (String)"TreeStructureServiceHelper_4", (String)"fi-bcm-computing", (Object[])new Object[0]), DimEntityNumEnum.getNumberByEntieyNum((String)entityNum), number));
        }
        return baseMember.getString("longnumber");
    }

    public static DynamicObject getBaseMember(String entityNum, String fileds, QFilter filter) {
        if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        }
        return QueryServiceHelper.queryOne((String)entityNum, (String)fileds, (QFilter[])new QFilter[]{filter});
    }

    public static String getParentOrgBaseNumber(String modelNum, String currentOrgNum) {
        IDNumberTreeNode orgMember = MemberReader.findEntityMemberByNum((String)modelNum, (String)currentOrgNum);
        IDNumberTreeNode parent = orgMember.getParent();
        String parentOrgBaseNum = parent.getNumber();
        if (StorageTypeEnum.STORAGE != parent.getStorageType()) {
            Map<Long, String> baseId2Number = TreeStructureServiceHelper.getEntityBaseMemberid2Numbers(Collections.singletonList(parent.getId()));
            parentOrgBaseNum = baseId2Number.get(parent.getId());
        }
        return parentOrgBaseNum;
    }

    public static Map<Long, String> getEntityBaseMemberid2Numbers(Collection<Long> ids) {
        return (Map)ThreadCache.get((Object)("base_id2num" + ids), () -> {
            HashMap map = new HashMap();
            BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter("id", "in", (Object)ids).toArray()).values().forEach(dyna -> map.put(dyna.getLong("id"), dyna.getString("number")));
            return map;
        });
    }
}

