/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.cache.MemberReader;

public abstract class AbstractContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long modelId;
    private long scenarioId;
    private long fyId;
    private long periodId;
    private String modelNum;
    private String scenariodNum;
    private String fyNum;
    private String periodNum;
    private Map<String, Object> properties = null;
    private Date curDate = new Date();

    public AbstractContext() {
    }

    public AbstractContext(long modelId, long scenarioId, long fyId, long periodId) {
        this.modelId = modelId;
        this.scenarioId = scenarioId;
        this.fyId = fyId;
        this.periodId = periodId;
    }

    public AbstractContext(SimpleItem model, SimpleItem scenario, SimpleItem fy, SimpleItem period) {
        this.modelId = Long.parseLong(model.id.toString());
        this.modelNum = model.number;
        this.scenarioId = Long.parseLong(scenario.id.toString());
        this.scenariodNum = scenario.number;
        this.fyId = Long.parseLong(fy.id.toString());
        this.fyNum = fy.number;
        this.periodId = Long.parseLong(period.id.toString());
        this.periodNum = period.number;
    }

    public long getModelId() {
        return this.modelId;
    }

    public long getScenarioId() {
        return this.scenarioId;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public long getFyId() {
        return this.fyId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
        this.modelNum = null;
    }

    public void setScenarioId(long scenarioId) {
        this.scenarioId = scenarioId;
        this.scenariodNum = null;
    }

    public void setFyId(long fyId) {
        this.fyId = fyId;
        this.fyNum = null;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
        this.periodNum = null;
    }

    public String getScenariodNum() {
        if (StringUtils.isEmpty((String)this.scenariodNum)) {
            this.scenariodNum = MemberReader.findScenaMemberById((String)this.getModelNum(), (Long)this.scenarioId).getNumber();
        }
        return this.scenariodNum;
    }

    public String getFyNum() {
        if (StringUtils.isEmpty((String)this.fyNum)) {
            this.fyNum = MemberReader.findFyMemberById((String)this.getModelNum(), (Long)this.fyId).getNumber();
        }
        return this.fyNum;
    }

    public String getPeriodNum() {
        if (StringUtils.isEmpty((String)this.periodNum)) {
            this.periodNum = MemberReader.findPeriodMemberById((String)this.getModelNum(), (Long)this.periodId).getNumber();
        }
        return this.periodNum;
    }

    public String getModelNum() {
        if (StringUtils.isEmpty((String)this.modelNum)) {
            this.modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        }
        return this.modelNum;
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>(2);
        }
        this.properties.put(key, value);
    }

    public <T> T getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return (T)this.properties.get(key);
    }

    public Date curDate() {
        return this.curDate;
    }
}

