/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class AdjustModelUpgradeService {
    private long modelId;
    private long dimensionId;
    private String fieldmapped;
    private long defaultValue;
    private String membermodel;
    private int seq;

    public AdjustModelUpgradeService(long modelId, long dimensionId, String fieldmapped, long defaultValue, String membermodel) {
        this.modelId = modelId;
        this.dimensionId = dimensionId;
        this.fieldmapped = fieldmapped;
        this.defaultValue = defaultValue;
        this.membermodel = membermodel;
        List objects = QueryServiceHelper.queryPrimaryKeys((String)"bcm_dimension", (QFilter[])new QFilter("model", "=", (Object)modelId).and("fieldmapped", "=", (Object)this.fieldmapped).toArray(), null, (int)-1);
        this.seq = CollectionUtils.isEmpty((Collection)objects) ? 20 : objects.size();
    }

    public boolean upgradeRptAdjustData() {
        List adjustIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])new QFilter("model", "=", (Object)this.modelId).toArray(), null, (int)-1);
        if (adjustIds.size() > 0) {
            ArrayList paramsList = new ArrayList();
            StringBuilder sycSql = new StringBuilder();
            sycSql.append("insert into t_bcm_rptadjustcomdim (FENTRYID,fid,FDimensionID,FMemberid,fseq,fcomentitysign) VALUES (?,?,?,?,?,?)");
            try (TXHandle tx = TX.required();){
                try {
                    AdjustOperationThreadHelper.groupList(adjustIds, true).values().forEach(idList -> {
                        paramsList.clear();
                        for (Object id : idList) {
                            Object[] param = new Object[]{GlobalIdUtil.genGlobalLongId(), id, this.dimensionId, this.defaultValue, this.seq, this.membermodel};
                            paramsList.add(param);
                        }
                        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sycSql.toString(), (List)paramsList);
                    });
                    String sql = String.format("update t_bcm_rptadjustdata SET %s = ? WHERE fmodelid = ?", "F" + this.fieldmapped);
                    DB.update((DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])new Object[]{this.defaultValue, this.modelId});
                    SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
                    SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjustdata");
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException(ThrowableHelper.toString((Exception)e));
                }
            }
        }
        return true;
    }

    public boolean upgradeAdjustCommonTemplateData() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.modelId);
        qFilter.and("templatetype", "=", (Object)TemplateCatalogEnum.PRTADJUST.getTemplatetype());
        List templateIds = QueryServiceHelper.queryPrimaryKeys((String)"bcm_papertemplate", (String)"bcm_papertemplate", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (!CollectionUtils.isEmpty((Collection)templateIds)) {
            ArrayList paramsList = new ArrayList();
            StringBuilder sycSql = new StringBuilder();
            sycSql.append("insert into t_bcm_adjusttmpcomdim (FENTRYID,fid,FDimensionID,FMemberid,fseq,fcomentitysign) VALUES (?,?,?,?,?,?)");
            try (TXHandle tx = TX.required();){
                try {
                    templateIds.forEach(templateId -> {
                        Object[] param = new Object[]{GlobalIdUtil.genGlobalLongId(), templateId, this.dimensionId, this.defaultValue, this.seq, this.membermodel};
                        paramsList.add(param);
                    });
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sycSql.toString(), paramsList);
                    SaveServiceHelper.clearDataEntityCache((String)"bcm_papertemplate");
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException(ThrowableHelper.toString((Exception)e));
                }
            }
        }
        return true;
    }
}

