/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.adjust.AdjustModelUpgradeService;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustEntryConfig;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.servicehelper.AdjustQueryServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.convert.exception.CvtExchangeException;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.AbstractScheme;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.scheme.LossCarryScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.MutexServiceHelper;
import kd.fi.bcm.business.serviceHelper.UserServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AdjustTypeEnum;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CheckStatusEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.PermEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.LinkAdjustMappingEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class AdjustmentServiceHelper {
    public static final String ENTRYROWTYPE_CURR_DIFF = "1";
    public static final String ENTRYROWTYPE_RATE_DIFF = "2";
    public static final String errorcode_illegal_entry_org = "illegal_entry_org";
    private static final String ENTITY = "entity";
    private static final String SCENARIO = "scenario";
    protected static final List<String> linkAdjustSource = new ArrayList<String>(2);
    protected static final List<Integer> autoSource = new ArrayList<Integer>(5);
    private static final Map<String, String> COMM_DIM_LINK_MAP;

    public static List<Integer> getAutoSource() {
        return autoSource;
    }

    public static Pair<Boolean, String> validateSceneVersion(AdjustOperationContext ctx, DynamicObject adjust, List<DynamicObject> adjustDataList) {
        Long sceneId = DynUtils.getBaseId((DynamicObject)adjust, (String)SCENARIO);
        Long yearId = DynUtils.getBaseId((DynamicObject)adjust, (String)"year");
        Long periodId = DynUtils.getBaseId((DynamicObject)adjust, (String)"period");
        if (MergeControlHelper.isQuoteScene(ctx.getModelId(), sceneId)) {
            if (OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process"))) {
                Long mergeId = DynUtils.getBaseId((DynamicObject)adjust, (String)ENTITY);
                if (!MergeControlHelper.isVersionedOrg(ctx.getModelId(), sceneId, yearId, periodId, mergeId)) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)AdjustSceneVersionValidator.packErrorMsg(MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)mergeId).getNumber(), MemberReader.findFyMemberById((Long)ctx.getModelId(), (Long)yearId).getNumber(), MemberReader.findPeriodMemberById((Long)ctx.getModelId(), (Long)periodId).getNumber()));
                }
            } else {
                Set closedVersionedOrgSet = adjustDataList.stream().map(adjustData -> DynUtils.getBaseId((DynamicObject)adjustData, (String)ENTITY)).filter(entityId -> !MergeControlHelper.isVersionedOrg(ctx.getModelId(), sceneId, yearId, periodId, entityId)).map(entityId -> MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)entityId).getNumber()).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(closedVersionedOrgSet)) {
                    return Pair.onePair((Object)Boolean.FALSE, (Object)AdjustSceneVersionValidator.packErrorMsg(closedVersionedOrgSet, MemberReader.findFyMemberById((Long)ctx.getModelId(), (Long)yearId).getNumber(), MemberReader.findPeriodMemberById((Long)ctx.getModelId(), (Long)periodId).getNumber()));
                }
            }
        }
        return Pair.onePair((Object)Boolean.TRUE, null);
    }

    @SDKMark(description="")
    public static OperationResult sycToMDD(OperationResult operationResult, List<Long> pks, boolean isAudit, AdjustTypeEnum type, boolean isNeedMonitorDataStatus) {
        DynamicObject dy;
        if (pks != null && pks.size() > 0 && (dy = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"year.id,period.id,scenario.id,model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pks.get(0))})) != null) {
            AdjustCheckServiceHelper.doSysToMdd(dy.getLong("model.id"), dy.getLong("scenario.id"), dy.getLong("year.id"), dy.getLong("period.id"), pks, isAudit);
        }
        return operationResult;
    }

    public static Pair<Boolean, String> getUserDefineDimSet(long modelId, String dimNum, Object permClassId) {
        return AdjustmentServiceHelper.getUserDefineDimSet(modelId, permClassId).get(dimNum);
    }

    public static Map<String, Pair<Boolean, String>> getUserDefineDimSet(long modelId, Object permClassId) {
        long userId = LongUtil.toLong((Object)RequestContext.getOrCreate().getUserId());
        return (Map)BcmThreadCache.get((Object)"getUserDefineDimSet", (Object)modelId, (Object)userId, (Object)(permClassId == null ? "" : permClassId), () -> {
            HashMap userDefineDimSet = new HashMap(16);
            SchemeContext sctx = new SchemeContext(modelId);
            Map<Long, Pair<Boolean, String>> hideDefaultMap = QueryDimensionServiceHelper.getDimensionHideDefaultItem(modelId);
            Map<String, DynamicObject> defaultValueMap = QueryDimensionServiceHelper.getDefaultValue(modelId, "bcm_adjustoffset_entry", permClassId == null ? null : permClassId.toString(), userId).stream().collect(Collectors.toMap(p -> p.getString("dimension"), p -> p, (v1, v2) -> v2));
            sctx.getDimensions().forEach(dim -> {
                if (defaultValueMap.containsKey(dim.getNumber())) {
                    long memId = ((DynamicObject)defaultValueMap.get(dim.getNumber())).getLong("defaultvalueid");
                    if (memId != 0L && !PermissionServiceImpl.getInstance(modelId).isAllNoPerm(dim.getId(), dim.getMembermodel(), Collections.singletonList(memId))) {
                        userDefineDimSet.put(dim.getNumber(), Pair.onePair((Object)Boolean.FALSE, (Object)Long.toString(memId)));
                    } else {
                        userDefineDimSet.put(dim.getNumber(), Pair.onePair((Object)Boolean.FALSE, (Object)"0"));
                    }
                } else if (hideDefaultMap.containsKey(dim.getId())) {
                    Pair memPair = (Pair)hideDefaultMap.get(dim.getId());
                    long memId = Long.parseLong((String)memPair.p2);
                    if (memId != 0L && !PermissionServiceImpl.getInstance(modelId).isAllNoPerm(dim.getId(), dim.getMembermodel(), Collections.singletonList(memId))) {
                        userDefineDimSet.put(dim.getNumber(), memPair);
                    } else {
                        userDefineDimSet.put(dim.getNumber(), Pair.onePair((Object)Boolean.FALSE, (Object)"0"));
                    }
                } else {
                    userDefineDimSet.put(dim.getNumber(), Pair.onePair((Object)Boolean.FALSE, (Object)"0"));
                }
            });
            return userDefineDimSet;
        });
    }

    public static Map<Long, Boolean> checkArchiveEntrystatus(Long modelid, Long scene, Long year, Long period, DynamicObject[] adjustdatas) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (DynamicObject adjustdata : adjustdatas) {
            if (OrgRelaProcessMembPool.isRelaProcess((String)adjustdata.getString("adjust.process"))) {
                if (adjustdata.getLong("merge.id") == 0L) {
                    orgIds.add(adjustdata.getLong("adjust.entity.id"));
                    continue;
                }
                orgIds.add(adjustdata.getLong("merge.id"));
                continue;
            }
            orgIds.add(adjustdata.getLong("entity.id"));
        }
        orgIds.remove(0L);
        Map<Long, McStatus> mcStatusMap = McStatus.batchGetMcStatus(modelid, orgIds, scene, year, period);
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(16);
        for (DynamicObject adjustdata : adjustdatas) {
            long entity;
            boolean isOpen = true;
            long l = entity = OrgRelaProcessMembPool.isRelaProcess((String)adjustdata.getString("adjust.process")) ? adjustdata.getLong("merge.id") : adjustdata.getLong("entity.id");
            if (mcStatusMap != null && mcStatusMap.get(entity) != null && mcStatusMap.get(entity).getArchive().isArchive()) {
                isOpen = false;
            }
            if (!resultMap.getOrDefault(adjustdata.getLong("adjust.id"), Boolean.TRUE).booleanValue()) continue;
            resultMap.put(adjustdata.getLong("adjust.id"), isOpen);
        }
        return resultMap;
    }

    public static void changeCarryYearAdjustElim(VersionParam versionParam, Map<String, String> dimComb, List<LossCarryScheme> lossCarrySchemes, DynamicObject newdata) {
        LossCarryScheme selectlossCarryScheme = (LossCarryScheme)AdjustmentServiceHelper.searchSchemeByDimComb(versionParam, dimComb, lossCarrySchemes, true);
        if (selectlossCarryScheme != null) {
            selectlossCarryScheme.getAfterDimenSopeInfo().forEach((dim, dimdy) -> {
                if (dimdy != null) {
                    newdata.set(dim.getFieldmapped(), dimdy);
                }
            });
        }
    }

    public static AbstractScheme searchSchemeByDimComb(VersionParam versionParam, Map<String, String> dimComb, List<? extends AbstractScheme> schemes, boolean byfieldMap) {
        AbstractScheme selectlossCarryScheme = null;
        for (AbstractScheme abstractScheme : schemes) {
            DimensionScope applySceneScope;
            DimensionScope applyEntityScope;
            if (byfieldMap && abstractScheme instanceof LossCarryScheme && ((applyEntityScope = ((LossCarryScheme)abstractScheme).getApplyEntityScope()) != null && dimComb.get(ENTITY) != null && !applyEntityScope.contains(dimComb.get(ENTITY)) || (applySceneScope = ((LossCarryScheme)abstractScheme).getApplySceneScope()) != null && dimComb.get(SCENARIO) != null && !applySceneScope.contains(dimComb.get(SCENARIO)))) continue;
            Map lossCarryDetails = abstractScheme.getSchemeDetails();
            for (Map.Entry dim : lossCarryDetails.entrySet()) {
                Set<String> resolveScopes;
                String dimnumber;
                String string = dimnumber = byfieldMap ? ((Dimension)dim.getKey()).getFieldmapped() : ((Dimension)dim.getKey()).getNumber();
                if (dim.getValue() == null || !CollectionUtils.isNotEmpty(resolveScopes = ((DimensionScope)dim.getValue()).getResolveScopes(versionParam))) continue;
                if (dimComb.get(dimnumber) != null && resolveScopes.contains(dimComb.get(dimnumber))) {
                    selectlossCarryScheme = abstractScheme;
                    continue;
                }
                if (dimComb.get(dimnumber) == null || resolveScopes.contains(dimComb.get(dimnumber))) continue;
                selectlossCarryScheme = null;
                break;
            }
            if (selectlossCarryScheme == null) continue;
            return selectlossCarryScheme;
        }
        return null;
    }

    public static List<LossCarryScheme> getOverYearCopyConfig(long modelid) {
        return AdjustEntryConfig.get().getLossCarrySchemes(modelid);
    }

    public static List<LossCarryScheme> getLossCarrySchemes(SchemeContext sctx) {
        return AdjustEntryConfig.get().getLossCarrySchemes(sctx.getModel());
    }

    public static boolean checkAmountOutOfRange(BigDecimal amount) {
        int scale = amount.scale();
        int precision = amount.precision() - amount.scale();
        return scale <= 20 && precision <= 15;
    }

    public static boolean updateAdjust2AddDim(long modelId, long dimensionId, String fieldmapped, long defaultValue, String membermodel) {
        AdjustModelUpgradeService adjustModelUpgradeService = new AdjustModelUpgradeService(modelId, dimensionId, fieldmapped, defaultValue, membermodel);
        adjustModelUpgradeService.upgradeRptAdjustData();
        return adjustModelUpgradeService.upgradeAdjustCommonTemplateData();
    }

    @Deprecated
    public static boolean checkAdjustDataBalance(long model, String balanceType, List<DynamicObject> adjustDatas, long cvtbeforecurrency, boolean isMultipleCurrency) {
        boolean isBalance = true;
        if (!ENTRYROWTYPE_RATE_DIFF.equals(balanceType)) {
            Map<String, Collection<DynamicObject>> balanceGroup = AdjustmentServiceHelper.balanceGroupBy(balanceType, adjustDatas);
            isBalance = AdjustmentServiceHelper.checkAllGroupBalance(model, balanceGroup, cvtbeforecurrency, isMultipleCurrency);
        }
        return isBalance;
    }

    private static Map<String, Collection<DynamicObject>> balanceGroupBy(String balanceType, List<DynamicObject> adjustDatas) {
        HashMultimap group = HashMultimap.create();
        adjustDatas.stream().filter(p -> p.getBoolean("isdefaultcurrency") && !AdjustConvertUtil.getDiffTest().test(p.getInt("entryrowtype")) && !EntrySourceEnum.getLinkListToStringNotRule().contains(p.getString("entrysource"))).forEach(entry -> {
            String key;
            if (ENTRYROWTYPE_CURR_DIFF.equals(balanceType)) {
                key = entry.getString("groupnum");
                if (StringUtils.isEmpty((CharSequence)key)) {
                    key = "noGroupNum";
                }
            } else {
                key = entry.getString("entity.number");
                if (StringUtils.isEmpty((CharSequence)key)) {
                    key = "noOrgNum";
                }
            }
            group.put((Object)key, entry);
        });
        return group.asMap();
    }

    private static boolean checkAllGroupBalance(long model, Map<String, Collection<DynamicObject>> balanceGroup, long cvtbeforecurrency, boolean isMultipleCurrency) {
        boolean isSingleCurrency = !isMultipleCurrency && cvtbeforecurrency == 0L;
        BigDecimal configBalance = ConfigServiceHelper.getAdjustBalance(model);
        for (Collection<DynamicObject> group : balanceGroup.values()) {
            BigDecimal debtor = BigDecimal.ZERO;
            BigDecimal lender = BigDecimal.ZERO;
            for (DynamicObject entry : group) {
                debtor = debtor.add(entry.getBigDecimal(isSingleCurrency ? "debit" : "cvtbeforedebit"));
                lender = lender.add(entry.getBigDecimal(isSingleCurrency ? "credit" : "cvtbeforecredit"));
            }
            if (debtor.subtract(lender).abs().compareTo(configBalance) <= 0) continue;
            return false;
        }
        return true;
    }

    public static String getDefaultCvtRate(long model) {
        return "EntryExchangeRate";
    }

    public static void updateDefaultCvtRate(List<Object> modelIds) {
        DBRoute dbRoute = new DBRoute("bcm");
        DataSet dataSet = DB.queryDataSet((String)"updateDefaultCvtRate", (DBRoute)dbRoute, (String)"select fmodelid as model from T_BCM_StructOfChangeType where fisexchange = '1'");
        while (dataSet.hasNext()) {
            modelIds.remove(dataSet.next().getLong("model"));
        }
        if (!modelIds.isEmpty()) {
            QFilter qf = new QFilter("model", "in", modelIds);
            qf.and("number", "=", (Object)"FYTraDif");
            qf.and("storagetype", "!=", (Object)"3");
            List isStr = QueryServiceHelper.queryPrimaryKeys((String)"bcm_changetypemembertree", (QFilter[])qf.toArray(), null, (int)-1).stream().map(p -> p.toString()).collect(Collectors.toList());
            if (isStr.size() > 0) {
                String sql = String.format("update T_BCM_StructOfChangeType set fchangeway = '7',fisexchange = '1' where fid in (%s)", String.join((CharSequence)",", isStr));
                try {
                    DB.execute((DBRoute)dbRoute, (String)sql);
                    DataEntityCacheManager cacheManager = new DataEntityCacheManager("T_BCM_StructOfChangeType");
                    cacheManager.removeByPrimaryKey(isStr.toArray());
                }
                catch (Exception e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"SQL\u8bed\u53e5\uff1a%1$s\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s\u3002", (String)"AdjustmentServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), sql, ThrowableHelper.toString((Exception)e)));
                }
            }
        }
    }

    public static void updateCheckTmplState(Long model, List<Long> pks, boolean isAudit) {
        HashMap<Long, String> checkIdAdjustNumberMap = new HashMap<Long, String>(16);
        DynamicObjectCollection mappings = QueryServiceHelper.query((String)"bcm_linkadjust_mapping", (String)"id,elim.id,elim.number,elimentry.id,linkid", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)model), new QFilter("biztype", "=", (Object)LinkAdjustMappingEnum.CHECK_RECORD.getBizType()), new QFilter("elim.id", "in", pks)});
        if (!mappings.isEmpty()) {
            Map<Long, String> entryNumberMap = mappings.stream().collect(Collectors.toMap(k -> k.getLong("linkid"), v -> v.getString("elim.number"), (v1, v2) -> v1));
            if (entryNumberMap.size() > 0) {
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id,entryentity.id", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryNumberMap.keySet())});
                dynamicObjects.forEach(dyn -> checkIdAdjustNumberMap.putIfAbsent(dyn.getLong("id"), entryNumberMap.getOrDefault(dyn.getLong("entryentity.id"), " ")));
            }
            if (!isAudit) {
                DeleteServiceHelper.delete((String)"bcm_linkadjust_mapping", (QFilter[])new QFilter[]{new QFilter("id", "in", mappings.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()))});
            }
            AdjustmentServiceHelper.updateCheckEntryState(checkIdAdjustNumberMap, isAudit);
        }
    }

    public static void updateCheckEntryState(Map<Long, String> checkIdAdjustNumberMap, boolean isAudit) {
        if (checkIdAdjustNumberMap != null && checkIdAdjustNumberMap.size() > 0) {
            Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            Date now = TimeServiceHelper.now();
            String updateSql = isAudit ? "update t_bcm_checkrecord set fstatus = ? ,fadjustnumber = ?,fisautoelim = ?,fmodifierid =?,fmodifytime =? where fid = ?" : "update t_bcm_checkrecord set fstatus = ? ,fadjustnumber = ?,fisautoelim = ?,fdiffmode=?,fmodifierid =?,fmodifytime =? where fid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            for (Map.Entry<Long, String> entry : checkIdAdjustNumberMap.entrySet()) {
                Object[] params;
                if (isAudit) {
                    params = new Object[]{CheckStatusEnum.CONFIRMED.value, entry.getValue(), "0", userId, now, entry.getKey()};
                    paramsList.add(params);
                    continue;
                }
                params = new Object[]{CheckStatusEnum.UNCONFIRM.value, " ", ENTRYROWTYPE_CURR_DIFF, " ", userId, now, entry.getKey()};
                paramsList.add(params);
            }
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
            SaveServiceHelper.clearDataEntityCache((String)"bcm_checkrecord");
        }
    }

    public static boolean adjustNumberIsExist(Object adjustId, Object modelId, Object yearId, Object scenarioId, Object periodId, String number) {
        QFBuilder qfBuilder = new QFBuilder("id", "!=", adjustId);
        qfBuilder.and("model", "=", modelId);
        qfBuilder.and("year", "=", yearId);
        qfBuilder.and(" scenario", "=", scenarioId);
        qfBuilder.and("period", "=", periodId);
        qfBuilder.and("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"bcm_rptadjust", (QFilter[])qfBuilder.toArray());
    }

    public static boolean newAdjustNumberIsExist(Object modelId, Object yearId, Object scenarioId, Object periodId, String number) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelId);
        qfBuilder.and("year", "=", yearId);
        qfBuilder.and(" scenario", "=", scenarioId);
        qfBuilder.and("period", "=", periodId);
        qfBuilder.and("number", "=", (Object)number);
        return QueryServiceHelper.exists((String)"bcm_rptadjust", (QFilter[])qfBuilder.toArray());
    }

    public static boolean adjustNumberIsExist(AdjustModel adjustModel, String number) {
        if (null == adjustModel) {
            throw new KDBizException(ResManager.loadKDString((String)"adjustModel\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u7801\u6548\u9a8c\u3002", (String)"AdjustmentServiceHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return AdjustmentServiceHelper.adjustNumberIsExist(adjustModel.getId(), adjustModel.getModelId(), adjustModel.getYearId(), adjustModel.getScenarioId(), adjustModel.getPeriodId(), number);
    }

    public static Map<Long, Boolean> batchCheckSourceAdjust(List<DynamicObject> adjusts, RptAdjustStatusEnum status, OperationResult operationResult) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(16);
        List sourceId = adjusts.stream().map(adjust -> adjust.getLong("linkagelinksource")).collect(Collectors.toList());
        QFilter sourceAdjustQF = new QFilter("id", "in", sourceId).and("entrysource", "not in", (Object)new String[]{ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue(), ElimHeaderSourceEnum.SHARE_LINKAGE.getValue()});
        Map linkageAdjusts = BusinessDataServiceHelper.loadFromCache((String)"bcm_rptadjust", (String)"entrysource,status", (QFilter[])sourceAdjustQF.toArray());
        for (DynamicObject adjust2 : adjusts) {
            DynamicObject sourceAdjust;
            boolean isLinkageHeader = adjust2.getString("entrysource").equals(ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()) || adjust2.getString("entrysource").equals(ElimHeaderSourceEnum.SHARE_LINKAGE.getValue());
            DynamicObject dynamicObject = sourceAdjust = isLinkageHeader ? (DynamicObject)linkageAdjusts.get(adjust2.getLong("linkagelinksource")) : adjust2;
            if (!isLinkageHeader || AdjustmentServiceHelper.checkAdjustStatus(sourceAdjust, status, true)) {
                resultMap.put(adjust2.getLong("id"), Boolean.TRUE);
                continue;
            }
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u8054\u52a8\u5206\u5f55\u6240\u5c5e\u6e90\u5206\u5f55\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\u3002", (String)"AdjustmentServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]));
            operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
            operationResult.addErrorInfo(operateErrorInfo);
            operationResult.getSuccessPkIds().remove(adjust2.getLong("id"));
            resultMap.put(adjust2.getLong("id"), Boolean.FALSE);
        }
        return resultMap;
    }

    public static boolean checkAdjustStatus(DynamicObject dy, RptAdjustStatusEnum status, boolean checkSource) {
        boolean isLinkageHeader;
        if (dy == null) {
            return true;
        }
        DynamicObject adjust = dy;
        boolean bl = isLinkageHeader = dy.getString("entrysource").equals(ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()) || dy.getString("entrysource").equals(ElimHeaderSourceEnum.SHARE_LINKAGE.getValue());
        if (!(checkSource ^ isLinkageHeader)) {
            long sourceAdjustId = dy.getLong("linkagelinksource");
            adjust = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"number,name,status", (QFilter[])new QFBuilder("id", "=", (Object)sourceAdjustId).toArray());
        }
        return adjust != null && adjust.getString("status").equals(status.status());
    }

    public static QFilter getAdjustDataQFByProcess(List<String> processList, Set<String> orgSet, Set<String> mergeSet) {
        if (processList != null && processList.size() > 0) {
            Map<Boolean, List<String>> processMap = processList.stream().collect(Collectors.groupingBy(p -> OrgRelaProcessMembPool.isRelaProcess((String)p)));
            QFilter hasMerge = null;
            QFilter noMerge = null;
            if (processMap.get(Boolean.TRUE) != null && processMap.get(Boolean.TRUE).size() > 0 && mergeSet != null && mergeSet.size() > 0) {
                hasMerge = new QFilter("process.number", "in", processMap.get(Boolean.TRUE)).and(new QFilter("adjust.entity.number", "in", mergeSet).or("merge.number", "in", mergeSet));
            }
            if (processMap.get(Boolean.FALSE) != null && processMap.get(Boolean.FALSE).size() > 0 && orgSet != null && orgSet.size() > 0) {
                noMerge = new QFilter("process.number", "in", processMap.get(Boolean.FALSE)).and("entity.number", "in", orgSet);
            }
            if (hasMerge != null && noMerge != null) {
                return hasMerge.or(noMerge);
            }
            if (hasMerge != null) {
                return hasMerge;
            }
            if (noMerge != null) {
                return noMerge;
            }
        }
        return new QFilter(ENTRYROWTYPE_CURR_DIFF, "!=", (Object)1);
    }

    @Deprecated
    @SDKMark
    public static Map<Long, Set<Object>> collectAdjust(long model, long scene, long year, long period, Set<Long> orgid, QFilter otherQF) {
        return AdjustQueryServiceHelper.queryAdjustIdsGroupByBelongOrg(model, scene, year, period, orgid, otherQF == null ? null : Collections.singletonList(otherQF));
    }

    public static Set<String> collectUnAuditAdjust(long model, long scene, long year, long period, DynamicObjectCollection dyc) {
        QFBuilder statusQF = new QFBuilder("adjust.status", "!=", (Object)"3");
        HashSet<Long> orgIdSet = new HashSet<Long>(8);
        if (CollectionUtils.isNotEmpty((Collection)dyc)) {
            orgIdSet.addAll(dyc.stream().map(d -> d.getLong("memberid")).collect(Collectors.toSet()));
        }
        return AdjustQueryServiceHelper.queryAdjustExistOrgSet(model, scene, year, period, orgIdSet, statusQF.toList());
    }

    public static Long transformDimid(DynamicObject dim, String key) {
        return DynUtils.getBaseId((DynamicObject)dim, (String)key);
    }

    public static Pair<String, String> requestMutex(long dataId) {
        String mutexKey = dataId + "";
        Map<String, String> lockInfo = MutexServiceHelper.getLockInfo(mutexKey, "bcm_rptadjust", "adjustdata");
        if (lockInfo == null) {
            boolean success = MutexServiceHelper.request(mutexKey, "bcm_rptadjust", "adjustdata");
            if (success) {
                return Pair.onePair((Object)mutexKey, null);
            }
            return Pair.onePair((Object)mutexKey, (Object)ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25", (String)"AdjustmentServiceHelper_24", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!RequestContext.getOrCreate().getUserId().equals(lockInfo.get("userid"))) {
            return Pair.onePair((Object)mutexKey, (Object)String.format(ResManager.loadKDString((String)"\u5df2\u88ab%s\u9501\u5b9a\uff0c\u5982\u9700\u4fee\u6539\u8bf7\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"AdjustmentServiceHelper_25", (String)"fi-bcm-business", (Object[])new Object[0]), UserServiceHelper.getUsernameByUserid(lockInfo.get("userid"))));
        }
        return Pair.onePair((Object)mutexKey, null);
    }

    public static void batchRelease(List<String> lockKeys) {
        if (lockKeys == null || lockKeys.isEmpty()) {
            return;
        }
        MutexServiceHelper.batchRelease(lockKeys, "bcm_rptadjust", "adjustdata");
    }

    public static String toString_Adj(Throwable t) {
        if (t instanceof CvtExchangeException) {
            return t.toString().substring(CvtExchangeException.class.getName().length() + 1);
        }
        if (t instanceof KDBizException) {
            return t.getMessage();
        }
        return ThrowableHelper.toString((Throwable)t);
    }

    public static OperationResult checkAdjustByValidator(long modelId, List<Object> pkIds, Consumer<AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>>> adjConsumer) {
        AdjustValidatorExecute<List<Object>> validatorExecute = new AdjustValidatorExecute<List<Object>>(modelId);
        adjConsumer.accept(validatorExecute);
        validatorExecute.excute(pkIds);
        return validatorExecute.getValidateResult();
    }

    public static boolean isBigicmalCol(String colKey) {
        switch (colKey) {
            case "debit": 
            case "credit": 
            case "summoney": 
            case "rate": 
            case "cvtbeforedebit": 
            case "cvtbeforecredit": 
            case "cvtbeforesummoney": {
                return true;
            }
        }
        return colKey.startsWith("debit") || colKey.startsWith("credit") || colKey.startsWith("summoney") || colKey.startsWith("rate");
    }

    public static boolean hasPermClassWriteTCache(String entityName, String modelId, Long id) {
        String userId = String.valueOf(RequestContext.get().getUserId());
        return !((Set)ThreadCache.get((Object)(entityName + "_" + modelId + "&" + userId), () -> {
            HashSet set = new HashSet(16);
            ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMap(entityName, modelId, userId);
            Collection entries = map.entries();
            for (Map.Entry entrie : entries) {
                if (DataTypeEnum.WRITEIN.getIndex().equals(entrie.getKey())) continue;
                set.add(entrie.getValue());
            }
            return set;
        })).contains(id);
    }

    public static void saveContinueHistory(List<DynamicObject> adjustDyns) {
        List<DynamicObject> continueDyns = adjustDyns.stream().filter(e -> ElimRptAdjSourceTypeEnum.CONTINUE.getValue() == e.getInt("sourcetype")).collect(Collectors.toList());
        if (continueDyns.size() > 0) {
            DynamicObjectCollection continueHis = QueryServiceHelper.query((String)"bcm_adjustcontinuehis", (String)"id,adjust.id,lastadjust.id,sourceadjust.id,createtime", (QFilter[])new QFilter[]{new QFilter("adjust.id", "in", continueDyns.stream().map(e -> e.getLong("id")).collect(Collectors.toSet()))});
            Set continueHisKeySet = continueHis.stream().map(e -> e.getString("adjust.id") + e.getString("lastadjust.id")).collect(Collectors.toSet());
            DynamicObjectCollection extendContinueHis = QueryServiceHelper.query((String)"bcm_adjustcontinuehis", (String)"id,adjust.id,lastadjust.id,sourceadjust.id,createtime", (QFilter[])new QFilter[]{new QFilter("adjust.id", "in", continueDyns.stream().map(e -> e.getLong("extend")).collect(Collectors.toSet()))});
            Map<Long, DynamicObject> extendHisMap = extendContinueHis.stream().collect(Collectors.toMap(k -> k.getLong("adjust.id"), v -> v, (v1, v2) -> v1));
            ArrayList needSaveDyns = new ArrayList(continueDyns.size());
            Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            Date now = TimeServiceHelper.now();
            continueDyns.forEach(e -> {
                if (!continueHisKeySet.contains(e.getString("id") + e.getString("extend"))) {
                    DynamicObject lastHis = (DynamicObject)extendHisMap.get(e.getLong("extend"));
                    Long sourceAdjustId = 0L;
                    sourceAdjustId = lastHis != null ? Long.valueOf(lastHis.getLong("sourceadjust.id")) : Long.valueOf(e.getLong("extend"));
                    if (sourceAdjustId != 0L) {
                        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjustcontinuehis");
                        dynamicObject.set("adjust", (Object)e.getLong("id"));
                        dynamicObject.set("lastadjust", (Object)e.getLong("extend"));
                        dynamicObject.set("sourceadjust", (Object)sourceAdjustId);
                        dynamicObject.set("creator", (Object)userId);
                        dynamicObject.set("createtime", (Object)now);
                        needSaveDyns.add(dynamicObject);
                    }
                }
            });
            if (needSaveDyns.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])needSaveDyns.toArray(new DynamicObject[needSaveDyns.size()]));
            }
        }
    }

    public static int getDimensionNoPermAndRead(Long modelId, Long memberId, String dimNum) {
        if (PermissionServiceImpl.getInstance(modelId).hasNoPerm(MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum), memberId)) {
            return PermEnum.NOPERM.getValue();
        }
        if (PermissionServiceImpl.getInstance(modelId).hasReadPerm(MemberReader.getDimensionIdByNum((long)modelId, (String)dimNum), memberId)) {
            return PermEnum.READONLY.getValue();
        }
        return PermEnum.READWRITE.getValue();
    }

    public static void checkPermission(long modelId, String entityNum, String permItemId) {
        int permission = PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (long)modelId, (String)AppMetadataCache.getAppInfo((String)ApplicationTypeEnum.CM.getAppnum()).getId(), (String)entityNum, (String)permItemId);
        if (permission == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(RequestContext.get().getUserId()), String.valueOf(modelId))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6267\u884c\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBcmBaseOpServicePlugin_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static void rebuildAdjustCommembEntry(long modelId, List<DynamicObject> heads, List<DynamicObject> entries) {
        if (heads != null && !heads.isEmpty() && entries != null && !entries.isEmpty()) {
            Map dimNumDynsMap = MemberReader.getDimDyoByModelId((long)modelId);
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            Map<Long, DynamicObject> dimIdDynsMap = dimNumDynsMap.values().stream().collect(Collectors.toMap(e -> e.getLong("id"), v -> v, (v1, v2) -> v1));
            Map<Long, List<DynamicObject>> adjustDataMap = entries.stream().collect(Collectors.groupingBy(e -> DynUtils.getBaseId((String)"rebuildAdjustCommembEntry_elim", (DynamicObject)e, (String)"adjust")));
            heads.forEach(head -> {
                List adjustDatas = (List)adjustDataMap.get(head.getLong("id"));
                if (adjustDatas != null && !adjustDatas.isEmpty()) {
                    HashSet needChangeComDim = new HashSet(16);
                    DynamicObjectCollection commembentry = head.getDynamicObjectCollection("commembentry");
                    DynamicObjectCollection spreadmembentry = head.getDynamicObjectCollection("spreadmembentry");
                    commembentry.forEach(com -> {
                        Long dimId = DynUtils.getBaseId((String)"rebuildAdjustCommembEntry_commembentry", (DynamicObject)com, (String)"comdimension");
                        Long comMemId = DynUtils.getBaseId((String)"rebuildAdjustCommembEntry_commembentry", (DynamicObject)com, (String)"commembid");
                        DynamicObject dimDyn = (DynamicObject)dimIdDynsMap.get(dimId);
                        if (dimDyn != null) {
                            String dimNumber;
                            String string = dimNumber = dimDyn.getBoolean("issysdimension") ? dimDyn.getString("number") : dimDyn.getString("fieldmapped");
                            if (COMM_DIM_LINK_MAP.containsKey(dimNumber)) {
                                String comMemNum = BcmThreadCache.findNodeById((String)modelNumber, (String)dimNumber, (long)comMemId).getNumber();
                                Set ids = adjustDatas.stream().map(e -> DynUtils.getBaseId((String)"rebuildAdjustCommembEntry_entry", (DynamicObject)e, (String)COMM_DIM_LINK_MAP.get(dimNumber))).collect(Collectors.toSet());
                                Set numbers = ids.stream().map(id -> BcmThreadCache.findNodeById((String)modelNumber, (String)dimNumber, (long)id).getNumber()).collect(Collectors.toSet());
                                if (numbers.size() > 1) {
                                    needChangeComDim.add(com);
                                }
                                if (numbers.size() == 1 && !comMemNum.equals(numbers.iterator().next()) && !comMemId.equals(LongUtil.toLong((Object)SystemVarsEnum.RELATE_ENTITY.getId()))) {
                                    com.set("commembid", ids.iterator().next());
                                }
                            }
                        }
                    });
                    if (!needChangeComDim.isEmpty()) {
                        head.set("spreadjson", null);
                        head.set("data", null);
                        commembentry.removeAll(needChangeComDim);
                        commembentry.sort(Comparator.comparing(e -> e.getInt("seq")));
                        int seq = 0;
                        for (DynamicObject c : commembentry) {
                            c.set("seq", (Object)seq++);
                        }
                        int maxSeq = spreadmembentry.size();
                        OptionalInt optionalInt = spreadmembentry.stream().mapToInt(e -> e.getInt("seq")).max();
                        if (optionalInt.isPresent()) {
                            maxSeq = optionalInt.getAsInt();
                        }
                        for (DynamicObject c : needChangeComDim) {
                            DynamicObject dynaObj = spreadmembentry.addNew();
                            dynaObj.set("spreaddimension", (Object)DynUtils.getBaseId((String)"rebuildAdjustCommembEntry_commembentry", (DynamicObject)c, (String)"comdimension"));
                            dynaObj.set("spreadmembid", null);
                            dynaObj.set("seq", (Object)(++maxSeq));
                        }
                    }
                }
            });
        }
    }

    static {
        linkAdjustSource.add(ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue());
        linkAdjustSource.add(ElimHeaderSourceEnum.SHARE_LINKAGE.getValue());
        autoSource.add(EntrySourceEnum.CHECKLINKAGECREATE.getValue());
        autoSource.add(EntrySourceEnum.INVAUTOCREATE.getValue());
        autoSource.add(EntrySourceEnum.CHECKAUTOCREATE.getValue());
        autoSource.add(EntrySourceEnum.RULECREATE.getValue());
        autoSource.add(EntrySourceEnum.CHECKLINKAGECREATE.getValue());
        COMM_DIM_LINK_MAP = new HashMap<String, String>(16);
        COMM_DIM_LINK_MAP.put("AuditTrail", "audittrail");
        COMM_DIM_LINK_MAP.put("DataSort", "datasort");
        COMM_DIM_LINK_MAP.put("ChangeType", "changetype");
        COMM_DIM_LINK_MAP.put("MultiGAAP", "multigaap");
        COMM_DIM_LINK_MAP.put("InternalCompany", "internalcompany");
        COMM_DIM_LINK_MAP.put("MyCompany", "mycompany");
        COMM_DIM_LINK_MAP.put("dim1", "dim1");
        COMM_DIM_LINK_MAP.put("dim2", "dim2");
        COMM_DIM_LINK_MAP.put("dim3", "dim3");
        COMM_DIM_LINK_MAP.put("dim4", "dim4");
        COMM_DIM_LINK_MAP.put("dim5", "dim5");
        COMM_DIM_LINK_MAP.put("dim6", "dim6");
    }
}

