/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.attachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class AdjustAttachmentHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AdjustAttachmentHelper.class);
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static final String FINTERID = "fInterID";

    public static void copyAttachment(Map<Long, Long> src2tarAdjustMap) {
        if (!CollectionUtils.isEmpty(src2tarAdjustMap)) {
            Map<String, Long> attachmentAdjust2SrcMap = AdjustAttachmentHelper.convertAttachmentSrcAdjust(src2tarAdjustMap);
            try (TXHandle tx = TX.requiresNew((String)BOS_ATTACHMENT);){
                String selectFields = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)BOS_ATTACHMENT).getAllFields().keySet());
                QFilter qf = new QFilter(FINTERID, "in", attachmentAdjust2SrcMap.keySet()).and("fBillType", "=", (Object)"bcm_rptadjust");
                DynamicObject[] attachmentCols = BusinessDataServiceHelper.load((String)BOS_ATTACHMENT, (String)selectFields, (QFilter[])qf.toArray());
                if (attachmentCols != null) {
                    long gid = GlobalIdUtil.genGlobalLongId();
                    CloneUtils cloneUtils = new CloneUtils(true, true);
                    ArrayList<DynamicObject> copyList = new ArrayList<DynamicObject>(attachmentCols.length);
                    for (int i = 0; i < attachmentCols.length; ++i) {
                        DynamicObject clone = (DynamicObject)cloneUtils.clone(attachmentCols[i].getDataEntityType(), (Object)attachmentCols[i]);
                        clone.set(FINTERID, (Object)(src2tarAdjustMap.get(attachmentAdjust2SrcMap.get(attachmentCols[i].getString(FINTERID))) + ""));
                        clone.set("fnumber", (Object)String.format("rc-upload-copy-%s-%s", gid, i));
                        copyList.add(clone);
                    }
                    SaveServiceHelper.save((DynamicObject[])copyList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void moveAttachment(Set<String> srcElimIds, String tarElimId) {
        if (!CollectionUtils.isEmpty(srcElimIds)) {
            PlatUtil.executeWithTX(tx -> {
                QFilter qf = new QFilter(FINTERID, "in", (Object)srcElimIds).and("fBillType", "=", (Object)"bcm_rptadjust");
                String selectFields = String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)BOS_ATTACHMENT).getAllFields().keySet());
                DynamicObject[] attachmentCols = BusinessDataServiceHelper.load((String)BOS_ATTACHMENT, (String)selectFields, (QFilter[])qf.toArray());
                if (attachmentCols != null) {
                    Arrays.stream(attachmentCols).forEach(attachment -> attachment.set(FINTERID, (Object)tarElimId));
                    SaveServiceHelper.save((DynamicObject[])attachmentCols);
                }
            });
        }
    }

    private static Map<String, Long> convertAttachmentSrcAdjust(Map<Long, Long> src2tarAdjustMap) {
        Map<Long, Long> attachmentSrcAdjust = AdjustAttachmentHelper.getAttachmentSrcAdjust(src2tarAdjustMap.keySet());
        HashMap<String, Long> attachmentTarAdjust = new HashMap<String, Long>(attachmentSrcAdjust.size());
        attachmentSrcAdjust.forEach((k, v) -> attachmentTarAdjust.put(v.toString(), (Long)k));
        return attachmentTarAdjust;
    }

    public static Map<Long, Long> getAttachmentSrcAdjust(Collection<Long> adjustIds) {
        HashMap<Long, Long> resMap = new HashMap<Long, Long>(16);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"id,shareentry.shareadjust,linkagelinksource,entrysource", (QFilter[])new QFilter[]{new QFilter("id", "in", adjustIds)});
        if (dys != null) {
            HashMap<Long, Long> sharAdjustIds = new HashMap<Long, Long>(10);
            for (DynamicObject dy : dys) {
                long adjustId = dy.getLong("id");
                String entrySource = dy.getString("entrysource");
                if (ElimHeaderSourceEnum.SHARE.getValue().equals(entrySource) || ElimHeaderSourceEnum.SHARE_LINKAGE.getValue().equals(entrySource)) {
                    adjustId = ((DynamicObject)dy.getDynamicObjectCollection("shareentry").get(0)).getLong("shareadjust.id");
                    sharAdjustIds.put(adjustId, dy.getLong("id"));
                } else if (ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue().equals(entrySource)) {
                    adjustId = dy.getLong("linkagelinksource");
                }
                resMap.put(dy.getLong("id"), adjustId);
            }
            if (!CollectionUtils.isEmpty(sharAdjustIds)) {
                Map<Long, Long> temp = AdjustAttachmentHelper.getAttachmentSrcAdjust(sharAdjustIds.keySet());
                temp.forEach((sharAdjust, srcAdjust) -> resMap.put((Long)sharAdjustIds.get(sharAdjust), (Long)srcAdjust));
            }
        }
        return resMap;
    }

    public static void clearAttachment(Collection<Long> adjustIds) {
        try (TXHandle tx = TX.requiresNew((String)BOS_ATTACHMENT);){
            if (!CollectionUtils.isEmpty(adjustIds)) {
                QFilter qf = new QFilter(FINTERID, "in", adjustIds.stream().map(Object::toString).collect(Collectors.toList())).and("fBillType", "=", (Object)"bcm_rptadjust");
                DeleteServiceHelper.delete((String)BOS_ATTACHMENT, (QFilter[])qf.toArray());
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

