/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.model.AdjustBalanceCheckModel;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.BalanceTypeEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Sheet;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustBalanceCheckService {
    private long modelId;
    private String modelNum;
    private BigDecimal configBalance;
    private List<Dimension> useBalanceDims;
    private boolean isDebug = WatchLoggerUtil.isDebug();

    public AdjustBalanceCheckService(long modelId) {
        this.modelId = modelId;
        this.modelNum = MemberReader.findModelNumberById((Object)modelId);
        this.configBalance = ConfigServiceHelper.getAdjustBalance(modelId);
    }

    private List<Dimension> getUseBalanceDims() {
        if (this.useBalanceDims == null) {
            this.useBalanceDims = AdjustOperationHelper.getUseBalanceDims(this.modelId);
        }
        return this.useBalanceDims;
    }

    private boolean isCalcCurrentRow(boolean isMuiltCurrency, Map<String, Integer> indexmap, Sheet effectiveSheet, int rowIndex) {
        Cell entrySourceCell = effectiveSheet.getCell(rowIndex, indexmap.get("entrysource").intValue());
        if (EntrySourceEnum.getLinkList().contains(entrySourceCell.getValue())) {
            return false;
        }
        if (isMuiltCurrency) {
            if (!indexmap.containsKey("entryrowtype")) {
                return true;
            }
            int entryRowTypeColIndex = indexmap.get("entryrowtype");
            Cell cell = effectiveSheet.getCell(rowIndex, entryRowTypeColIndex);
            int rowTypeCol = cell.getValue() == null ? 0 : Integer.parseInt(StringUtils.isEmpty((String)cell.getValue().toString()) ? "0" : cell.getValue().toString());
            return !AdjustConvertUtil.getDiffTest().test(rowTypeCol);
        }
        return true;
    }

    public static Map<String, Integer> createOrGetIndexMap(Sheet effectiveSheet) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < effectiveSheet.getMaxColumnCount(); ++i) {
            Cell cell = effectiveSheet.getCell(0, i);
            if (cell == null || cell.getUserObject("entitysign") == null) continue;
            String sign = (String)cell.getUserObject("entitysign");
            if (StringUtils.isNotEmpty((String)sign) && sign.startsWith("bcm_") && !"bcm_mergenode".equals(sign)) {
                indexMap.put(cell.getDimension(0).getNumber(), i);
                continue;
            }
            indexMap.put(sign, i);
        }
        return indexMap;
    }

    public Map<String, AdjustBalanceCheckModel> checkAdjustBalance(boolean isMuiltCurrency, AdjustModel adjustModel, Sheet effectiveSheet, List<Integer> effectRow) {
        return this.checkAdjustBalance(isMuiltCurrency, adjustModel.getBalancetype(), adjustModel, effectiveSheet, effectRow);
    }

    public Map<String, AdjustBalanceCheckModel> checkAdjustBalance(boolean isMuiltCurrency, int balanceType, AdjustModel adjustModel, Sheet effectiveSheet, List<Integer> effectRow) {
        if (BalanceTypeEnum.UNBALANCE.getIndex() == balanceType) {
            return Collections.emptyMap();
        }
        Map<String, Integer> orGetIndexMap = AdjustBalanceCheckService.createOrGetIndexMap(effectiveSheet);
        HashMap<String, Integer> dimNumIndexs = new HashMap<String, Integer>(this.getUseBalanceDims().size());
        int balanceDiff = 0;
        StringBuilder comformulaMsg = new StringBuilder();
        boolean dimCheck = true;
        for (Dimension dim : this.getUseBalanceDims()) {
            IDNumberTreeNode node;
            Integer col = orGetIndexMap.get(dim.getNumber());
            if (col != null) {
                dimNumIndexs.put(dim.getNumber(), col);
                continue;
            }
            CommDimensionEntry comdim = adjustModel.getCommDimensionEntries().stream().filter(com -> com.getDimension().getId() == dim.getId().longValue()).findFirst().orElseGet(() -> null);
            if (comdim != null && comdim.getMember() != null && (node = MemberReader.findMemberById((String)this.modelNum, (String)dim.getEntity(), (Long)comdim.getMember().getId())) != IDNumberTreeNode.NotFoundTreeNode) {
                if (!this.isSetDimBalanceRedirect(node)) continue;
                balanceDiff ^= 0xFFFFFFFF;
                if (!this.isDebug) continue;
                comformulaMsg.append("[").append(node.getDimNumber()).append("@").append(node.getNumber()).append("=-1]*");
                continue;
            }
            dimCheck = false;
        }
        boolean isBalance = BalanceTypeEnum.BALANCE.getIndex() == balanceType;
        Integer groupBalanceIndex = orGetIndexMap.get(isBalance ? "groupnum" : "Entity");
        Integer creditIndex = orGetIndexMap.get(isMuiltCurrency ? "cvtbeforecredit" : "credit");
        Integer debitIndex = orGetIndexMap.get(isMuiltCurrency ? "cvtbeforedebit" : "debit");
        HashMap<String, AdjustBalanceCheckModel> groupRowsMap = new HashMap<String, AdjustBalanceCheckModel>(16);
        ArrayList<String> collectDimMsgs = new ArrayList<String>(10);
        if (CollectionUtils.isNotEmpty(effectRow)) {
            for (Integer rowIndex : effectRow) {
                Cell groupCell = effectiveSheet.getCell(rowIndex.intValue(), groupBalanceIndex.intValue());
                String groupkey = groupCell.getValue() == null ? "" : (isBalance ? groupCell.getValue().toString() : (String)groupCell.getUserObject("membnumber"));
                AdjustBalanceCheckModel adjustBalanceResult = (AdjustBalanceCheckModel)groupRowsMap.get(groupkey);
                if (adjustBalanceResult == null) {
                    adjustBalanceResult = new AdjustBalanceCheckModel(groupkey);
                    adjustBalanceResult.setDefualtBalance(dimCheck);
                    groupRowsMap.put(groupkey, adjustBalanceResult);
                }
                if (this.isDebug && StringUtils.isNotEmpty((String)comformulaMsg.toString())) {
                    collectDimMsgs.add(comformulaMsg.substring(0, comformulaMsg.length() - 1));
                }
                if (this.isCalcCurrentRow(isMuiltCurrency, orGetIndexMap, effectiveSheet, rowIndex)) {
                    Cell debitCell = effectiveSheet.getCell(rowIndex.intValue(), debitIndex.intValue());
                    BigDecimal debtor = debitCell.getValue() instanceof BigDecimal ? (BigDecimal)debitCell.getValue() : BigDecimal.ZERO;
                    Cell creditCell = effectiveSheet.getCell(rowIndex.intValue(), creditIndex.intValue());
                    BigDecimal lender = creditCell.getValue() instanceof BigDecimal ? (BigDecimal)creditCell.getValue() : BigDecimal.ZERO;
                    int balanceVal = balanceDiff;
                    for (Map.Entry dim : dimNumIndexs.entrySet()) {
                        IDNumberTreeNode node;
                        String number;
                        Cell nodeCell = effectiveSheet.getCell(rowIndex.intValue(), ((Integer)dim.getValue()).intValue());
                        String string = number = nodeCell != null ? (String)nodeCell.getUserObject("membnumber") : null;
                        if (StringUtils.isNotEmpty((String)number) && (node = MemberReader.findMemberByNumber((String)this.modelNum, (String)((String)dim.getKey()), (String)number)) != IDNumberTreeNode.NotFoundTreeNode) {
                            if (!this.isSetDimBalanceRedirect(node)) continue;
                            balanceVal ^= 0xFFFFFFFF;
                            if (!this.isDebug) continue;
                            collectDimMsgs.add("[" + node.getDimNumber() + "@" + node.getNumber() + "=-1]");
                            continue;
                        }
                        adjustBalanceResult.setDefualtBalance(false);
                        break;
                    }
                    if (this.isDebug) {
                        String join = String.join((CharSequence)"*", collectDimMsgs);
                        if (StringUtils.isNotEmpty((String)join)) {
                            join = join + "*";
                        }
                        if (debtor != null && !debtor.equals(BigDecimal.ZERO)) {
                            adjustBalanceResult.addDebitFormula(join + debtor.stripTrailingZeros().toPlainString());
                        }
                        if (lender != null && !lender.equals(BigDecimal.ZERO)) {
                            adjustBalanceResult.addCreditFormula(join + lender.stripTrailingZeros().toPlainString());
                        }
                        collectDimMsgs.clear();
                    }
                    if (balanceVal == -1) {
                        debtor = this.negate(debtor);
                        lender = this.negate(lender);
                    }
                    adjustBalanceResult.setDebitSum(debtor);
                    adjustBalanceResult.setCreditSum(lender);
                }
                adjustBalanceResult.getRows().add(rowIndex);
            }
        }
        return groupRowsMap;
    }

    private BigDecimal negate(BigDecimal v) {
        if (v != null && v != BigDecimal.ZERO) {
            v = v.negate();
        }
        return v;
    }

    private boolean isSetDimBalanceRedirect(IDNumberTreeNode node) {
        Boolean baldirection = (Boolean)node.getProperty("baldirection");
        if (baldirection != null && baldirection.booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Map<String, AdjustBalanceCheckModel> checkAdjustBalance(DynamicObject adjust, Collection<DynamicObject> adjustDatas) {
        boolean isMuiltCurrency = adjust.getBoolean("multiplecurrency") || DynUtils.getBaseId((DynamicObject)adjust, (String)"cvtbeforecurrency") != 0L;
        BalanceTypeEnum balanceType = BalanceTypeEnum.getEnumByIndex((int)adjust.getInt("balancetype"));
        return this.checkAdjustBalance(isMuiltCurrency, balanceType, adjustDatas);
    }

    private Map<String, AdjustBalanceCheckModel> checkAdjustBalance(boolean isMuiltCurrency, BalanceTypeEnum balanceTypeEnum, Collection<DynamicObject> adjustDatas) {
        if (BalanceTypeEnum.UNBALANCE == balanceTypeEnum) {
            return Collections.emptyMap();
        }
        boolean isBalance = BalanceTypeEnum.BALANCE == balanceTypeEnum;
        String creditIndex = isMuiltCurrency ? "cvtbeforecredit" : "credit";
        String debitIndex = isMuiltCurrency ? "cvtbeforedebit" : "debit";
        HashMap<String, AdjustBalanceCheckModel> groupRowsMap = new HashMap<String, AdjustBalanceCheckModel>(16);
        ArrayList<String> collectDimMsgs = new ArrayList<String>(10);
        for (DynamicObject adjustData : adjustDatas) {
            String groupkey;
            if (!adjustData.getBoolean("isdefaultcurrency") || AdjustConvertUtil.getDiffTest().test(adjustData.getInt("entryrowtype")) || EntrySourceEnum.getLinkList().contains(adjustData.getInt("entrysource"))) continue;
            if (isBalance) {
                groupkey = adjustData.getString("groupnum");
            } else {
                Long entity = DynUtils.getBaseId((DynamicObject)adjustData, (String)"entity");
                groupkey = MemberReader.findEntityMemberById((Long)this.modelId, (Long)entity).getNumber();
            }
            AdjustBalanceCheckModel adjustBalanceResult = groupRowsMap.computeIfAbsent(StringUtils.isEmpty((String)groupkey) ? "" : groupkey, k -> new AdjustBalanceCheckModel((String)k));
            BigDecimal debtor = adjustData.getBigDecimal(debitIndex);
            BigDecimal lender = adjustData.getBigDecimal(creditIndex);
            int balanceVal = 0;
            for (Dimension dim : this.getUseBalanceDims()) {
                Long baseId = DynUtils.getBaseId((DynamicObject)adjustData, (String)dim.getFieldmapped());
                IDNumberTreeNode node = MemberReader.findMemberById((String)this.modelNum, (String)dim.getEntity(), (Long)baseId);
                if (node == IDNumberTreeNode.NotFoundTreeNode) {
                    adjustBalanceResult.setDefualtBalance(false);
                    break;
                }
                if (!this.isSetDimBalanceRedirect(node)) continue;
                balanceVal ^= 0xFFFFFFFF;
                if (!this.isDebug) continue;
                collectDimMsgs.add("[" + node.getDimNumber() + "@" + node.getNumber() + "=-1]");
            }
            if (this.isDebug) {
                String join = String.join((CharSequence)"*", collectDimMsgs);
                if (StringUtils.isNotEmpty((String)join)) {
                    join = join + "*";
                }
                if (debtor != null && debtor.compareTo(BigDecimal.ZERO) != 0) {
                    adjustBalanceResult.addDebitFormula(join + debtor.stripTrailingZeros().toPlainString());
                }
                if (lender != null && lender.compareTo(BigDecimal.ZERO) != 0) {
                    adjustBalanceResult.addCreditFormula(join + lender.stripTrailingZeros().toPlainString());
                }
                collectDimMsgs.clear();
            }
            if (balanceVal == -1) {
                debtor = this.negate(debtor);
                lender = this.negate(lender);
            }
            adjustBalanceResult.setDebitSum(debtor);
            adjustBalanceResult.setCreditSum(lender);
            adjustBalanceResult.getRows().add(adjustData);
        }
        return groupRowsMap;
    }

    private boolean getAdjustDataRowRedirectIsNegate(DynamicObject adjustData) {
        int balanceVal = 0;
        for (Dimension dim : this.getUseBalanceDims()) {
            Long baseId = DynUtils.getBaseId((DynamicObject)adjustData, (String)dim.getFieldmapped());
            IDNumberTreeNode node = MemberReader.findMemberById((String)this.modelNum, (String)dim.getEntity(), (Long)baseId);
            if (node == IDNumberTreeNode.NotFoundTreeNode) {
                return false;
            }
            if (!this.isSetDimBalanceRedirect(node)) continue;
            balanceVal ^= 0xFFFFFFFF;
        }
        return balanceVal == -1;
    }

    public void resetAdjustDataMoneyRedirect(boolean isMultiplecurrency, DynamicObject adjustData) {
        if (this.getAdjustDataRowRedirectIsNegate(adjustData)) {
            if (isMultiplecurrency) {
                adjustData.set("cvtbeforedebit", (Object)this.negate(adjustData.getBigDecimal("cvtbeforedebit")));
                adjustData.set("cvtbeforecredit", (Object)this.negate(adjustData.getBigDecimal("cvtbeforecredit")));
                adjustData.set("cvtbeforesummoney", (Object)this.negate(adjustData.getBigDecimal("cvtbeforesummoney")));
            } else {
                adjustData.set("debit", (Object)this.negate(adjustData.getBigDecimal("debit")));
                adjustData.set("credit", (Object)this.negate(adjustData.getBigDecimal("credit")));
                adjustData.set("summoney", (Object)this.negate(adjustData.getBigDecimal("summoney")));
            }
        }
    }

    public void resetAdjustDataMoneyRedirect(DynamicObject adjustData) {
        this.resetAdjustDataMoneyRedirect(false, adjustData);
    }

    public List<String> getNonBalanceDataWithInfo(BalanceTypeEnum balanceTypeEnum, Map<String, AdjustBalanceCheckModel> map) {
        ArrayList<String> list = new ArrayList<String>(10);
        String groupName = balanceTypeEnum == BalanceTypeEnum.BALANCEWITHORG ? ResManager.loadKDString((String)"\u7ec4\u7ec7\u5206\u7ec4", (String)"AdjustBalanceCheckService_1", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u7ec4\u53f7", (String)"AdjustBalanceCheckService_2", (String)"fi-bcm-business", (Object[])new Object[0]);
        String msg = ResManager.loadKDString((String)"%1$s %2$s\uff0c\u501f\u65b9\u91d1\u989d%3$s\uff0c\u8d37\u65b9\u91d1\u989d%4$s\uff0c\u501f\u8d37\u5dee\u989d%5$s\uff0c\u4e0d\u5e73\u8861\u6821\u9a8c\u8bf7\u68c0\u67e5\uff1b", (String)"AdjustBalanceCheckService_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        map.forEach((k, v) -> {
            if (!v.isDataBalance(this.configBalance)) {
                String msgFormat;
                String groupKey = v.getGroupKey();
                if (v.isDefualtBalance()) {
                    String debitSum = v.getDebitSum().stripTrailingZeros().toPlainString();
                    String creditSum = v.getCreditSum().stripTrailingZeros().toPlainString();
                    String debitSubCreditAbsSum = v.getDebitSubCreditWithAbs();
                    msgFormat = String.format(msg, groupName, groupKey, debitSum, creditSum, debitSubCreditAbsSum);
                } else {
                    msgFormat = String.format(ResManager.loadKDString((String)"%1$s %2$s\u53d8\u52a8\u7c7b\u578b\u548c\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u4e0d\u5b8c\u6574\uff0c\u4e0d\u5e73\u8861\u6821\u9a8c\u8bf7\u68c0\u67e5\uff1b", (String)"AdjustBalanceCheckService_4", (String)"fi-bcm-business", (Object[])new Object[0]), groupName, groupKey);
                }
                list.add(msgFormat + v.getComputeFormula());
            }
        });
        return list;
    }

    public BigDecimal getConfigBalance() {
        return this.configBalance;
    }

    public boolean isBalance(DynamicObject adjust, Collection<DynamicObject> adjustDatas) {
        Collection<AdjustBalanceCheckModel> values = this.checkAdjustBalance(adjust, adjustDatas).values();
        return values.isEmpty() || values.stream().allMatch(e -> e.isDataBalance(this.configBalance));
    }

    public void computeIfNoBalance(DynamicObject adjust, Collection<DynamicObject> adjustDatas, Consumer<AdjustBalanceCheckModel> consumer) {
        BalanceTypeEnum balanceType = BalanceTypeEnum.getEnumByIndex((int)adjust.getInt("balancetype"));
        this.computeIfNoBalance(balanceType, adjust, adjustDatas, consumer);
    }

    public boolean computeIfNoBalance(BalanceTypeEnum balanceType, DynamicObject adjust, Collection<DynamicObject> adjustDatas, Consumer<AdjustBalanceCheckModel> consumer) {
        boolean isMuiltCurrency = adjust.getBoolean("multiplecurrency") || DynUtils.getBaseId((DynamicObject)adjust, (String)"cvtbeforecurrency") != 0L;
        Map<String, AdjustBalanceCheckModel> adjustBalanceCheckModelMap = this.checkAdjustBalance(isMuiltCurrency, balanceType, adjustDatas);
        boolean isNoBalance = false;
        for (Map.Entry<String, AdjustBalanceCheckModel> entry : adjustBalanceCheckModelMap.entrySet()) {
            if (entry.getValue().isDataBalance(this.configBalance)) continue;
            isNoBalance = true;
            consumer.accept(entry.getValue());
        }
        return isNoBalance;
    }
}

