/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.check;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckContext;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.trace.impl.AdjustDimOperationTraceLogImpl;
import kd.fi.bcm.business.formula.calculate.adjust.GetJLEntryCalculate;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.business.util.WatchLoggerUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperationStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public class AdjustCheckServiceHelper {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustCheckServiceHelper.class);
    private static final List<String> DEFAULT_DIMS_SET = Collections.unmodifiableList(Arrays.asList(PresetConstant.SCENE_DIM, PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, "olaporg", PresetConstant.PROCESS_DIM, PresetConstant.CURRENCY_DIM));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSysToMddSameProcess(long model, long scene, long year, long period, Collection<Long> elimids, boolean isAudit) {
        block18: {
            String processId = (String)ThreadCache.get((Object)"cache_node_prefix");
            if (StringUtils.isEmpty((String)processId)) {
                AdjustCheckServiceHelper.doSysToMdd(model, scene, year, period, elimids, isAudit, null);
            } else {
                try (DLock dl = DLock.create((String)processId);){
                    if (dl.tryLock(120000L)) {
                        try {
                            AdjustCheckServiceHelper.doSysToMdd(model, scene, year, period, elimids, isAudit, null);
                            break block18;
                        }
                        finally {
                            dl.unlock();
                        }
                    }
                    AdjustCheckServiceHelper.doSysToMdd(model, scene, year, period, elimids, isAudit, null);
                }
            }
        }
    }

    public static void doSysToMdd(long model, long scene, long year, long period, Collection<Long> elimids, boolean isAudit) {
        AdjustCheckServiceHelper.doSysToMdd(model, scene, year, period, elimids, isAudit, null);
    }

    public static void doSysToMddWithTraceLog(String specialKey, Map<String, Set<String>> adjGroupNums, long model, long scene, long year, long period, Collection<Long> elimids, boolean isAudit) {
        AdjustCheckServiceHelper.doSysToMdd(model, scene, year, period, elimids, isAudit, null);
        if (isAudit && !CollectionUtils.isEmpty(adjGroupNums)) {
            AdjustDimOperationTraceLogImpl traceLog = new AdjustDimOperationTraceLogImpl();
            traceLog.setModelId(model);
            traceLog.setSceneId(scene);
            traceLog.setYearId(year);
            traceLog.setPeriodId(period);
            traceLog.setOperTypeEnum(AdjustOperTypeEnum.CREATEAUTOOPERATION);
            traceLog.setSpecialSourceKey(specialKey);
            adjGroupNums.forEach((num, groups) -> traceLog.addTag(String.format(ResManager.loadKDString((String)"\u65b0\u589e\u8c03\u6574\u62b5\u9500\u5206\u5f55\u6570\u636e\uff1a\u7f16\u7801[%1$s]-\u5206\u7ec4\u53f7[%2$s]", (String)"AdjustCheckServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]), num, String.join((CharSequence)",", groups)), () -> null));
            traceLog.publish();
        }
    }

    public static void doSysToMdd(long model, long scene, long year, long period, Collection<Long> elimids, boolean isAudit, AdjRecordLog adjLog) {
        AdjustCheckContext ctx = new AdjustCheckContext();
        if (adjLog != null) {
            ctx.setAdjRecordLog(adjLog);
        }
        ctx.setModel((Pair<Long, String>)Pair.onePair((Object)model, (Object)MemberReader.findModelNumberById((Object)model)));
        ctx.setYear(year);
        ctx.setScene(scene);
        ctx.setPeriod(period);
        ctx.setAudit(isAudit);
        if (elimids != null && !elimids.isEmpty()) {
            ctx.getPks().addAll(Sets.newHashSet(elimids));
            AdjustCheckServiceHelper.doSysToMdd(ctx);
        }
    }

    public static void doBackToMddByDetailIds(long model, long scene, long year, long period, Collection<Long> elimDetailids, AdjRecordLog adjLog) {
        AdjustCheckContext ctx = new AdjustCheckContext();
        if (adjLog != null) {
            ctx.setAdjRecordLog(adjLog);
        }
        ctx.setModel((Pair<Long, String>)Pair.onePair((Object)model, (Object)MemberReader.findModelNumberById((Object)model)));
        ctx.setYear(year);
        ctx.setScene(scene);
        ctx.setPeriod(period);
        ctx.setAudit(false);
        if (elimDetailids != null && !elimDetailids.isEmpty()) {
            ctx.getDetailPks().addAll(Sets.newHashSet(elimDetailids));
            AdjustCheckServiceHelper.doSysToMdd(ctx);
        }
    }

    private static void doSysToMdd(AdjustCheckContext ctx) {
        try {
            LOG.startWatch();
            AdjustCheckServiceHelper.recomputeForAICombine(ctx);
            ctx.getAdjRecordLog().setSuccessConut(ctx.getPks().isEmpty() ? ctx.getDetailPks().size() : ctx.getPks().size());
        }
        finally {
            LOG.infoEnd(ResManager.loadKDString((String)"\u91cd\u7b97\u7ed3\u675f", (String)"AdjustCheckServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static void updateOlapOrgNumUpStatus(long model, long scene, long year, long period) {
        HashMap olapOrgUpMap = new HashMap();
        HashMap adjHead2MergeMap = new HashMap();
        QFBuilder qf = new QFBuilder("model", "=", (Object)model);
        qf.add("scenario", "=", (Object)scene);
        qf.add("year", "=", (Object)year);
        qf.add("period", "=", (Object)period);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"updateOlapOrgNumUpStatus", (String)"bcm_rptadjustdata", (String)"adjust.entity.id,merge.id,id,process.number as Process,adjust.entity.number as oldmergeNum,merge.number as mergeNum,entity.longnumber,entity.number,olaporg", (QFilter[])qf.toArray(), null, (int)-1);){
            ds.forEachRemaining(entry -> {
                long mergeId;
                String olaporg = entry.getString("olaporg");
                if (StringUtils.isEmpty((String)olaporg)) {
                    String olapOrg;
                    String string = olapOrg = OrgRelaProcessMembPool.isRelaProcess((String)entry.getString("Process")) ? AdjustCheckServiceHelper.getParentDirectChild(entry.getString("oldmergeNum"), entry.getString("entity.longnumber")) : entry.getString("entity.number");
                    if (StringUtils.isNotEmpty((String)olapOrg)) {
                        olapOrgUpMap.put(entry.getLong("id"), olapOrg);
                    }
                }
                if ((mergeId = entry.getLong("merge.id").longValue()) == 0L) {
                    adjHead2MergeMap.put(entry.getLong("id"), entry.getLong("adjust.entity.id"));
                }
            });
        }
        PlatUtil.executeWithTX(tx -> {
            AdjustCheckServiceHelper.updateEntriesOlapOrg(olapOrgUpMap);
            AdjustCheckServiceHelper.updateEntriesMergeId(adjHead2MergeMap);
        });
    }

    public static void updateEntriesMergeId(Map<Long, Long> adjHead2MergeMap) {
        if (adjHead2MergeMap == null || adjHead2MergeMap.isEmpty()) {
            return;
        }
        String sql = "update t_bcm_rptadjustdata set fmergeid = ? where fid = ?";
        ArrayList paramsList = new ArrayList();
        adjHead2MergeMap.forEach((id, mergeid) -> {
            Object[] param = new Object[]{mergeid, id};
            paramsList.add(param);
            if (paramsList.size() == 1000) {
                DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, (List)paramsList);
                paramsList.clear();
            }
        });
        if (!paramsList.isEmpty()) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
        adjHead2MergeMap.clear();
    }

    public static void updateEntriesOlapOrg(Map<Long, String> toUpdateData) {
        if (toUpdateData == null || toUpdateData.isEmpty()) {
            return;
        }
        String sql = "update t_bcm_rptadjustdata set folaporg = ? where fid = ?";
        ArrayList paramsList = new ArrayList();
        toUpdateData.forEach((id, olaporgNum) -> {
            Object[] param = new Object[]{olaporgNum, id};
            paramsList.add(param);
            if (paramsList.size() == 1000) {
                DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, (List)paramsList);
                paramsList.clear();
            }
        });
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
        toUpdateData.clear();
    }

    public static boolean recomputeForAICombine(AdjustCheckContext ctx) {
        try {
            ctx.getAdjRecordLog().setStatus(AdjustOperationStatusEnum.RECOMPUTEDATASTATUS.getStatus());
            ctx.getTraceLog().setModelId((Long)ctx.getModel().p1);
            ctx.getTraceLog().setSceneId(ctx.getScene());
            ctx.getTraceLog().setYearId(ctx.getYear());
            ctx.getTraceLog().setPeriodId(ctx.getPeriod());
            ctx.getTraceLog().setDimKeys(Arrays.asList(ctx.getDimKeys()));
            ctx.getTraceLog().setOperTypeEnum(ctx.isAudit() ? AdjustOperTypeEnum.AUDITOPERATION : AdjustOperTypeEnum.BACKOPERATION);
            PlatUtil.executeWithTX(tx -> {
                Map<String, Collection<String>> dimScope = AdjustCheckServiceHelper.collectDimenScope(ctx);
                AdjustCheckServiceHelper.lockDimCombine(ctx);
                AdjustCheckServiceHelper.updateAdjustStatus(ctx);
                AdjustCheckServiceHelper.recomputeAuditData(ctx, dimScope, new String[]{RptAdjustStatusEnum.AUDIT.status()});
            });
            ctx.getAdjRecordLog().setSuccessConut(ctx.getPks().isEmpty() ? ctx.getDetailPks().size() : ctx.getPks().size());
            SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
            SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjustdata");
        }
        catch (KDBizException e) {
            ctx.getAdjRecordLog().setSuccessConut(0);
            if (ThreadCache.get((Object)"ignoreLock") == null || ThreadCache.get((Object)"isLockException") == null) {
                ThreadCache.remove((Object)"isLockException");
                throw e;
            }
            LOG.info("bizRule data lock ignore");
        }
        catch (Throwable e) {
            ctx.getAdjRecordLog().setSuccessConut(0);
            LOG.error("recompute error : ", e);
            throw new KDBizException(String.format("recompute error : %s", e.getMessage()));
        }
        finally {
            AdjustCheckServiceHelper.unlockDimCombine(ctx);
        }
        return true;
    }

    public static void recomputeAuditData(AdjustCheckContext ctx, Map<String, Collection<String>> dimenScope, String[] tarStatus) {
        if (!ctx.isNoCheckDimCombineSet() && ctx.getDimCombineSet().isEmpty()) {
            return;
        }
        try (DataSet reComputeDs = AdjustCheckServiceHelper.queryRecomputeData(ctx, dimenScope, tarStatus);){
            try {
                String[] dimKeys = ctx.getDimKeys();
                CellSet cellSets = new CellSet(ctx.getDimKeys(), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                cellSets.setFromQuery(false);
                ArrayList members = new ArrayList();
                reComputeDs.forEachRemaining(entry -> {
                    for (String dimKey : dimKeys) {
                        members.add(entry.getString(dimKey));
                    }
                    if (ctx.getDimCombineSet().remove(String.join((CharSequence)"@", members)) || ctx.isNoCheckDimCombineSet()) {
                        BigDecimal money = entry.getBigDecimal("balance").setScale(14, RoundingMode.HALF_DOWN);
                        if (!OlapServiceHelper.isSandBoxCube((String)ctx.getModel().p2)) {
                            ctx.getTraceLog().addTag(String.join((CharSequence)"|", members), () -> money);
                        }
                        cellSets.set(members.toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), (Object)money);
                    }
                    members.clear();
                });
                ctx.getDimCombineSet().forEach(lockKey -> {
                    cellSets.set(lockKey.split("@"), FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
                    if (!OlapServiceHelper.isSandBoxCube((String)ctx.getModel().p2)) {
                        ctx.getTraceLog().addTag(lockKey.replace("@", "|"), () -> null);
                    }
                });
                SaveCommandInfo info = new SaveCommandInfo();
                info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                info.setDimensions(dimKeys);
                AdjustCheckServiceHelper.batchCreateDimensionMembers(ctx, cellSets);
                OlapCommandUtil.addSourceMeasure((String)((String)ctx.getModel().p2), (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.J1);
                if (!OlapServiceHelper.isSandBoxCube((String)ctx.getModel().p2)) {
                    OperationContext context = OperationContext.get();
                    if (context != null) {
                        context.setFormId("bcm_rptadjust_list");
                    }
                    OlapTraceServiceHelper.setTraceOpInfo((String)(ctx.isAudit() ? ResManager.loadKDString((String)"(\u5ba1\u6838)", (String)"AdjustCheckServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"(\u6253\u56de)", (String)"AdjustCheckServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0])));
                }
                OlapServiceHelper.saveData(info, cellSets, (String)ctx.getModel().p2, true, false);
                ctx.getTraceLog().publish();
            }
            catch (Throwable t) {
                String errorMsg = ResManager.loadKDString((String)"\u5206\u5f55\u91cd\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (String)"AdjustCheckServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]);
                LOG.error(errorMsg, t);
                throw new KDBizException(errorMsg + ThrowableHelper.toString((Throwable)t));
            }
        }
    }

    private static void batchCreateDimensionMembers(AdjustCheckContext ctx, CellSet cellSets) {
        if (OlapServiceHelper.isSandBoxCube((String)ctx.getModel().p2) && GetJLEntryCalculate.isFromGetJLEntryCalculate()) {
            HashMap<String, Integer> dimKey2Index = new HashMap<String, Integer>(16);
            int i = 0;
            for (String dimKey : ctx.getDimKeys()) {
                dimKey2Index.put(dimKey, i++);
            }
            HashSet olapOrgSet = new HashSet(30);
            cellSets.getMutableMetricEntries(FacTabFieldDefEnum.FIELD_MONEY.getField()).forEachRemaining(vp -> olapOrgSet.add(((MembersKey)vp.getFirst()).getKey(((Integer)dimKey2Index.get("Entity")).intValue())));
            OlapServiceHelper.batchCreateDimensionMembers((String)ctx.getModel().p2, "Entity", olapOrgSet.toArray(new String[olapOrgSet.size()]));
        }
    }

    private static DataSet queryRecomputeData(AdjustCheckContext ctx, Map<String, Collection<String>> dimenScope, String[] tarStatus) {
        QFBuilder qf = new QFBuilder("model", "=", ctx.getModel().p1);
        DEFAULT_DIMS_SET.forEach(dim -> {
            Collection v = (Collection)dimenScope.remove(dim);
            if (v != null) {
                if ("olaporg".equals(dim)) {
                    qf.add(dim, "in", (Object)v);
                } else {
                    qf.add(dim, "in", AdjustCheckServiceHelper.transfNum2Ids((String)ctx.getModel().p2, dim, new HashSet<String>(v)));
                }
            }
        });
        dimenScope.forEach((k, v) -> qf.add(ctx.getSctx().getDimensionByNumber((String)k).getFieldmapped() + ".number", "in", v));
        qf.add("isdefaultcurrency", "=", (Object)"1");
        if (tarStatus.length == 1) {
            qf.add("adjust.status", "=", (Object)tarStatus[0]);
        } else {
            qf.add("adjust.status", "in", (Object)tarStatus);
        }
        DataSet rs = QueryServiceHelper.queryDataSet((String)"queryRecomputeData", (String)"bcm_rptadjustdata", (String)AdjustCheckServiceHelper.getAdjEntrySelectStr(ctx.getSctx().getDimensions()), (QFilter[])qf.toArray(), null, (int)-1);
        GroupbyDataSet gpRs = rs.groupBy(ctx.getDimKeys());
        gpRs.sum("balance");
        return gpRs.finish();
    }

    private static String getAdjEntrySelectStr(List<Dimension> dims) {
        HashSet<String> fields = new HashSet<String>(dims.size());
        for (Dimension dim : dims) {
            if ("Entity".equals(dim.getNumber())) {
                if (GetJLEntryCalculate.isFromGetJLEntryCalculate()) {
                    Set orgRelaPrpSet = OrgRelaProcessMembPool.getRelaProcessMembPool().stream().map(p -> "'" + p + "'").collect(Collectors.toSet());
                    StringJoiner ksqlHelper = new StringJoiner(" ");
                    ksqlHelper.add("case when ");
                    ksqlHelper.add("Process.number in (" + String.join((CharSequence)",", orgRelaPrpSet) + ")");
                    ksqlHelper.add("then CONVERT(VARCHAR(50),concat(merge.number,concat('_', entity.number)))");
                    ksqlHelper.add("else CONVERT(VARCHAR(50),entity.number)");
                    ksqlHelper.add("end as Entity");
                    fields.add(ksqlHelper.toString());
                    continue;
                }
                fields.add("olaporg as Entity");
                continue;
            }
            if ("Process".equals(dim.getNumber())) {
                fields.add("case when Process.number ='ERAdj' then CONVERT(VARCHAR(50),'RAdj') else CONVERT(VARCHAR(50),Process.number) end as Process");
                continue;
            }
            fields.add(String.format("%s.number as %s", dim.getFieldmapped(), dim.getNumber()));
        }
        fields.add("id");
        fields.add("case when account.drcrdirect ='1' then debit-credit else credit-debit end as balance");
        return String.join((CharSequence)",", fields);
    }

    private static Map<String, Collection<String>> collectDimenScope(AdjustCheckContext ctx) {
        HashMultimap dimScope = HashMultimap.create();
        HashMap<Long, String> olaporgUpMap = new HashMap<Long, String>();
        try (DataSet ds = null;){
            QFBuilder qf = new QFBuilder("model", "=", ctx.getModel().p1);
            if (!ctx.getDetailPks().isEmpty()) {
                qf.add("id", "in", ctx.getDetailPks());
            } else {
                qf.add("adjust", "in", ctx.getPks());
            }
            qf.add("isdefaultcurrency", "=", (Object)"1");
            if (!ctx.isAudit()) {
                qf.add("adjust.status", "=", (Object)RptAdjustStatusEnum.AUDIT.status());
            }
            ds = QueryServiceHelper.queryDataSet((String)"collectDimenScope", (String)"bcm_rptadjustdata", (String)AdjustCheckServiceHelper.getDimScopeSelectStr(ctx.getSctx().getDimensions()), (QFilter[])qf.toArray(), null, (int)-1);
            ArrayList members = new ArrayList();
            ArrayList lockKeyMemList = new ArrayList();
            StringBuilder errorCather = new StringBuilder();
            ds.forEachRemaining(entry -> {
                String mergeNum = entry.getString("oldmergeNum");
                if (StringUtils.isEmpty((String)mergeNum)) {
                    mergeNum = entry.getString("mergeNum");
                }
                String olaporg = entry.getString("olaporg");
                boolean isRelaProcess = OrgRelaProcessMembPool.isRelaProcess((String)entry.getString("Process"));
                for (String dimNum : ctx.getDimKeys()) {
                    Dimension p = ctx.getSctx().getDimensionByNumber(dimNum);
                    String member = entry.getString(p.getNumber());
                    if (StringUtils.isEmpty((String)member)) {
                        errorCather.append(p.getName()).append(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u5206\u5f55\u4fe1\u606f\u3002", (String)"AdjustCheckServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0])).append(';');
                        continue;
                    }
                    if ("Entity".equals(p.getNumber())) {
                        if (ctx.isAudit() || StringUtils.isEmpty((String)olaporg)) {
                            String olaporgNew;
                            String string = olaporgNew = isRelaProcess ? AdjustCheckServiceHelper.getParentDirectChild(mergeNum, entry.getString("entity.longnumber")) : entry.getString("Entity");
                            if (StringUtils.isNotEmpty((String)olaporgNew)) {
                                if (!olaporgNew.equals(olaporg)) {
                                    olaporg = olaporgNew;
                                    olaporgUpMap.put(entry.getLong("id"), olaporg);
                                }
                            } else {
                                errorCather.append(String.format(ResManager.loadKDString((String)"\u5165\u5e93\u7ec4\u7ec7\u7f16\u7801\u751f\u6210\u5931\u8d25,\u5176\u4e2d\u660e\u7ec6\u5206\u5f55\u7ec4\u7ec7\u4e3a%1$s,\u5408\u5e76\u8282\u70b9\u7ec4\u7ec7\u4e3a%2$s\u3002", (String)"AdjustCheckServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getString("entity.longnumber"), mergeNum));
                            }
                        }
                        members.add(olaporg);
                        dimScope.put((Object)"olaporg", (Object)olaporg);
                    } else if ("Process".equals(p.getNumber()) && ("RAdj".equals(member) || "ERAdj".equals(member))) {
                        dimScope.put((Object)p.getNumber(), (Object)"RAdj");
                        dimScope.put((Object)p.getNumber(), (Object)"ERAdj");
                        members.add("RAdj");
                    } else {
                        dimScope.put((Object)p.getNumber(), (Object)member);
                        members.add(member);
                    }
                    if (!"ChangeType".equals(p.getNumber()) && !"Account".equals(p.getNumber()) && !"InternalCompany".equals(p.getNumber())) continue;
                    lockKeyMemList.add(member);
                }
                if (errorCather.length() == 0) {
                    ctx.addDimCombine(String.join((CharSequence)"@", members));
                    ctx.addPreparedLockKey(isRelaProcess ? mergeNum : entry.getString("Entity"), String.join((CharSequence)"@", lockKeyMemList));
                } else {
                    errorCather.insert(0, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7f16\u7801\u4e3a%1$s\u7684\u5206\u5f55\u4e2d\u5206\u7ec4\u53f7\u4e3a%2$s\u5e8f\u53f7\u4e3a%3$s\u7684\u5206\u5f55", (String)"AdjustCheckServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), entry.getString("adjust.number"), entry.getString("groupnum"), entry.getString("dseq")));
                    AdjustCheckServiceHelper.addLog(errorCather.toString());
                    if (ctx.isAudit()) {
                        throw new KDBizException(errorCather.toString());
                    }
                }
                lockKeyMemList.clear();
                members.clear();
            });
            AdjustCheckServiceHelper.updateEntriesOlapOrg(olaporgUpMap);
        }
        return dimScope.asMap();
    }

    private static String getDimScopeSelectStr(List<Dimension> dims) {
        HashSet<String> fields = new HashSet<String>(dims.size());
        for (Dimension dim : dims) {
            fields.add(String.format("%s.number as %s", dim.getFieldmapped(), dim.getNumber()));
        }
        fields.add("id");
        fields.add("olaporg");
        fields.add("entity.longnumber");
        fields.add("adjust.entity.number as oldmergeNum");
        fields.add("merge.number as mergeNum");
        fields.add("adjust.number");
        fields.add("groupnum");
        fields.add("dseq");
        return String.join((CharSequence)",", fields);
    }

    private static void updateAdjustStatus(AdjustCheckContext ctx) {
        if (ctx.getPks().size() > 0) {
            Date now = TimeServiceHelper.now();
            Long userId = LongUtil.toLong((Object)RequestContext.get().getUserId());
            String status = ctx.isAudit() ? RptAdjustStatusEnum.AUDIT.status() : RptAdjustStatusEnum.BACK.status();
            CharSequence[] succids = (String[])ctx.getPks().stream().map(Object::toString).distinct().toArray(String[]::new);
            if (ctx.isAudit()) {
                String adutidSql = "update t_bcm_rptadjust set fstatus = ?, freviewerid = ? ,freviewtime = ?, fcallbackerid = 0,fcallbacktime = null,fsubmitterid = (case when fsubmitterid = 0 then ? else fsubmitterid end) , fsubmittime = (case when fsubmittime is null then ? else fsubmittime end) where fid in (%s)";
                Object[] params = new Object[]{status, userId, now, userId, now};
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(adutidSql, String.join((CharSequence)",", succids)), (Object[])params);
            } else {
                String unAuditSql = " update t_bcm_rptadjust set fstatus = ?, fcallbackerid = ?,fcallbacktime = ?,freviewerid = 0,freviewtime = null  where fid in (%s)";
                Object[] params = new Object[]{status, userId, now};
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format(unAuditSql, String.join((CharSequence)",", succids)), (Object[])params);
            }
        }
        if (!ctx.getDetailPks().isEmpty()) {
            BusinessDataWriter.delete((String)"bcm_linkadjust_mapping", (QFilter[])new QFilter[]{new QFilter("elimentry", "in", ctx.getDetailPks())});
            BusinessDataWriter.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata").getDynamicObjectType(), (Object[])ctx.getDetailPks().toArray());
        }
    }

    public static String getParentDirectChild(String pNumber, String childLongNumber) {
        if (!StringUtils.isEmpty((String)pNumber) && !StringUtils.isEmpty((String)childLongNumber)) {
            String[] spr = childLongNumber.split("!");
            for (int i = 0; i < spr.length; ++i) {
                if (!spr[i].equals(pNumber) || i == spr.length - 1) continue;
                return pNumber + "_" + spr[i + 1];
            }
        }
        return null;
    }

    public static List<Long> transfNum2Ids(String modelNum, String dimNum, Set<String> membNums) {
        ArrayList<Long> ids = new ArrayList<Long>(membNums.size());
        for (String m : membNums) {
            IDNumberTreeNode node = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)m);
            if (node == IDNumberTreeNode.NotFoundTreeNode) continue;
            ids.add(node.getId());
            if (node.getShareNodes() == null) continue;
            node.getShareNodes().forEach(s -> ids.add(s.getId()));
        }
        return ids;
    }

    private static void lockDimCombine(AdjustCheckContext ctx) {
        if (AdjustCheckServiceHelper.isFromAllInOnExecute() || AdjustCheckServiceHelper.isFromBatchInvestOnExecute()) {
            return;
        }
        Map<String, Boolean> mutexMap = ctx.getLocker().batchRequest();
        if (mutexMap.containsValue(Boolean.FALSE)) {
            Set wrongMutex = mutexMap.entrySet().stream().filter(p -> (Boolean)p.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
            AdjustCheckServiceHelper.unlockDimCombine(ctx);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76f8\u5173\u8054\u7684[%s]\u7ef4\u5ea6\u7ec4\u5408\u5206\u5f55\u6b63\u5728\u6253\u56de\u6216\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u3002", (String)"AdjustCheckServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), wrongMutex));
        }
    }

    private static void unlockDimCombine(AdjustCheckContext ctx) {
        if (AdjustCheckServiceHelper.isFromAllInOnExecute() || AdjustCheckServiceHelper.isFromBatchInvestOnExecute()) {
            return;
        }
        ctx.getLocker().batchRelease();
    }

    public static boolean isFromAllInOnExecute() {
        return ThreadCache.exists((Object)"all_in_one_thread");
    }

    public static boolean isFromBatchInvestOnExecute() {
        return ThreadCache.exists((Object)"all_in_one_thread_invest");
    }

    private static void addLog(String msg) {
        WatchLoggerUtil.debug(LOG, msg);
    }
}

