/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.check;

import com.google.common.collect.HashMultimap;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckContext;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.operation.AdjustClearOperation;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class AdjustClearServiceHelper {
    public static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustClearServiceHelper.class);

    public static OperationResult batchDeleteAdjust(String orginSign, long modelId, long scene, long year, long period, List<Long> pkIds) {
        AdjustClearOperation clearOperation = new AdjustClearOperation((Long)modelId, (Long)scene, (Long)year, (Long)period, pkIds);
        clearOperation.setAutoElim(true);
        clearOperation.setOriginalSign(orginSign);
        clearOperation.excute();
        return clearOperation.getOperationResult();
    }

    public static OperationResult batchDeleteAutoAdjust(String orginSign, long modelId, long scene, long year, long period, List<Long> pkIds) {
        AdjustClearOperation clearOperation = new AdjustClearOperation((Long)modelId, (Long)scene, (Long)year, (Long)period, pkIds);
        clearOperation.setAutoElim(true);
        clearOperation.setOriginalSign(orginSign);
        clearOperation.excute();
        return clearOperation.getOperationResult();
    }

    public static void batchDeleteAutoAdjustGroup(String orginSign, long modelId, long scene, long year, long period, HashMultimap<Long, String> idGroup) {
        PlatUtil.executeWithTX(tx -> {
            Set needDeleteAdjustIds;
            AdjustCheckContext ctx = new AdjustCheckContext(modelId, scene, year, period);
            ctx.getTraceLog().setDimKeys(Arrays.asList(ctx.getDimKeys()));
            ctx.getTraceLog().setOperTypeEnum(AdjustOperTypeEnum.DELETEOPERATION);
            ctx.getTraceLog().setSpecialSourceKey(String.format(ResManager.loadKDString((String)"%s\u7684\u5206\u5f55\u6e05\u9664\u64cd\u4f5c", (String)"AdjustClearServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), orginSign));
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_rptadjust", (String)"id,linkagelinksource", (QFilter[])new QFBuilder("id", "in", (Object)idGroup.keySet()).toArray(), null);){
                ds.forEachRemaining(row -> {
                    if (row.getLong("linkagelinksource") != null && row.getLong("linkagelinksource") != 0L) {
                        idGroup.putAll((Object)row.getLong("linkagelinksource"), (Iterable)idGroup.get((Object)row.getLong("id")));
                    }
                });
            }
            HashSet<Long> toBackDetailSet = new HashSet<Long>(16);
            HashSet toDelDetailSet = new HashSet(16);
            HashSet<Long> toKeepAdjustHeadSet = new HashSet<Long>(16);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"bcm_rptadjustdata", (String)AdjustClearServiceHelper.getEntryFieldStr(ctx.getSctx()), (QFilter[])new QFBuilder("adjust", "in", (Object)idGroup.keySet()).toArray(), null);){
                ds.forEachRemaining(row -> {
                    Set grpSet = idGroup.get((Object)row.getLong("adjust.id"));
                    if (grpSet.contains(row.getString("groupnum"))) {
                        if (RptAdjustStatusEnum.AUDIT.status().equals(row.getString("adjust.status"))) {
                            toBackDetailSet.add(row.getLong("id"));
                        } else {
                            toDelDetailSet.add(row.getLong("id"));
                        }
                        AdjustClearServiceHelper.packAuditLogStr(ctx, row);
                    } else {
                        toKeepAdjustHeadSet.add(row.getLong("adjust.id"));
                    }
                });
            }
            if (!toBackDetailSet.isEmpty()) {
                AdjustCheckServiceHelper.doBackToMddByDetailIds(modelId, scene, year, period, toBackDetailSet, null);
            }
            if (!toDelDetailSet.isEmpty()) {
                BusinessDataWriter.delete((String)"bcm_linkadjust_mapping", (QFilter[])new QFilter[]{new QFilter("elimentry", "in", toDelDetailSet)});
                BusinessDataWriter.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata").getDynamicObjectType(), (Object[])toDelDetailSet.toArray());
            }
            if (!(needDeleteAdjustIds = idGroup.keySet().stream().filter(id -> !toKeepAdjustHeadSet.contains(id)).collect(Collectors.toSet())).isEmpty()) {
                BusinessDataWriter.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjust").getDynamicObjectType(), (Object[])needDeleteAdjustIds.toArray());
            }
            AdjustClearServiceHelper.updateAdjustTimeMsg(toKeepAdjustHeadSet);
            if (!orginSign.equals("CheckService.doSave")) {
                ctx.getTraceLog().publish();
            }
        });
    }

    private static void packAuditLogStr(AdjustCheckContext ctx, Row row) {
        StringJoiner sb = new StringJoiner("|");
        for (Dimension dim : ctx.getSctx().getDimensions()) {
            sb.add(row.getString(dim.getNumber()));
        }
        ctx.getTraceLog().addTag(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7f16\u7801%1$s\u5206\u7ec4\u53f7%2$s\u5e8f\u53f7%3$s\uff1a%4$s", (String)"AdjustClearServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), row.getString("adjust.number"), row.getString("groupnum"), row.getString("dseq"), sb), () -> row.getBigDecimal("summoney"));
    }

    public static void updateAdjustTimeMsg(Set<Long> keySet) {
        if (CollectionUtil.isEmpty(keySet)) {
            return;
        }
        CharSequence[] succids = (String[])keySet.stream().map(Object::toString).distinct().toArray(String[]::new);
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance();
        df.applyPattern("yyyy-MM-dd HH:mm:ss");
        String nowtime = String.format("{ts'%s'}", df.format(TimeServiceHelper.now()));
        StringJoiner sqlHelper = new StringJoiner(" ");
        sqlHelper.add("update t_bcm_rptadjust set fspreadjson = ' ' , fdata = ' '");
        sqlHelper.add(",fmodifierid = " + RequestContext.get().getCurrUserId());
        sqlHelper.add(",fmodifytime = " + nowtime);
        sqlHelper.add(String.format(",fsubmitterid = (case when fstatus in ('3','4') then %s else fsubmitterid end)", RequestContext.get().getUserId()));
        sqlHelper.add(String.format(",fsubmittime = (case when fstatus in ('3','4') then %s else fsubmittime end)", nowtime));
        sqlHelper.add(String.format(",freviewerid = (case when fstatus = '3' then %s else freviewerid end)", RequestContext.get().getUserId()));
        sqlHelper.add(String.format(",freviewtime = (case when fstatus = '3' then %s else freviewtime end)", nowtime));
        sqlHelper.add(String.format("where fid in (%s) ", String.join((CharSequence)",", succids)));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sqlHelper.toString());
        SaveServiceHelper.clearDataEntityCache((String)"bcm_rptadjust");
    }

    private static String getEntryFieldStr(SchemeContext sctx) {
        HashSet<String> fields = new HashSet<String>(20);
        for (Dimension dim : sctx.getDimensions()) {
            if ("Entity".equals(dim.getNumber())) {
                fields.add("olaporg as Entity");
                continue;
            }
            fields.add(String.format("%s.number as %s", dim.getFieldmapped(), dim.getNumber()));
        }
        fields.add("dseq");
        fields.add("groupnum");
        fields.add("summoney");
        fields.add("id");
        fields.add("adjust.id");
        fields.add("adjust.status");
        fields.add("adjust.number");
        return String.join((CharSequence)",", fields);
    }
}

