/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import kd.bos.form.IFormView;
import kd.fi.bcm.business.adjust.controller.AdjustStyleContext;
import kd.fi.bcm.business.adjust.controller.model.BaseDataControlModel;
import kd.fi.bcm.business.adjust.controller.model.BtnControlModel;
import kd.fi.bcm.business.adjust.controller.model.TextControlModel;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustAttributeStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustConfigStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustFlowStatusStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustLinkSourceStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustListShowTypeStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustMutiCurrencyStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AdjustPaperTemplateStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.AfterCheckStrategy;
import kd.fi.bcm.business.adjust.controller.strategy.IAdjustStrategy;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.common.AdjustControlConstant;

public class AdjustShowStyleController {
    public static void refreshSpreadShowStyle(IFormView view, boolean hasDataPerm, boolean isLinkPage, AdjustModel model) {
        AdjustStyleContext context = new AdjustStyleContext(view, isLinkPage, model);
        if (isLinkPage && model.getLinkagelinksourceId() == 0L) {
            context.setDataPerm(false);
        } else {
            context.setDataPerm(hasDataPerm);
        }
        AdjustShowStyleController.refreshBtnShowStyle(context, AdjustControlConstant.ReportPage, btn -> {
            btn.add(new AdjustFlowStatusStrategy());
            btn.add(new AdjustAttributeStrategy());
            btn.add(new AdjustLinkSourceStrategy());
            btn.add(new AdjustMutiCurrencyStrategy());
            btn.add(new AdjustConfigStrategy());
        });
        AdjustShowStyleController.refreshTextShowStyle(context, AdjustControlConstant.ReportPage, btnStrategys -> {
            btnStrategys.add(new AdjustFlowStatusStrategy());
            btnStrategys.add(new AdjustMutiCurrencyStrategy());
            btnStrategys.add(new AdjustLinkSourceStrategy());
            btnStrategys.add(new AdjustAttributeStrategy());
            btnStrategys.add(new AdjustConfigStrategy());
            btnStrategys.add(new AfterCheckStrategy());
        });
        AdjustShowStyleController.refreshCommonEntryShowStyle(context, btnStrategys -> {
            btnStrategys.add(new AdjustFlowStatusStrategy());
            btnStrategys.add(new AfterCheckStrategy());
        });
    }

    public static void refreshPaperTemplateEditStyle(IFormView view, boolean hasDataPerm, AdjustModel model) {
        AdjustStyleContext context = new AdjustStyleContext(view, false, model);
        context.setDataPerm(hasDataPerm);
        AdjustShowStyleController.refreshBtnShowStyle(context, AdjustControlConstant.PaperTemplateEditPage, e -> {
            e.add(new AdjustPaperTemplateStrategy());
            e.add(new AfterCheckStrategy());
        });
        AdjustShowStyleController.refreshTextShowStyle(context, AdjustControlConstant.PaperTemplateEditPage, e -> {
            e.add(new AdjustPaperTemplateStrategy());
            e.add(new AdjustMutiCurrencyStrategy());
            e.add(new AfterCheckStrategy());
        });
        AdjustShowStyleController.refreshCommonEntryShowStyle(context, e -> {
            e.add(new AdjustPaperTemplateStrategy());
            e.add(new AfterCheckStrategy());
        });
    }

    public static void refreshListShowStyle(IFormView view, Long modelId) {
        AdjustStyleContext context = new AdjustStyleContext(view, modelId);
        context.setDataPerm(true);
        ArrayList<IAdjustStrategy> btnStrategys = new ArrayList<IAdjustStrategy>();
        btnStrategys.add(new AdjustConfigStrategy());
        btnStrategys.add(new AdjustListShowTypeStrategy());
        btnStrategys.add(new AfterCheckStrategy());
        AdjustControlConstant.getBtnControls((Integer)AdjustControlConstant.ListPage).forEach((key, type) -> {
            BtnControlModel btn = new BtnControlModel((String)key, (int)type);
            btnStrategys.forEach(strategy -> strategy.check(context, btn));
        });
        context.getView().updateView("toolbarap");
    }

    private static void refreshBtnShowStyle(AdjustStyleContext context, Integer adjustControlType, Consumer<List<IAdjustStrategy>> func) {
        ArrayList<AfterCheckStrategy> btnStrategys = new ArrayList<AfterCheckStrategy>();
        if (func != null) {
            func.accept(btnStrategys);
        }
        btnStrategys.add(new AfterCheckStrategy());
        AdjustControlConstant.getBtnControls((Integer)adjustControlType).forEach((key, type) -> {
            BtnControlModel btn = new BtnControlModel((String)key, (int)type);
            btnStrategys.forEach(strategy -> strategy.check(context, btn));
        });
        context.getView().updateView("toolbarap");
    }

    private static void refreshCommonEntryShowStyle(AdjustStyleContext context, Consumer<List<IAdjustStrategy>> func) {
        ArrayList btnStrategys = new ArrayList();
        if (func != null) {
            func.accept(btnStrategys);
        }
        context.getAdjust().getCommDimensionEntries().forEach(e -> {
            String f7key = null;
            f7key = e.getNumber().equals("bcm_mergenode") ? "entity" : (e.getDimension().getMemberEntityNumber() + '_' + e.getDimension().getNumber()).toLowerCase(Locale.ENGLISH);
            BaseDataControlModel base = new BaseDataControlModel(f7key, e.getDimension());
            btnStrategys.forEach(strategy -> strategy.check(context, base));
        });
    }

    private static void refreshTextShowStyle(AdjustStyleContext context, Integer adjustControlType, Consumer<List<IAdjustStrategy>> func) {
        ArrayList btnStrategys = new ArrayList();
        if (func != null) {
            func.accept(btnStrategys);
        }
        AdjustControlConstant.getTextControls((Integer)adjustControlType).forEach((key, type) -> {
            TextControlModel btn = new TextControlModel((String)key, (int)type);
            btnStrategys.forEach(strategy -> strategy.check(context, btn));
        });
        context.getView().updateView("flexpanelap2");
    }
}

