/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.form.IFormView;
import kd.fi.bcm.business.adjust.controller.AdjustStyleNewContext;
import kd.fi.bcm.business.adjust.controller.newstrategy.AbstractNewAdjustStrategy;
import kd.fi.bcm.business.adjust.controller.newstrategy.AdjustCommonUsePermAdjustStrategy;
import kd.fi.bcm.business.adjust.model.AdjustTemplateModel;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.common.AdjustControlConstant;
import kd.fi.bcm.common.enums.adjust.AdjustControlTypeEnum;
import kd.fi.bcm.common.enums.adjust.AdjustSrcPageControlEnum;
import kd.fi.bcm.common.util.CollectionUtil;

public class AdjustShowStyleNewController {
    public static void refreshCommonUseReportShowStyle(IFormView curPageView, AdjustStyleNewContext _ctx, AdjustTemplateModel adjustTemplateModel) {
        _ctx.setSrcPage(AdjustSrcPageControlEnum.CommonUseReport);
        _ctx.addProperty("data", adjustTemplateModel);
        _ctx.setControlType(AdjustControlTypeEnum.BTN_CONTROL);
        AdjustShowStyleNewController.refreshPageControlShowStyle(curPageView, _ctx, AdjustShowStyleNewController.getPageControls(_ctx.getSrcPage(), AdjustControlTypeEnum.BTN_CONTROL), strategy -> strategy.add(new AdjustCommonUsePermAdjustStrategy()));
    }

    private static void refreshPageControlShowStyle(IFormView curPageView, AdjustStyleNewContext _ctx, Map<String, Integer> getPageControls, Consumer<List<AbstractNewAdjustStrategy>> func) {
        if (getPageControls == null || CollectionUtil.isEmpty(getPageControls.keySet())) {
            return;
        }
        ArrayList btnStrategyList = new ArrayList(4);
        if (func != null) {
            func.accept(btnStrategyList);
        }
        HashSet hideControls = new HashSet(16);
        HashSet disEnableControls = new HashSet(16);
        btnStrategyList.forEach(strategy -> {
            strategy.setCtx(_ctx);
            strategy.check(getPageControls);
            hideControls.addAll(strategy.getHideSet());
            disEnableControls.addAll(strategy.getDisEnableSet());
        });
        String[] wholePageControls = getPageControls.keySet().toArray(new String[0]);
        curPageView.setVisible(Boolean.TRUE, wholePageControls);
        curPageView.setVisible(Boolean.FALSE, hideControls.toArray(new String[0]));
        curPageView.setEnable(Boolean.TRUE, wholePageControls);
        curPageView.setEnable(Boolean.FALSE, disEnableControls.toArray(new String[0]));
    }

    public static Map<String, Integer> getPageControls(AdjustSrcPageControlEnum srcPage, AdjustControlTypeEnum controlType) {
        if (controlType == AdjustControlTypeEnum.BTN_CONTROL) {
            return new HashMap<String, Integer>(AdjustControlConstant.getBtnControls((Integer)srcPage.getIndex()));
        }
        if (controlType == AdjustControlTypeEnum.TEXT_CONTROL) {
            return new HashMap<String, Integer>(AdjustControlConstant.getTextControls((Integer)srcPage.getIndex()));
        }
        return new HashMap<String, Integer>(16);
    }

    public static String buildF7Key(Dimension dim) {
        return (dim.getMemberEntityNumber() + '_' + dim.getNumber()).toLowerCase(Locale.ENGLISH);
    }

    private String splitDimNumByF7key(String f7key) {
        return f7key.substring(f7key.lastIndexOf(95) + 1);
    }
}

