/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.controller.strategy;

import java.util.HashSet;
import java.util.Set;
import kd.fi.bcm.business.adjust.controller.AdjustStyleContext;
import kd.fi.bcm.business.adjust.controller.model.BaseDataControlModel;
import kd.fi.bcm.business.adjust.controller.model.BtnControlModel;
import kd.fi.bcm.business.adjust.controller.model.IControlModel;
import kd.fi.bcm.business.adjust.controller.model.TextControlModel;
import kd.fi.bcm.business.adjust.controller.strategy.IAdjustStrategy;

abstract class AbstractAdjustStrategy
implements IAdjustStrategy {
    private Set<String> hideSet = new HashSet<String>();
    private Set<String> enableSet = new HashSet<String>();

    AbstractAdjustStrategy() {
    }

    @Override
    public void check(AdjustStyleContext context, IControlModel controlModel) {
        if (controlModel instanceof BtnControlModel) {
            this.checkBtnControl(context, controlModel);
        } else if (controlModel instanceof TextControlModel) {
            this.checkTextControl(context, controlModel);
        } else if (controlModel instanceof BaseDataControlModel) {
            this.checkBaseDataControl(context, controlModel);
        }
        if (controlModel.isVisible()) {
            controlModel.setVisible(!this.hideSet.contains(controlModel.getKey()));
        }
        if (controlModel.isEnable()) {
            controlModel.setEnable(!this.enableSet.contains(controlModel.getKey()));
        }
        this.hideSet.clear();
        this.enableSet.clear();
    }

    protected void checkBtnControl(AdjustStyleContext context, IControlModel controlModel) {
    }

    protected void checkTextControl(AdjustStyleContext context, IControlModel controlModel) {
    }

    protected void checkBaseDataControl(AdjustStyleContext context, IControlModel controlModel) {
    }

    protected void hideControl(String key) {
        this.hideSet.add(key);
    }

    protected void disableControl(String key) {
        this.enableSet.add(key);
    }
}

