/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.controller.strategy;

import kd.fi.bcm.business.adjust.controller.AdjustStyleContext;
import kd.fi.bcm.business.adjust.controller.model.IControlModel;
import kd.fi.bcm.business.adjust.controller.strategy.AbstractAdjustStrategy;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.enums.JournalTypeEnum;

public class AdjustAttributeStrategy
extends AbstractAdjustStrategy {
    @Override
    public void checkBtnControl(AdjustStyleContext context, IControlModel controlModel) {
        AdjustModel adjustModel = context.getAdjust();
        JournalTypeEnum journalType = JournalTypeEnum.getEumByKey((String)Integer.toString(adjustModel.getJournaltype()));
        if (journalType == JournalTypeEnum.PERIOD || journalType == JournalTypeEnum.YEAR) {
            this.hideControl("btn_normal_to_period");
            this.hideControl("btn_normal_to_year");
        } else if (journalType == JournalTypeEnum.NORMAL) {
            this.hideControl("btn_continue_to_normal");
        } else {
            this.hideControl("btn_normal_to_period");
            this.hideControl("btn_normal_to_year");
            this.hideControl("btn_continue_to_normal");
        }
        if (adjustModel.getCheckrecordId() == null || adjustModel.getCheckrecordId() == 0L) {
            this.hideControl("btn_viewcheckrecord");
        }
    }

    @Override
    public void checkTextControl(AdjustStyleContext context, IControlModel controlModel) {
        AdjustModel adjustModel = context.getAdjust();
        if (!OrgRelaProcessMembPool.isRelaProcess((String)adjustModel.getProcess()) || adjustModel.getSpreadDimensionEntries().stream().anyMatch(p -> p.getNumber().equals("bcm_mergenode"))) {
            this.hideControl("entity");
        }
        if (!context.isLinkPage() && ("CADJ".equals(adjustModel.getProcess()) || "ADJ".equals(adjustModel.getProcess()))) {
            this.hideControl("businesstypetext");
        } else {
            this.disableControl("bussnesstype");
            this.hideControl("bussnesstype");
        }
        if (context.isLinkPage()) {
            this.disableControl("balancetype");
        }
    }
}

