/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.controller.strategy;

import kd.fi.bcm.business.adjust.controller.AdjustStyleContext;
import kd.fi.bcm.business.adjust.controller.model.IControlModel;
import kd.fi.bcm.business.adjust.controller.strategy.AbstractAdjustStrategy;
import kd.fi.bcm.business.adjust.model.AdjustModel;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;

public class AdjustFlowStatusStrategy
extends AbstractAdjustStrategy {
    @Override
    public void checkBtnControl(AdjustStyleContext context, IControlModel controlModel) {
        AdjustModel adjustModel = context.getAdjust();
        RptAdjustStatusEnum status = RptAdjustStatusEnum.getStatusEnumBy((String)adjustModel.getStatus());
        if ((status == RptAdjustStatusEnum.AUDIT || status == RptAdjustStatusEnum.COMMIT || status == RptAdjustStatusEnum.RATIFY) && controlModel.getType() == 1) {
            this.hideControl(controlModel.getKey());
        }
        switch (status) {
            case TEMPSAVE: {
                this.hideControl("btn_submit");
            }
            case SAVE: 
            case BACK: {
                this.hideControl("btn_ratify");
                if (!ConfigServiceHelper.getBoolParam(context.getModelId(), "CM046")) {
                    this.hideControl("btn_audit");
                }
                this.hideControl("btn_cancel_submit");
                this.hideControl("btn_cancel_ratify");
                this.hideControl("btn_back");
                this.hideControl("btn_elim");
                this.hideControl("btn_continue");
                this.hideControl("btn_entrysearch");
                this.hideControl("btn_shareentrysearch");
                this.hideControl("btn_sharesetting");
                break;
            }
            case COMMIT: {
                this.hideControl("btn_spiltscrean");
                this.hideControl("btn_tempsave");
                this.hideControl("btn_submit");
                this.hideControl("btn_cancel_ratify");
                this.hideControl("btn_ratify");
                this.hideControl("btn_cancel_submit");
                this.disableControl("btn_save");
                this.hideControl("btn_elim");
                this.hideControl("btn_continue");
                this.hideControl("btn_createlinkage");
                this.hideControl("btn_addentry");
                this.hideControl("btn_adddiffentry");
                this.hideControl("btn_layout");
                this.hideControl("btn_entrysearch");
                this.hideControl("btn_shareentrysearch");
                this.hideControl("btn_sharesetting");
                break;
            }
            case RATIFY: {
                this.hideControl("btn_spiltscrean");
                this.hideControl("btn_tempsave");
                this.hideControl("btn_submit");
                this.hideControl("btn_cancel_submit");
                this.hideControl("btn_ratify");
                this.hideControl("btn_back");
                this.disableControl("btn_save");
                this.hideControl("btn_elim");
                this.hideControl("btn_continue");
                this.hideControl("btn_createlinkage");
                this.hideControl("btn_addentry");
                this.hideControl("btn_adddiffentry");
                this.hideControl("btn_layout");
                this.hideControl("btn_entrysearch");
                this.hideControl("btn_shareentrysearch");
                this.hideControl("btn_sharesetting");
                break;
            }
            case AUDIT: {
                this.hideControl("btn_spiltscrean");
                this.hideControl("btn_tempsave");
                this.hideControl("btn_submit");
                this.hideControl("btn_cancel_submit");
                this.hideControl("btn_ratify");
                this.hideControl("btn_cancel_ratify");
                this.hideControl("btn_audit");
                this.disableControl("btn_save");
                this.hideControl("btn_createlinkage");
                this.hideControl("btn_addentry");
                this.hideControl("btn_adddiffentry");
                this.hideControl("btn_layout");
            }
        }
    }

    @Override
    public void checkTextControl(AdjustStyleContext context, IControlModel controlModel) {
        AdjustModel adjustModel = context.getAdjust();
        RptAdjustStatusEnum status = RptAdjustStatusEnum.getStatusEnumBy((String)adjustModel.getStatus());
        switch (status) {
            case TEMPSAVE: 
            case SAVE: 
            case BACK: {
                controlModel.setDataPerm(true);
                controlModel.setEnable(true);
                break;
            }
            default: {
                controlModel.setDataPerm(false);
                controlModel.setEnable(false);
            }
        }
        this.hideControl("balancetext");
    }

    @Override
    protected void checkBaseDataControl(AdjustStyleContext context, IControlModel controlModel) {
        AdjustModel adjustModel = context.getAdjust();
        RptAdjustStatusEnum status = RptAdjustStatusEnum.getStatusEnumBy((String)adjustModel.getStatus());
        switch (status) {
            case TEMPSAVE: 
            case SAVE: 
            case BACK: {
                break;
            }
            default: {
                this.disableControl(controlModel.getKey());
            }
        }
    }
}

