/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertPathNode;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.RateCvtSetScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class AdjustConvertService {
    private final Pair<Long, String> modelPair;
    private final Pair<Long, String> scene;
    private final Pair<Long, String> tarYear;
    private final Pair<Long, String> tarPeriod;
    private SchemeContext sctx;
    private List<RateCvtSetScheme> rateCvtSetSchemes;
    private Map<Integer, List<DynamicObject>> userDefindedList;
    private WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());

    public AdjustConvertService(Long modelId, Long scene, Long tarYear, Long tarPeriod) {
        this.modelPair = Pair.onePair((Object)modelId, (Object)MemberReader.findModelNumberById((Object)modelId));
        this.tarPeriod = Pair.onePair((Object)tarPeriod, (Object)MemberReader.findPeriodMemberById((String)((String)this.modelPair.p2), (Long)tarPeriod).getNumber());
        this.scene = Pair.onePair((Object)scene, (Object)MemberReader.findScenaMemberById((String)((String)this.modelPair.p2), (Long)scene).getNumber());
        this.tarYear = Pair.onePair((Object)tarYear, (Object)MemberReader.findFyMemberById((String)((String)this.modelPair.p2), (Long)tarYear).getNumber());
        this.initData();
    }

    private void initData() {
        this.rateCvtSetSchemes = AdjustConvertUtil.queryRateCvtSetSchemes(this.getModelId(), 0);
        this.sctx = SchemeContext.getInstance(this.getModelId());
        boolean isUseNewgetUserDefindedList = ConfigServiceHelper.getBoolParam(this.getModelId(), "isUseNewgetUserDefindedList");
        this.userDefindedList = AdjustConvertUtil.createSeqGroup(AdjustConvertUtil.getUserDefindedList(this.getModelId(), (Long)this.tarYear.p1, (Long)this.scene.p1, (Long)this.tarPeriod.p1), isUseNewgetUserDefindedList);
    }

    public void setSkipRateModelErr(boolean skipRateModelErr) {
    }

    public void batchConvert(Collection<DynamicObject> newEntries) {
        HashSet<Long> orgSet = new HashSet<Long>();
        HashMap<Long, List> groupByElims = new HashMap<Long, List>();
        for (DynamicObject p : newEntries) {
            if (AdjustConvertUtil.getDiffTest().test(p.getInt("entryrowtype"))) continue;
            if (p.get("entity") != null) {
                orgSet.add(DynUtils.getBaseId((DynamicObject)p, (String)"entity"));
            }
            groupByElims.computeIfAbsent(p.getLong("adjust.id"), k -> new ArrayList()).add(p);
        }
        this.prepareRateData(orgSet);
        groupByElims.forEach((id, entries) -> this.convert((List<DynamicObject>)entries));
    }

    public void prepareRateData(Set<Long> orgSet) {
        orgSet.remove(0L);
        if (CollectionUtil.isEmpty(orgSet)) {
            return;
        }
        BaseData baseData = new BaseData((Long)this.modelPair.p1, this.scene, this.tarYear, this.tarPeriod);
        ExchangeQueryHelper.getMultiRateDatasByOrgIds(baseData, orgSet, CollectionUtils.EMPTY_COLLECTION, CollectionUtils.EMPTY_COLLECTION);
    }

    private List<DynamicObject> convert(List<DynamicObject> entries) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(entries.size());
        DynamicObject entry = null;
        BigDecimal rateValue = null;
        AdjustConvertPathNode convertPath = new AdjustConvertPathNode();
        int prec = 2;
        for (int i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            if (this.checkConvertAvailable(entry)) {
                convertPath.setCvtOrg(DynUtils.getBaseId((DynamicObject)entry, (String)"entity"));
                convertPath.setSrcCurrency(DynUtils.getBaseId((DynamicObject)entry, (String)"adjust.cvtbeforecurrency"));
                convertPath.setTarCurrency(DynUtils.getBaseId((DynamicObject)entry, (String)"currency"));
                for (Dimension dim : this.sctx.getDimensions()) {
                    convertPath.setDimComb(dim.getNumber(), DynUtils.getBaseId((DynamicObject)entry, (String)dim.getFieldmapped()));
                }
                rateValue = this.resolveConvertPathRate(convertPath);
                String accountNum = convertPath.queryDimMemNode(this.getModelId(), "Account").getNumber();
                prec = CurrencyScaleHandler.getNewCurrencyScale(this.getModelId(), (String)this.scene.p2, MemberReader.findCurrencyMemberById((String)this.sctx.getModelNumber(), (Long)convertPath.getSrcCurrency()).getNumber(), accountNum);
                BigDecimal beforeDebit = entry.getBigDecimal("cvtbeforedebit").setScale(prec, 4);
                BigDecimal beforeCredit = entry.getBigDecimal("cvtbeforecredit").setScale(prec, 4);
                BigDecimal summoney = entry.getBigDecimal("cvtbeforesummoney").setScale(prec, 4);
                entry.set("rate", (Object)rateValue);
                entry.set("cvtbeforedebit", (Object)beforeDebit);
                entry.set("cvtbeforecredit", (Object)beforeCredit);
                entry.set("cvtbeforesummoney", (Object)summoney);
                prec = CurrencyScaleHandler.getNewCurrencyScale(this.getModelId(), (String)this.scene.p2, convertPath.queryDimMemNode(this.getModelId(), "Currency").getNumber(), accountNum);
                entry.set("debit", (Object)beforeDebit.multiply(rateValue).setScale(prec, 4));
                entry.set("credit", (Object)beforeCredit.multiply(rateValue).setScale(prec, 4));
                entry.set("summoney", (Object)summoney.multiply(rateValue).setScale(prec, 4));
            }
            result.add(entry);
        }
        return result;
    }

    public BigDecimal resolveConvertPathRate(AdjustConvertPathNode convertPath) {
        try {
            Long modelId = this.getModelId();
            this.checkConvertPathNotNull(convertPath);
            IDNumberTreeNode accNode = convertPath.queryDimMemNode(modelId, "Account");
            if (StringUtils.isEmpty((CharSequence)((CharSequence)accNode.getProperty("entryrate")))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u672a\u5b9a\u4e49\u5206\u5f55\u7528\u6c47\u7387\u3002", (String)"AdjustConvertService_13", (String)"fi-bcm-business", (Object[])new Object[0]), accNode.getNumber()));
            }
            BigDecimal resultRate = BigDecimal.ONE;
            IDNumberTreeNode srcCurrNode = MemberReader.findCurrencyMemberById((String)this.sctx.getModelNumber(), (Long)convertPath.getSrcCurrency());
            IDNumberTreeNode tarCurrNode = MemberReader.findCurrencyMemberById((String)this.sctx.getModelNumber(), (Long)convertPath.getTarCurrency());
            if (srcCurrNode.getNumber().equals(tarCurrNode.getNumber())) {
                return resultRate;
            }
            BaseData baseData = new BaseData((Long)this.modelPair.p1, this.scene, this.tarYear, this.tarPeriod);
            Long orgId = convertPath.getCvtOrg();
            RateModel rateModel = ExchangeQueryHelper.getRateData(baseData, orgId, srcCurrNode.getNumber(), tarCurrNode.getNumber());
            BigDecimal accRateValue = rateModel.getRateByNumber(AdjustConvertUtil.getRateNumberByEnumValue((String)accNode.getProperty("entryrate")));
            String rateAnnexedNumber = this.getUserDefindedRateNumber(convertPath, (Pair<Long, String>)Pair.onePair((Object)srcCurrNode.getId(), (Object)srcCurrNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)tarCurrNode.getId(), (Object)tarCurrNode.getNumber()));
            if (StringUtil.isEmpty((CharSequence)rateAnnexedNumber)) {
                IDNumberTreeNode changeNode = convertPath.queryDimMemNode(this.getModelId(), "ChangeType");
                resultRate = ConvertUtil.getRate(accNode.getNumber(), changeNode.getNumber(), ExchangeEnum.getExchangeEnumByIndex((String)((String)accNode.getProperty("exchange"))), ChangewayEnum.getChangewayEnumByIndexkdec((String)((String)changeNode.getProperty("changeway"))), rateModel);
            } else if (!"hasCvtNumber".equals(rateAnnexedNumber)) {
                resultRate = rateModel.getRateByNumber(rateAnnexedNumber);
            }
            if (resultRate == null) {
                resultRate = accRateValue;
            }
            return BigDecimal.ZERO.compareTo(resultRate) == 0 ? resultRate : (rateModel.isMultiply() ? resultRate : BigDecimal.ONE.divide(resultRate, 15, 4));
        }
        catch (Throwable t) {
            this.log.error(t);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6298\u7b97\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a\uff1a%2$s", (String)"AdjustConvertService_5", (String)"fi-bcm-business", (Object[])new Object[0]), convertPath.getShowMsg(this.getModelId()), AdjustmentServiceHelper.toString_Adj(t)));
        }
    }

    private void checkConvertPathNotNull(AdjustConvertPathNode convertPath) {
        String modelNum = MemberReader.findModelNumberById((Object)this.getModelId());
        HashSet<String> emptyFieldSet = new HashSet<String>(5);
        if (IDNumberTreeNode.NotFoundTreeNode == MemberReader.findCurrencyMemberById((String)modelNum, (Long)convertPath.getSrcCurrency())) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u6e90\u5e01\u79cd", (String)"AdjustConvertService_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (IDNumberTreeNode.NotFoundTreeNode == MemberReader.findCurrencyMemberById((String)modelNum, (Long)convertPath.getTarCurrency())) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u76ee\u6807\u5e01\u79cd", (String)"AdjustConvertService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (IDNumberTreeNode.NotFoundTreeNode == MemberReader.findEntityMemberById((String)modelNum, (Long)convertPath.getCvtOrg())) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AdjustConvertService_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (IDNumberTreeNode.NotFoundTreeNode == convertPath.queryDimMemNode(this.getModelId(), "Account")) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AdjustConvertService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (IDNumberTreeNode.NotFoundTreeNode == convertPath.queryDimMemNode(this.getModelId(), "ChangeType")) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"AdjustConvertService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!emptyFieldSet.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustConvertService_12", (String)"fi-bcm-business", (Object[])new Object[0]), emptyFieldSet));
        }
    }

    private String getUserDefindedRateNumber(AdjustConvertPathNode convertPath, Pair<Long, String> srcCur, Pair<Long, String> tarCur) {
        Map<String, String[]> scopeMap = this.sctx.getDimensions().stream().collect(Collectors.toMap(Dimension::getNumber, p -> new String[]{convertPath.queryDimMemNode(this.getModelId(), p.getNumber()).getNumber()}));
        scopeMap.put("Year", new String[]{(String)this.tarYear.p2});
        scopeMap.put("Period", new String[]{(String)this.tarPeriod.p2});
        PairList path = new PairList();
        path.addPair(srcCur.p1, srcCur.p2);
        path.addPair(tarCur.p1, tarCur.p2);
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)this.sctx.getModelNumber(), (Long)convertPath.getCvtOrg());
        return ConvertServiceHelper.getUserDefindedRateNumber(path.toList(), this.modelPair, (Pair<Long, String>)Pair.onePair((Object)orgNode.getId(), (Object)orgNode.getNumber()), this.tarYear, this.tarPeriod, this.scene, scopeMap, this.userDefindedList);
    }

    private boolean checkConvertAvailable(DynamicObject entry) {
        if (entry.get("entity") == null) {
            return false;
        }
        if (AdjustConvertUtil.getDiffTest().test(entry.getInt("entryrowtype"))) {
            return false;
        }
        Long srcCurrid = AdjustmentServiceHelper.transformDimid(entry, "adjust.cvtbeforecurrency");
        Long tarCurrid = AdjustmentServiceHelper.transformDimid(entry, "currency");
        if (srcCurrid == null || srcCurrid == 0L || tarCurrid == null || tarCurrid == 0L) {
            return false;
        }
        return ElimRptAdjSourceTypeEnum.SHARE.getValue() == entry.getInt("adjust.sourcetype") && AdjustConvertUtil.isBigDecimalEmpty(entry.getBigDecimal("rate")) && !AdjustConvertUtil.getMultipleCurrency((Long)this.modelPair.p1, AdjustmentServiceHelper.transformDimid(entry, "adjust.entity"), entry.getString("adjust.bussnesstype")).contains(AdjustmentServiceHelper.transformDimid(entry, "currency")) || AdjustmentServiceHelper.searchSchemeByDimComb(AdjustOperationHelper.createVersionParam((Long)this.modelPair.p1, DynUtils.getBaseId((String)"checkConvertAvailable", (DynamicObject)entry, (String)"scenario"), DynUtils.getBaseId((String)"checkConvertAvailable", (DynamicObject)entry, (String)"year"), DynUtils.getBaseId((String)"checkConvertAvailable", (DynamicObject)entry, (String)"period")), this.getCombKey(entry), this.rateCvtSetSchemes, false) == null;
    }

    private Map<String, String> getCombKey(DynamicObject entry) {
        return this.sctx.getDimensions().stream().collect(Collectors.toMap(Dimension::getNumber, p -> MemberReader.findMemberById((long)this.getModelId(), (String)p.getMembermodel(), (Long)AdjustmentServiceHelper.transformDimid(entry, p.getFieldmapped())).getNumber()));
    }

    private Long getModelId() {
        return (Long)this.modelPair.p1;
    }
}

