/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.convert;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.convert.ctx.SimpleVo;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.scheme.RateCvtSetScheme;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.adjust.AdjustEntryRowTypeEnum;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class AdjustRateDiffCreateService {
    private static final String RATE_SUB_FORMUAL = "(%1$s(%2$s)*(ACC_RATE(%3$s)-REALITY_RATE(%4$s))*CT_AGGOPRT(%5$s))";
    private AtomicInteger seq = new AtomicInteger(0);
    private final Long modelId;
    private final Long scene;
    private final Long tarYear;
    private final Long tarPeriod;
    private Boolean isFromDataBase;
    private final DynamicObject changeType;
    private final SchemeContext sctx;
    private final List<RateCvtSetScheme> rateCvtRiffSchemes;

    public AdjustRateDiffCreateService(Long modelId, Long scene, Long tarYear, Long tarPeriod) {
        this.modelId = modelId;
        this.tarPeriod = tarPeriod;
        this.scene = scene;
        this.tarYear = tarYear;
        this.sctx = SchemeContext.getInstance(modelId);
        this.rateCvtRiffSchemes = AdjustConvertUtil.queryRateCvtSetSchemes(this.getModelId(), 1);
        this.changeType = (DynamicObject)ThreadCache.get((Object)("cvtChangeTypeAdj" + modelId), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("isexchange", "=", (Object)"1"));
            return BusinessDataServiceHelper.loadSingle((String)"bcm_changetypemembertree", (String)"id", (QFilter[])new QFilter[]{filter});
        });
    }

    public void setFromDataBase(Boolean fromDataBase) {
        this.isFromDataBase = fromDataBase;
    }

    public List<DynamicObject> createRateDiffSingleElim(List<DynamicObject> convertDatas, boolean isMutiCurrency) {
        if (convertDatas.isEmpty()) {
            return convertDatas;
        }
        IDNumberTreeNode srcCur = MemberReader.findMemberById((long)this.modelId, (String)"bcm_currencymembertree", (Long)DynUtils.getBaseId((DynamicObject)convertDatas.get(0), (String)"adjust.cvtbeforecurrency"));
        if (isMutiCurrency || srcCur != IDNumberTreeNode.NotFoundTreeNode) {
            if (this.changeType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\u7ef4\u5ea6\u6ca1\u6709\u627e\u5230\u7528\u4e8e\u751f\u6210\u6c47\u7387\u5dee\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u7ef4\u5ea6\u7ba1\u7406-\u53d8\u52a8\u7c7b\u578b\u4e2d\u7ef4\u62a4\u3002", (String)"AdjustRateDiffCreateService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ArrayList<DynamicObject> rateDiffs = new ArrayList<DynamicObject>(10);
            HashSet<Long> orgSet = new HashSet<Long>();
            Map groupBy = convertDatas.stream().filter(p -> !AdjustConvertUtil.getDiffTest().test(p.getInt("entryrowtype"))).peek(p -> orgSet.add(DynUtils.getBaseId((DynamicObject)p, (String)"entity"))).sorted(Comparator.comparingInt(p -> p.getInt("showseq"))).collect(Collectors.groupingBy(p -> p.getString("groupnum") + EntrySourceEnum.getLinkList().contains(p.getInt("entrysource")), LinkedHashMap::new, Collectors.toList()));
            this.prepareRateData(orgSet);
            groupBy.forEach((sign, groupList) -> {
                rateDiffs.addAll((Collection<DynamicObject>)groupList);
                rateDiffs.addAll(this.createRateDiffGroupBy((List<DynamicObject>)groupList));
            });
            AdjustConvertUtil.resetSeq(rateDiffs, Boolean.FALSE);
            return rateDiffs;
        }
        return new ArrayList<DynamicObject>(convertDatas);
    }

    public void prepareRateData(Set<Long> orgSet) {
        orgSet.remove(0L);
        if (CollectionUtil.isEmpty(orgSet)) {
            return;
        }
        BaseData baseData = new BaseData(this.getModelId(), this.scene, this.tarYear, this.tarPeriod);
        ExchangeQueryHelper.getMultiRateDatasByOrgIds(baseData, orgSet, CollectionUtils.EMPTY_COLLECTION, CollectionUtils.EMPTY_COLLECTION);
    }

    private List<DynamicObject> createRateDiffGroupBy(List<DynamicObject> convertDatas) {
        HashMap<String, DynamicObject> tempMap = new HashMap<String, DynamicObject>(10);
        Table<String, String, Map<String, Pair<BigDecimal, String>>> result = this.groupByCombKey2dc(convertDatas, tempMap);
        ArrayList<DynamicObject> rateDiffs = new ArrayList<DynamicObject>(10);
        for (Table.Cell cell : result.cellSet()) {
            DynamicObject srcEntry;
            Pair<Pair<BigDecimal, String>, Map<String, Pair<BigDecimal, String>>> integrationData = this.integrationData((Table.Cell<String, String, Map<String, Pair<BigDecimal, String>>>)cell);
            if (integrationData == null || (srcEntry = (DynamicObject)tempMap.get(cell.getColumnKey())) == null) continue;
            boolean isOrmCopy = this.isFromDataBase == null ? srcEntry.getDataEntityState() != null && srcEntry.getDataEntityState().getFromDatabase() : this.isFromDataBase;
            DynamicObject mainEntry = AdjustOperationHelper.copyDynamicObject(srcEntry, isOrmCopy);
            if (EntrySourceEnum.getLinkList().contains(mainEntry.getInt("entrysource"))) {
                mainEntry.set("dseq", (Object)(mainEntry.getString("dseq") + "-" + this.seq.incrementAndGet()));
            } else {
                mainEntry.set("dseq", (Object)("100000000000" + this.seq.incrementAndGet()));
                mainEntry.set("showseq", (Object)(10000 + this.seq.incrementAndGet()));
            }
            mainEntry.set("calculatecontent", null);
            mainEntry.set("changeType", (Object)this.changeType);
            mainEntry.set("credit", null);
            mainEntry.set("debit", null);
            mainEntry.set("summoney", null);
            mainEntry.set("cvtbeforesummoney", null);
            mainEntry.set("cvtbeforecredit", null);
            mainEntry.set("cvtbeforedebit", null);
            mainEntry.set("rate", null);
            mainEntry.set("isdefaultcurrency", (Object)"1");
            mainEntry.set("description", (Object)ResManager.loadKDString((String)"\u6c47\u7387\u5dee", (String)"AdjustRateDiffCreateService_5", (String)"fi-bcm-business", (Object[])new Object[0]));
            mainEntry.set("entryrowtype", (Object)AdjustEntryRowTypeEnum.RATE_DIFF.getValue());
            StringJoiner sj = new StringJoiner("\n ");
            if (integrationData.p1 != null) {
                Pair<BigDecimal, String> money2formula = this.dealScale((Pair<BigDecimal, String>)((Pair)integrationData.p1), DynUtils.getBaseId((DynamicObject)mainEntry, (String)"currency"), DynUtils.getBaseId((DynamicObject)mainEntry, (String)"account"));
                mainEntry.set("summoney", money2formula.p1);
                mainEntry.set((String)cell.getRowKey(), money2formula.p1);
                sj.add("mainCurr:" + (String)money2formula.p2);
            }
            rateDiffs.add(mainEntry);
            if (integrationData.p2 != null) {
                sj.add(" otherCurr:");
                ((Map)integrationData.p2).forEach((curr, value) -> {
                    if (StringUtils.isNotEmpty((CharSequence)curr) && !"0".equals(curr)) {
                        DynamicObject otherEntry = AdjustOperationHelper.copyDynamicObject(mainEntry, isOrmCopy);
                        otherEntry.set("currency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)LongUtil.toLong((Object)curr), (String)"bcm_currencymembertree"));
                        otherEntry.set("credit", null);
                        otherEntry.set("debit", null);
                        Pair<BigDecimal, String> money2formula = this.dealScale((Pair<BigDecimal, String>)value, DynUtils.getBaseId((DynamicObject)otherEntry, (String)"currency"), DynUtils.getBaseId((DynamicObject)otherEntry, (String)"account"));
                        otherEntry.set("summoney", money2formula.p1);
                        otherEntry.set((String)cell.getRowKey(), money2formula.p1);
                        otherEntry.set("calculatecontent", money2formula.p2);
                        otherEntry.set("isdefaultcurrency", (Object)"0");
                        sj.add((CharSequence)money2formula.p2);
                        rateDiffs.add(otherEntry);
                    }
                });
            }
            mainEntry.set("calculatecontent", (Object)sj.toString());
        }
        return rateDiffs;
    }

    private Pair<BigDecimal, String> dealScale(Pair<BigDecimal, String> money2formula, Long currencyId, Long accountId) {
        int prec = CurrencyScaleHandler.getNewCurrencyScale(this.modelId, MemberReader.findScenaMemberById((String)this.sctx.getModelNumber(), (Long)this.scene).getNumber(), MemberReader.findCurrencyMemberById((String)this.sctx.getModelNumber(), (Long)currencyId).getNumber(), MemberReader.findMemberById((long)this.modelId, (String)"bcm_accountmembertree", (Long)accountId).getNumber());
        BigDecimal money = ((BigDecimal)money2formula.p1).setScale(prec, 4);
        return Pair.onePair((Object)money, (Object)("ROUND(" + (String)money2formula.p2 + "," + prec + ")=" + money.stripTrailingZeros().toPlainString() + ";"));
    }

    private Pair<Pair<BigDecimal, String>, Map<String, Pair<BigDecimal, String>>> integrationData(Table.Cell<String, String, Map<String, Pair<BigDecimal, String>>> cell) {
        Map<String, Pair> otherCurrValue = ((Map)cell.getValue()).keySet().stream().filter(p -> AdjustConvertUtil.getDiffCreateTest().test((BigDecimal)((Pair)((Map)cell.getValue()).get((Object)p)).p1)).collect(Collectors.toMap(p -> p, p -> (Pair)((Map)cell.getValue()).get(p)));
        Pair mainValue = otherCurrValue.remove("isdefaultcurrency");
        if (mainValue == null && otherCurrValue.isEmpty()) {
            return null;
        }
        return Pair.onePair((Object)mainValue, otherCurrValue);
    }

    private Table<String, String, Map<String, Pair<BigDecimal, String>>> groupByCombKey2dc(List<DynamicObject> convertDatas, Map<String, DynamicObject> tempMap) {
        RateModel rateModel = null;
        HashBasedTable result = HashBasedTable.create();
        HashMap<String, String> dimMap = new HashMap<String, String>(16);
        boolean isdefaultcurrency = true;
        for (DynamicObject convertData : convertDatas) {
            Pair pair;
            BigDecimal debitValue;
            BigDecimal creditValue;
            StringBuilder creditBuilder = new StringBuilder();
            StringBuilder debitBuilder = new StringBuilder();
            dimMap.clear();
            Long tarCurrId = AdjustmentServiceHelper.transformDimid(convertData, "currency");
            String srcCurr = MemberReader.findCurrencyMemberById((String)this.sctx.getModelNumber(), (Long)AdjustmentServiceHelper.transformDimid(convertData, "adjust.cvtbeforecurrency")).getNumber();
            String tarCurr = MemberReader.findCurrencyMemberById((String)this.sctx.getModelNumber(), (Long)tarCurrId).getNumber();
            this.sctx.getDimensions().forEach(p -> dimMap.put(p.getNumber(), MemberReader.findMemberById((long)this.getModelId(), (String)p.getEntity(), (Long)AdjustmentServiceHelper.transformDimid(convertData, p.getFieldmapped())).getNumber()));
            if (dimMap.size() != this.sctx.getDimensions().size() || dimMap.containsValue(IDNumberTreeNode.NotFoundTreeNode.getNumber())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6570\u636e\u4e2d\u7684\u7ef4\u5ea6\u6210\u5458\u662f\u5426\u5b8c\u6574\uff0c\u7ef4\u5ea6\u7ec4\u5408\u4e3a\uff1a%s\u3002", (String)"AdjustRateDiffCreateService_4", (String)"fi-bcm-business", (Object[])new Object[0]), ((Object)dimMap).toString()));
            }
            isdefaultcurrency = convertData.getBoolean("isdefaultcurrency");
            String combKey = String.join((CharSequence)"_", dimMap.entrySet().stream().filter(p -> !"ChangeType".equals(p.getKey()) && !"Currency".equals(p.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet()));
            if (isdefaultcurrency) {
                tempMap.put(combKey, convertData);
            }
            if (AdjustmentServiceHelper.searchSchemeByDimComb(AdjustOperationHelper.createVersionParam(this.modelId, DynUtils.getBaseId((String)this.getClass().getName(), (DynamicObject)convertData, (String)"scenario"), DynUtils.getBaseId((String)this.getClass().getName(), (DynamicObject)convertData, (String)"year"), DynUtils.getBaseId((String)this.getClass().getName(), (DynamicObject)convertData, (String)"period")), dimMap, this.rateCvtRiffSchemes, false) != null || StringUtils.equals((CharSequence)srcCurr, (CharSequence)tarCurr)) continue;
            BaseData baseData = new BaseData(this.modelId, this.scene, this.tarYear, this.tarPeriod);
            Long orgId = DynUtils.getBaseId((DynamicObject)convertData, (String)"entity");
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)this.modelId, (Long)orgId);
            rateModel = ExchangeQueryHelper.getRateData(baseData, SimpleVo.newOne(orgNode), srcCurr, tarCurr);
            BigDecimal accRateValue = rateModel.getRateByNumber(this.queryAccRateNumber(AdjustmentServiceHelper.transformDimid(convertData, "account")));
            if (BigDecimal.ZERO.compareTo(accRateValue) != 0) {
                accRateValue = rateModel.isMultiply() ? accRateValue : BigDecimal.ONE.divide(accRateValue, 16, 4);
            }
            BigDecimal rateAnnexed = convertData.getBigDecimal("rate");
            BigDecimal rateSubtract = accRateValue.subtract(rateAnnexed);
            BigDecimal aggOprt = this.queryChangeTypeAgg(AdjustmentServiceHelper.transformDimid(convertData, "changetype"));
            BigDecimal cvtbeforedebit = convertData.getBigDecimal("cvtbeforedebit");
            BigDecimal cvtbeforecredit = convertData.getBigDecimal("cvtbeforecredit");
            if (cvtbeforecredit != null && cvtbeforecredit.compareTo(BigDecimal.ZERO) != 0) {
                creditValue = cvtbeforecredit.multiply(rateSubtract).multiply(aggOprt);
                creditBuilder.append(String.format(RATE_SUB_FORMUAL, "CVT_BEFORE_CREDIT", cvtbeforecredit.stripTrailingZeros().toPlainString(), accRateValue.stripTrailingZeros().toPlainString(), rateAnnexed.stripTrailingZeros().toPlainString(), aggOprt.stripTrailingZeros().toPlainString()));
            } else {
                creditValue = BigDecimal.ZERO;
                creditBuilder.append("0");
            }
            if (cvtbeforedebit != null && cvtbeforedebit.compareTo(BigDecimal.ZERO) != 0) {
                debitValue = cvtbeforedebit.multiply(rateSubtract).multiply(aggOprt);
                debitBuilder.append(String.format(RATE_SUB_FORMUAL, "CVT_BEFORE_DEBIT", cvtbeforedebit.stripTrailingZeros().toPlainString(), accRateValue.stripTrailingZeros().toPlainString(), rateAnnexed.stripTrailingZeros().toPlainString(), aggOprt.stripTrailingZeros().toPlainString()));
            } else {
                debitValue = BigDecimal.ZERO;
                debitBuilder.append("0");
            }
            IDNumberTreeNode accNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)AdjustmentServiceHelper.transformDimid(convertData, "account"));
            if (DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.getOIndex().equals(accNode.getProperty("drcrdirect"))) {
                pair = Pair.onePair((Object)debitValue.add(creditValue.negate()), (Object)debitBuilder.append("-").append((CharSequence)creditBuilder).toString());
                this.addValueMap((Table<String, String, Map<String, Pair<BigDecimal, String>>>)result, "debit", combKey, (Pair<BigDecimal, String>)pair, isdefaultcurrency ? "isdefaultcurrency" : Long.toString(tarCurrId));
                continue;
            }
            pair = Pair.onePair((Object)creditValue.add(debitValue.negate()), (Object)creditBuilder.append("-").append((CharSequence)debitBuilder).toString());
            this.addValueMap((Table<String, String, Map<String, Pair<BigDecimal, String>>>)result, "credit", combKey, (Pair<BigDecimal, String>)pair, isdefaultcurrency ? "isdefaultcurrency" : Long.toString(tarCurrId));
        }
        return result;
    }

    private void addValueMap(Table<String, String, Map<String, Pair<BigDecimal, String>>> result, String dc, String combKey, Pair<BigDecimal, String> value, String currencyNum) {
        if (value != null && BigDecimal.ZERO.compareTo((BigDecimal)value.p1) != 0) {
            Map currMap;
            Pair bigDecimalStringPair;
            if (!result.contains((Object)dc, (Object)combKey)) {
                result.put((Object)dc, (Object)combKey, new HashMap());
            }
            if ((bigDecimalStringPair = (Pair)(currMap = (Map)result.get((Object)dc, (Object)combKey)).get(currencyNum)) == null) {
                currMap.put(currencyNum, value);
            } else {
                currMap.put(currencyNum, Pair.onePair((Object)((BigDecimal)bigDecimalStringPair.p1).add((BigDecimal)value.p1), (Object)((String)bigDecimalStringPair.p2 + "+" + (String)value.p2)));
            }
            result.put((Object)dc, (Object)combKey, (Object)currMap);
        }
    }

    private String queryAccRateNumber(long accId) {
        return (String)ThreadCache.get((Object)(accId + "entryrate"), () -> {
            IDNumberTreeNode dimNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_accountmembertree", (Long)accId);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(dimNode)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79d1\u76eeID\u4e0d\u5b58\u5728\uff1a%d\u3002", (String)"AdjustRateDiffCreateService_2", (String)"fi-bcm-business", (Object[])new Object[0]), accId));
            }
            return AdjustConvertUtil.getRateNumberByEnumValue((String)dimNode.getProperty("entryrate"));
        });
    }

    private BigDecimal queryChangeTypeAgg(long ctId) {
        return (BigDecimal)ThreadCache.get((Object)(ctId + "ChangeTypeAgg"), () -> {
            IDNumberTreeNode dimNode = MemberReader.findMemberById((long)this.getModelId(), (String)"bcm_changetypemembertree", (Long)ctId);
            if (IDNumberTreeNode.NotFoundTreeNode.equals(dimNode)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578bID\u4e0d\u5b58\u5728\uff1a%d\u3002", (String)"AdjustRateDiffCreateService_3", (String)"fi-bcm-business", (Object[])new Object[0]), ctId));
            }
            AggOprtEnum aggoprt = AggOprtEnum.getAggOprtEnumByname((String)dimNode.getAggOprt());
            if (aggoprt == AggOprtEnum.SUBSTRACT) {
                return BigDecimal.ONE.negate();
            }
            return BigDecimal.ONE;
        });
    }

    private Long getModelId() {
        return this.modelId;
    }
}

