/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.convert;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertPathNode;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustConvertUtil;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.RateModel;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.RateCvtSetScheme;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.dynamicObjectModel.IDynamicObjectModel;
import kd.fi.bcm.common.enums.ChangewayEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class NewAdjustConvertService {
    private final AdjustOperationContext _ctx;
    private List<RateCvtSetScheme> rateCvtSetSchemes;
    private Map<Integer, List<DynamicObject>> userDefindedList;
    private Table<String, Long, Set<Long>> multipleCurrencyTable = HashBasedTable.create();
    private WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());

    public NewAdjustConvertService(AdjustOperationContext _ctx) {
        this._ctx = _ctx;
    }

    public List<RateCvtSetScheme> getRateCvtSetSchemes() {
        if (this.rateCvtSetSchemes == null) {
            this.rateCvtSetSchemes = AdjustConvertUtil.queryRateCvtSetSchemes(this._ctx().getModelId(), 0);
        }
        return this.rateCvtSetSchemes;
    }

    public Map<Integer, List<DynamicObject>> getUserDefindedList() {
        if (this.userDefindedList == null) {
            boolean isUseNewgetUserDefindedList = ConfigServiceHelper.getBoolParam(this._ctx().getModelId(), "isUseNewgetUserDefindedList");
            this.userDefindedList = AdjustConvertUtil.createSeqGroup(AdjustConvertUtil.getUserDefindedList(this._ctx().getModelId(), this._ctx().getFyId(), this._ctx().getScenarioId(), this._ctx().getPeriodId()), isUseNewgetUserDefindedList);
        }
        return this.userDefindedList;
    }

    public void prepareConvertData(List<IDynamicObjectModel> adjustDys) {
        HashMultimap org2BussTypeMap = HashMultimap.create();
        for (IDynamicObjectModel adjust : adjustDys) {
            if (!OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process")) || !AdjustOperationHelper.isMultipleCurrencyElim(adjust)) continue;
            org2BussTypeMap.put((Object)adjust.getBaseDataId("entity"), (Object)adjust.getString("bussnesstype"));
        }
        if (org2BussTypeMap.isEmpty()) {
            return;
        }
        this.prepareRateData(org2BussTypeMap.keySet());
        this.prepareMultipleCurrencyData((HashMultimap<Long, String>)org2BussTypeMap);
    }

    public void prepareMultipleCurrencyData(HashMultimap<Long, String> pk2BussType) {
        if (CollectionUtil.isEmpty((Collection)pk2BussType.keySet())) {
            return;
        }
        List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bcm_entrycvtcurrency", (QFilter[])QFilter.of((String)"model = ?", (Object[])new Object[]{this._ctx().getModelId()}).toArray(), null, (int)-1);
        DynamicObject[] cvtSchemes = BusinessDataServiceHelper.load((Object[])queryPrimaryKeys.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_entrycvtcurrency"));
        pk2BussType.forEach((orgId, bussinessType) -> {
            if (!this.multipleCurrencyTable.contains(bussinessType, orgId)) {
                this.multipleCurrencyTable.put(bussinessType, orgId, AdjustConvertUtil.getMultipleCurrency(this._ctx().getModelId(), cvtSchemes, orgId, bussinessType));
            }
        });
    }

    public void prepareRateData(Set<Long> orgSet) {
        orgSet.remove(0L);
        if (CollectionUtil.isEmpty(orgSet)) {
            return;
        }
        BaseData baseData = new BaseData((Long)this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId());
        ExchangeQueryHelper.getMultiRateDatasByOrgIds(baseData, orgSet, CollectionUtils.EMPTY_COLLECTION, CollectionUtils.EMPTY_COLLECTION);
    }

    public void singleConvert(IDynamicObjectModel adjust, List<IDynamicObjectModel> entries) {
        this.singleConvert(adjust, entries, true);
    }

    public void singleConvert(IDynamicObjectModel adjust, List<IDynamicObjectModel> entries, boolean needPrepareConvertData) {
        if (CollectionUtil.isEmpty(entries) || !OrgRelaProcessMembPool.isRelaProcess((String)adjust.getString("process")) || !AdjustOperationHelper.isMultipleCurrencyElim(adjust)) {
            return;
        }
        if (needPrepareConvertData) {
            this.prepareConvertData(Collections.singletonList(adjust));
        }
        long cvtbeforecurrency = adjust.getBaseDataId("cvtbeforecurrency");
        AdjustConvertPathNode convertPath = new AdjustConvertPathNode();
        entries.stream().filter(entry -> this.checkConvertAvailable(adjust, (IDynamicObjectModel)entry)).forEach(entry -> {
            convertPath.setCvtOrg(entry.getBaseDataId("entity"));
            convertPath.setSrcCurrency(cvtbeforecurrency);
            convertPath.setTarCurrency(entry.getBaseDataId("currency"));
            for (Dimension dim : this._ctx().getSctx().getDimensions()) {
                IDNumberTreeNode dimNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)dim.getNumber(), (long)entry.getBaseDataId(dim.getFieldmapped()));
                convertPath.setDimComb(dim.getNumber(), dimNode.getId());
                convertPath.setDimNumComb(dim.getNumber(), dimNode.getNumber());
            }
            BigDecimal rateValue = this.resolveConvertPathRate(convertPath);
            String accountNum = convertPath.getDimNumCombMap().get("Account");
            int prec = CurrencyScaleHandler.getNewCurrencyScale(this._ctx().getModelId(), this._ctx().getScenariodNum(), MemberReader.findCurrencyMemberById((String)this._ctx().getModelNum(), (Long)convertPath.getSrcCurrency()).getNumber(), accountNum);
            BigDecimal beforeDebit = entry.getBigDecimal("cvtbeforedebit").setScale(prec, 4);
            BigDecimal beforeCredit = entry.getBigDecimal("cvtbeforecredit").setScale(prec, 4);
            BigDecimal summoney = entry.getBigDecimal("cvtbeforesummoney").setScale(prec, 4);
            entry.set("rate", (Object)rateValue);
            entry.set("cvtbeforedebit", (Object)beforeDebit);
            entry.set("cvtbeforecredit", (Object)beforeCredit);
            entry.set("cvtbeforesummoney", (Object)summoney);
            prec = CurrencyScaleHandler.getNewCurrencyScale(this._ctx().getModelId(), this._ctx().getScenariodNum(), convertPath.getDimNumCombMap().get("Currency"), accountNum);
            entry.set("debit", (Object)beforeDebit.multiply(rateValue).setScale(prec, 4));
            entry.set("credit", (Object)beforeCredit.multiply(rateValue).setScale(prec, 4));
            entry.set("summoney", (Object)summoney.multiply(rateValue).setScale(prec, 4));
        });
    }

    public BigDecimal resolveConvertPathRate(AdjustConvertPathNode convertPath) {
        try {
            this.checkConvertPathNotNull(convertPath);
            IDNumberTreeNode accNode = convertPath.queryDimMemNode(this._ctx().getModelId(), "Account");
            if (StringUtils.isEmpty((CharSequence)((CharSequence)accNode.getProperty("entryrate")))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7ef4\u5ea6\u6210\u5458\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u672a\u5b9a\u4e49\u5206\u5f55\u7528\u6c47\u7387\u3002", (String)"AdjustConvertService_13", (String)"fi-bcm-business", (Object[])new Object[0]), accNode.getNumber()));
            }
            BigDecimal resultRate = BigDecimal.ONE;
            IDNumberTreeNode srcCurrNode = MemberReader.findCurrencyMemberById((String)this._ctx().getModelNum(), (Long)convertPath.getSrcCurrency());
            IDNumberTreeNode tarCurrNode = MemberReader.findCurrencyMemberById((String)this._ctx().getModelNum(), (Long)convertPath.getTarCurrency());
            if (srcCurrNode.getNumber().equals(tarCurrNode.getNumber())) {
                return resultRate;
            }
            Long orgId = convertPath.getCvtOrg();
            BaseData baseData = (BaseData)ThreadCache.get((Object)"resolveBaseData", () -> new BaseData((Long)this._ctx().getModelId(), this._ctx().getScenarioId(), this._ctx().getFyId(), this._ctx().getPeriodId()));
            RateModel rateModel = (RateModel)BcmThreadCache.get((Object)orgId, (Object)srcCurrNode.getNumber(), (Object)tarCurrNode.getNumber(), () -> ExchangeQueryHelper.getRateData(baseData, orgId, srcCurrNode.getNumber(), tarCurrNode.getNumber()));
            BigDecimal accRateValue = rateModel.getRateByNumber(AdjustConvertUtil.getRateNumberByEnumValue((String)accNode.getProperty("entryrate")));
            String rateAnnexedNumber = this.getUserDefindedRateNumber(convertPath, (Pair<Long, String>)Pair.onePair((Object)srcCurrNode.getId(), (Object)srcCurrNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)tarCurrNode.getId(), (Object)tarCurrNode.getNumber()));
            if (StringUtil.isEmpty((CharSequence)rateAnnexedNumber)) {
                IDNumberTreeNode changeNode = convertPath.queryDimMemNode(this._ctx().getModelId(), "ChangeType");
                resultRate = ConvertUtil.getRate(accNode.getNumber(), changeNode.getNumber(), ExchangeEnum.getExchangeEnumByIndex((String)((String)accNode.getProperty("exchange"))), ChangewayEnum.getChangewayEnumByIndexkdec((String)((String)changeNode.getProperty("changeway"))), rateModel);
            } else if (!"hasCvtNumber".equals(rateAnnexedNumber)) {
                resultRate = rateModel.getRateByNumber(rateAnnexedNumber);
            }
            if (resultRate == null) {
                resultRate = accRateValue;
            }
            return BigDecimal.ZERO.compareTo(resultRate) == 0 ? resultRate : (rateModel.isMultiply() ? resultRate : BigDecimal.ONE.divide(resultRate, 15, 4));
        }
        catch (Throwable t) {
            this.log.error(t);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6298\u7b97\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a\uff1a%2$s", (String)"AdjustConvertService_5", (String)"fi-bcm-business", (Object[])new Object[0]), convertPath.getShowMsg(this._ctx().getModelId()), t.getMessage()));
        }
    }

    private void checkConvertPathNotNull(AdjustConvertPathNode convertPath) {
        HashSet<String> emptyFieldSet = new HashSet<String>(5);
        if (!LongUtil.isvalidLong((Object)convertPath.getSrcCurrency())) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u6e90\u5e01\u79cd", (String)"AdjustConvertService_7", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!LongUtil.isvalidLong((Object)convertPath.getTarCurrency())) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u76ee\u6807\u5e01\u79cd", (String)"AdjustConvertService_8", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!LongUtil.isvalidLong((Object)convertPath.getCvtOrg())) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AdjustConvertService_9", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!LongUtil.isvalidLong((Object)convertPath.getDimComb().get("Account"))) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AdjustConvertService_10", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!LongUtil.isvalidLong((Object)convertPath.getDimComb().get("ChangeType"))) {
            emptyFieldSet.add(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"AdjustConvertService_11", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (!emptyFieldSet.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustConvertService_12", (String)"fi-bcm-business", (Object[])new Object[0]), emptyFieldSet));
        }
    }

    private String getUserDefindedRateNumber(AdjustConvertPathNode convertPath, Pair<Long, String> srcCur, Pair<Long, String> tarCur) {
        Map<String, String[]> scopeMap = this._ctx().getSctx().getDimensions().parallelStream().collect(Collectors.toMap(Dimension::getNumber, p -> new String[]{convertPath.getDimNumCombMap().get(p.getNumber())}));
        scopeMap.put("Year", new String[]{this._ctx().getFyNum()});
        scopeMap.put("Period", new String[]{this._ctx().getPeriodNum()});
        PairList path = new PairList();
        path.addPair(srcCur.p1, srcCur.p2);
        path.addPair(tarCur.p1, tarCur.p2);
        IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)"Entity", (long)convertPath.getCvtOrg());
        return ConvertServiceHelper.getUserDefindedRateNumber(path.toList(), (Pair<Long, String>)Pair.onePair((Object)this._ctx.getModelId(), (Object)this._ctx().getModelNum()), (Pair<Long, String>)Pair.onePair((Object)orgNode.getId(), (Object)orgNode.getNumber()), (Pair<Long, String>)Pair.onePair((Object)this._ctx().getFyId(), (Object)this._ctx().getFyNum()), (Pair<Long, String>)Pair.onePair((Object)this._ctx().getPeriodId(), (Object)this._ctx().getPeriodNum()), (Pair<Long, String>)Pair.onePair((Object)this._ctx().getScenarioId(), (Object)this._ctx().getScenariodNum()), scopeMap, this.getUserDefindedList());
    }

    private boolean checkConvertAvailable(IDynamicObjectModel adjust, IDynamicObjectModel entry) {
        Set mutiCurs;
        if (AdjustConvertUtil.getDiffTest().test(entry.getInt("entryrowtype"))) {
            return false;
        }
        if (entry.getBaseDataId("currency") == 0L) {
            return false;
        }
        if (ElimRptAdjSourceTypeEnum.SHARE.getValue() == adjust.getInt("sourcetype") && AdjustConvertUtil.isBigDecimalEmpty(entry.getBigDecimal("rate")) && ((mutiCurs = (Set)this.multipleCurrencyTable.get((Object)adjust.getString(""), (Object)adjust.getBaseDataId("entity"))) == null || !mutiCurs.contains(entry.getBaseDataId("currency")))) {
            return true;
        }
        return AdjustmentServiceHelper.searchSchemeByDimComb(AdjustOperationHelper.createVersionParam(this._ctx().getModelId(), entry.getBaseDataId("scenario"), entry.getBaseDataId("year"), entry.getBaseDataId("period")), this.getCombKey(entry), this.getRateCvtSetSchemes(), false) == null;
    }

    private Map<String, String> getCombKey(IDynamicObjectModel entry) {
        return this._ctx().getSctx().getDimensions().stream().collect(Collectors.toMap(Dimension::getNumber, p -> BcmThreadCache.findNodeById((String)this._ctx().getModelNum(), (String)p.getNumber(), (long)entry.getBaseDataId(p.getFieldmapped())).getNumber()));
    }

    public AdjustOperationContext _ctx() {
        return this._ctx;
    }
}

