/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.factory.adjustLockOper;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.BcmMutexLockDataInfo;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.IOperLocker;
import kd.fi.bcm.common.encrypt.Encrypt;
import kd.fi.bcm.common.encrypt.EncryptFactory;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class AdjustDataMutexOperLocker
implements IOperLocker {
    private static final int MAX_LOCKNUM = 800;
    protected static final Encrypt encrypt = EncryptFactory.getInstance((String)"Encrypt_Five");

    @Override
    public Map<String, Boolean> batchRequire(List<Map<String, Object>> lockers) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(lockers.size());
        try {
            this.encryptLockers(lockers);
            try (DataMutex dataMutex = MutexFactory.createDataMutex();){
                BatchProcessHelper.batchConsume(lockers, (int)800, lockGroupList -> resultMap.putAll(dataMutex.batchrequire(lockGroupList)));
            }
        }
        catch (IOException e) {
            throw new KDBizException("accure IOException when closing data mutex!".concat(AdjustmentServiceHelper.toString_Adj(e)));
        }
        return this.unEncryptLockers(lockers, resultMap);
    }

    @Override
    public Map<String, Boolean> batchRelease(List<Map<String, Object>> lockers) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(lockers.size());
        try {
            this.encryptLockers(lockers);
            try (DataMutex dataMutex = MutexFactory.createDataMutex();){
                BatchProcessHelper.batchConsume(lockers, (int)800, lockGroupList -> resultMap.putAll(dataMutex.batchRelease(lockGroupList)));
            }
        }
        catch (IOException e) {
            throw new KDBizException("accure IOException when closing data mutex!".concat(AdjustmentServiceHelper.toString_Adj(e)));
        }
        return this.unEncryptLockers(lockers, resultMap);
    }

    @Override
    public Map<String, BcmMutexLockDataInfo> getAllLockInfos(String lockerType) {
        throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u5e73\u53f0\u7684\u7f51\u7edc\u4e92\u65a5\u754c\u9762\u624d\u80fd\u6b63\u5e38\u83b7\u53d6\u9501\u7684\u4fe1\u606f\u3002", (String)"AdjustDataMutexOperLocker_1", (String)"fi-bcm-business", (Object[])new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getAllKeys(String lockerType) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Set<String> set = dataMutex.getLockInfo().keySet();
            return set;
        }
        catch (IOException t) {
            throw new KDBizException("accure IOException when closing data mutex!".concat(AdjustmentServiceHelper.toString_Adj(t)));
        }
    }

    @Override
    public List<String> getKeysWithPrefix(String lockerType, String prefix) {
        Set<String> allKeys = this.getAllKeys(lockerType);
        return StringUtils.isEmpty((String)prefix) || CollectionUtil.isEmpty(allKeys) ? Collections.emptyList() : allKeys.stream().filter(key -> key.startsWith(prefix)).collect(Collectors.toList());
    }

    private void encryptLockers(List<Map<String, Object>> lockers) {
        lockers.forEach(locker -> {
            String dataObjId = locker.getOrDefault("dataObjId", "").toString();
            String groupId = locker.getOrDefault("groupId", "").toString();
            locker.put("dataObjId", encrypt.ecode(dataObjId));
            locker.put("groupId", encrypt.ecode(groupId));
            locker.put("srcDataObjId", dataObjId);
        });
    }

    private Map<String, Boolean> unEncryptLockers(List<Map<String, Object>> lockers, Map<String, Boolean> resultMap) {
        HashMap<String, Boolean> newResultMap = new HashMap<String, Boolean>(resultMap.size());
        lockers.forEach(locker -> {
            String dataObjId = locker.getOrDefault("dataObjId", "").toString();
            String srcDataObjId = locker.getOrDefault("srcDataObjId", "").toString();
            newResultMap.put(srcDataObjId, resultMap.getOrDefault(dataObjId, false));
        });
        return newResultMap;
    }
}

