/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.factory.adjustLockOper;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.BcmMutexLockDataInfo;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.IOperLocker;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class AdjustRedisOperLocker
implements IOperLocker {
    private static final int LOCK_TIME = 180000;
    private static final int CACHE_KEEP_TIME_S = 10800000;
    private static final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bcm_adjDimLockCache", new DistributeCacheHAPolicy(true, true));
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustRedisOperLocker.class);

    @Override
    public Map<String, Boolean> batchRequire(List<Map<String, Object>> lockers) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(lockers.size());
        Map<String, List<Map>> lockerMap = lockers.stream().peek(locker -> resultMap.put(locker.getOrDefault("dataObjId", "").toString(), false)).collect(Collectors.groupingBy(p -> p.getOrDefault("groupId", "defaultgroupId").toString()));
        lockerMap.forEach((groupId, lockerList) -> {
            String desc = ((Map)lockerList.get(0)).getOrDefault("operationKey", "").toString();
            String entityKey = ((Map)lockerList.get(0)).getOrDefault("entityKey", "").toString();
            boolean isStrict = ((Map)lockerList.get(0)).getOrDefault("isStrict", false);
            PlatUtil.tryDLock(groupId, desc, !isStrict, 180000, dc -> {
                HashMap cacheLockInfos = new HashMap(lockerList.size());
                Map<String, String> oldCacheLockInfoMap = this.getOldCacheLockInfos(entityKey);
                lockerList.forEach(locker -> {
                    String dataObjId = locker.getOrDefault("dataObjId", "").toString();
                    String lockerKey = groupId + "_" + dataObjId;
                    try {
                        if (oldCacheLockInfoMap.containsKey(lockerKey)) {
                            resultMap.put(dataObjId, false);
                        } else {
                            resultMap.put(dataObjId, true);
                            cacheLockInfos.put(lockerKey, SerializationUtils.serializeToBase64((Object)this.buildLockInfo((Map<String, Object>)locker)));
                        }
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                        resultMap.put(dataObjId, false);
                        cacheLockInfos.remove(lockerKey);
                    }
                });
                if (!cacheLockInfos.isEmpty()) {
                    redisCache.put(entityKey, cacheLockInfos, 10800000);
                }
            });
        });
        return resultMap;
    }

    @Override
    public Map<String, Boolean> batchRelease(List<Map<String, Object>> lockers) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(lockers.size());
        Map<String, List<Map>> lockerMap = lockers.stream().peek(locker -> resultMap.put(locker.getOrDefault("dataObjId", "").toString(), false)).collect(Collectors.groupingBy(p -> p.getOrDefault("groupId", "defaultgroupId").toString()));
        lockerMap.forEach((groupId, lockerList) -> {
            String desc = ((Map)lockerList.get(0)).getOrDefault("operationKey", "").toString();
            String entityKey = ((Map)lockerList.get(0)).getOrDefault("entityKey", "").toString();
            boolean isStrict = ((Map)lockerList.get(0)).getOrDefault("isStrict", false);
            PlatUtil.tryDLock(groupId, desc, !isStrict, 180000, dc -> {
                Map<String, String> oldCacheLockInfoMap = this.getOldCacheLockInfos(entityKey);
                String[] removeCacheLocks = (String[])lockerList.stream().map(locker -> {
                    String dataObjId = locker.getOrDefault("dataObjId", "").toString();
                    String lockerKey = groupId + "_" + dataObjId;
                    resultMap.put(lockerKey, true);
                    return lockerKey;
                }).filter(oldCacheLockInfoMap::containsKey).toArray(String[]::new);
                if (removeCacheLocks.length > 0) {
                    redisCache.remove(entityKey, removeCacheLocks);
                }
            });
        });
        return resultMap;
    }

    @Override
    public Map<String, BcmMutexLockDataInfo> getAllLockInfos(String lockerType) {
        return this.getOldCacheLockInfos(lockerType).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> (BcmMutexLockDataInfo)SerializationUtils.deSerializeFromBase64((String)((String)p.getValue()))));
    }

    @Override
    public Set<String> getAllKeys(String lockerType) {
        return this.getOldCacheLockInfos(lockerType).keySet();
    }

    @Override
    public List<String> getKeysWithPrefix(String lockerType, String prefix) {
        return redisCache.getKeysWithPrefix(lockerType, prefix);
    }

    private Map<String, String> getOldCacheLockInfos(String lockerType) {
        return Optional.ofNullable(redisCache.getAll(lockerType)).orElseGet(Maps::newHashMap);
    }

    private BcmMutexLockDataInfo buildLockInfo(Map<String, Object> mutexRequire) {
        String dataObjId = (String)mutexRequire.get("dataObjId");
        String operationKey = mutexRequire.getOrDefault("operationKey", "").toString();
        String entityKey = mutexRequire.getOrDefault("entityKey", "").toString();
        String groupId = mutexRequire.getOrDefault("groupId", "").toString();
        RequestContext rc = RequestContext.get();
        BcmMutexLockDataInfo lockInfo = new BcmMutexLockDataInfo(dataObjId, entityKey, groupId, operationKey);
        lockInfo.setUserId(rc.getUserId());
        lockInfo.setLockedTime(String.valueOf(System.currentTimeMillis()));
        lockInfo.setClient(rc.getClient());
        lockInfo.setGlobalSession(rc.getGlobalSessionId());
        return lockInfo;
    }
}

