/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.formula;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.fi.bcm.business.adjust.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.AcctCfFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.AcctFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.DefaultFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.ExcRateFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.GetJLFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.IFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.RefFormulaHandler;
import kd.fi.bcm.business.adjust.formula.handler.VFormulaHandler;
import kd.fi.bcm.business.adjust.model.CalcLine;
import kd.fi.bcm.business.adjust.model.CommDimensionEntry;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;

public class AdjustFormulaParseHelper {
    public static final String SIGN_CURSTR = "$Cur";
    private static final Map<String, IFormulaHandler<AdjustOperationContext, CalcLine>> registerFormulaHandler = new HashMap<String, IFormulaHandler<AdjustOperationContext, CalcLine>>(6);
    private static final DefaultFormulaHandler defaultFormulaHandler = new DefaultFormulaHandler();

    private static void registerFormulaHandler(AbstractFormulaHandler formulaHandler) {
        registerFormulaHandler.put(formulaHandler.getName(), formulaHandler);
    }

    public static String getCurEntryDimMemStr(ICalContext _ctx, CalcLine line, String dimNum) {
        String modelNum = MemberReader.findModelNumberById((Object)_ctx.getModelId());
        switch (dimNum) {
            case "Period": {
                return BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)_ctx.getPeriodId()).getNumber();
            }
            case "Year": {
                return BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)_ctx.getYearId()).getNumber();
            }
            case "Scenario": {
                return BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)_ctx.getScenarioId()).getNumber();
            }
            case "Process": {
                return line.getTmp().getProcess();
            }
            case "Entity": {
                return BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)line.getOrgId()).getParent_SonNumber();
            }
        }
        return (String)BcmThreadCache.get((Object)"getCurEntryDimMemStr", (Object)line.getTmp().getNumber(), (Object)line.getRow(), (Object)dimNum, () -> {
            Optional<CommDimensionEntry> first;
            Long memId = (Long)line.getEntry().getRowData().get(dimNum);
            if (memId == null && (first = line.getTmp().getCommDimensionEntries().stream().filter(comm -> dimNum.equalsIgnoreCase(comm.getDimension().getNumber())).findFirst()).isPresent() && first.get().getMember() != null) {
                memId = first.get().getMember().getId();
            }
            return BcmThreadCache.findNodeById((String)modelNum, (String)dimNum, (long)LongUtil.toLong((Object)memId)).getNumber();
        });
    }

    public static SchemeContext getSctx(Long modelId) {
        return SchemeContext.getInstance(modelId);
    }

    public static void walkBeforeCalExpress(ICalContext _ctx, IFormula f, CalcLine line) {
        registerFormulaHandler.getOrDefault(f.getName().toUpperCase(Locale.ENGLISH), defaultFormulaHandler).dealBeforeCalFormula(_ctx, f, line);
    }

    public static String handelParam(Object p) {
        return p == null ? "" : p.toString().trim().replace("\"", "");
    }

    public static Expression walkExpress(AdjustOperationContext ctx, Expression expr, CalcLine line) {
        return AdjustFormulaParseHelper.walkExpress(expr, exr -> {
            if (exr instanceof ReferenceExpr) {
                exr = registerFormulaHandler.get("Ref").dealFormula(ctx, (Expression)exr, line);
            } else if (exr instanceof FunctionExpr) {
                String funcName = ((FunctionExpr)exr).getFuncionName();
                IFormulaHandler<AdjustOperationContext, CalcLine> handler = registerFormulaHandler.get(funcName);
                if (handler == null) {
                    exr = defaultFormulaHandler.dealFormula(ctx, (Expression)exr, line);
                } else {
                    List params = ((FunctionExpr)exr).getParameters();
                    for (int i = 0; i < params.size(); ++i) {
                        Object childExpr = params.get(i);
                        if (!(childExpr instanceof Expression)) continue;
                        params.set(i, AdjustFormulaParseHelper.walkExpress(ctx, (Expression)childExpr, line));
                    }
                    exr = handler.dealFormula(ctx, (Expression)exr, line);
                }
            }
            return exr;
        });
    }

    @SDKMark
    public static Expression walkExpress(Expression expr, Function<Expression, Expression> fDeal) {
        if (expr instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)expr).setLeft(AdjustFormulaParseHelper.walkExpress(((BinaryOperationExpr)expr).getLeft(), fDeal));
            ((BinaryOperationExpr)expr).setRight(AdjustFormulaParseHelper.walkExpress(((BinaryOperationExpr)expr).getRight(), fDeal));
        } else if (expr instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)expr).setOperand(AdjustFormulaParseHelper.walkExpress(((UnaryOperationExpr)expr).getOperand(), fDeal));
        } else {
            expr = fDeal.apply(expr);
        }
        return expr;
    }

    public static Expression walkDeepExpress(Expression expr, Function<Expression, Expression> fDeal) {
        if (expr instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)expr).setLeft(AdjustFormulaParseHelper.walkDeepExpress(((BinaryOperationExpr)expr).getLeft(), fDeal));
            ((BinaryOperationExpr)expr).setRight(AdjustFormulaParseHelper.walkDeepExpress(((BinaryOperationExpr)expr).getRight(), fDeal));
        } else if (expr instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)expr).setOperand(AdjustFormulaParseHelper.walkDeepExpress(((UnaryOperationExpr)expr).getOperand(), fDeal));
        } else if (expr instanceof FunctionExpr) {
            List params = ((FunctionExpr)expr).getParameters();
            for (int i = 0; i < params.size(); ++i) {
                Object childExpr = params.get(i);
                if (!(childExpr instanceof Expression)) continue;
                params.set(i, AdjustFormulaParseHelper.walkDeepExpress((Expression)childExpr, fDeal));
            }
            expr = fDeal.apply(expr);
        } else {
            expr = fDeal.apply(expr);
        }
        return expr;
    }

    static {
        AdjustFormulaParseHelper.registerFormulaHandler(new VFormulaHandler());
        AdjustFormulaParseHelper.registerFormulaHandler(new AcctCfFormulaHandler());
        AdjustFormulaParseHelper.registerFormulaHandler(new AcctFormulaHandler());
        AdjustFormulaParseHelper.registerFormulaHandler(new RefFormulaHandler());
        AdjustFormulaParseHelper.registerFormulaHandler(new GetJLFormulaHandler());
        AdjustFormulaParseHelper.registerFormulaHandler(new ExcRateFormulaHandler());
    }
}

