/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.formula.handler;

import java.util.LinkedHashMap;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.adjust.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.business.adjust.model.CalcLine;
import kd.fi.bcm.business.convert.query.BaseData;
import kd.fi.bcm.business.convert.query.ExchangeQueryHelper;
import kd.fi.bcm.business.convert.query.ModelRate;
import kd.fi.bcm.business.convert.query.RateSchema;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;

public class ExcRateFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, CalcLine line) {
        ParamList params = f.getParamList();
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>(16);
        for (ParamItem item : params) {
            String[] splitArr;
            if (item == null || (splitArr = VFormula.splitDimAndMemb(this.handelParam(item.getParam()))).length != 2) continue;
            paramMap.put(splitArr[0], this.handelParam(splitArr[1]));
        }
        params.clear();
        SchemeContext _sctx = AdjustFormulaParseHelper.getSctx(_ctx.getModelId());
        _sctx.getDimensions().forEach(dim -> paramMap.computeIfAbsent(dim.getShortnum(), a -> this.getCurEntryDimMemStr(_ctx, _sctx, line, dim.getShortnum())));
        IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)_ctx.getModelId()), (String)"Entity", (long)line.getOrgId());
        String fyNum = (String)paramMap.get(DimTypesEnum.YEAR.getShortNumber());
        String periodNum = (String)paramMap.get(DimTypesEnum.PERIOD.getShortNumber());
        String entityNum = (String)paramMap.get(DimTypesEnum.ENTITY.getShortNumber());
        String processNum = (String)paramMap.get(DimTypesEnum.PROCESS.getShortNumber());
        String currencyNum = (String)paramMap.get(DimTypesEnum.CURRENCY.getShortNumber());
        Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), fyNum, periodNum);
        fyNum = (String)yearAndPeriod.p1;
        periodNum = (String)yearAndPeriod.p2;
        paramMap.put(DimTypesEnum.YEAR.getShortNumber(), fyNum);
        paramMap.put(DimTypesEnum.PERIOD.getShortNumber(), periodNum);
        paramMap.put(DimTypesEnum.PROCESS.getShortNumber(), this.dealCurrency(processNum, orgNode));
        paramMap.put(DimTypesEnum.CURRENCY.getShortNumber(), this.dealCurrency(currencyNum, orgNode));
        if ("Entity".equals(entityNum)) {
            String rateSchemaNumber;
            String modelNumber = MemberReader.findModelNumberById((Object)_ctx.getModelId());
            IDNumberTreeNode fyMember = MemberReader.findFyMemberByNum((String)modelNumber, (String)((String)yearAndPeriod.p1));
            IDNumberTreeNode periodMember = MemberReader.findFyMemberByNum((String)modelNumber, (String)((String)yearAndPeriod.p2));
            ModelRate modelRate = ExchangeQueryHelper.getModeRate(new BaseData(_ctx.getModelId(), _ctx.getScenarioId(), fyMember.getId(), periodMember.getId()));
            RateSchema rateSchema = modelRate.getRateSchemaByOrgNum((String)_ctx.getProperty("orgUnitNumber"));
            String string = rateSchemaNumber = RateSchema.EMPTY_RATE_SCHEMA == rateSchema ? "" : rateSchema.getRateSchemaNumber();
            if (StringUtils.isEmpty((String)rateSchemaNumber) || IDNumberTreeNode.NotFoundTreeNode.getNumber().equals(rateSchemaNumber)) {
                rateSchemaNumber = "RatePreset";
            }
            paramMap.put(DimTypesEnum.ENTITY.getShortNumber(), rateSchemaNumber);
        }
        paramMap.forEach((dimShortNum, memNum) -> params.add(new ParamItem(dimShortNum + '.' + memNum)));
    }

    private String dealCurrency(String currencyNum, IDNumberTreeNode orgNode) {
        if (currencyNum.contains("CURENTITYEC")) {
            return orgNode.getCurrency();
        }
        if (currencyNum.contains("CURENTITYPC")) {
            if (orgNode.getParent() != null && StringUtils.isNotEmpty((String)orgNode.getParent().getCurrency())) {
                return orgNode.getParent().getCurrency();
            }
            log.error(String.format("ExcRateFormula CURENTITYPC for orgNode [%s] parent Node currency is empty!", orgNode.getLongNumber()));
            throw new KDBizException(String.format("ExcRateFormula CURENTITYPC for orgNode [%s] parent Node currency is empty!", orgNode.getLongNumber()));
        }
        return currencyNum;
    }

    private String getCurEntryDimMemStr(ICalContext ctx, SchemeContext _sctx, CalcLine line, String dimShortNum) {
        DimTypesEnum dimTypesEnum = DimTypesEnum.getDimTypesEnumByShowNumber((String)dimShortNum);
        if (dimTypesEnum != null) {
            switch (dimTypesEnum) {
                case ENTITY: {
                    return "Entity";
                }
                case PERIOD: {
                    return ctx.getPeriod();
                }
                case CURRENCY: {
                    return this.getDefaultCurrency(ctx, line);
                }
                case YEAR: {
                    return ctx.getYear();
                }
                case SCENARIO: {
                    return ctx.getScenario();
                }
                case PROCESS: {
                    return "CURENTITYEC";
                }
                case CHANGETYPE: {
                    return "EndingBalance";
                }
                case MYCOMPANY: {
                    return "MCNone";
                }
                case DATASORT: {
                    return "Actual";
                }
                case INTERCOMPANY: {
                    return "ICNone";
                }
                case MULTIGAAP: {
                    return "MGNone";
                }
                case AUDITTRIAL: {
                    return "ATNone";
                }
            }
            Dimension dim = _sctx.getDimensionByShortNum(dimShortNum);
            if (dim != null) {
                return dim.getShortnum() + "None";
            }
        } else {
            Dimension dim = _sctx.getDimensionByShortNum(dimShortNum);
            if (dim != null) {
                return dim.getShortnum() + "None";
            }
        }
        return "";
    }

    @Override
    public String getName() {
        return "EXCRATE";
    }

    private String getDefaultCurrency(ICalContext ctx, CalcLine line) {
        if (OrgRelaProcessMembPool.isRelaProcess((String)line.getTmp().getProcess())) {
            IDNumberTreeNode unitOrgTreeNode = line.getUnitOrgTreeNode();
            if (unitOrgTreeNode != null && unitOrgTreeNode != IDNumberTreeNode.NotFoundTreeNode) {
                return unitOrgTreeNode.getCurrency();
            }
        } else {
            IDNumberTreeNode lineOrgNode = MemberReader.findEntityMemberById((Long)ctx.getModelId(), (Long)LongUtil.toLong((Object)line.getOrgId()));
            if (lineOrgNode != IDNumberTreeNode.NotFoundTreeNode) {
                return (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)lineOrgNode, (long)ctx.getModelId().longValue(), (String)line.getTmp().getProcess(), (String)"DC").p2;
            }
        }
        return "";
    }
}

