/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.formula.handler;

import java.util.LinkedHashMap;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.formula.AdjustFormulaParseHelper;
import kd.fi.bcm.business.adjust.formula.handler.AbstractFormulaHandler;
import kd.fi.bcm.business.adjust.model.CalcLine;
import kd.fi.bcm.business.convert.util.ConvertServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.formula.model.IFormula;
import kd.fi.bcm.business.formula.model.VFormula;
import kd.fi.bcm.business.formula.param.ParamItem;
import kd.fi.bcm.business.formula.param.ParamList;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.CollectionUtil;

public class VFormulaHandler
extends AbstractFormulaHandler {
    @Override
    public void dealBeforeCalFormula(ICalContext _ctx, IFormula f, CalcLine line) {
        ParamList params = f.getParamList();
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>(16);
        for (ParamItem item : params) {
            String[] splitArr;
            if (item == null || (splitArr = VFormula.splitDimAndMemb(this.handelParam(item.getParam()))).length != 2) continue;
            paramMap.put(splitArr[0], this.handelParam(splitArr[1]));
        }
        params.clear();
        SchemeContext _sctx = AdjustFormulaParseHelper.getSctx(_ctx.getModelId());
        _sctx.getDimensions().forEach(dim -> paramMap.computeIfAbsent(dim.getShortnum(), a -> AdjustFormulaParseHelper.getCurEntryDimMemStr(_ctx, line, dim.getNumber())));
        String sceneNum = (String)paramMap.get(DimTypesEnum.SCENARIO.getShortNumber());
        String fyNum = (String)paramMap.get(DimTypesEnum.YEAR.getShortNumber());
        String periodNum = (String)paramMap.get(DimTypesEnum.PERIOD.getShortNumber());
        String entityNum = (String)paramMap.get(DimTypesEnum.ENTITY.getShortNumber());
        String processNum = (String)paramMap.get(DimTypesEnum.PROCESS.getShortNumber());
        String currencyNum = (String)paramMap.get(DimTypesEnum.CURRENCY.getShortNumber());
        String myCompanyNum = (String)paramMap.get(DimTypesEnum.MYCOMPANY.getShortNumber());
        IDNumberTreeNode orgNode = StringUtils.isEmpty((String)entityNum) ? BcmThreadCache.findNodeById((String)_sctx.getModelNumber(), (String)"Entity", (long)line.getOrgId()) : BcmThreadCache.findMemberByNum((String)_sctx.getModelNumber(), (String)"Entity", (String)entityNum);
        entityNum = OrgRelaProcessMembPool.isRelaProcess((String)processNum) ? orgNode.getParent_SonNumber() : orgNode.getNumber();
        paramMap.put(DimTypesEnum.ENTITY.getShortNumber(), entityNum);
        if (StringUtils.isEmpty((String)currencyNum)) {
            currencyNum = OrgRelaProcessMembPool.isRelaProcess((String)processNum) ? line.getUnitOrgTreeNode().getCurrency() : BcmThreadCache.findNodeById((String)_sctx.getModelNumber(), (String)"Entity", (long)line.getOrgId()).getCurrency();
        } else if ("DC".equals(currencyNum) || "EC".equals(currencyNum) || "PC".equals(currencyNum)) {
            currencyNum = (String)TransMemberUtil.getTransOrgAndCurbyOrgId((IDNumberTreeNode)orgNode, (long)_ctx.getModelId().longValue(), (String)processNum, (String)currencyNum).p2;
            paramMap.put(DimTypesEnum.CURRENCY.getShortNumber(), currencyNum);
        }
        if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(myCompanyNum)) {
            myCompanyNum = orgNode.getNumber();
            paramMap.put(DimTypesEnum.MYCOMPANY.getShortNumber(), myCompanyNum);
        }
        Pair<String, String> yearAndPeriod = InvestServiceHelper.cvtPeriodAndYear(_ctx.getModelId(), _ctx.getScenarioId(), _ctx.getYearId(), _ctx.getPeriodId(), fyNum, periodNum);
        fyNum = (String)yearAndPeriod.p1;
        periodNum = (String)yearAndPeriod.p2;
        paramMap.put(DimTypesEnum.YEAR.getShortNumber(), fyNum);
        paramMap.put(DimTypesEnum.PERIOD.getShortNumber(), periodNum);
        Set<String> errorMsg = ConvertServiceHelper.convert4ProcessSpilt(_ctx.getModelId(), sceneNum, fyNum, periodNum, entityNum, processNum, currencyNum, true);
        if (!CollectionUtil.isEmpty(errorMsg)) {
            f.setException((Exception)((Object)new InvalidParamException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f%1$s\u6298\u7b97\u5931\u8d25\uff1a%2$s", (String)"VFormulaHandler_3", (String)"fi-bcm-business", (Object[])new Object[0]), f, errorMsg))));
        }
        paramMap.forEach((dimShortNum, memNum) -> params.add(new ParamItem(dimShortNum + '.' + memNum)));
    }

    @Override
    public String getName() {
        return "V";
    }
}

