/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DrCRDirectEnum;

public class CurrencyMoneyNode {
    private String currencyNumber;
    private BigDecimal debit;
    private BigDecimal credit;
    private BigDecimal summoney;
    private String accNum;
    private BigDecimal rate;
    private boolean ischanged = false;
    private List<String> errorMsgList;

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public void setSummoney(BigDecimal summoney) {
        this.summoney = summoney;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public void setAccNum(String accNum) {
        this.accNum = accNum;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public void setIschanged(boolean ischanged) {
        this.ischanged = ischanged;
    }

    public BigDecimal getSummoney() {
        return this.summoney == null ? BigDecimal.ZERO : this.summoney;
    }

    public BigDecimal getDebit() {
        return this.debit == null ? BigDecimal.ZERO : this.debit;
    }

    public BigDecimal getCredit() {
        return this.credit == null ? BigDecimal.ZERO : this.credit;
    }

    public BigDecimal getRealDebit() {
        return this.debit;
    }

    public BigDecimal getRealCredit() {
        return this.credit;
    }

    public BigDecimal getRealSummoney() {
        return this.summoney;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public boolean isChanged() {
        return this.ischanged;
    }

    public String getAccNum() {
        return this.accNum;
    }

    public boolean isDebitDirect(Long modelId) {
        IDNumberTreeNode accNode = MemberReader.findMemberByNumber((String)MemberReader.findModelNumberById((Object)modelId), (String)"Account", (String)this.getAccNum());
        return DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.index.equals(accNode.getProperty("drcrdirect"));
    }

    public void addErrorMsg(String msg) {
        if (this.errorMsgList == null) {
            this.errorMsgList = new ArrayList<String>(4);
        }
        this.errorMsgList.add(msg);
    }

    public String getErrorMsg() {
        if (this.errorMsgList == null) {
            return null;
        }
        return String.join((CharSequence)";", this.errorMsgList);
    }

    public void clear() {
        this.currencyNumber = null;
        this.summoney = null;
        this.accNum = null;
        this.rate = null;
        this.ischanged = false;
        this.debit = null;
        this.credit = null;
        if (this.errorMsgList != null) {
            this.errorMsgList.clear();
        }
    }
}

