/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader;

import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.adjust.util.AdjustDimRedirectHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class DimMemberNode {
    public static final DimMemberNode notFoundNode = new DimMemberNode();
    private Long memId;
    private String name;
    private String number;
    private boolean isLeaf;
    private StorageTypeEnum storageTypeEnum;
    private boolean isShowNumber = true;
    private boolean isShowName = true;
    private String errorMsg;
    private Map<String, Object> properties = null;
    private DimMemberNode redirectMemberNode;

    public DimMemberNode() {
    }

    public DimMemberNode(Long memId, String name, String number) {
        this.memId = memId;
        this.name = name;
        this.number = number;
    }

    public Long getId() {
        return this.memId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public StorageTypeEnum getStorageType() {
        return this.storageTypeEnum;
    }

    public void setStorageType(StorageTypeEnum storageTypeEnum) {
        this.storageTypeEnum = storageTypeEnum;
    }

    public void setShowStyleType(Pair<Boolean, Boolean> showPair) {
        if (showPair != null) {
            this.isShowName = (Boolean)showPair.p2;
            this.isShowNumber = (Boolean)showPair.p1;
        }
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public <T> T getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return (T)this.properties.get(key);
    }

    public String toString() {
        if (this.isShowNumber && !this.isShowName) {
            return this.number;
        }
        if (!this.isShowNumber && this.isShowName) {
            return this.name;
        }
        return this.name + "|" + this.number;
    }

    public DimMemberNode getRedirectMemberNode(long modelId, String dimNum) {
        IDNumberTreeNode memNode = AdjustDimRedirectHelper.getParentRedirectChildMember(modelId, DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNum), this.memId);
        if (this.getId() != null && !this.getId().equals(memNode.getId())) {
            this.redirectMemberNode = new DimMemberNode(memNode.getId(), memNode.getName(), memNode.getNumber());
            this.redirectMemberNode.setLeaf(memNode.isLeaf());
            this.redirectMemberNode.setStorageType(memNode.getStorageType());
            this.redirectMemberNode.isShowName = this.isShowName;
            this.redirectMemberNode.isShowNumber = this.isShowNumber;
        }
        return this.redirectMemberNode == null ? this : this.redirectMemberNode;
    }

    public void setRedirectMemberNode(DimMemberNode redirectMemberNode) {
        this.redirectMemberNode = redirectMemberNode;
    }

    public boolean isShowNumber() {
        return this.isShowNumber;
    }

    public void setShowNumber(boolean showNumber) {
        this.isShowNumber = showNumber;
    }

    public boolean isShowName() {
        return this.isShowName;
    }

    public void setShowName(boolean showName) {
        this.isShowName = showName;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

