/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.fi.bcm.business.adjust.inputReader.EmptyInputHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.AccountInputDimMemberHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.CommonInputMoneyHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.ConvertInputMoneyHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.DefaultInputDimMemberHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.EntityInputDimMemberHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.ICInputDimMemberHandler;
import kd.fi.bcm.business.adjust.inputReader.handler.IInputHandler;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.common.cache.BcmThreadCache;
import org.apache.http.client.utils.CloneUtils;

class InputHandlerProxy {
    InputHandlerProxy() {
    }

    static InputHandlerProxy getInstance() {
        return new InputHandlerProxy();
    }

    public IInputHandler invokeHandler(AdjustOperationContext ctx, String sign) {
        Map invokeHandlerMap = this.needInsulateVer(sign) ? (Map)BcmThreadCache.get((Object)"InputHandlerProxy", (Object)ctx.getModelId(), (Object)ctx.getScenarioId(), (Object)ctx.getFyId(), (Object)ctx.getPeriodId(), Maps::newHashMap) : (Map)BcmThreadCache.get((Object)"InputHandlerProxy", (Object)ctx.getModelId(), (Object)sign, Maps::newHashMap);
        return invokeHandlerMap.computeIfAbsent(sign, a -> this.getInputHandler(ctx, sign));
    }

    private boolean needInsulateVer(String sign) {
        return "Entity".equals(sign) || "ConvertMoney".equals(sign) || "InternalCompany".equals(sign);
    }

    private IInputHandler getInputHandler(AdjustOperationContext ctx, String sign) {
        try {
            ctx = (AdjustOperationContext)CloneUtils.cloneObject((Object)ctx);
            switch (sign) {
                case "Entity": {
                    return new EntityInputDimMemberHandler(ctx);
                }
                case "Account": {
                    return new AccountInputDimMemberHandler(ctx);
                }
                case "InternalCompany": {
                    return new ICInputDimMemberHandler(ctx);
                }
                case "CommonMoney": {
                    return new CommonInputMoneyHandler(ctx);
                }
                case "ConvertMoney": {
                    return new ConvertInputMoneyHandler(ctx);
                }
            }
            if (ctx.getSctx().getNumberMap().containsKey(sign)) {
                return new DefaultInputDimMemberHandler(ctx, sign);
            }
            return new EmptyInputHandler(ctx);
        }
        catch (Throwable t) {
            return new EmptyInputHandler(ctx);
        }
    }
}

