/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.adjust.inputReader.DimMemberNode;
import kd.fi.bcm.business.adjust.inputReader.handler.IInputHandler;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.spread.common.util.StringUtil;

public abstract class AbstractInputDimMemberHandler
implements IInputHandler<Set<DimMemberNode>> {
    protected AdjustOperationContext ctx;
    protected final String dimNum;
    protected final String entitysign;
    private boolean isInit = false;
    private final Map<String, Set<Long>> nameDictionaries = new ConcurrentHashMap<String, Set<Long>>();
    private final Map<Long, DimMemberNode> id2MemberCache = new HashMap<Long, DimMemberNode>(50);
    protected final Map<String, Set<Long>> number2IdCache = new HashMap<String, Set<Long>>(16);
    protected final Map<String, Set<Long>> name2IdCache = new HashMap<String, Set<Long>>(16);

    AbstractInputDimMemberHandler(AdjustOperationContext ctx, String dimNum) {
        this.dimNum = dimNum;
        this.ctx = ctx;
        this.entitysign = DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNum);
    }

    @Override
    public Set<DimMemberNode> resolveInputValue(Object inputValue) {
        if (inputValue == null || StringUtil.isEmptyString((String)inputValue.toString())) {
            return Collections.emptySet();
        }
        HashSet<Long> resIds = new HashSet<Long>(6);
        if (inputValue instanceof Long) {
            resIds.add((Long)inputValue);
        } else if (this.isNeedFuzzyQuery()) {
            String input = inputValue.toString();
            if (input.contains("|")) {
                String searchNumber = input.split("\\|")[1];
                resIds.addAll(this.number2IdCache.computeIfAbsent(searchNumber, a -> this.searchDimMemberByNum(searchNumber)));
            } else {
                resIds.addAll(this.number2IdCache.computeIfAbsent(input, a -> this.searchDimMemberByNum(input)));
                resIds.remove(0L);
                if (CollectionUtil.isEmpty(resIds)) {
                    resIds.addAll(this.name2IdCache.computeIfAbsent(input, a -> this.searchDimMemberByName(input)));
                }
            }
        } else {
            resIds.addAll(this.number2IdCache.computeIfAbsent(inputValue.toString(), a -> this.searchDimMemberByNum(inputValue.toString())));
        }
        return this.convertDimMemberNodeSet(resIds);
    }

    protected Set<DimMemberNode> convertDimMemberNodeSet(Set<Long> resIds) {
        return resIds.stream().map(resId -> this.id2MemberCache.computeIfAbsent((Long)resId, r -> this.searchDimMemberById((Long)resId))).filter(node -> node != DimMemberNode.notFoundNode).collect(Collectors.toSet());
    }

    protected boolean isNeedFuzzyQuery() {
        return !Boolean.FALSE.equals(this.ctx.getProperty("isNeedFuzzyQuery"));
    }

    protected Set<Long> searchDimMemberByNum(String number) {
        IDNumberTreeNode dimMemNode = BcmThreadCache.findMemberByNum((String)this.getCtx().getModelNum(), (String)this.dimNum, (String)number.trim());
        if (dimMemNode == IDNumberTreeNode.NotFoundTreeNode) {
            return Collections.emptySet();
        }
        return Collections.singleton(dimMemNode.getId());
    }

    protected Set<Long> searchDimMemberByName(String name) {
        return this.searchDictionaryByName(name);
    }

    public void initInputHandler() {
        if (!this.isInit()) {
            MemberReader.getAllNodeByDimNum((String)this.dimNum, (String)this.ctx.getModelNum()).parallelStream().filter(node -> !node.isShare()).forEach(node -> this.addNameDictionary(node.getId(), node.getName()));
            this.setInit(true);
        }
    }

    protected DimMemberNode searchDimMemberById(Long memId) {
        IDNumberTreeNode memNode = BcmThreadCache.findNodeById((String)this.ctx.getModelNum(), (String)this.dimNum, (long)memId);
        if (IDNumberTreeNode.NotFoundTreeNode != memNode) {
            DimMemberNode node = new DimMemberNode(memNode.getId(), memNode.getName(), memNode.getNumber());
            node.setLeaf(memNode.isLeaf());
            node.setStorageType(memNode.getStorageType());
            node.setShowStyleType(this.getDimShowTypeMap().get(this.dimNum));
            this.dealDimMemberNode(node, memNode);
            return node;
        }
        return DimMemberNode.notFoundNode;
    }

    protected void dealDimMemberNode(DimMemberNode node, IDNumberTreeNode memNode) {
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }

    private Map<String, Pair<Boolean, Boolean>> getDimShowTypeMap() {
        return (Map)ThreadCache.get((Object)this.ctx.getModelNum().concat("_").concat("adjustShowtype"), () -> {
            HashMap<String, Pair> styleMap = new HashMap<String, Pair>(16);
            DynamicObjectCollection spreadStyles = QueryServiceHelper.query((String)"bcm_spreadstyle", (String)"dimension.number,isshownumber, isshowname", (QFilter[])new QFilter("model", "=", (Object)this.ctx.getModelId()).toArray());
            for (DynamicObject spreadStyle : spreadStyles) {
                styleMap.put(spreadStyle.getString("dimension.number"), Pair.onePair((Object)spreadStyle.getBoolean("isshownumber"), (Object)spreadStyle.getBoolean("isshowname")));
            }
            return styleMap;
        });
    }

    public void setInit(boolean init) {
        this.isInit = init;
    }

    public boolean isInit() {
        return this.isInit;
    }

    protected void addNameDictionary(long pkId, String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return;
        }
        this.nameDictionaries.computeIfAbsent(name.trim(), a -> new ConcurrentHashSet(2)).add(pkId);
    }

    protected Set<Long> searchDictionaryByName(String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return Collections.emptySet();
        }
        this.initInputHandler();
        return this.nameDictionaries.getOrDefault(name.trim(), Collections.emptySet());
    }
}

