/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.fi.bcm.business.adjust.inputReader.CurrencyMoneyNode;
import kd.fi.bcm.business.adjust.inputReader.handler.IInputHandler;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;

public abstract class AbstractInputMoneyHandler
implements IInputHandler<CurrencyMoneyNode> {
    private final AdjustOperationContext ctx;

    AbstractInputMoneyHandler(AdjustOperationContext ctx) {
        this.ctx = ctx;
    }

    public AdjustOperationContext getCtx() {
        return this.ctx;
    }

    protected int getCurrencyScale(String accNum, String currencyNum) {
        return CurrencyScaleHandler.getNewCurrencyScale(this.getCtx().getModelId(), this.getCtx().getScenariodNum(), currencyNum, accNum);
    }

    protected boolean isZero(BigDecimal value) {
        return value == null || BigDecimal.ZERO.compareTo(value) == 0;
    }

    protected CurrencyMoneyNode dealCurrencyMoneyNode(CurrencyMoneyNode moneyNode) {
        if (moneyNode != null) {
            if (this.isZero(moneyNode.getSummoney())) {
                moneyNode.setRate(null);
                moneyNode.setDebit(null);
                moneyNode.setCredit(null);
                moneyNode.setSummoney(null);
            } else {
                int newScale = this.getCurrencyScale(moneyNode.getAccNum(), moneyNode.getCurrencyNumber());
                BigDecimal newSummoney = moneyNode.getSummoney().setScale(newScale, RoundingMode.HALF_UP);
                moneyNode.setSummoney(newSummoney);
                boolean isDebit = moneyNode.isDebitDirect(this.getCtx().getModelId());
                if (!this.isZero(moneyNode.getDebit())) {
                    moneyNode.setDebit(moneyNode.getSummoney());
                    moneyNode.setCredit(null);
                } else if (!this.isZero(moneyNode.getCredit())) {
                    moneyNode.setCredit(moneyNode.getSummoney().negate());
                    moneyNode.setDebit(null);
                } else if (isDebit) {
                    moneyNode.setDebit(moneyNode.getSummoney());
                    moneyNode.setCredit(null);
                } else {
                    moneyNode.setCredit(moneyNode.getSummoney().negate());
                    moneyNode.setDebit(null);
                }
            }
        }
        return moneyNode;
    }
}

