/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustConvertPathNode;
import kd.fi.bcm.business.adjust.convert.AdjustConvertService;
import kd.fi.bcm.business.adjust.inputReader.ConvertMoneyNode;
import kd.fi.bcm.business.adjust.inputReader.CurrencyMoneyNode;
import kd.fi.bcm.business.adjust.inputReader.handler.AbstractInputMoneyHandler;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.common.cache.MemberReader;

public class ConvertInputMoneyHandler
extends AbstractInputMoneyHandler {
    private final AdjustConvertService convertService;
    private final AdjustConvertPathNode convertPath = new AdjustConvertPathNode();

    public ConvertInputMoneyHandler(AdjustOperationContext ctx) {
        super(ctx);
        this.convertService = new AdjustConvertService(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId());
    }

    @Override
    public ConvertMoneyNode resolveInputValue(Object input) {
        ConvertMoneyNode inputMoneyNode = (ConvertMoneyNode)input;
        if (inputMoneyNode != null) {
            CurrencyMoneyNode cvtBeforeNode = inputMoneyNode.getCvtBeforMoneyNode();
            if (!cvtBeforeNode.isChanged()) {
                cvtBeforeNode.setSummoney(this.resolveNewCvtBeforeSumMoney(inputMoneyNode));
            }
            this.dealCurrencyMoneyNode(cvtBeforeNode);
            this.convert(inputMoneyNode, inputMoneyNode.getDefaultMoneyNode());
            for (CurrencyMoneyNode moneyNode : inputMoneyNode.getOtherMoneyNodeMap().values()) {
                this.convert(inputMoneyNode, moneyNode);
            }
        }
        return inputMoneyNode;
    }

    private void convert(ConvertMoneyNode inputMoneyNode, CurrencyMoneyNode moneyNode) {
        CurrencyMoneyNode beforeNode = inputMoneyNode.getCvtBeforMoneyNode();
        if (this.isZero(beforeNode.getSummoney())) {
            moneyNode.setSummoney(null);
        } else {
            if (inputMoneyNode.autoGainNewRate() && this.isZero(moneyNode.getRate())) {
                moneyNode.setRate(this.resolveNewRate(inputMoneyNode, beforeNode.getCurrencyNumber(), moneyNode.getCurrencyNumber()));
            }
            if (this.isZero(moneyNode.getRate())) {
                moneyNode.setSummoney(null);
            } else {
                moneyNode.setSummoney(beforeNode.getSummoney().multiply(moneyNode.getRate()));
            }
        }
        this.dealCurrencyMoneyNode(moneyNode);
    }

    private BigDecimal resolveNewCvtBeforeSumMoney(ConvertMoneyNode inputMoneyNode) {
        CurrencyMoneyNode cvtBeforeNode = inputMoneyNode.getCvtBeforMoneyNode();
        CurrencyMoneyNode cvtAfterNode = null;
        ArrayList<CurrencyMoneyNode> moneyNodeList = new ArrayList<CurrencyMoneyNode>(7);
        moneyNodeList.add(inputMoneyNode.getDefaultMoneyNode());
        moneyNodeList.addAll(inputMoneyNode.getOtherMoneyNodeMap().values());
        cvtAfterNode = moneyNodeList.stream().filter(p -> p.isChanged() && !this.isZero(p.getRate()) && !this.isZero(p.getSummoney())).findFirst().orElse(null);
        if (cvtAfterNode == null) {
            return cvtBeforeNode.getSummoney();
        }
        return cvtAfterNode.getSummoney().divide(cvtAfterNode.getRate(), 15, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal resolveNewRate(ConvertMoneyNode inputMoneyNode, String srcCurrencyNum, String tarCurrencyNum) {
        this.convertPath.getDimComb().putAll(inputMoneyNode.getDimComb());
        this.convertPath.setCvtOrg(this.convertPath.getDimComb().get("Entity"));
        this.convertPath.setSrcCurrency(MemberReader.findCurrencyMemberByNum((String)this.getCtx().getModelNum(), (String)srcCurrencyNum).getId());
        this.convertPath.setTarCurrency(MemberReader.findCurrencyMemberByNum((String)this.getCtx().getModelNum(), (String)tarCurrencyNum).getId());
        try {
            BigDecimal bigDecimal = this.getConvertService().resolveConvertPathRate(this.convertPath);
            return bigDecimal;
        }
        catch (Throwable t) {
            inputMoneyNode.addErrorMsg(AdjustmentServiceHelper.toString_Adj(t));
            BigDecimal bigDecimal = null;
            return bigDecimal;
        }
        finally {
            this.convertPath.clear();
        }
    }

    public AdjustConvertService getConvertService() {
        return this.convertService;
    }
}

