/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.inputReader.handler;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.bcm.business.adjust.inputReader.DimMemberNode;
import kd.fi.bcm.business.adjust.inputReader.handler.AbstractInputDimMemberHandler;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.lang3.tuple.Pair;

public class EntityInputDimMemberHandler
extends AbstractInputDimMemberHandler {
    private IDNumberTreeNode mergeNode;

    public EntityInputDimMemberHandler(AdjustOperationContext ctx) {
        super(ctx, "Entity");
    }

    @Override
    protected boolean isNeedFuzzyQuery() {
        return true;
    }

    @Override
    protected Set<Long> searchDimMemberByNum(String number) {
        String realnNumber = number.trim();
        String process = (String)this.getCtx().getProperty("process");
        if (OrgRelaProcessMembPool.isRelaProcess((String)process)) {
            if (this.ctx.getFyId() != 0L && this.ctx.getPeriodId() != 0L && this.ctx.getScenarioId() != 0L) {
                return Sets.newHashSet((Object[])new Long[]{InvestServiceHelper.queryEffectiveOrg(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), this.getMergeNode().getId(), realnNumber)});
            }
            String prefix = this.getMergeNode().getLongNumber() + "!";
            return MemberReader.findEntityMemberByPredicate((String)this.getCtx().getModelNum(), (String)realnNumber, child -> child.getNumber().equals(this.getMergeNode().getNumber()) || child.getLongNumber().startsWith(prefix)).stream().map(IDNumberTreeNode::getId).collect(Collectors.toSet());
        }
        if (this.getMergeNode() != null) {
            if (realnNumber.equals(this.getMergeNode().getNumber())) {
                return Sets.newHashSet((Object[])new Long[]{this.getMergeNode().getId()});
            }
            return new HashSet<Long>(16);
        }
        return Sets.newHashSet((Object[])new Long[]{BcmThreadCache.findMemberByNum((String)this.getCtx().getModelNum(), (String)"Entity", (String)realnNumber).getId()});
    }

    @Override
    protected Set<Long> searchDimMemberByName(String name) {
        HashSet<Long> resIds = new HashSet<Long>(2);
        if (this.ctx.getFyId() != 0L && this.ctx.getPeriodId() != 0L && this.ctx.getScenarioId() != 0L && OrgRelaProcessMembPool.isRelaProcess((String)((String)this.getCtx().getProperty("process")))) {
            for (Long resId : this.searchDictionaryByName(name.trim())) {
                IDNumberTreeNode node = BcmThreadCache.findNodeById((String)this.getCtx().getModelNum(), (String)"Entity", (long)resId);
                resIds.add(InvestServiceHelper.queryEffectiveOrg(this.getCtx().getModelId(), this.getCtx().getScenarioId(), this.getCtx().getFyId(), this.getCtx().getPeriodId(), this.getMergeNode().getId(), node.getNumber()));
            }
        } else {
            resIds.addAll(this.searchDictionaryByName(name.trim()));
        }
        return resIds;
    }

    @Override
    public void initInputHandler() {
        if (!this.isInit()) {
            Map<Long, Object> orgNodesFromCache;
            boolean isRADJ;
            boolean hasCslId = LongUtil.isvalidLong((Object)this.getCtx().getCslId());
            boolean hasMergeId = this.getMergeNode() != null && IDNumberTreeNode.NotFoundTreeNode != this.getMergeNode();
            Object isRADJParam = this.getCtx().getProperty("isRADJ");
            boolean bl = isRADJ = isRADJParam != null && (Boolean)isRADJParam != false;
            if (isRADJ && hasMergeId) {
                orgNodesFromCache = new HashMap<Long, IDNumberTreeNode>(16);
                orgNodesFromCache.put(this.getMergeNode().getId(), this.getMergeNode());
            } else if (hasCslId || hasMergeId) {
                if (hasMergeId) {
                    this.getCtx().setCslId((Long)this.getMergeNode().getProperty("cslscheme.id"));
                }
                CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of("model", this.ctx.getModelId());
                param.setNeedSchemeFilter(true);
                param.setNeedSchemeModelFilter(true);
                param.setCslScheme((Pair<Long, String>)Pair.of((Object)this.getCtx().getCslId(), (Object)""));
                param.setSceneId(Long.toString(this.getCtx().getScenarioId()));
                param.setYearNum(this.getCtx().getFyNum());
                param.setPeriodId(Long.toString(this.getCtx().getPeriodId()));
                param.setFilterCondition(orgNode -> this.getMergeNode() == null || IDNumberTreeNode.NotFoundTreeNode == this.getMergeNode() || orgNode == this.getMergeNode() || orgNode.getLongNumber().startsWith(this.getMergeNode().getLongNumber() + "!"));
                orgNodesFromCache = CslSchemeServiceHelper.getOrgNodesFromCache(param);
            } else {
                orgNodesFromCache = MemberReader.getAllNodeFromCache((String)"bcm_entitymembertree", (String)this.getCtx().getModelNum());
            }
            if (this.ctx.getFyId() != 0L && this.ctx.getPeriodId() != 0L && this.ctx.getScenarioId() != 0L) {
                FilterOrgStructParam structParam = new FilterOrgStructParam(this.ctx.getModelId(), this.ctx.getScenarioId(), this.ctx.getFyNum(), this.ctx.getPeriodId());
                EntityVersioningUtil.filterEffectiveOrgByMergeStruct(structParam, orgNodesFromCache.keySet()).entrySet().parallelStream().forEach(p -> this.addNameDictionary((Long)p.getKey(), (String)p.getValue()));
            }
            this.setInit(true);
        }
    }

    @Override
    protected void dealDimMemberNode(DimMemberNode node, IDNumberTreeNode memNode) {
        if (memNode.getParent() != null) {
            node.addProperty("parentnumber", memNode.getParent().getNumber());
            node.addProperty("cvtcurrency", "Entity".equals(memNode.getParent().getNumber()) ? this.resolveOrgCurrency(memNode) : this.resolveOrgCurrency(memNode.getParent()));
        }
        node.addProperty("longnumber", memNode.getLongNumber());
        node.addProperty(DimTypesEnum.CURRENCY.getNumber(), this.resolveOrgCurrency(memNode));
    }

    private String resolveOrgCurrency(IDNumberTreeNode memNode) {
        return memNode.getCurrency();
    }

    private IDNumberTreeNode getMergeNode() {
        if (this.mergeNode == null) {
            this.mergeNode = MemberReader.findEntityMemberById((String)this.getCtx().getModelNum(), (Long)((Long)this.getCtx().getProperty("bcm_mergenode")));
        }
        return this.mergeNode;
    }
}

