/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.link;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.convert.convertor.ConvertDifferenceHandle;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.LinkageTypeEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class LinkageMappingPool {
    private Long modelId;
    private Long scenarioId;
    private Long periodId;
    private Long yearId;
    private Map<String, Set<Long>> aclinkIdMap = new HashMap<String, Set<Long>>(16);
    private Map<Object, DynamicObject> curLinkageConfigMap = new HashMap<Object, DynamicObject>(16);
    private Map<Long, DimensionScope> linkApplyEntityMap = new HashMap<Long, DimensionScope>(16);

    public LinkageMappingPool(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        this.modelId = modelId;
        this.scenarioId = scenarioId;
        this.yearId = yearId;
        this.periodId = periodId;
    }

    private Set<String> filterAccountAndChangetype(Collection<DynamicObject> adjustData) {
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject e2 : adjustData) {
            set.add(DynUtils.getBaseId((DynamicObject)e2, (String)"changetype"));
        }
        return set.stream().map(e -> MemberReader.findMemberById((long)this.modelId, (String)"bcm_changetypemembertree", (Long)e).getNumber()).collect(Collectors.toSet());
    }

    private static Map<String, List<Long>> initAllLinkageConfig(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        HashMap<String, List<Long>> res = new HashMap<String, List<Long>>(16);
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("id", "in", LinkageMappingServiceHelper.queryIds(modelId, scenarioId));
        qf.add("status", "=", (Object)"1");
        qf.add("entryentity.linkagetype", "in", (Object)new String[]{LinkageTypeEnum.TARGET.getIndex(), LinkageTypeEnum.ALL.getIndex()});
        Map dys = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)"id, entryentity.account, entryentity.changetype,entryentity.linkagetype,effective.effectiveyear, effective.effectiveperiod, effective.applytype, effective.yearscope", (QFilter[])qf.toArray());
        if (!dys.isEmpty()) {
            List<Long> yearIdsList = DimensionServiceHelper.getYearIdsByModel(modelId);
            dys.forEach((linkConfigId, dy) -> {
                DynamicObjectCollection effectives = dy.getDynamicObjectCollection("effective");
                if (ConvertDifferenceHandle.isApply(yearId, periodId, effectives, yearIdsList)) {
                    DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
                    entryentity.stream().filter(e -> !LinkageTypeEnum.TARGET.getIndex().equals(e.getString("linkagetype"))).forEach(e -> {
                        List linkageConfigIds = res.computeIfAbsent(e.getString("changetype.number"), k -> new ArrayList(10));
                        linkageConfigIds.add((Long)linkConfigId);
                    });
                }
            });
        }
        return res;
    }

    private static Map<String, List<Long>> getAllLinkageConfigCache(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        return (Map)ThreadCache.get((Object)"linkageMapping-config", () -> LinkageMappingPool.initAllLinkageConfig(modelId, scenarioId, yearId, periodId));
    }

    public void initAdjustLinkageConfig(Collection<DynamicObject> adjustData) {
        Set<String> keys = this.filterAccountAndChangetype(adjustData);
        HashSet ids = new HashSet(16);
        keys.stream().forEach(e -> {
            List configs = LinkageMappingPool.getAllLinkageConfigCache(this.modelId, this.scenarioId, this.yearId, this.periodId).getOrDefault(e, Collections.emptyList());
            if (!configs.isEmpty()) {
                Set tempIds = this.aclinkIdMap.computeIfAbsent((String)e, k -> new HashSet(16));
                tempIds.addAll(configs);
                ids.addAll(configs);
            }
        });
        if (!ids.isEmpty()) {
            String selector = "number, entryentity.id, entryentity.template, entryentity.groupnum, entryentity.seq, entryentity.linkagetype, entryentity.weight, entryentity.operator, entryentity.account, entryentity.audittrial, entryentity.changetype, entryentity.mycompany, entryentity.intercompany, entryentity.userdefined1, entryentity.userdefined2, entryentity.userdefined3, entryentity.userdefined4, entryentity.userdefined5, entryentity.userdefined6,entryentity.mycompanyrange, entryentity.intercompanyrange, entryentity.userdefinedrange1, entryentity.userdefinedrange2, entryentity.userdefinedrange3, entryentity.userdefinedrange4, entryentity.userdefinedrange5, entryentity.userdefinedrange6,applyentity.entityisexcept,applyentity.entitymeb,applyentity.property,applyentity.propertyvalue,applyentity.entityrange";
            this.curLinkageConfigMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)selector, (QFilter[])new QFBuilder("id", "in", ids).toArray());
            this.curLinkageConfigMap.values().forEach(dys -> {
                DimensionScope entityScope = LinkageMappingServiceHelper.getApplyEntityScope(this.modelId, dys);
                if (entityScope != null) {
                    this.linkApplyEntityMap.put(dys.getLong("id"), entityScope);
                }
            });
        }
    }

    public List<DynamicObject> getNeedLinkageConfig(DynamicObject adjust) {
        String acctAndChatKey = LinkageMappingPool.getChangeTypeKey(this.modelId, adjust);
        Set linkageConfigIds = this.aclinkIdMap.getOrDefault(acctAndChatKey, Collections.emptySet());
        return linkageConfigIds.stream().map(linkconfigId -> this.curLinkageConfigMap.get(linkconfigId)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean applyEntity(DynamicObject e, DynamicObject adjustData) {
        DimensionScope dimensionScope = this.linkApplyEntityMap.get(e.getLong("id"));
        if (dimensionScope == null) {
            return true;
        }
        String entityNum = OrgRelaProcessMembPool.isRelaProcess((String)adjustData.getString("process.number")) ? adjustData.getString("merge.number") : adjustData.getString("entity.number");
        return dimensionScope.contains(entityNum);
    }

    public boolean nonLinkageConfig() {
        return this.curLinkageConfigMap.isEmpty();
    }

    public static String getChangeTypeKey(long model, DynamicObject dy) {
        IDNumberTreeNode chatree = MemberReader.findMemberById((long)model, (String)"bcm_changetypemembertree", (Long)DynUtils.getBaseId((DynamicObject)dy, (String)"changetype"));
        return chatree.getNumber();
    }
}

