/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.link;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.convert.AdjustConvertService;
import kd.fi.bcm.business.adjust.link.LinkageMappingPool;
import kd.fi.bcm.business.adjust.link.LinkageMappingServiceHelper;
import kd.fi.bcm.business.adjust.model.LinkageDataCollector;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.validator.AdjustValidatorExecute;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.SchemeContext;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.adjust.AdjustOperationUtils;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.EntrySourceEnum;
import kd.fi.bcm.common.enums.LinkageTypeEnum;
import kd.fi.bcm.common.util.DynUtils;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class LinkageMappingService {
    public static final Set<String> toCheckDimSet = Sets.newHashSet((Object[])new String[]{"Account", "AuditTrail", "ChangeType", "InternalCompany", "MyCompany"});
    public static final Map<String, String> fieldLinkMap = new HashMap(){
        {
            this.put("internalcompany", "intercompany");
            this.put("audittrail", "audittrial");
            this.put("dim1", "userdefined1");
            this.put("dim2", "userdefined2");
            this.put("dim3", "userdefined3");
            this.put("dim4", "userdefined4");
            this.put("dim5", "userdefined5");
            this.put("dim6", "userdefined6");
        }
    };
    private final Long modelId;
    private final String modelNum;
    private final Long periodId;
    private final Long yearId;
    private final Long scenarioId;
    private boolean isCM017;
    private final boolean isKeepModified;
    private final Map<Long, Long> source2LinkageMap = new HashMap<Long, Long>(16);
    private final Collection<Long> adjustIdSet;
    private EntrySourceEnum entryType = EntrySourceEnum.MANUALLINKAGECREATE;
    private SchemeContext sctx = null;
    private final List<Dimension> toCheckDimensionList = new ArrayList<Dimension>(16);
    private IDNumberTreeNode audittrialLinkageJournal;
    private final AdjustValidatorExecute<Pair<List<DynamicObject>, Map<Long, List<DynamicObject>>>> linkValidatorExecute;

    public LinkageMappingService(Long modelId, Long yearId, Long scenarioId, Long periodId, Collection<Long> adjustIds, Boolean isKeepModified) {
        this.isKeepModified = isKeepModified;
        this.scenarioId = scenarioId;
        this.yearId = yearId;
        this.periodId = periodId;
        this.modelId = modelId;
        this.modelNum = MemberReader.findModelNumberById((Object)modelId);
        this.isCM017 = ConfigServiceHelper.getBoolParam(modelId, "CM017");
        this.adjustIdSet = adjustIds;
        this.linkValidatorExecute = new AdjustValidatorExecute(new AdjustOperationContext(modelId));
        this.linkValidatorExecute.addOnlyWarningValidator(new AdjustCheckDimMemValidator());
    }

    public LinkageMappingService(Long modelId, Long yearId, Long scenarioId, Long periodId, Collection<Long> adjustIds, EntrySourceEnum entryType) {
        this(modelId, yearId, scenarioId, periodId, adjustIds, false);
        if (entryType != null) {
            this.entryType = entryType;
        }
    }

    public LinkageMappingService(Long modelId, Long yearId, Long scenarioId, Long periodId, Collection<Long> adjustIds) {
        this(modelId, yearId, scenarioId, periodId, adjustIds, true);
    }

    public static LinkageMappingService newObject(Collection<Long> adjustIds) {
        return LinkageMappingService.newObject(adjustIds, EntrySourceEnum.MANUALLINKAGECREATE);
    }

    public static LinkageMappingService newObject(DynamicObject adjust, EntrySourceEnum entryType) {
        Long scenarioId = 0L;
        Long yearId = 0L;
        Long periodId = 0L;
        Long modelId = 0L;
        ArrayList<Long> list = new ArrayList<Long>(1);
        if (adjust != null) {
            scenarioId = DynUtils.getBaseId((DynamicObject)adjust, (String)"scenario");
            yearId = DynUtils.getBaseId((DynamicObject)adjust, (String)"year");
            periodId = DynUtils.getBaseId((DynamicObject)adjust, (String)"period");
            modelId = DynUtils.getBaseId((DynamicObject)adjust, (String)"model");
            list.add(adjust.getLong("id"));
        }
        return new LinkageMappingService(modelId, yearId, scenarioId, periodId, list, entryType);
    }

    public static LinkageMappingService newObject(Collection<Long> adjustIds, EntrySourceEnum entryType) {
        DynamicObject adjust;
        Long scenarioId = 0L;
        Long yearId = 0L;
        Long periodId = 0L;
        Long modelId = 0L;
        if (!CollectionUtils.isEmpty(adjustIds) && (adjust = QueryServiceHelper.queryOne((String)"bcm_rptadjust", (String)"id,year,scenario,period,model", (QFilter[])new QFilter("id", "in", adjustIds).toArray())) != null) {
            scenarioId = DynUtils.getBaseId((DynamicObject)adjust, (String)"scenario");
            yearId = DynUtils.getBaseId((DynamicObject)adjust, (String)"year");
            periodId = DynUtils.getBaseId((DynamicObject)adjust, (String)"period");
            modelId = DynUtils.getBaseId((DynamicObject)adjust, (String)"model");
        }
        return new LinkageMappingService(modelId, yearId, scenarioId, periodId, adjustIds, entryType);
    }

    public void setAutoElim() {
    }

    private void resetLinkageSourceAdjust() {
        QFilter qf;
        DynamicObjectCollection adjusts;
        if (this.source2LinkageMap.isEmpty() && !CollectionUtils.isEmpty((Collection)(adjusts = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"id,entrysource,linkagelinksource", (QFilter[])(qf = new QFilter("id", "in", this.adjustIdSet)).toArray())))) {
            for (DynamicObject adjust : adjusts) {
                if (adjust.getString("entrysource").equals(ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()) || adjust.getString("entrysource").equals(ElimHeaderSourceEnum.SHARE_LINKAGE.getValue())) {
                    this.source2LinkageMap.put(adjust.getLong("linkagelinksource"), adjust.getLong("id"));
                    continue;
                }
                this.source2LinkageMap.put(adjust.getLong("id"), adjust.getLong("linkagelinksource"));
            }
        }
    }

    public Map<Long, Long> resetHistoryLinkageAdjustData() {
        this.resetLinkageSourceAdjust();
        if (this.isCM017) {
            this.splitToLinkageAndSource();
        } else {
            this.mergeLinkageAndSource();
        }
        return this.source2LinkageMap;
    }

    private void mergeLinkageAndSource() {
        Set<Long> linkageIds;
        if (!this.source2LinkageMap.isEmpty() && !(linkageIds = this.source2LinkageMap.values().stream().filter(e -> e != 0L).collect(Collectors.toSet())).isEmpty()) {
            DynamicObject[] srcAdjusts = BusinessDataServiceHelper.load((Object[])this.source2LinkageMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
            DynamicObject[] linkageAdjustDatas = LinkageMappingService.loadLinkageAdjustData(this.modelId, linkageIds);
            if (linkageAdjustDatas.length > 0) {
                this.source2LinkageMap.forEach((adjustId, linkageId) -> {
                    if (linkageId != 0L) {
                        for (DynamicObject data : linkageAdjustDatas) {
                            if (linkageId.longValue() != data.getLong("adjust.id")) continue;
                            data.set("adjust", adjustId);
                        }
                    }
                });
                SaveServiceHelper.update((DynamicObject[])linkageAdjustDatas);
            }
            Arrays.stream(srcAdjusts).forEach(e -> e.set("linkagelinksource", (Object)0L));
            SaveServiceHelper.update((DynamicObject[])srcAdjusts);
            DeleteServiceHelper.delete((IDataEntityType)srcAdjusts[0].getDataEntityType(), (Object[])this.source2LinkageMap.values().toArray());
            this.source2LinkageMap.keySet().forEach(k -> this.source2LinkageMap.put((Long)k, 0L));
        }
    }

    private static DynamicObject[] loadLinkageAdjustData(Long modelId, Set<Long> linkageIds) {
        QFBuilder linkBuiler = new QFBuilder();
        linkBuiler.add("model", "=", (Object)modelId);
        linkBuiler.add("adjust", "in", linkageIds);
        linkBuiler.add("entrysource", "in", (Object)new String[]{"2", "4", "6"});
        return BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)"adjust", (QFilter[])linkBuiler.toArray(), (String)"adjust");
    }

    private void splitToLinkageAndSource() {
        this.splitHistoryToLinkageAndSource();
    }

    private void splitHistoryToLinkageAndSource() {
        List ids;
        HashMap newSourceId2LinkageIdMap = Maps.newHashMap();
        List linkageIds = this.source2LinkageMap.values().stream().filter(linkageId -> linkageId != 0L).collect(Collectors.toList());
        if (!linkageIds.isEmpty() && (ids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_rptadjust", (QFilter[])new QFilter("id", "in", linkageIds).toArray(), null, (int)-1)).size() != linkageIds.size()) {
            linkageIds.removeAll(ids);
            for (Map.Entry<Long, Long> entry : this.source2LinkageMap.entrySet()) {
                if (entry.getValue() == 0L || !linkageIds.contains(entry.getValue())) continue;
                newSourceId2LinkageIdMap.put(entry.getKey(), entry.getValue());
            }
        }
        QFBuilder linkBuilder = new QFBuilder();
        linkBuilder.add("model", "=", (Object)this.modelId);
        linkBuilder.add("adjust", "in", this.source2LinkageMap.keySet());
        linkBuilder.add("entrysource", "in", (Object)new String[]{"2", "4", "6"});
        DynamicObject[] adjustdatas = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)"id,adjust", (QFilter[])linkBuilder.toArray());
        if (adjustdatas != null && adjustdatas.length > 0) {
            for (DynamicObject adjustdata : adjustdatas) {
                Long linkageAdjustId = this.source2LinkageMap.get(adjustdata.getLong("adjust.id"));
                if (linkageAdjustId == null || linkageAdjustId == 0L) {
                    linkageAdjustId = GlobalIdUtil.genGlobalLongId();
                    this.source2LinkageMap.put(adjustdata.getLong("adjust.id"), linkageAdjustId);
                    newSourceId2LinkageIdMap.put(adjustdata.getLong("adjust.id"), linkageAdjustId);
                }
                adjustdata.set("adjust", (Object)linkageAdjustId);
            }
            SaveServiceHelper.update((DynamicObject[])adjustdatas);
        }
        if (!newSourceId2LinkageIdMap.isEmpty()) {
            this.createLinkageHead(newSourceId2LinkageIdMap);
        }
    }

    private void createLinkageHead(Map<Long, Long> newSourceId2LinkageIdMap) {
        DynamicObject[] sourceAdjusts = BusinessDataServiceHelper.load((Object[])newSourceId2LinkageIdMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_rptadjust"));
        ArrayList linkageAdjustHeadList = new ArrayList();
        Arrays.stream(sourceAdjusts).forEach(sourceAdjust -> {
            Long newlinkageId = (Long)newSourceId2LinkageIdMap.get(sourceAdjust.getLong("id"));
            if (newlinkageId != 0L) {
                DynamicObject newLinkAdjust = LinkageMappingServiceHelper.createNewLinkAdjust(sourceAdjust);
                newLinkAdjust.set("status", (Object)sourceAdjust.getString("status"));
                newLinkAdjust.set("id", (Object)newlinkageId);
                newLinkAdjust.set("linkagelinksource", (Object)sourceAdjust.getLong("id"));
                linkageAdjustHeadList.add(newLinkAdjust);
            }
            sourceAdjust.set("linkagelinksource", (Object)newlinkageId);
        });
        SaveServiceHelper.update((DynamicObject[])sourceAdjusts);
        if (!linkageAdjustHeadList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])linkageAdjustHeadList.toArray(new DynamicObject[0]));
            AdjustOperationHelper.clonePermClassFromSrcAdjust(this.modelId, newSourceId2LinkageIdMap);
        }
    }

    private void initLinkageBaseData() {
        this.sctx = SchemeContext.getInstance(this.modelId);
        for (Dimension dim : this.sctx.getDimensions()) {
            if (dim.isIssys() && !toCheckDimSet.contains(dim.getNumber())) continue;
            this.toCheckDimensionList.add(dim);
        }
    }

    private Map<String, List<String>> dealKeepModifiedLinkageData(LinkageDataCollector linkageDataCollector) {
        HashMap<String, List<String>> linkAdjustMap = new HashMap<String, List<String>>(16);
        if (this.isKeepModified) {
            Set<Long> sourceIds = this.source2LinkageMap.keySet();
            Collection<Long> linkageAdjustIds = this.source2LinkageMap.values();
            HashSet<Long> t = new HashSet<Long>(sourceIds);
            t.addAll(linkageAdjustIds);
            DynamicObject[] linkAdjustDataKeepModified = this.getLinkAdjustDataKeepModified(t);
            HashMap linkage2SourceMap = new HashMap();
            this.source2LinkageMap.forEach((k, v) -> {
                if (v != 0L) {
                    linkage2SourceMap.put(v, k);
                }
            });
            for (DynamicObject linkageData : linkAdjustDataKeepModified) {
                long adjustId = DynUtils.getBaseId((DynamicObject)linkageData, (String)"adjust");
                if (this.isCM017) {
                    if (sourceIds.contains(adjustId)) {
                        linkageData.set("adjust", (Object)this.source2LinkageMap.get(adjustId));
                        linkageDataCollector.getAdjustIds().put(adjustId, true);
                    } else {
                        linkageDataCollector.getAdjustIds().put((Long)linkage2SourceMap.get(adjustId), true);
                    }
                } else {
                    if (linkageAdjustIds.contains(adjustId)) {
                        linkageData.set("adjust", linkage2SourceMap.get(adjustId));
                    }
                    linkageDataCollector.getAdjustIds().put(DynUtils.getBaseId((DynamicObject)linkageData, (String)"adjust"), true);
                }
                if (linkAdjustMap.get(linkageData.getString("linksource") + "") == null) {
                    linkAdjustMap.put(linkageData.getString("linksource"), new ArrayList(10));
                }
                ((List)linkAdjustMap.get(linkageData.getString("linksource"))).add(linkageData.getString("groupnum") + linkageData.getString("dseq"));
            }
            linkageDataCollector.setRetainHistoryLinkDatas(linkAdjustDataKeepModified);
        }
        return linkAdjustMap;
    }

    private boolean isZero(DynamicObject adjustData) {
        if (BigDecimal.ZERO.compareTo(adjustData.getBigDecimal("debit")) == 0 && BigDecimal.ZERO.compareTo(adjustData.getBigDecimal("credit")) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public LinkageDataCollector getPreGenerateLinkageAdjustData() {
        this.resetLinkageSourceAdjust();
        LinkageDataCollector linkageDataCollector = new LinkageDataCollector(this.modelId);
        linkageDataCollector.setSourceId2LinkageIdMap(this.source2LinkageMap);
        if (this.isCM017) {
            for (Map.Entry<Long, Long> entry : this.source2LinkageMap.entrySet()) {
                if ((Long)entry.getValue() != 0L) continue;
                this.source2LinkageMap.put((Long)entry.getKey(), GlobalIdUtil.genGlobalLongId());
            }
        }
        Map<String, List<String>> linkAdjustMap = this.dealKeepModifiedLinkageData(linkageDataCollector);
        if (!this.isCM017) {
            for (Map.Entry entry : this.source2LinkageMap.entrySet()) {
                if ((Long)entry.getValue() == 0L) continue;
                this.source2LinkageMap.put((Long)entry.getKey(), 0L);
            }
        }
        QFBuilder qf = new QFBuilder();
        qf.add("adjust", "in", this.source2LinkageMap.keySet());
        qf.add("entrysource", "in", (Object)EntrySourceEnum.getEntrySources());
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)"merge,merge.number,id,adjust,model,scenario,year,period,process,process.number,entity,entity.number,currency,multigaap,datasort,checkrecordentry,entryrowtype,isdefaultcurrency,groupnum,dseq,description,account,changetype,audittrail,internalcompany,mycompany,dim1,dim2,dim3,dim4,dim5,dim6,debit,credit,rate,entrysource,ischanged,linksource,olaporg,summoney", (QFilter[])qf.toArray());
        LinkageMappingPool linkageMappingPool = new LinkageMappingPool(this.modelId, this.scenarioId, this.yearId, this.periodId);
        linkageMappingPool.initAdjustLinkageConfig((Collection<DynamicObject>)dynamicObjectCollection);
        linkageDataCollector.setSourceDatas(dynamicObjectCollection);
        if (linkageMappingPool.nonLinkageConfig()) {
            return linkageDataCollector;
        }
        TreeMap<Long, List> mappingRelaMap = new TreeMap<Long, List>();
        this.initLinkageBaseData();
        DynamicObject tempEntry = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
        for (DynamicObject sourcedata : dynamicObjectCollection) {
            if (this.isZero(sourcedata)) continue;
            boolean createLinkageIsOk = linkageDataCollector.getAdjustIds().getOrDefault(DynUtils.getBaseId((DynamicObject)sourcedata, (String)"adjust"), Boolean.TRUE);
            List<DynamicObject> needLinkageConfigs = linkageMappingPool.getNeedLinkageConfig(sourcedata);
            if (needLinkageConfigs.isEmpty()) continue;
            int seq = 0;
            for (DynamicObject linkageData : needLinkageConfigs) {
                Pair<Long, String> linkageSourceGroupNum;
                if (!linkageMappingPool.applyEntity(linkageData, sourcedata) || (linkageSourceGroupNum = this.findLinkageSourceAndGroupNum(linkageData, sourcedata)) == null) continue;
                long sourceId = (Long)DynUtils.getProperty((String)"findLinkageSourceAndGroupNum_source", (DynamicObject)sourcedata, (String)"id", (Object)0L);
                List mappingIdList = mappingRelaMap.computeIfAbsent(sourceId, k -> new ArrayList(10));
                mappingIdList.add(linkageSourceGroupNum.p1);
                for (DynamicObject entry : linkageData.getDynamicObjectCollection("entryentity")) {
                    boolean isModifify;
                    if (this.isKeepModified) {
                        String groupnum = (String)DynUtils.getProperty((String)"findLinkageSourceAndGroupNum_source", (DynamicObject)sourcedata, (String)"groupnum", (Object)"");
                        String dseq = (String)DynUtils.getProperty((String)"findLinkageSourceAndGroupNum_source", (DynamicObject)sourcedata, (String)"dseq", (Object)"");
                        String num = groupnum + dseq;
                        List<String> groupnumMap = linkAdjustMap.get(entry.getString("id"));
                        isModifify = groupnumMap != null && groupnumMap.stream().anyMatch(p -> p.startsWith(num));
                    } else {
                        isModifify = false;
                    }
                    String linkGroupnum = entry.getString("groupnum");
                    String linkagetype = entry.getString("linkagetype");
                    if (((String)linkageSourceGroupNum.p2).equals(linkGroupnum) || LinkageTypeEnum.SOURCE.getIndex().equals(linkagetype)) continue;
                    boolean allDimMatch = true;
                    for (Dimension dim : this.toCheckDimensionList) {
                        tempEntry.set(dim.getFieldmapped(), null);
                        IDNumberTreeNode srcMemNode = BcmThreadCache.findNodeById((String)this.modelNum, (String)dim.getNumber(), (long)DynUtils.getBaseId((String)"findLinkageSourceAndGroupNum_source", (DynamicObject)sourcedata, (String)dim.getFieldmapped()));
                        IDNumberTreeNode targetMemNode = BcmThreadCache.findNodeById((String)this.modelNum, (String)dim.getNumber(), (long)DynUtils.getBaseId((String)"findLinkageSourceAndGroupNum_link", (DynamicObject)entry, (String)LinkageMappingService.findRealFieldKey(dim)));
                        if (IDNumberTreeNode.NotFoundTreeNode == targetMemNode) {
                            if ("AuditTrail".equals(dim.getNumber())) {
                                targetMemNode = this.getAudittrialLinkageJournal();
                            }
                            if (IDNumberTreeNode.NotFoundTreeNode == targetMemNode) {
                                targetMemNode = srcMemNode;
                            }
                            tempEntry.set(dim.getFieldmapped(), (Object)targetMemNode.getId());
                        } else if (targetMemNode.isLeaf()) {
                            tempEntry.set(dim.getFieldmapped(), (Object)targetMemNode.getId());
                        } else if (LinkageMappingServiceHelper.checkIsMatch(AdjustOperationHelper.createVersionParam(this.modelId, this.scenarioId, this.yearId, this.periodId), targetMemNode, srcMemNode, true)) {
                            targetMemNode = srcMemNode;
                            tempEntry.set(dim.getFieldmapped(), (Object)srcMemNode.getId());
                        } else if (this.entryType == EntrySourceEnum.MANUALLINKAGECREATE) {
                            boolean bl = createLinkageIsOk = isModifify && createLinkageIsOk;
                        }
                        if (srcMemNode.getNumber().equals(targetMemNode.getNumber())) continue;
                        allDimMatch = false;
                    }
                    if (allDimMatch) continue;
                    linkageDataCollector.putAdjustId(DynUtils.getBaseId((String)"findLinkageSourceAndGroupNum_source", (DynamicObject)sourcedata, (String)"adjust"), createLinkageIsOk);
                    if (!isModifify) {
                        DynamicObject linkageAdjustData = this.createLinkageAdjustData(entry, sourcedata, seq, tempEntry);
                        linkageDataCollector.getCreateLinkageDatas().add(linkageAdjustData);
                    }
                    ++seq;
                }
            }
        }
        this.validatorCheck(linkageDataCollector);
        return linkageDataCollector;
    }

    public static String findRealFieldKey(Dimension dim) {
        return fieldLinkMap.getOrDefault(dim.getFieldmapped(), dim.getFieldmapped());
    }

    private void validatorCheck(LinkageDataCollector linkageDataCollector) {
        AdjustValidatorExecute linkValidatorExecute = new AdjustValidatorExecute(new AdjustOperationContext(this.modelId));
        linkageDataCollector.setOperationResult(linkValidatorExecute.getValidateResult());
    }

    public LinkageDataCollector buildAutoElimLinkage() {
        this.setAutoElim();
        return this.rebuildLinkage();
    }

    public LinkageDataCollector rebuildLinkage() {
        LinkageDataCollector linkageModel = this.getPreGenerateLinkageAdjustData();
        linkageModel.saveLinkageData();
        this.convert(linkageModel);
        return linkageModel;
    }

    private void convert(LinkageDataCollector collector) {
        Map<Long, Long> sourceId2LinkageIdMap = collector.getSourceId2LinkageIdMap();
        HashSet<Long> sets = new HashSet<Long>(sourceId2LinkageIdMap.keySet());
        sets.addAll(sourceId2LinkageIdMap.values());
        sets.remove(0L);
        DynamicObject[] rptadjustdatas = BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_rptadjustdata").getAllFields().keySet()), (QFilter[])new QFilter[]{new QFilter("adjust", "in", sets), new QFilter("entrySource", "in", (Object)EntrySourceEnum.getLinkListToString())}, null);
        if (rptadjustdatas != null && rptadjustdatas.length > 0) {
            AdjustConvertService convertor = new AdjustConvertService(this.modelId, this.scenarioId, this.yearId, this.periodId);
            List<DynamicObject> rptadjustdataList = Arrays.stream(rptadjustdatas).collect(Collectors.toList());
            convertor.batchConvert(rptadjustdataList);
            SaveServiceHelper.save((DynamicObject[])rptadjustdatas);
        }
    }

    private Pair<Long, String> findLinkageSourceAndGroupNum(DynamicObject linkageEntryData, DynamicObject adjustData) {
        Long sourceId = null;
        String groupNum = null;
        for (DynamicObject entry : linkageEntryData.getDynamicObjectCollection("entryentity")) {
            if (LinkageTypeEnum.TARGET.getIndex().equals(DynUtils.getProperty((String)"findLinkageSourceAndGroupNum_link", (DynamicObject)entry, (String)"linkagetype", (Object)""))) continue;
            boolean isPass = true;
            for (Dimension dim : this.toCheckDimensionList) {
                String dimKey = fieldLinkMap.getOrDefault(dim.getFieldmapped(), dim.getFieldmapped());
                if (LinkageMappingServiceHelper.checkIsMatch(AdjustOperationHelper.createVersionParam(this.sctx.getModel(), this.scenarioId, this.yearId, this.periodId), BcmThreadCache.findNodeById((String)this.modelNum, (String)dim.getNumber(), (long)DynUtils.getBaseId((String)"findLinkageSourceAndGroupNum_link", (DynamicObject)entry, (String)dimKey)), BcmThreadCache.findNodeById((String)this.modelNum, (String)dim.getNumber(), (long)DynUtils.getBaseId((String)"findLinkageSourceAndGroupNum_source", (DynamicObject)adjustData, (String)dim.getFieldmapped())), false)) continue;
                isPass = false;
                break;
            }
            if (!isPass) continue;
            sourceId = (Long)DynUtils.getProperty((String)"findLinkageSourceAndGroupNum_link", (DynamicObject)entry, (String)"id", (Object)0L);
            groupNum = entry.getString("groupnum");
            break;
        }
        if (groupNum == null) {
            return null;
        }
        return Pair.onePair(sourceId, groupNum);
    }

    public IDNumberTreeNode getAudittrialLinkageJournal() {
        if (this.audittrialLinkageJournal == null) {
            this.audittrialLinkageJournal = MemberReader.findMemberByNumber((String)this.sctx.getModelNumber(), (String)"AuditTrail", (String)"LinkageJournal");
        }
        return this.audittrialLinkageJournal;
    }

    private DynamicObject createLinkageAdjustData(DynamicObject entry, DynamicObject sourceAdjustData, int seq, DynamicObject tempEntry) {
        String tempname;
        long sourceAdjustId = DynUtils.getBaseId((DynamicObject)sourceAdjustData, (String)"adjust");
        DynamicObject adjustData = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptadjustdata");
        adjustData.set("adjust", (Object)(this.source2LinkageMap.getOrDefault(sourceAdjustId, 0L) == 0L ? Long.valueOf(sourceAdjustId) : this.source2LinkageMap.get(sourceAdjustId)));
        adjustData.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        adjustData.set("groupnum", (Object)sourceAdjustData.getString("groupnum"));
        adjustData.set("dseq", (Object)(sourceAdjustData.getString("dseq") + "-" + (seq < 9 ? "0" + (seq + 1) : Integer.valueOf(seq + 1))));
        String description = sourceAdjustData.getString("description");
        String string = tempname = entry.getString("template.name") == null ? "" : entry.getString("template.name");
        if (StringUtils.isEmpty((String)description)) {
            adjustData.set("description", (Object)tempname.concat(ResManager.loadKDString((String)"\u8054\u52a8\u5206\u5f55", (String)"LinkageMappingServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0])));
        } else {
            adjustData.set("description", (Object)(description + tempname + this.entryType.getName()));
        }
        for (Dimension dim : this.sctx.getDimensions()) {
            if (this.toCheckDimensionList.contains(dim)) {
                adjustData.set(dim.getFieldmapped(), (Object)DynUtils.getBaseId((DynamicObject)tempEntry, (String)dim.getFieldmapped()));
                continue;
            }
            adjustData.set(dim.getFieldmapped(), (Object)DynUtils.getBaseId((DynamicObject)sourceAdjustData, (String)dim.getFieldmapped()));
        }
        adjustData.set("merge", (Object)DynUtils.getBaseId((DynamicObject)sourceAdjustData, (String)"merge"));
        adjustData.set("olaporg", (Object)sourceAdjustData.getString("olaporg"));
        adjustData.set("entrysource", (Object)this.entryType.getValue());
        adjustData.set("model", (Object)this.modelId);
        adjustData.set("checkrecordentry", (Object)DynUtils.getBaseId((DynamicObject)sourceAdjustData, (String)"checkrecordentry"));
        adjustData.set("differ", (Object)0.0);
        adjustData.set("isdefaultcurrency", (Object)sourceAdjustData.getString("isdefaultcurrency"));
        adjustData.set("entryrowtype", (Object)(StringUtils.isNotEmpty((String)sourceAdjustData.getString("entryrowtype")) ? sourceAdjustData.getString("entryrowtype") : "0"));
        adjustData.set("linksource", (Object)entry.getLong("id"));
        adjustData.set("ischanged", (Object)"0");
        BigDecimal operator = new BigDecimal(entry.getString("operator").equals("2") ? -1 : 1);
        BigDecimal weight = new BigDecimal(entry.getInt("weight")).divide(new BigDecimal(100));
        String modelNum = MemberReader.findModelNumberById((Object)this.modelId);
        adjustData.set("debit", (Object)sourceAdjustData.getBigDecimal("debit").multiply(weight).multiply(operator));
        adjustData.set("credit", (Object)sourceAdjustData.getBigDecimal("credit").multiply(weight).multiply(operator));
        adjustData.set("summoney", (Object)AdjustOperationUtils.handleSummoney((BigDecimal)adjustData.getBigDecimal("debit"), (BigDecimal)adjustData.getBigDecimal("credit")));
        BigDecimal rateValue = sourceAdjustData.getBigDecimal("rate");
        if (BigDecimal.ZERO.compareTo(rateValue) == 0) {
            int scale = CurrencyScaleHandler.getNewCurrencyScale(this.modelId, MemberReader.findScenaMemberById((String)modelNum, (Long)this.scenarioId).getNumber(), MemberReader.findCurrencyMemberById((String)modelNum, (Long)DynUtils.getBaseId((DynamicObject)adjustData, (String)"currency")).getNumber(), MemberReader.findMemberById((String)modelNum, (String)"bcm_accountmembertree", (Long)DynUtils.getBaseId((DynamicObject)adjustData, (String)"account")).getNumber());
            adjustData.set("debit", (Object)adjustData.getBigDecimal("debit").setScale(scale, RoundingMode.HALF_UP));
            adjustData.set("credit", (Object)adjustData.getBigDecimal("credit").setScale(scale, RoundingMode.HALF_UP));
            adjustData.set("summoney", (Object)adjustData.getBigDecimal("summoney").setScale(scale, RoundingMode.HALF_UP));
        } else {
            adjustData.set("rate", (Object)rateValue);
            adjustData.set("cvtbeforedebit", (Object)adjustData.getBigDecimal("debit").divide(rateValue, RoundingMode.HALF_UP));
            adjustData.set("cvtbeforecredit", (Object)adjustData.getBigDecimal("credit").divide(rateValue, RoundingMode.HALF_UP));
            adjustData.set("cvtbeforesummoney", (Object)adjustData.getBigDecimal("summoney").divide(rateValue, RoundingMode.HALF_UP));
        }
        DynamicObjectCollection dyc = adjustData.getDynamicObjectCollection("entryentity");
        DynamicObject addNew = dyc.addNew();
        addNew.set("mappingentry", (Object)entry.getLong("id"));
        return adjustData;
    }

    public DynamicObject[] getLinkAdjustDataKeepModified(Set<Long> adjustIds) {
        QFBuilder linkBuilder = new QFBuilder();
        linkBuilder.add("adjust", "in", adjustIds);
        linkBuilder.add("ischanged", "=", (Object)"1");
        linkBuilder.add("entrysource", "in", (Object)new String[]{"2", "4", "6"});
        return BusinessDataServiceHelper.load((String)"bcm_rptadjustdata", (String)"merge,merge.number,id,adjust,model,scenario,year,period,process,process.number,entity,entity.number,currency,multigaap,datasort,checkrecordentry,entryrowtype,isdefaultcurrency,groupnum,dseq,description,account,changetype,audittrail,internalcompany,mycompany,dim1,dim2,dim3,dim4,dim5,dim6,debit,credit,rate,entrysource,ischanged,linksource,olaporg,summoney", (QFilter[])linkBuilder.toArray());
    }

    public void setCM017(boolean isCM017) {
        this.isCM017 = isCM017;
    }
}

