/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.link;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustCheckServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.adjust.util.ApplyEntityHelper;
import kd.fi.bcm.business.check.CheckUtil;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ElimHeaderSourceEnum;
import kd.fi.bcm.common.enums.ElimRptAdjSourceTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.QFBuilder;

public class LinkageMappingServiceHelper {
    public static final String selectStr = "merge,merge.number,id,adjust,model,scenario,year,period,process,process.number,entity,entity.number,currency,multigaap,datasort,checkrecordentry,entryrowtype,isdefaultcurrency,groupnum,dseq,description,account,changetype,audittrail,internalcompany,mycompany,dim1,dim2,dim3,dim4,dim5,dim6,debit,credit,rate,entrysource,ischanged,linksource,olaporg,summoney";

    public static List<Long> queryIds(long modelId, long scenarioId) {
        Set<Long> idSet = CheckUtil.getApplySceneTmpls(modelId, scenarioId, "bcm_linkagemapping");
        return new ArrayList<Long>(idSet);
    }

    public static DimensionScope getApplyEntityScope(Long modelId, DynamicObject dyn) {
        if (dyn.getDynamicObjectCollection("applyentity") != null && !dyn.getDynamicObjectCollection("applyentity").isEmpty()) {
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(16);
            for (DynamicObject dy : dyn.getDynamicObjectCollection("applyentity")) {
                items.add(MapInitHelper.ofMap((Object)"id", (Object)(dy.getLong("entitymeb.id") == 0L ? dy.getLong("propertyvalue.id") : dy.getLong("entitymeb.id")), (Object)"scope", (Object)dy.getString("entityrange"), (Object)"isexcept", (Object)dy.getString("entityisexcept"), (Object)"pid", (Object)dy.getLong("property.id")));
            }
            return ApplyEntityHelper.getApplyEntityScope(modelId, items);
        }
        return null;
    }

    public static List<Long> queryIdsByOrgId(long modelId, long orgId, Collection<DynamicObject> dys) {
        IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
        ArrayList<Long> result = new ArrayList<Long>(16);
        dys.forEach(dyn -> {
            if (dyn.getDynamicObjectCollection("applyentity") != null && !dyn.getDynamicObjectCollection("applyentity").isEmpty()) {
                ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(16);
                for (DynamicObject dy : dyn.getDynamicObjectCollection("applyentity")) {
                    items.add(MapInitHelper.ofMap((Object)"id", (Object)(dy.getLong("entitymeb.id") == 0L ? dy.getLong("propertyvalue.id") : dy.getLong("entitymeb.id")), (Object)"scope", (Object)dy.getString("entityrange"), (Object)"isexcept", (Object)dy.getString("entityisexcept"), (Object)"pid", (Object)dy.getLong("property.id")));
                }
                if (ApplyEntityHelper.getApplyEntityScope(modelId, items).contains(orgNode.getNumber())) {
                    result.add(dyn.getLong("id"));
                }
            } else {
                result.add(dyn.getLong("id"));
            }
        });
        return result;
    }

    public static List<Long> queryEnableIdsByModelid(long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("status", "=", (Object)"1");
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)"id", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(10);
        loadFromCache.keySet().forEach(id -> ids.add(Long.valueOf(id.toString())));
        return ids;
    }

    public static DynamicObjectCollection queryById(Long id) {
        QFilter qf = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.query((String)"bcm_linkagemapping", (String)LinkageMappingServiceHelper.getQuerySelectFields(), (QFilter[])new QFilter[]{qf}, (String)"number, entryentity.groupnum, entryentity.seq");
    }

    public static DynamicObjectCollection queryByIds(List<Long> ids) {
        QFilter qf = new QFilter("id", "in", ids);
        return QueryServiceHelper.query((String)"bcm_linkagemapping", (String)LinkageMappingServiceHelper.getQuerySelectFields(), (QFilter[])new QFilter[]{qf}, (String)"number, entryentity.groupnum, entryentity.seq");
    }

    public static String getQuerySelectFields() {
        return "id, number, name, model.id, status, description, modifier, modifier.name, modifytime, entryentity.id, entryentity.template.id, entryentity.template.number, entryentity.template.name, entryentity.groupnum, entryentity.groupname, entryentity.linkagetype, entryentity.weight, entryentity.operator, entryentity.dimshow, entryentity.account.id, entryentity.account.name, entryentity.account.number, entryentity.account.accountuse, entryentity.account.dimension.number, entryentity.changetype.id, entryentity.changetype.name, entryentity.changetype.number, entryentity.changetype.dimension.number, entryentity.audittrial.id, entryentity.audittrial.name, entryentity.audittrial.number, entryentity.audittrial.dimension.number, entryentity.mycompany.id, entryentity.mycompany.name, entryentity.mycompany.number, entryentity.mycompany.dimension.number, entryentity.intercompany.id, entryentity.intercompany.name, entryentity.intercompany.number, entryentity.intercompany.dimension.number, entryentity.userdefined1.id, entryentity.userdefined1.name, entryentity.userdefined1.number, entryentity.userdefined1.dimension.number, entryentity.userdefined2.id, entryentity.userdefined2.name, entryentity.userdefined2.number, entryentity.userdefined2.dimension.number, entryentity.userdefined3.id, entryentity.userdefined3.name, entryentity.userdefined3.number, entryentity.userdefined3.dimension.number, entryentity.userdefined4.id, entryentity.userdefined4.name, entryentity.userdefined4.number, entryentity.userdefined4.dimension.number, entryentity.userdefined5.id, entryentity.userdefined5.name, entryentity.userdefined5.number, entryentity.userdefined5.dimension.number, entryentity.userdefined6.id, entryentity.userdefined6.name, entryentity.userdefined6.number, entryentity.userdefined6.dimension.number, entryentity.accountrange, entryentity.audittrialrange, entryentity.changetyperange, entryentity.mycompanyrange, entryentity.intercompanyrange, entryentity.userdefinedrange1, entryentity.userdefinedrange2, entryentity.userdefinedrange3, entryentity.userdefinedrange4, entryentity.userdefinedrange5, entryentity.userdefinedrange6 ";
    }

    public static String validateAll(long modelId, long scenarioId, List<Long> ids) {
        StringBuilder validateMsg = new StringBuilder();
        Map allData = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)LinkageMappingServiceHelper.getValidateSelectFields(), (QFilter[])new QFBuilder("id", "in", LinkageMappingServiceHelper.queryIds(modelId, scenarioId)).toArray());
        Map toCheckData = null;
        if (ids != null && ids.size() > 0) {
            QFilter qf = new QFilter("id", "in", (Object)ids.toArray());
            toCheckData = BusinessDataServiceHelper.loadFromCache((String)"bcm_linkagemapping", (String)LinkageMappingServiceHelper.getValidateSelectFields(), (QFilter[])new QFilter[]{qf});
        } else {
            toCheckData = allData;
        }
        HashSet<String> checkeds = new HashSet<String>(16);
        for (DynamicObject check : toCheckData.values()) {
            DynamicObjectCollection checkdys = check.getDynamicObjectCollection("entryentity");
            for (DynamicObject checkdy : checkdys) {
                String checkIndex = check.getString("number") + checkdy.getString("groupnum") + checkdy.getString("seq");
                if (checkeds.contains(checkIndex)) continue;
                boolean hasRepeat = false;
                StringBuffer str = new StringBuffer();
                str.append(ResManager.loadKDString((String)"\u91cd\u590d\u6570\u636e\u5982\u4e0b\uff1a", (String)"LinkageMappingServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0])).append("\n");
                String msg = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u5206\u7ec4\u201c%2$s\u201d\u7684\u7b2c%3$s\u884c", (String)"LinkageMappingServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]) + "\n";
                str.append(String.format(msg, check.getString("number"), checkdy.getString("groupname"), checkdy.getString("seq")));
                for (DynamicObject data : allData.values()) {
                    DynamicObjectCollection datadys = data.getDynamicObjectCollection("entryentity");
                    for (DynamicObject datady : datadys) {
                        String dataIndex = data.getString("number") + datady.getString("groupnum") + datady.getString("seq");
                        if (checkIndex.equals(dataIndex) || checkdy.getLong("account.id") != datady.getLong("account.id") || checkdy.getLong("changetype.id") != datady.getLong("changetype.id") || checkdy.getLong("intercompany.id") != datady.getLong("intercompany.id") || checkdy.getLong("userdefined1.id") != datady.getLong("userdefined1.id") || checkdy.getLong("userdefined2.id") != datady.getLong("userdefined2.id") || checkdy.getLong("userdefined3.id") != datady.getLong("userdefined3.id") || checkdy.getLong("userdefined4.id") != datady.getLong("userdefined4.id") || checkdy.getLong("userdefined5.id") != datady.getLong("userdefined5.id") || checkdy.getLong("userdefined6.id") != datady.getLong("userdefined6.id") || checkdy.getLong("mycompany.id") != datady.getLong("mycompany.id")) continue;
                        str.append(String.format(msg, data.getString("number"), datady.getString("groupname"), datady.getString("seq")));
                        checkeds.add(dataIndex);
                        hasRepeat = true;
                    }
                }
                if (!hasRepeat) continue;
                validateMsg.append(str);
            }
        }
        return validateMsg.toString();
    }

    private static String getValidateSelectFields() {
        return "number, entryentity.id, entryentity.groupnum, entryentity.groupname, entryentity.seq, entryentity.account, entryentity.audittrial, entryentity.changetype, entryentity.mycompany, entryentity.mycompanyrange, entryentity.intercompany, entryentity.userdefined1, entryentity.userdefined2, entryentity.userdefined3, entryentity.userdefined4, entryentity.userdefined5, entryentity.userdefined6";
    }

    public static boolean checkIsMatch(VersionParam versionParam, IDNumberTreeNode linkMem, IDNumberTreeNode adjustDataMem, boolean isTarget) {
        if (linkMem == null || IDNumberTreeNode.NotFoundTreeNode.equals(linkMem)) {
            return true;
        }
        if (adjustDataMem == null || IDNumberTreeNode.NotFoundTreeNode.equals(adjustDataMem)) {
            return false;
        }
        if (linkMem.isLeaf()) {
            return isTarget || linkMem.getNumber().equals(adjustDataMem.getNumber());
        }
        if ("InternalCompany".equals(linkMem.getDimNumber())) {
            return AdjustOperationHelper.isMatchIcItem(versionParam, linkMem.getNumber(), adjustDataMem.getNumber());
        }
        return adjustDataMem.getBaseTreeNode().getLongNumber().startsWith(linkMem.getLongNumber() + "!") || adjustDataMem.getBaseTreeNode().getShareNodes().stream().anyMatch(e -> e.getLongNumber().startsWith(linkMem.getLongNumber() + "!"));
    }

    public static Map<String, String> getUserDefinedDim(Object modelid) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bcm_dimension", (String)"id, number, shortnumber, fieldmapped, issysdimension", (QFilter[])new QFBuilder().add("model", "=", modelid).toArray(), (String)"dseq");
        HashMap<String, String> dimUserDefine = new HashMap<String, String>(16);
        dims.forEach(e -> {
            if (!e.getBoolean("issysdimension")) {
                dimUserDefine.put(e.getString("number"), e.getString("fieldmapped"));
            }
        });
        return dimUserDefine;
    }

    public static Set<String> getRowColLinkMemNumbers(Object modelid, Map<String, String> userdefinedDim, String number, String dimNum, DynamicObject linkmappingEntry) {
        String numberStr = userdefinedDim.get(number);
        boolean isIC = DimTypesEnum.INTERCOMPANY.getNumber().equals(number);
        String realNumber = isIC ? "intercompany" : number.toLowerCase(Locale.ENGLISH);
        String queryNumber = "entryentity." + (null != numberStr ? "userdefined" + numberStr.replace("dim", "") : realNumber) + ".number";
        String queryid = "entryentity." + (null != numberStr ? "userdefined" + numberStr.replace("dim", "") : realNumber) + ".id";
        String queryRange = "entryentity." + (null != numberStr ? "userdefinedrange" + numberStr.replace("dim", "") : realNumber + "range");
        Long linkid = linkmappingEntry.getLong(queryid);
        String linkNumber = linkmappingEntry.getString(queryNumber);
        int linkRange = linkmappingEntry.getInt(queryRange);
        return QueryMemberDetailsHelper.queryMemberNumbersByRange(DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), linkid, linkNumber, linkRange, String.valueOf(modelid), DetailTypeEnum.OTHERS);
    }

    public static DynamicObject createNewLinkAdjust(DynamicObject adjust) {
        boolean isShareAdjust = "1".equals(adjust.getString("entrysource"));
        long linkPageid = GlobalIdUtil.genGlobalLongId();
        String adjustnumber = adjust.getString("number");
        String linknumber = adjustnumber + "LD";
        DynamicObject linkageAdjust = (DynamicObject)OrmUtils.clone((IDataEntityBase)adjust, (boolean)true, (boolean)true);
        linkageAdjust.set("number", (Object)linknumber);
        linkageAdjust.set("id", (Object)linkPageid);
        linkageAdjust.set("modifystatus", (Object)"0");
        linkageAdjust.set("entrysource", (Object)(isShareAdjust ? ElimHeaderSourceEnum.SHARE_LINKAGE.getValue() : ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()));
        linkageAdjust.set("modifier", (Object)RequestContext.get().getUserId());
        linkageAdjust.set("modifytime", (Object)TimeServiceHelper.now());
        linkageAdjust.set("submitter", null);
        linkageAdjust.set("submittime", null);
        linkageAdjust.set("ratifier", null);
        linkageAdjust.set("ratifytime", null);
        linkageAdjust.set("reviewer", null);
        linkageAdjust.set("reviewtime", null);
        linkageAdjust.set("callbacker", null);
        linkageAdjust.set("callbacktime", null);
        linkageAdjust.set("balancetype", (Object)"2");
        linkageAdjust.set("extend", (Object)0L);
        linkageAdjust.set("extendfrom", null);
        linkageAdjust.set("allshareorg", null);
        linkageAdjust.set("spreadjson", null);
        linkageAdjust.set("data", null);
        linkageAdjust.set("sourcetype", (Object)ElimRptAdjSourceTypeEnum.LINK.getValue());
        DynamicObjectCollection pageDim = linkageAdjust.getDynamicObjectCollection("commembentry");
        Optional<DynamicObject> option = pageDim.stream().filter(dim -> "AuditTrail".equals(dim.getString("comdimension.number"))).findFirst();
        if (option.isPresent() && adjust.getLong("audittrail.id") != 0L) {
            QFBuilder linkageTournalQF = new QFBuilder();
            linkageTournalQF.add("model", "=", (Object)adjust.getLong("model.id"));
            linkageTournalQF.and("number", "=", (Object)"LinkageJournal");
            DynamicObject atDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_audittrialmembertree", (String)"id", (QFilter[])linkageTournalQF.toArray());
            if (atDy == null) {
                atDy = adjust.getDynamicObject("audittrail");
            }
            linkageAdjust.set("audittrail", (Object)atDy);
            option.get().set("commembid", (Object)atDy.getLong("id"));
        }
        return linkageAdjust;
    }

    public static void backLinkLinkageAdjust(Long modelId, Long scene, Long year, Long period, List<Long> adjustIds) {
        QFBuilder qb = new QFBuilder("id", "in", adjustIds);
        qb.add("entrysource", "in", (Object)new String[]{ElimHeaderSourceEnum.SOURCE.getValue(), ElimHeaderSourceEnum.SHARE.getValue()});
        List<Long> linkSourceIds = QueryServiceHelper.query((String)"bcm_rptadjust", (String)"linkagelinksource", (QFilter[])qb.toArray()).stream().map(adjust -> adjust.getLong("linkagelinksource")).collect(Collectors.toList());
        if (!linkSourceIds.isEmpty()) {
            AdjustCheckServiceHelper.doSysToMdd(modelId, scene, year, period, linkSourceIds, false);
            LinkageMappingServiceHelper.handleShareEntry(modelId, scene, year, period, linkSourceIds);
        }
    }

    public static void handleShareEntry(Long modelId, Long scene, Long year, Long period, List<Long> pks) {
        ArrayList delSharePks = Lists.newArrayList();
        QueryServiceHelper.query((String)"bcm_rptadjust", (String)"shareentry.shareadjust", (QFilter[])new QFilter("id", "in", pks).and("entrysource", "in", (Object)new String[]{ElimHeaderSourceEnum.SOURCE.getValue(), ElimHeaderSourceEnum.SOURCE_LINKAGE.getValue()}).toArray()).forEach(p -> delSharePks.add(p.getLong("shareentry.shareadjust")));
        if (delSharePks.size() > 0) {
            AdjustClearServiceHelper.batchDeleteAutoAdjust("handleShareEntry", modelId, scene, year, period, delSharePks);
        }
    }
}

