/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.adjust.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bcm.business.adjust.factory.adjustLockOper.AdjustLockOperFactory;
import kd.fi.bcm.business.adjust.model.LockerInfo;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.enums.adjust.AdjustLockOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.MapInitHelper;

public class AdjustApplicationLocker {
    private final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(AdjustApplicationLocker.class);
    private static final String DEFAULTGROUPID = "";
    private final AdjustLockOperTypeEnum lockerTypeEnum;
    private final Map<String, LockerInfo> lockKeyHasMap = new HashMap<String, LockerInfo>();

    public static AdjustLockOperTypeEnum.LOCKTYPE getLockType(AdjustLockOperTypeEnum lockerTypeEnum) {
        AdjustLockOperTypeEnum.LOCKTYPE locktype = AdjustLockOperTypeEnum.LOCKTYPE.LOCK_DATAMUTEX;
        if (lockerTypeEnum != null) {
            if (lockerTypeEnum.getLocktype() != null) {
                locktype = lockerTypeEnum.getLocktype();
            }
            if (ConfigServiceHelper.getGlobalBoolParam("isForceAdjustDataMutexLock")) {
                locktype = AdjustLockOperTypeEnum.LOCKTYPE.LOCK_DATAMUTEX;
            }
        }
        return locktype;
    }

    public AdjustApplicationLocker(AdjustLockOperTypeEnum lockerTypeEnum) {
        this.lockerTypeEnum = lockerTypeEnum;
    }

    public void addPreparedLockKey(String lockKey, String opName) {
        this.addPreparedLockKey(DEFAULTGROUPID, lockKey, opName);
    }

    public void addPreparedLockKey(String groupId, String lockKey, String opName) {
        this.lockKeyHasMap.computeIfAbsent(lockKey, a -> (LockerInfo)BcmThreadCache.get((Object)"addPreparedLockKey", (Object)groupId, (Object)lockKey, () -> new LockerInfo(groupId, lockKey, this.lockerTypeEnum, opName)));
    }

    public Map<String, Boolean> batchRequest() {
        this.LOG.startWatch();
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(100);
        try {
            List<Map<String, Object>> mutexRequireList = this.lockKeyHasMap.values().stream().map(this::createDataMutexLockInfo).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(mutexRequireList)) {
                resultMap.putAll(AdjustLockOperFactory.getLockerInstance(AdjustApplicationLocker.getLockType(this.lockerTypeEnum)).batchRequire(mutexRequireList));
            }
        }
        finally {
            this.lockKeyHasMap.forEach((lockKey, locker) -> locker.setLocked(resultMap.getOrDefault(lockKey, Boolean.FALSE)));
        }
        this.LOG.errorEnd("request mutex adjustLockKey");
        return resultMap;
    }

    public Map<String, Boolean> batchRelease() {
        this.LOG.startWatch();
        List<Map<String, Object>> mutexRequireList = this.lockKeyHasMap.values().stream().filter(LockerInfo::isLocked).map(this::createDataMutexLockInfo).collect(Collectors.toList());
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(mutexRequireList.size());
        if (!CollectionUtils.isEmpty(mutexRequireList)) {
            resultMap.putAll(AdjustLockOperFactory.getLockerInstance(AdjustApplicationLocker.getLockType(this.lockerTypeEnum)).batchRelease(mutexRequireList));
        }
        this.LOG.errorEnd("release mutex adjustLockKey");
        this.lockKeyHasMap.clear();
        return resultMap;
    }

    private Map<String, Object> createDataMutexLockInfo(LockerInfo lockerInfo) {
        return MapInitHelper.ofMap((Object)"dataObjId", (Object)lockerInfo.originLockStr(), (Object)"groupId", (Object)lockerInfo.groupId(), (Object)"entityKey", (Object)this.lockerTypeEnum.entityKey(), (Object)"isStrict", (Object)this.lockerTypeEnum.isStrict(), (Object)"operationKey", (Object)lockerInfo.getOpName());
    }
}

